/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.layerpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import structurevis.ui.layerpanel.GeneralLayer;
import structurevis.ui.layerpanel.LayerPanel;

public class NameField
extends JPanel
implements ActionListener,
MouseListener {
    public Border borderPadding = BorderFactory.createEmptyBorder(0, 3, 0, 0);
    public JTextField textField = new JTextField();
    ImageIcon pinnedIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/pinned.png"));
    ImageIcon unpinnedIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/unpinned.png"));
    public JLabel labelIcon = new JLabel();
    JPopupMenu popupMenu = new JPopupMenu();
    JMenuItem pinTab = new JMenuItem("Pin tab");
    LayerPanel layerPanel;
    GeneralLayer layer;

    public NameField(LayerPanel layerPanel, String text, GeneralLayer layer) {
        this.layerPanel = layerPanel;
        this.layer = layer;
        this.addMouseListener(this);
        this.textField.addMouseListener(this);
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.textField.setText(text);
        this.textField.setEditable(false);
        this.textField.setBorder(this.borderPadding);
        this.add((Component)this.textField, "Center");
        this.labelIcon.addMouseListener(this);
        this.labelIcon.setBorder(BorderFactory.createEmptyBorder(2, 8, 0, 0));
        if (layer.canPin) {
            if (layer.isPinned) {
                this.labelIcon.setIcon(this.pinnedIcon);
                this.labelIcon.setToolTipText("Unpin layer");
            } else {
                this.labelIcon.setIcon(this.unpinnedIcon);
                this.labelIcon.setToolTipText("Pin layer");
            }
            this.add((Component)this.labelIcon, "East");
        }
        this.pinTab.addActionListener(this);
        this.popupMenu.add(this.pinTab);
    }

    @Override
    public void setBackground(Color backgroundColor) {
        super.setBackground(backgroundColor);
        if (this.textField != null) {
            this.textField.setBackground(backgroundColor);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.pinTab)) {
            if (!this.layer.isPinned) {
                this.labelIcon.setIcon(this.pinnedIcon);
                this.layerPanel.pinLayer(this.layer);
            } else {
                this.labelIcon.setIcon(this.unpinnedIcon);
                this.layerPanel.unpinLayer(this.layer);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.layer.canPin && e.getClickCount() >= 1 && SwingUtilities.isLeftMouseButton(e)) {
            if (!this.layer.isPinned) {
                this.labelIcon.setIcon(this.pinnedIcon);
                this.layerPanel.pinLayer(this.layer);
                this.labelIcon.setToolTipText("Unpin layer");
            } else {
                this.labelIcon.setIcon(this.unpinnedIcon);
                this.layerPanel.unpinLayer(this.layer);
                this.labelIcon.setToolTipText("Pin layer");
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.layer.canPin) {
            // empty if block
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

