/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.layerpanel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Scrollable;
import structurevis.ui.MainApp;
import structurevis.ui.layerpanel.GeneralLayer;
import structurevis.ui.layerpanel.GenomeLayer;
import structurevis.ui.layerpanel.GraphLayer;
import structurevis.ui.layerpanel.NameField;

public class LayerPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
Scrollable {
    boolean repaint = true;
    Font f1 = new Font("Arial", 0, 15);
    Font f2 = new Font("Arial", 0, 12);
    int selectedStart = -1;
    int selectedEnd = -1;
    int mouseoverGeneStart = -1;
    int mouseoverGeneEnd = -1;
    public int genomeLength = 10000;
    public int height = 0;
    MainApp mainapp;
    int width = 1000;
    boolean trackWidth = true;
    JPopupMenu popupMenu = new JPopupMenu();
    JMenuItem autofitItem = new JMenuItem("Autofit width");
    JMenuItem zoomInItem = new JMenuItem("Zoom in");
    JMenuItem zoomOutItem = new JMenuItem("Zoom out");
    ArrayList<NameField> nameFields = new ArrayList();
    ArrayList<GeneralLayer> layers = new ArrayList();
    GenomeLayer genomeLayer;
    GraphLayer graphLayer1D;
    ArrayList<GeneralLayer> pinnedLayers = new ArrayList();
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    public JPanel left;
    public JPanel right;

    public LayerPanel(MainApp mainapp, int genomeLength) {
        this.initComponents();
        this.mainapp = mainapp;
        this.genomeLength = genomeLength;
        this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder());
        this.jSplitPane1.setDividerLocation(125);
        this.addMouseListener(this);
        this.popupMenu.add(this.autofitItem);
        this.popupMenu.add(this.zoomInItem);
        this.popupMenu.add(this.zoomOutItem);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.updatePanel();
    }

    public void setGenomeLayer(GenomeLayer genomeLayer) {
        this.genomeLayer = genomeLayer;
        this.updatePanel();
    }

    public void setGraphLayer1D(GraphLayer graphLayer1D) {
        this.graphLayer1D = graphLayer1D;
        this.updatePanel();
    }

    public void setGenomeLength(int genomeLength) {
        this.genomeLength = genomeLength;
        this.updatePanel();
    }

    public void updatePanel() {
        int i;
        this.removeAllLayers();
        if (this.genomeLayer != null) {
            this.genomeLayer.canPin = false;
            this.addLayer(this.genomeLayer);
        }
        if (this.graphLayer1D != null) {
            this.addLayer(this.graphLayer1D);
        }
        for (i = 0; i < this.pinnedLayers.size(); ++i) {
            if (this.pinnedLayers.get(i).equals(this.graphLayer1D) || !this.pinnedLayers.get((int)i).isPinned) continue;
            this.addLayer(this.pinnedLayers.get(i));
        }
        this.revalidate();
        this.repaint();
        for (i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).redraw();
        }
        if (this.mainapp != null) {
            this.mainapp.validate();
        }
    }

    public void redraw() {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).redraw();
        }
    }

    public void pinLayer(GeneralLayer layer) {
        for (int i = 0; i < this.layers.size(); ++i) {
            if (!this.layers.get(i).equals(layer) || layer.isPinned) continue;
            try {
                layer.isPinned = true;
                GeneralLayer layerClone = (GeneralLayer)this.layers.get(i).clone();
                if (this.pinnedLayers.contains(layerClone)) break;
                this.pinnedLayers.add(layerClone);
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(LayerPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            break;
        }
    }

    public boolean unpinLayer(GeneralLayer layer) {
        layer.isPinned = false;
        boolean success = this.pinnedLayers.remove(layer);
        this.updatePanel();
        return success;
    }

    public void addLayer(GeneralLayer layer) {
        NameField nameField = new NameField(this, layer.name, layer);
        nameField.setMinimumSize(new Dimension(0, layer.getPreferredSize().height));
        nameField.setPreferredSize(new Dimension(100, layer.getPreferredSize().height));
        nameField.setMaximumSize(new Dimension(Integer.MAX_VALUE, layer.getPreferredSize().height));
        nameField.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.left.add(nameField);
        this.nameFields.add(nameField);
        layer.setMinimumSize(new Dimension(0, layer.getPreferredSize().height));
        layer.setPreferredSize(new Dimension(800, layer.getPreferredSize().height));
        layer.setMaximumSize(new Dimension(Integer.MAX_VALUE, layer.getPreferredSize().height));
        layer.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.right.add(layer);
        this.layers.add(layer);
        this.height += layer.getPreferredSize().height;
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.height));
    }

    public void updateNames() {
        for (int i = 0; i < this.nameFields.size(); ++i) {
            this.nameFields.get((int)i).textField.setText(this.layers.get((int)i).name);
        }
    }

    public void removeAllLayers() {
        this.height = 0;
        this.left.removeAll();
        this.nameFields.clear();
        this.right.removeAll();
        this.layers.clear();
    }

    public int getPositionInGenome(double f) {
        return (int)(f * (double)this.genomeLength);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jSplitPane1 = new JSplitPane();
        this.left = new JPanel();
        this.right = new JPanel();
        this.setLayout(new BoxLayout(this, 2));
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBar(null);
        this.jScrollPane1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setDividerSize(2);
        this.left.setPreferredSize(new Dimension(100, 0));
        this.left.setLayout(new BoxLayout(this.left, 3));
        this.jSplitPane1.setLeftComponent(this.left);
        this.right.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.right.setPreferredSize(new Dimension(0, 20));
        this.right.setLayout(new BoxLayout(this.right, 3));
        this.jSplitPane1.setRightComponent(this.right);
        this.jScrollPane1.setViewportView(this.jSplitPane1);
        this.add(this.jScrollPane1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return -1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return -1;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.trackWidth;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void autofitWidth() {
        this.trackWidth = true;
        this.revalidate();
        this.width = this.getWidth();
    }

    public void resizeWidth(int width) {
        this.trackWidth = false;
        this.setPreferredSize(new Dimension(width, this.height));
        this.revalidate();
    }

    public void zoomIn() {
        this.width = (int)((double)this.getWidth() * 1.5);
        this.resizeWidth(this.width);
    }

    public void zoomOut() {
        this.width = (int)((double)this.getWidth() / 1.5);
        this.resizeWidth(this.width);
    }
}

