/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.layerpanel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import structurevis.structures.metadata.SequenceData1D;
import structurevis.ui.layerpanel.GeneralLayer;
import structurevis.ui.layerpanel.LayerPanel;

public class GraphLayer
extends GeneralLayer
implements ActionListener,
MouseListener {
    Graphics2D g = null;
    double[] slidingWindowData;
    JPopupMenu popupMenu = new JPopupMenu();
    JMenu slidingWindowMenu = new JMenu("Sliding window size");
    private static final int[] windowSizes = new int[]{5, 10, 20, 30, 50, 75, 100, 150, 200};
    ButtonGroup slidingWindowGroup = new ButtonGroup();
    JRadioButtonMenuItem[] slidingWindowItems = new JRadioButtonMenuItem[windowSizes.length];
    public SequenceData1D data1D;
    int currentWindowIndex = 4;
    boolean forceRepaint = true;

    public GraphLayer(LayerPanel layerPanel, SequenceData1D data1D, String name) {
        super(layerPanel, name);
        this.setPreferredSize(new Dimension(1000, 20));
        this.setData(data1D);
        this.addMouseListener(this);
        for (int i = 0; i < this.slidingWindowItems.length; ++i) {
            this.slidingWindowItems[i] = new JRadioButtonMenuItem(windowSizes[i] + "");
            this.slidingWindowItems[i].addActionListener(this);
            this.slidingWindowGroup.add(this.slidingWindowItems[i]);
            this.slidingWindowMenu.add(this.slidingWindowItems[i]);
        }
        this.slidingWindowItems[this.currentWindowIndex].setSelected(true);
        this.popupMenu.add(this.slidingWindowMenu);
    }

    public void setData(SequenceData1D data1D) {
        this.setData(data1D, windowSizes[this.currentWindowIndex]);
    }

    public void setData(SequenceData1D data1D, int windowSize) {
        this.data1D = data1D;
        this.setSlidingWindow(windowSize);
    }

    public void setSlidingWindow(int windowSize) {
        if (this.data1D != null) {
            this.slidingWindowData = new double[this.data1D.data.length];
            for (int i = 0; i < this.slidingWindowData.length; ++i) {
                double sum = 0.0;
                double count = 0.0;
                for (int j = 0; j < windowSize; ++j) {
                    int x = i - windowSize / 2 + j;
                    if (x < 0 || x >= this.slidingWindowData.length || !this.data1D.used[x]) continue;
                    sum += (double)this.data1D.data[x];
                    count += 1.0;
                }
                this.slidingWindowData[i] = this.data1D.used[i] && count > 0.0 ? sum / count : -1.0;
            }
        }
    }

    @Override
    public void redraw() {
        this.forceRepaint = true;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g2 = (Graphics2D)graphics;
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        if (this.bufferedImage == null || this.bufferedImage.getWidth() != panelWidth || this.bufferedImage.getHeight() != panelHeight) {
            this.bufferedImage = (BufferedImage)this.createImage(panelWidth, panelHeight);
            this.g = (Graphics2D)this.bufferedImage.getGraphics();
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.forceRepaint = true;
        }
        if (this.forceRepaint) {
            this.forceRepaint = false;
            this.g.setColor(Color.white);
            this.g.fillRect(0, 0, panelWidth, panelHeight);
            for (int i = 0; i < this.getWidth(); ++i) {
                float x;
                int coordinate = (int)((double)i / (double)this.getWidth() * (double)this.layerPanel.genomeLength);
                if (this.data1D == null || coordinate >= this.slidingWindowData.length || (x = (float)this.slidingWindowData[coordinate]) == -1.0f) continue;
                Color c = this.data1D.colorGradientSecondary.getColor(this.data1D.dataTransform.transform(x));
                this.g.setColor(c);
                this.g.fillRect(i + this.xoffset, 0, 1, this.getHeight());
            }
        }
        g2.drawImage((Image)this.bufferedImage, 0, 0, this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.popupMenu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < windowSizes.length; ++i) {
            if (!e.getSource().equals(this.slidingWindowItems[i])) continue;
            this.currentWindowIndex = i;
            this.setData(this.data1D, windowSizes[i]);
            this.redraw();
            break;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GraphLayer layer = new GraphLayer(this.layerPanel, this.data1D, this.name);
        layer.canPin = this.canPin;
        layer.isPinned = this.isPinned;
        return layer;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            GraphLayer other = (GraphLayer)obj;
            if (this.data1D == null && other.data1D == null) {
                return true;
            }
            if (!this.data1D.equals(other.data1D)) {
                return false;
            }
            return this.currentWindowIndex == other.currentWindowIndex;
        }
        return false;
    }
}

