/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.layerpanel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import structurevis.structures.Structure;
import structurevis.ui.StructureDrawPanel;
import structurevis.ui.layerpanel.GeneralLayer;
import structurevis.ui.layerpanel.GenomeOrganization;
import structurevis.ui.layerpanel.LayerPanel;
import structurevis.ui.layerpanel.Region;

public class GenomeLayer
extends GeneralLayer
implements ActionListener,
MouseListener,
MouseMotionListener {
    public int rulerHeight = 20;
    public int blockHeight = 25;
    GenomeOrganization genomeOrganization;
    int maxLevel = 0;
    int mouseoverStart = -1;
    int mouseoverEnd = -1;
    int selectedStart = -1;
    int selectedEnd = -1;
    JPopupMenu popupMenu = new JPopupMenu();
    JMenuItem autofitItem = new JMenuItem("Autofit width");
    JMenuItem zoomInItem = new JMenuItem("Zoom in");
    JMenuItem zoomOutItem = new JMenuItem("Zoom out");
    int minorTickMark = 500;
    int majorTickMark = 1000;
    int[] tickMarkPossibilities = new int[]{1, 5, 10, 15, 20, 25, 50, 75, 100, 200, 250, 500, 750, 1500, 2000};
    Structure selected = null;
    ArrayList<Structure> structures = null;
    ArrayList<StructureAndMouseoverRegion> structurePositions = null;
    ArrayList<StructureAndMouseoverRegion> structurePositions2 = null;
    Structure selected2 = null;
    boolean forceRepaint = true;

    public GenomeLayer(LayerPanel layerPanel, GenomeOrganization genomeStructure, String name) {
        super(layerPanel, name);
        this.setGenomeOrganization(genomeStructure);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.autofitItem.addActionListener(this);
        this.zoomInItem.addActionListener(this);
        this.popupMenu.add(this.zoomOutItem).addActionListener(this);
        this.popupMenu.add(this.autofitItem);
        this.popupMenu.add(this.zoomInItem);
        this.popupMenu.add(this.zoomOutItem);
    }

    public int chooseBestTickMarkSize(int genomeLength) {
        for (int i = this.tickMarkPossibilities.length - 1; i >= 0; --i) {
            double distanceBetweenTicks = (double)this.getWidth() / (double)genomeLength * (double)this.tickMarkPossibilities[i];
            if (!(distanceBetweenTicks < 40.0)) continue;
            if (i < this.tickMarkPossibilities.length - 1) {
                return this.tickMarkPossibilities[i + 1];
            }
            return this.tickMarkPossibilities[i];
        }
        return 1;
    }

    @Override
    public void redraw() {
        this.forceRepaint = true;
        this.repaint();
    }

    public void setGenomeOrganization(GenomeOrganization g) {
        this.genomeOrganization = g;
        if (g != null) {
            for (int i = 0; i < g.genome.size(); ++i) {
                this.maxLevel = Math.max(this.maxLevel, g.genome.get((int)i).level);
            }
            this.setPreferredSize(new Dimension(10000, this.rulerHeight + (this.maxLevel + 1) * this.blockHeight));
            this.redraw();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        double mouseoverLength;
        Rectangle2D.Double rect;
        double x;
        double regionWidth;
        int i;
        super.paintComponent(graphics);
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        if (this.genomeOrganization != null) {
            g2.setColor(Color.white);
            g2.fillRect(0, 0, panelWidth, panelHeight);
            this.minorTickMark = this.chooseBestTickMarkSize(this.layerPanel.genomeLength);
            this.majorTickMark = this.minorTickMark * 2;
            g2.setFont(this.layerPanel.f2);
            for (i = 0; i < this.layerPanel.genomeLength; ++i) {
                Line2D.Double tick;
                double x2;
                if (i % this.majorTickMark == 0) {
                    x2 = (double)i / (double)this.layerPanel.genomeLength * (double)this.getWidth();
                    g2.setColor(Color.black);
                    tick = new Line2D.Double(x2 + (double)this.xoffset, this.rulerHeight - 1, x2 + (double)this.xoffset, this.rulerHeight + 1);
                    g2.draw(tick);
                    StructureDrawPanel.drawStringCentred(g2, x2 + (double)this.xoffset, this.rulerHeight / 2, i + "");
                    continue;
                }
                if (i % this.minorTickMark != 0) continue;
                x2 = (double)i / (double)this.layerPanel.genomeLength * (double)this.getWidth();
                g2.setColor(Color.black);
                tick = new Line2D.Double(x2 + (double)this.xoffset, this.rulerHeight - 1, x2 + (double)this.xoffset, this.rulerHeight + 1);
                g2.draw(tick);
            }
            for (i = 0; i < this.genomeOrganization.genome.size(); ++i) {
                Region region = this.genomeOrganization.genome.get(i);
                double regionLength = region.end - region.start;
                regionWidth = regionLength / (double)this.layerPanel.genomeLength * (double)this.getWidth();
                x = (double)region.start / (double)this.layerPanel.genomeLength * (double)this.getWidth();
                g2.setColor(region.color);
                rect = new Rectangle2D.Double(x + (double)this.xoffset, this.rulerHeight + region.level * this.blockHeight, regionWidth, this.blockHeight);
                g2.fill(rect);
                g2.setColor(Color.black);
                StructureDrawPanel.drawStringCentred(g2, x + (double)this.xoffset + regionWidth / 2.0, this.rulerHeight + region.level * this.blockHeight + this.blockHeight / 2, region.name);
            }
        }
        g2.drawImage((Image)this.bufferedImage, 0, 0, this);
        if (this.structurePositions2 != null) {
            for (i = 0; i < this.structurePositions2.size(); ++i) {
                Color blockColor = new Color(150, 150, 150, 100);
                if (this.structurePositions2.get((int)i).structure.equals(this.selected2)) {
                    blockColor = new Color(10, 255, 10, 100);
                }
                g2.setColor(blockColor);
                g2.fill(this.structurePositions2.get((int)i).rectangle);
                g2.setColor(Color.GRAY);
            }
        }
        if (this.structures != null && this.structurePositions != null) {
            for (i = 0; i < this.structurePositions.size(); ++i) {
                Color blockColor = new Color(150, 150, 150, 100);
                if (this.structurePositions.get((int)i).structure.equals(this.selected)) {
                    blockColor = new Color(255, 10, 10, 100);
                }
                g2.setColor(blockColor);
                g2.fill(this.structurePositions.get((int)i).rectangle);
                g2.setColor(Color.GRAY);
            }
        }
        double rulerHeight = 0.0;
        if (this.mouseoverStart != -1 || this.mouseoverEnd != -1) {
            mouseoverLength = this.mouseoverEnd - this.mouseoverStart;
            regionWidth = mouseoverLength / (double)this.layerPanel.genomeLength * (double)this.getWidth();
            x = (double)this.mouseoverStart / (double)this.layerPanel.genomeLength * (double)this.getWidth();
            g2.setColor(new Color(0, 0, 0, 125));
            rect = new Rectangle2D.Double(x + (double)this.xoffset, rulerHeight + 0.0 - 3.0, regionWidth, (double)(3 + this.getHeight()) - rulerHeight - 1.0);
            g2.draw(rect);
            if (this.layerPanel.genomeLength < this.mouseoverEnd) {
                mouseoverLength = this.mouseoverEnd - this.layerPanel.genomeLength;
                regionWidth = mouseoverLength / (double)this.layerPanel.genomeLength * (double)this.getWidth();
                x = 0.0;
                g2.setColor(new Color(125, 125, 125, 125));
                rect = new Rectangle2D.Double(x + (double)this.xoffset, rulerHeight + 0.0 - 3.0, regionWidth, (double)(3 + this.getHeight()) - rulerHeight - 1.0);
                g2.draw(rect);
            }
        }
        if (this.selectedStart != -1 || this.selectedEnd != -1) {
            mouseoverLength = this.selectedEnd - this.selectedStart;
            regionWidth = mouseoverLength / (double)this.layerPanel.genomeLength * (double)this.getWidth();
            x = (double)this.selectedStart / (double)this.layerPanel.genomeLength * (double)this.getWidth();
            g2.setColor(Color.RED);
            rect = new Rectangle2D.Double(x + (double)this.xoffset, rulerHeight + 0.0 - 3.0, regionWidth, (double)(3 + this.getHeight()) - rulerHeight - 1.0);
            g2.draw(rect);
            if (this.layerPanel.genomeLength < this.selectedEnd) {
                mouseoverLength = this.selectedEnd - this.layerPanel.genomeLength;
                regionWidth = mouseoverLength / (double)this.layerPanel.genomeLength * (double)this.getWidth();
                x = 0.0;
                g2.setColor(Color.RED);
                rect = new Rectangle2D.Double(x + (double)this.xoffset, rulerHeight + 0.0 - 3.0, regionWidth, (double)(3 + this.getHeight()) - rulerHeight - 1.0);
                g2.draw(rect);
            }
        }
    }

    public void drawMouseOverSelection(int start, int end) {
        this.mouseoverStart = start;
        this.mouseoverEnd = end;
        this.repaint();
    }

    public void drawSelected(int start, int end) {
        this.selectedStart = start;
        this.selectedStart = end;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isEnabled()) {
            this.structurePositions2 = (ArrayList)this.structurePositions.clone();
            this.selected2 = this.selected;
            if (this.selected != null) {
                this.layerPanel.mainapp.openStructure(this.selected);
            } else {
                int position;
                int structureIndex;
                int x = e.getX();
                if (x >= 0 && x < this.getWidth() && (structureIndex = this.layerPanel.mainapp.getStructureIndexAtPosition(position = (int)((double)x / (double)this.getWidth() * (double)this.layerPanel.genomeLength))) != -1) {
                    this.layerPanel.mainapp.openStructure(structureIndex);
                }
            }
        }
    }

    public void selectStructureAtPosition(int position) {
        if (this.layerPanel.mainapp != null) {
            Structure s = this.layerPanel.mainapp.getStructureAtPosition(position);
            this.selectStructure(s);
        }
    }

    public void selectStructure(Structure s) {
        if (s == null) {
            this.selectedStart = -1;
            this.selectedEnd = -1;
        } else {
            this.selectedStart = s.getStartPosition();
            this.selectedEnd = s.getEndPosition();
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.popupMenu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.structures = null;
        this.mouseoverStart = -1;
        this.mouseoverEnd = -1;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.isEnabled()) {
            int x = e.getX();
            int y = e.getY();
            if (x >= 0 && x < this.getWidth()) {
                int position = (int)((double)x / (double)this.getWidth() * (double)this.layerPanel.genomeLength);
                if (this.layerPanel.mainapp != null) {
                    Structure s = this.layerPanel.mainapp.getStructureAtPosition(position);
                    Structure largest = this.layerPanel.mainapp.getLargestStructureAtPosition(position, 500);
                    if (largest != null) {
                        this.selected = null;
                        this.structures = this.layerPanel.mainapp.getStructuresInRegion(largest.startPosition, largest.getEndPosition());
                        this.structurePositions = this.getStructurePositions(this.structures);
                        for (int i = 0; i < this.structurePositions.size(); ++i) {
                            if (!this.structurePositions.get((int)i).rectangle.contains(x, y)) continue;
                            this.selected = this.structurePositions.get((int)i).structure;
                        }
                        if (this.selected == null) {
                            this.selected = s;
                        }
                    } else {
                        this.structures = null;
                    }
                    if (this.selected == null) {
                        this.mouseoverStart = -1;
                        this.mouseoverEnd = -1;
                    } else {
                        this.mouseoverStart = this.selected.getStartPosition();
                        this.mouseoverEnd = this.selected.getEndPosition();
                    }
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.autofitItem)) {
            this.layerPanel.autofitWidth();
        } else if (e.getSource().equals(this.zoomInItem)) {
            this.layerPanel.zoomIn();
        } else if (e.getSource().equals(this.zoomOutItem)) {
            this.layerPanel.zoomOut();
        }
    }

    public ArrayList<StructureAndMouseoverRegion> getStructurePositions(ArrayList<Structure> structures) {
        int i;
        double rulerHeight = 0.0;
        ArrayList<StructureAndMouseoverRegion> rectangles = new ArrayList<StructureAndMouseoverRegion>();
        double minDistance = 3.0;
        int level = 0;
        System.out.println("start");
        for (i = 0; i < structures.size(); ++i) {
            double h = ((double)this.getHeight() - rulerHeight - 1.0) / (double)structures.size();
            double y = rulerHeight + (double)i * h;
            double mouseoverLength = (double)structures.get(i).getEndPosition() - (double)structures.get((int)i).startPosition;
            double regionWidth = mouseoverLength / (double)this.layerPanel.genomeLength * (double)this.getWidth();
            double x = (double)structures.get((int)i).startPosition / (double)this.layerPanel.genomeLength * (double)this.getWidth();
            Rectangle2D.Double rect = new Rectangle2D.Double(x + (double)this.xoffset, y, regionWidth, h);
            int rectLevel = 0;
            for (rectLevel = 0; rectLevel <= level + 1; ++rectLevel) {
                double dist = this.minHorizontalDistance(rectangles, rect, rectLevel);
                System.out.println(i + "\t" + dist + "\t" + level + "\t" + rect);
                if (!(dist < minDistance)) break;
            }
            System.out.println(rectLevel);
            level = Math.max(level, rectLevel);
            ((Rectangle2D)rect).setRect(x + (double)this.xoffset, rulerHeight + (double)rectLevel * h, regionWidth, h);
            rectangles.add(new StructureAndMouseoverRegion(structures.get(i), rect, rectLevel));
        }
        for (i = 0; i < rectangles.size(); ++i) {
            Rectangle2D r = rectangles.get((int)i).rectangle;
            double h = ((double)this.getHeight() - rulerHeight - 1.0) / (double)(level + 1);
            double y = rulerHeight + (double)rectangles.get((int)i).level * h;
            rectangles.get((int)i).rectangle.setRect(r.getX(), y, r.getWidth(), h);
        }
        return rectangles;
    }

    public double minHorizontalDistance(ArrayList<StructureAndMouseoverRegion> rectangles, Rectangle2D rect, int level) {
        double x = rect.getX();
        double width = rect.getWidth();
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < rectangles.size(); ++i) {
            double dist2;
            StructureAndMouseoverRegion other = rectangles.get(i);
            if (other.level != level) continue;
            double dist1 = other.rectangle.getX() - (x + width);
            if (dist1 >= 0.0) {
                distance = Math.min(distance, dist1);
            }
            if ((dist2 = x - (other.rectangle.getX() + other.rectangle.getWidth())) >= 0.0) {
                distance = Math.min(distance, dist2);
            }
            if (x >= other.rectangle.getX() && x + width <= other.rectangle.getX() + other.rectangle.getWidth()) {
                distance = 0.0;
            }
            if (!(x <= other.rectangle.getX()) || !(x + width >= other.rectangle.getX() + other.rectangle.getWidth())) continue;
            distance = 0.0;
        }
        return distance;
    }

    public class StructureAndMouseoverRegion {
        Structure structure;
        Rectangle2D rectangle;
        int level;

        public StructureAndMouseoverRegion(Structure structure, Rectangle2D rectangle, int level) {
            this.structure = structure;
            this.rectangle = rectangle;
            this.level = level;
        }
    }
}

