/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import structurevis.ui.datacreation.wizard.WizardController;
import structurevis.ui.datacreation.wizard.WizardListener;
import structurevis.ui.datacreation.wizard.WizardModel;
import structurevis.ui.datacreation.wizard.WizardPanelDescriptor;

public class Wizard
extends WindowAdapter
implements PropertyChangeListener {
    public static JFileChooser fileChooserOpen = new JFileChooser();
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    static String BACK_TEXT;
    static String NEXT_TEXT;
    static String FINISH_TEXT;
    static String CANCEL_TEXT;
    static Icon BACK_ICON;
    static Icon NEXT_ICON;
    static Icon FINISH_ICON;
    static Icon CANCEL_ICON;
    private WizardModel wizardModel;
    private WizardController wizardController;
    private JDialog wizardDialog;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private int returnCode;
    EventListenerList wizardListenerList = new EventListenerList();

    public Wizard() {
        this((JFrame)null);
    }

    public Wizard(JDialog owner) {
        this.wizardModel = new WizardModel();
        this.wizardDialog = new JDialog(owner);
        this.initComponents();
    }

    public Wizard(JFrame owner) {
        this.wizardModel = new WizardModel();
        this.wizardDialog = new JDialog(owner);
        this.initComponents();
    }

    public JDialog getDialog() {
        return this.wizardDialog;
    }

    public Component getOwner() {
        return this.wizardDialog.getOwner();
    }

    public void setTitle(String s) {
        this.wizardDialog.setTitle(s);
    }

    public String getTitle() {
        return this.wizardDialog.getTitle();
    }

    public void setModal(boolean b) {
        this.wizardDialog.setModal(b);
    }

    public boolean isModal() {
        return this.wizardDialog.isModal();
    }

    public int showModalDialog() {
        this.wizardDialog.setModal(true);
        this.wizardDialog.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.wizardDialog.getWidth()) / 2;
        int y = (screenSize.height - this.wizardDialog.getHeight()) / 2;
        this.wizardDialog.setLocation(x, y);
        this.wizardDialog.setVisible(true);
        return this.returnCode;
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public void registerWizardPanel(Object id, WizardPanelDescriptor panel) {
        this.cardPanel.add(panel.getPanelComponent(), id);
        panel.setWizard(this);
        this.wizardModel.registerPanel(id, panel);
    }

    public void setCurrentPanel(Object id) {
        WizardPanelDescriptor oldPanelDescriptor;
        if (id == null) {
            this.close(2);
        }
        if ((oldPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor()) != null) {
            oldPanelDescriptor.aboutToHidePanel();
        }
        this.wizardModel.setCurrentPanel(id);
        this.wizardModel.getCurrentPanelDescriptor().aboutToDisplayPanel();
        this.cardLayout.show(this.cardPanel, id.toString());
        this.wizardModel.getCurrentPanelDescriptor().displayingPanel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("currentPanelDescriptorProperty")) {
            this.wizardController.resetButtonsToPanelRules();
        } else if (evt.getPropertyName().equals("nextButtonTextProperty")) {
            this.nextButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("backButtonTextProperty")) {
            this.backButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("cancelButtonTextProperty")) {
            this.cancelButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("nextButtonEnabledProperty")) {
            this.nextButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("backButtonEnabledProperty")) {
            this.backButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("cancelButtonEnabledProperty")) {
            this.cancelButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("nextButtonIconProperty")) {
            this.nextButton.setIcon((Icon)evt.getNewValue());
        } else if (evt.getPropertyName().equals("backButtonIconProperty")) {
            this.backButton.setIcon((Icon)evt.getNewValue());
        } else if (evt.getPropertyName().equals("cancelButtonIconProperty")) {
            this.cancelButton.setIcon((Icon)evt.getNewValue());
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public boolean getBackButtonEnabled() {
        return this.wizardModel.getBackButtonEnabled();
    }

    public void setBackButtonEnabled(boolean newValue) {
        this.wizardModel.setBackButtonEnabled(new Boolean(newValue));
    }

    public boolean getNextFinishButtonEnabled() {
        return this.wizardModel.getNextFinishButtonEnabled();
    }

    public void setNextFinishButtonEnabled(boolean newValue) {
        this.wizardModel.setNextFinishButtonEnabled(new Boolean(newValue));
    }

    public void showErrorsBeforeContinue(boolean newValue) {
        this.wizardModel.showErrors = true;
    }

    public boolean getCancelButtonEnabled() {
        return this.wizardModel.getCancelButtonEnabled();
    }

    public void setCancelButtonEnabled(boolean newValue) {
        this.wizardModel.setCancelButtonEnabled(new Boolean(newValue));
    }

    public void close(int code) {
        this.returnCode = code;
        this.wizardDialog.dispose();
    }

    private void initComponents() {
        this.wizardModel.addPropertyChangeListener(this);
        this.wizardController = new WizardController(this);
        this.wizardDialog.getContentPane().setLayout(new BorderLayout());
        this.wizardDialog.addWindowListener(this);
        JPanel buttonPanel = new JPanel();
        JSeparator separator = new JSeparator();
        Box buttonBox = new Box(0);
        this.cardPanel = new JPanel();
        this.cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.wizardController);
        this.nextButton.addActionListener(this.wizardController);
        this.cancelButton.addActionListener(this.wizardController);
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)separator, "North");
        buttonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        buttonBox.add(this.backButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.nextButton);
        buttonBox.add(Box.createHorizontalStrut(30));
        buttonBox.add(this.cancelButton);
        buttonPanel.add((Component)buttonBox, "East");
        this.wizardDialog.getContentPane().add((Component)buttonPanel, "South");
        this.wizardDialog.getContentPane().add((Component)this.cardPanel, "Center");
    }

    private static Object getImage(String name) {
        Object url = null;
        return Wizard.class.getResource(name);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.returnCode = 1;
    }

    public void addWizardListener(WizardListener l) {
        this.wizardListenerList.add(WizardListener.class, l);
    }

    public void removeWizardListener(WizardListener l) {
        this.wizardListenerList.remove(WizardListener.class, l);
    }

    public void firePanelChangedEvent(Object fromPanelIdentifier, Object toPanelIdentifier) {
        Object[] listeners = this.wizardListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WizardListener.class) continue;
            ((WizardListener)listeners[i + 1]).panelChangedEvent(fromPanelIdentifier, toPanelIdentifier);
        }
    }

    static {
        try {
            PropertyResourceBundle resources = (PropertyResourceBundle)ResourceBundle.getBundle("structurevis.ui.datacreation.wizard.wizard");
            BACK_TEXT = (String)resources.getObject("backButtonText");
            NEXT_TEXT = (String)resources.getObject("nextButtonText");
            CANCEL_TEXT = (String)resources.getObject("cancelButtonText");
            FINISH_TEXT = (String)resources.getObject("finishButtonText");
        }
        catch (MissingResourceException mre) {
            System.out.println(mre);
            System.exit(1);
        }
    }
}

