/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import structurevis.ui.MainApp;
import structurevis.ui.datacreation.DataModel;
import structurevis.ui.datacreation.WizardMain;
import structurevis.ui.datacreation.wizard.Wizard;

public class WelcomePanel
extends JPanel
implements HyperlinkListener,
KeyListener {
    ImageIcon errorIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png"));
    ImageIcon correctIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/correct.png"));
    DataModel dataModel;
    Desktop desktop = null;
    private JButton browseButton;
    private JLabel errorLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;
    private JTextField projectDirectoryField;
    private JTextField projectLocationField;
    private JTextField projectNameField;

    public WelcomePanel(DataModel dataModel) {
        this.dataModel = dataModel;
        this.initComponents();
        String fileName = dataModel.getNextFileName(MainApp.defaultWorkspace.getAbsolutePath(), "UntitledProject");
        this.projectNameField.addKeyListener(this);
        this.projectNameField.setText(fileName);
        this.projectLocationField.setText(MainApp.defaultWorkspace.getAbsolutePath());
        dataModel.projectDirectory = new File(MainApp.defaultWorkspace.getAbsolutePath() + File.separatorChar + fileName);
        this.projectDirectoryField.setText(dataModel.projectDirectory.getAbsolutePath());
        try {
            PropertyResourceBundle resources = (PropertyResourceBundle)ResourceBundle.getBundle("structurevis.ui.datacreation.text");
            this.jTextPane1.setText(resources.getString("WELCOME_DESCRIPTION"));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (Desktop.isDesktopSupported()) {
            this.desktop = Desktop.getDesktop();
        }
        this.jTextPane1.addHyperlinkListener(this);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.projectLocationField = new JTextField();
        this.browseButton = new JButton();
        this.projectNameField = new JTextField();
        this.projectDirectoryField = new JTextField();
        this.errorLabel = new JLabel();
        this.jTextPane1.setContentType("text/html");
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setPreferredSize(new Dimension(640, 6));
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jLabel1.setText("Project name:");
        this.jLabel2.setText("Project location:");
        this.jLabel3.setText("Project directory:");
        this.projectLocationField.setEditable(false);
        this.browseButton.setText("Browse...");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomePanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.projectNameField.setText("UntitledProject");
        this.projectDirectoryField.setEditable(false);
        this.errorLabel.setForeground(new Color(255, 0, 0));
        this.errorLabel.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectDirectoryField, -1, 370, Short.MAX_VALUE).addComponent(this.projectLocationField, GroupLayout.Alignment.TRAILING, -1, 370, Short.MAX_VALUE).addComponent(this.projectNameField, GroupLayout.Alignment.TRAILING, -1, 370, Short.MAX_VALUE).addComponent(this.errorLabel, -1, 370, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.browseButton)).addComponent(this.jLabel3)).addContainerGap()).addComponent(this.jScrollPane1, -1, 587, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 238, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.projectNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseButton).addComponent(this.projectLocationField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.projectDirectoryField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel)));
    }

    public void updateFields() {
        this.dataModel.projectDirectory = new File(this.projectLocationField.getText() + "\\" + this.projectNameField.getText() + "\\");
        this.projectDirectoryField.setText(this.dataModel.projectDirectory.getAbsolutePath());
        this.errorLabel.setIcon(this.errorIcon);
        if (this.projectNameField.getText().length() < 1) {
            this.errorLabel.setText("Please enter a project name.");
            WizardMain.wizard.setNextFinishButtonEnabled(false);
        } else if (this.dataModel.projectDirectory.exists()) {
            this.errorLabel.setText("A project with this name already exists in this location. Choose a different project name.");
            WizardMain.wizard.setNextFinishButtonEnabled(false);
        } else {
            this.errorLabel.setText(" ");
            this.errorLabel.setIcon(null);
            WizardMain.wizard.setNextFinishButtonEnabled(true);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        if (new File(this.projectLocationField.getText()).exists()) {
            Wizard.fileChooserOpen.setSelectedFile(new File(this.projectLocationField.getText()));
        }
        Wizard.fileChooserOpen.setFileSelectionMode(1);
        int returnVal = Wizard.fileChooserOpen.showOpenDialog(this);
        if (returnVal == 0) {
            this.projectLocationField.setText(Wizard.fileChooserOpen.getSelectedFile().getAbsolutePath());
            this.updateFields();
        }
        Wizard.fileChooserOpen.setFileSelectionMode(2);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateFields();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && this.desktop != null) {
            try {
                this.desktop.browse(e.getURL().toURI());
            }
            catch (IOException ex) {
                System.err.println("WARNING: Desktop not supported.");
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(WelcomePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

