/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import structurevis.structures.StructureParser;
import structurevis.structures.io.ReadseqTools;
import structurevis.ui.datacreation.DataModel;
import structurevis.ui.datacreation.DataOverlay;
import structurevis.ui.datacreation.WizardMain;
import structurevis.ui.datacreation.wizard.Wizard;
import structurevis.ui.datacreation.wizard.WizardListener;

public class StructurePanel
extends JPanel
implements WizardListener {
    ImageIcon errorIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png"));
    ImageIcon correctIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/correct.png"));
    DataModel dataModel;
    boolean errors = true;
    private JRadioButton autoRadioButton;
    private JRadioButton circularRadioButton;
    private ButtonGroup conformationButtonGroup;
    private JButton consensusBrowseButton;
    private JComboBox consensusFileType;
    private JTextField consensusStructureField;
    private JRadioButton dnaRadioButton;
    private JLabel errorLabelFromFile;
    private JLabel errorLabelReferenceAlignment;
    private JLabel errorLabel_consensusStructure;
    private JButton fromFileBrowseButton;
    private JTextField fromFileField;
    private JRadioButton fromFileRadioButton;
    private JTextPane genomeStructureDescriptionPane;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JRadioButton linearRadioButton;
    private JSpinner maxSpinner;
    private JSpinner minSpinner;
    private ButtonGroup nucleicAcidButtonGroup;
    private JButton referenceBrowseButton;
    private JTextField referenceTextField;
    private JRadioButton rnaRadioButton;
    private JComboBox structureTypeBox1;
    private JTextPane substructureDescriptionPane;
    private ButtonGroup subtructuresButtonGroup;
    DataOverlay dataOverlay = null;

    public StructurePanel(DataModel dataModel) {
        this.dataModel = dataModel;
        this.initComponents();
        try {
            PropertyResourceBundle resources = (PropertyResourceBundle)ResourceBundle.getBundle("structurevis.ui.datacreation.text");
            this.genomeStructureDescriptionPane.setText(resources.getString("GENOME_STRUCTURE_DESCRIPTION"));
            this.substructureDescriptionPane.setText(resources.getString("SUBSTRUCTURE_DESCRIPTION"));
            this.genomeStructureDescriptionPane.setCaretPosition(0);
            this.substructureDescriptionPane.setCaretPosition(0);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.minSpinner.setModel(new SpinnerNumberModel(10, 0, Integer.MAX_VALUE, 1));
        this.maxSpinner.setModel(new SpinnerNumberModel(250, 2, Integer.MAX_VALUE, 1));
        WizardMain.wizard.addWizardListener(this);
        this.updateErrors();
    }

    public int getBestConsensusStructureFileType(File file) {
        try {
            StructureParser.parseCtFile(file);
            return 0;
        }
        catch (Exception ex) {
            try {
                StructureParser.parseNaspCtFile(file);
                return 1;
            }
            catch (Exception ex2) {
                try {
                    if (StructureParser.isDotBracketString(StructureParser.getDotBracketStringFromFile(file))) {
                        return 2;
                    }
                }
                catch (Exception ex3) {
                    // empty catch block
                }
                try {
                    StructureParser.parseTabDelimittedHelixFile(file, 0);
                    return 3;
                }
                catch (Exception exception) {
                    return -1;
                }
            }
        }
    }

    public String getConsensusStructureFileTypeError(File file) {
        String error = null;
        if (this.consensusFileType.getSelectedIndex() == 0) {
            try {
                StructureParser.parseCtFile(file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                error = "File does not appear to be a standard connect file.";
            }
        } else if (this.consensusFileType.getSelectedIndex() == 1) {
            try {
                StructureParser.parseCtFile(file);
            }
            catch (Exception ex) {
                error = "File does not appear to be a NASP connect file.";
            }
        } else if (this.consensusFileType.getSelectedIndex() == 2) {
            try {
                String dotBracketString = StructureParser.getDotBracketStringFromFile(file);
                if (!StructureParser.isDotBracketString(dotBracketString)) {
                    error = "File does not appear to be a dot bracket string file.";
                }
            }
            catch (Exception ex) {
                error = "File does not appear to be a dot bracket string file.";
            }
        } else if (this.consensusFileType.getSelectedIndex() == 3) {
            try {
                StructureParser.parseTabDelimittedHelixFile(file, 0);
            }
            catch (Exception ex) {
                error = "File does not appear to be a tab-delimitted helix file.";
            }
        }
        if (error != null) {
            int bestFileType = this.getBestConsensusStructureFileType(file);
            switch (bestFileType) {
                case -1: {
                    return "File cannot be read using any of the supported formats. Please select a different file.";
                }
                case 0: {
                    return error + " Try using 'Standard connect file'.";
                }
                case 1: {
                    return error + " Try using 'NASP connect file'.";
                }
                case 2: {
                    return error + " Try using 'Dot bracket file'.";
                }
                case 3: {
                    return error + " Try using 'Tab delimmited helix file'.";
                }
            }
        }
        return error;
    }

    public void updateErrors() {
        WizardMain.wizard.showErrorsBeforeContinue(false);
        this.errors = false;
        this.errorLabel_consensusStructure.setIcon(this.errorIcon);
        this.errorLabel_consensusStructure.setToolTipText("");
        String consensusErrorMessage = null;
        if (this.consensusStructureField.getText().equals("")) {
            this.errorLabel_consensusStructure.setToolTipText("Please select a file.");
            WizardMain.wizard.showErrorsBeforeContinue(true);
            this.errors = true;
        } else if (!this.dataModel.genomeStructureFile.exists()) {
            this.errorLabel_consensusStructure.setToolTipText("The specified file does not exist.");
            WizardMain.wizard.showErrorsBeforeContinue(true);
            this.errors = true;
        } else {
            consensusErrorMessage = this.getConsensusStructureFileTypeError(this.dataModel.genomeStructureFile);
            if (consensusErrorMessage != null) {
                this.errorLabel_consensusStructure.setToolTipText(consensusErrorMessage);
                WizardMain.wizard.showErrorsBeforeContinue(true);
                this.errors = true;
            } else {
                this.errorLabel_consensusStructure.setIcon(this.correctIcon);
            }
        }
        this.errorLabelReferenceAlignment.setIcon(this.errorIcon);
        this.errorLabelReferenceAlignment.setIcon(this.errorIcon);
        this.errorLabelReferenceAlignment.setToolTipText("");
        if (this.referenceTextField.getText().equals("")) {
            this.errorLabelReferenceAlignment.setToolTipText("Please select a file.");
            WizardMain.wizard.showErrorsBeforeContinue(true);
            this.errors = true;
        } else if (!this.dataModel.getReferenceAlignment().exists()) {
            this.errorLabelReferenceAlignment.setToolTipText("The specified file does not exist.");
            WizardMain.wizard.showErrorsBeforeContinue(true);
            this.errors = true;
        } else if (!ReadseqTools.isKnownFormat(this.dataModel.getReferenceAlignment())) {
            this.errorLabelReferenceAlignment.setToolTipText("The alignment format is not recognized.");
            WizardMain.wizard.showErrorsBeforeContinue(true);
            this.errors = true;
        } else {
            this.errorLabelReferenceAlignment.setToolTipText("The alignment format has been detected as: " + ReadseqTools.getFormatName(this.dataModel.getReferenceAlignment()) + ".");
            this.errorLabelReferenceAlignment.setIcon(this.correctIcon);
        }
        this.errorLabelFromFile.setToolTipText("");
        if (this.fromFileRadioButton.isSelected()) {
            this.errorLabelFromFile.setIcon(this.errorIcon);
            if (this.fromFileField.getText().equals("")) {
                this.errorLabelFromFile.setToolTipText("Please select a file.");
                WizardMain.wizard.showErrorsBeforeContinue(true);
                this.errors = true;
            } else if (!new File(this.referenceTextField.getText()).exists()) {
                this.errorLabelFromFile.setToolTipText("The specified file does not exist.");
                WizardMain.wizard.showErrorsBeforeContinue(true);
                this.errors = true;
            } else {
                this.errorLabelFromFile.setIcon(this.correctIcon);
            }
        } else {
            this.errorLabelFromFile.setIcon(null);
        }
    }

    private void initComponents() {
        this.nucleicAcidButtonGroup = new ButtonGroup();
        this.conformationButtonGroup = new ButtonGroup();
        this.subtructuresButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.consensusStructureField = new JTextField();
        this.consensusBrowseButton = new JButton();
        this.consensusFileType = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.genomeStructureDescriptionPane = new JTextPane();
        this.jLabel2 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.referenceBrowseButton = new JButton();
        this.referenceTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.linearRadioButton = new JRadioButton();
        this.circularRadioButton = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.jPanel4 = new JPanel();
        this.rnaRadioButton = new JRadioButton();
        this.dnaRadioButton = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.errorLabel_consensusStructure = new JLabel();
        this.errorLabelReferenceAlignment = new JLabel();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.fromFileField = new JTextField();
        this.fromFileBrowseButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.substructureDescriptionPane = new JTextPane();
        this.fromFileRadioButton = new JRadioButton();
        this.autoRadioButton = new JRadioButton();
        this.minSpinner = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.maxSpinner = new JSpinner();
        this.structureTypeBox1 = new JComboBox();
        this.jLabel6 = new JLabel();
        this.errorLabelFromFile = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Secondary structure"));
        this.jPanel1.setPreferredSize(new Dimension(912, 255));
        this.consensusStructureField.setEditable(false);
        this.consensusStructureField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructurePanel.this.consensusStructureFieldActionPerformed(evt);
            }
        });
        this.consensusBrowseButton.setText("Browse...");
        this.consensusBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructurePanel.this.consensusBrowseButtonActionPerformed(evt);
            }
        });
        this.consensusFileType.setModel(new DefaultComboBoxModel<String>(new String[]{"Standard connect file", "NASP connect file", "Dot bracket file", "Tab delimitted helix file"}));
        this.consensusFileType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructurePanel.this.consensusFileTypeActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Description");
        this.genomeStructureDescriptionPane.setContentType("text/html");
        this.genomeStructureDescriptionPane.setEditable(false);
        this.jScrollPane2.setViewportView(this.genomeStructureDescriptionPane);
        this.jLabel2.setText("Type:");
        this.jLabel8.setHorizontalAlignment(2);
        this.jLabel8.setText("Structure");
        this.jLabel9.setText("Reference alignment");
        this.referenceBrowseButton.setText("Browse...");
        this.referenceBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructurePanel.this.referenceBrowseButtonActionPerformed(evt);
            }
        });
        this.referenceTextField.setEditable(false);
        this.referenceTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructurePanel.this.referenceTextFieldActionPerformed(evt);
            }
        });
        this.conformationButtonGroup.add(this.linearRadioButton);
        this.linearRadioButton.setSelected(true);
        this.linearRadioButton.setText("Linear");
        this.linearRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StructurePanel.this.linearRadioButtonStateChanged(evt);
            }
        });
        this.conformationButtonGroup.add(this.circularRadioButton);
        this.circularRadioButton.setText("Circular");
        this.jLabel7.setText("Conformation");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(18, 18, 18).addComponent(this.linearRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.circularRadioButton).addContainerGap(102, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7, -2, 14, -2).addComponent(this.linearRadioButton).addComponent(this.circularRadioButton)));
        this.nucleicAcidButtonGroup.add(this.rnaRadioButton);
        this.rnaRadioButton.setSelected(true);
        this.rnaRadioButton.setText("RNA");
        this.rnaRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StructurePanel.this.rnaRadioButtonStateChanged(evt);
            }
        });
        this.nucleicAcidButtonGroup.add(this.dnaRadioButton);
        this.dnaRadioButton.setText("DNA");
        this.jLabel10.setText("Nucleic acid");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel10).addGap(18, 18, 18).addComponent(this.rnaRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dnaRadioButton).addContainerGap(86, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10, -2, 14, -2).addComponent(this.rnaRadioButton).addComponent(this.dnaRadioButton)));
        this.errorLabel_consensusStructure.setIcon(new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png")));
        this.errorLabel_consensusStructure.setText(" ");
        this.errorLabelReferenceAlignment.setIcon(new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png")));
        this.errorLabelReferenceAlignment.setText(" ");
        this.jButton1.setText("Auto-detect");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructurePanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 711, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.consensusStructureField, -1, 268, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel_consensusStructure).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.consensusBrowseButton).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.consensusFileType, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9).addGap(10, 10, 10).addComponent(this.referenceTextField, -1, 398, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabelReferenceAlignment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referenceBrowseButton)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.consensusStructureField, -2, -1, -2).addComponent(this.consensusFileType, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jButton1).addComponent(this.consensusBrowseButton).addComponent(this.errorLabel_consensusStructure)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.referenceTextField, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.referenceBrowseButton).addComponent(this.errorLabelReferenceAlignment)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addGap(20, 20, 20).addComponent(this.jLabel1)).addComponent(this.jPanel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 92, Short.MAX_VALUE).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Substructures"));
        this.fromFileField.setEditable(false);
        this.fromFileBrowseButton.setText("Browse...");
        this.fromFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructurePanel.this.fromFileBrowseButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Description");
        this.substructureDescriptionPane.setContentType("text/html");
        this.substructureDescriptionPane.setEditable(false);
        this.jScrollPane3.setViewportView(this.substructureDescriptionPane);
        this.subtructuresButtonGroup.add(this.fromFileRadioButton);
        this.fromFileRadioButton.setText("From file");
        this.fromFileRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StructurePanel.this.fromFileRadioButtonStateChanged(evt);
            }
        });
        this.subtructuresButtonGroup.add(this.autoRadioButton);
        this.autoRadioButton.setSelected(true);
        this.autoRadioButton.setText("Auto-generate from consensus structure");
        this.minSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StructurePanel.this.minSpinnerStateChanged(evt);
            }
        });
        this.jLabel4.setText("Min. substructure size (nucleotides)");
        this.jLabel5.setText("Max. substructure size (nucleotides)");
        this.maxSpinner.setVerifyInputWhenFocusTarget(false);
        this.maxSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StructurePanel.this.maxSpinnerStateChanged(evt);
            }
        });
        this.structureTypeBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"NASP structures file", "Existing structure collection"}));
        this.structureTypeBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructurePanel.this.structureTypeBox1ActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Type:");
        this.errorLabelFromFile.setIcon(new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png")));
        this.errorLabelFromFile.setText(" ");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 711, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.fromFileRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fromFileField, -1, 359, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabelFromFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromFileBrowseButton)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.autoRadioButton).addGap(32, 32, 32).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.maxSpinner).addComponent(this.minSpinner, -1, 57, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6).addGap(10, 10, 10).addComponent(this.structureTypeBox1, 0, 124, Short.MAX_VALUE)).addComponent(this.jLabel3)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoRadioButton).addComponent(this.jLabel4).addComponent(this.minSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.maxSpinner, -2, 20, -2)).addGap(62, 62, 62)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fromFileField, -2, -1, -2).addComponent(this.fromFileBrowseButton).addComponent(this.structureTypeBox1, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.fromFileRadioButton).addComponent(this.errorLabelFromFile)).addGap(18, 18, 18))).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 83, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, 743, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 286, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void consensusFileTypeActionPerformed(ActionEvent evt) {
        switch (this.consensusFileType.getSelectedIndex()) {
            case 0: {
                this.dataModel.genomeStructureFileType = DataModel.GenomeStructureFileType.STANDARD_CT_FILE;
                break;
            }
            case 1: {
                this.dataModel.genomeStructureFileType = DataModel.GenomeStructureFileType.NASP_CT_FILE;
                break;
            }
            case 2: {
                this.dataModel.genomeStructureFileType = DataModel.GenomeStructureFileType.DOT_BRACKET_FILE;
                break;
            }
            case 3: {
                this.dataModel.genomeStructureFileType = DataModel.GenomeStructureFileType.TAB_DELIMITTED_HELIX;
            }
        }
        this.updateErrors();
    }

    private void structureTypeBox1ActionPerformed(ActionEvent evt) {
        switch (this.structureTypeBox1.getSelectedIndex()) {
            case 0: {
                this.dataModel.substructuresStructureFileType = DataModel.SubstructuresStructureFileType.NASP_FILE_TYPE;
                break;
            }
            case 1: {
                this.dataModel.substructuresStructureFileType = DataModel.SubstructuresStructureFileType.EXISTING_COLLECTION;
            }
        }
        this.updateErrors();
    }

    private void consensusBrowseButtonActionPerformed(ActionEvent evt) {
        int returnVal = Wizard.fileChooserOpen.showOpenDialog(this);
        if (returnVal == 0) {
            this.consensusStructureField.setText(Wizard.fileChooserOpen.getSelectedFile().getPath());
            this.dataModel.genomeStructureFile = Wizard.fileChooserOpen.getSelectedFile();
        }
        this.updateErrors();
    }

    private void referenceBrowseButtonActionPerformed(ActionEvent evt) {
        int returnVal = Wizard.fileChooserOpen.showOpenDialog(this);
        if (returnVal == 0) {
            this.referenceTextField.setText(Wizard.fileChooserOpen.getSelectedFile().getPath());
            this.dataModel.setReferenceAlignment(Wizard.fileChooserOpen.getSelectedFile());
        }
        this.updateErrors();
    }

    private void referenceTextFieldActionPerformed(ActionEvent evt) {
    }

    private void rnaRadioButtonStateChanged(ChangeEvent evt) {
        this.dataModel.nucleicAcidRNA = this.rnaRadioButton.isSelected();
    }

    private void linearRadioButtonStateChanged(ChangeEvent evt) {
        this.dataModel.conformationCircular = !this.linearRadioButton.isSelected();
    }

    private void fromFileBrowseButtonActionPerformed(ActionEvent evt) {
        int returnVal = Wizard.fileChooserOpen.showOpenDialog(this);
        if (returnVal == 0) {
            this.fromFileField.setText(Wizard.fileChooserOpen.getSelectedFile().getPath());
            this.dataModel.substructureFile = Wizard.fileChooserOpen.getSelectedFile();
        }
        this.updateErrors();
    }

    private void consensusStructureFieldActionPerformed(ActionEvent evt) {
    }

    private void fromFileRadioButtonStateChanged(ChangeEvent evt) {
        this.dataModel.substructureFile = !this.fromFileRadioButton.isSelected() ? null : new File(this.fromFileField.getText());
        this.updateErrors();
    }

    private void minSpinnerStateChanged(ChangeEvent evt) {
        this.dataModel.minSubstructureSize = (Integer)this.minSpinner.getValue();
        if ((Integer)this.maxSpinner.getValue() < (Integer)this.minSpinner.getValue()) {
            this.minSpinner.setValue(this.maxSpinner.getValue());
        }
    }

    private void maxSpinnerStateChanged(ChangeEvent evt) {
        this.dataModel.maxSubstructureSize = (Integer)this.maxSpinner.getValue();
        if ((Integer)this.maxSpinner.getValue() < (Integer)this.minSpinner.getValue()) {
            this.maxSpinner.setValue(this.minSpinner.getValue());
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        File consensusFile = new File(this.consensusStructureField.getText());
        if (consensusFile.exists()) {
            int index = this.getBestConsensusStructureFileType(consensusFile);
            if (index >= 0) {
                this.consensusFileType.setSelectedIndex(index);
            } else {
                JOptionPane.showMessageDialog(this, "No suitable file type could be detected.", "Error", 0);
            }
        }
    }

    @Override
    public void panelChangedEvent(Object fromPanelIdentifier, Object toPanelIdentifier) {
        Object[] options;
        int n;
        if (fromPanelIdentifier.equals("STRUCTURE_PANEL") && toPanelIdentifier.equals("GENOME_ORGANIZATION_PANEL") && this.errors && (n = JOptionPane.showOptionDialog(this, "There are error(s) on the previous panel that will prevent the dataset creation wizard from completing successfully. Review settings now?", "Critical error(s)", 0, 2, null, options = new Object[]{"Yes (recommended)", "No"}, options[0])) == 0) {
            WizardMain.wizard.setCurrentPanel("STRUCTURE_PANEL");
        }
    }
}

