/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import structurevis.data.SparseMatrix;
import structurevis.structures.io.ReadseqTools;
import structurevis.ui.DataLegend;
import structurevis.ui.DataTransform;
import structurevis.ui.datacreation.DataModel;
import structurevis.ui.datacreation.DataOverlay;
import structurevis.ui.datacreation.DataSource2D;
import structurevis.ui.datacreation.verifiers.DecimalVerifier;
import structurevis.ui.datacreation.verifiers.TextVerifier;
import structurevis.ui.datacreation.wizard.Wizard;

public class SequenceDialog2D
extends JDialog
implements KeyListener {
    ImageIcon errorIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png"));
    ImageIcon correctIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/correct.png"));
    Image appIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/sv_icon.png")).getImage();
    DataOverlay dataOverlay = new DataOverlay();
    int currentIndex = 0;
    DataSource2D currentItem;
    DefaultComboBoxModel positionBoxModel = new DefaultComboBoxModel();
    DefaultComboBoxModel dataBoxModel = new DefaultComboBoxModel();
    DataModel dataModel;
    int openIndex = -1;
    HashMap<DataSource2D, Double> minDataTable = new HashMap();
    HashMap<DataSource2D, Double> maxDataTable = new HashMap();
    DecimalVerifier decimalVerifier = new DecimalVerifier();
    TextVerifier textVerifier = new TextVerifier();
    DataLegend dataLegend1 = new DataLegend();
    private JButton addButton;
    private JButton addNewButton;
    private JCheckBox codonPositionsCheckBox;
    private JTextField currentField;
    private JButton dataBrowseButton;
    private JTextField dataFileField;
    private JComboBox dataMaxComboBox;
    private JComboBox dataMinComboBox;
    private JComboBox dataTypeComboBox;
    private JButton deleteButton;
    private JLabel errorLabel_dataFile;
    private JLabel errorLabel_fieldName;
    private JLabel errorLabel_mappingAlignment;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTextField jTextField3;
    private JTextPane jTextPane1;
    private JButton mappingBrowseButton;
    private JTextField mappingFileField;
    private JTextField maxField;
    private JTextField minField;
    private JTextField nameField;
    private JButton nextButton;
    private JButton previousButton;
    private JComboBox transformTypeComboBox;
    private JTextField upperField;

    public SequenceDialog2D(Frame parent, boolean modal, DataModel dataModel, int openOverlay) {
        super(parent, modal);
        this.initComponents();
        if (openOverlay == -1) {
            this.addNewDataSource();
        }
        this.dataModel = dataModel;
        this.openIndex = openOverlay;
        if (openOverlay == -1) {
            this.nameField.setText(dataModel.getNextName("SequenceData2D_"));
            this.updateTextFields();
        }
        if (openOverlay != -1) {
            this.dataOverlay = dataModel.overlays.get(openOverlay);
            this.dataLegend1.colorGradient = this.dataOverlay.colorGradient;
            this.nameField.setText(this.dataOverlay.fieldName);
            this.transformTypeComboBox.setSelectedIndex(this.dataOverlay.transformType.ordinal());
            if (this.dataOverlay.useMin) {
                this.dataMinComboBox.setSelectedIndex(0);
            } else {
                this.dataMinComboBox.setSelectedIndex(1);
            }
            if (this.dataOverlay.useMax) {
                this.dataMaxComboBox.setSelectedIndex(0);
            } else {
                this.dataMaxComboBox.setSelectedIndex(1);
            }
            this.minField.setText(this.dataOverlay.minValue + "");
            this.maxField.setText(this.dataOverlay.maxValue + "");
            this.currentItem = this.dataOverlay.dataSources2D.get(0);
            this.updateDataLegend();
            this.displayDataSource(0);
        } else {
            this.updateDataLegend();
        }
        this.jTextPane1.setCaretPosition(0);
        this.nameField.addKeyListener(this);
        this.minField.addKeyListener(this);
        this.maxField.addKeyListener(this);
        this.nameField.setInputVerifier(this.textVerifier);
        this.minField.setInputVerifier(this.decimalVerifier);
        this.maxField.setInputVerifier(this.decimalVerifier);
        this.setTitle("Add 2-dimensional data");
        this.setIconImage(this.appIcon);
        this.dataLegend1.showEditMode();
        this.jScrollPane1.setViewportView(this.dataLegend1);
        this.updateToolTips();
    }

    public void updateToolTips() {
        this.errorLabel_dataFile.setIcon(this.errorIcon);
        this.errorLabel_dataFile.setToolTipText("");
        if (this.dataFileField.getText().equals("")) {
            this.errorLabel_dataFile.setToolTipText("Please select a file.");
        } else if (!new File(this.dataFileField.getText()).exists()) {
            this.errorLabel_dataFile.setToolTipText("The specified file does not exist.");
        } else {
            this.errorLabel_dataFile.setIcon(this.correctIcon);
        }
        this.errorLabel_mappingAlignment.setIcon(this.errorIcon);
        this.errorLabel_mappingAlignment.setIcon(this.errorIcon);
        this.errorLabel_mappingAlignment.setToolTipText("");
        if (this.mappingFileField.getText().equals("")) {
            this.errorLabel_mappingAlignment.setToolTipText("Please select a file.");
        } else if (!new File(this.mappingFileField.getText()).exists()) {
            this.errorLabel_mappingAlignment.setToolTipText("The specified file does not exist.");
        } else if (!ReadseqTools.isKnownFormat(new File(this.mappingFileField.getText()))) {
            this.errorLabel_mappingAlignment.setToolTipText("The alignment format is not recognized.");
        } else {
            this.errorLabel_mappingAlignment.setToolTipText("The alignment format has been detected as: " + ReadseqTools.getFormatName(new File(this.mappingFileField.getText())) + ".");
            this.errorLabel_mappingAlignment.setIcon(this.correctIcon);
        }
        this.errorLabel_fieldName.setToolTipText("");
        this.errorLabel_fieldName.setIcon(this.errorIcon);
        if (this.nameField.getText().equals("")) {
            this.errorLabel_fieldName.setToolTipText("Please enter a name.");
        } else if (this.dataModel.isFieldNameUsed(this.nameField.getText(), this.dataOverlay)) {
            this.errorLabel_fieldName.setToolTipText("A data overlay with this name already exists in this project. Please use a different name.");
        } else {
            this.errorLabel_fieldName.setIcon(null);
        }
    }

    public void updateMinMaxField() {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int j = 0; j < this.dataOverlay.dataSources2D.size(); ++j) {
            double[] minAndMax;
            File dataFile = this.dataOverlay.dataSources2D.get((int)j).dataFile;
            if (!dataFile.exists()) continue;
            if (this.dataOverlay.dataSources2D.get((int)j).dataFileType == 0) {
                if (!this.minDataTable.containsKey(this.dataOverlay.dataSources2D.get(j))) {
                    minAndMax = SparseMatrix.getMinAndMaxFromFile(dataFile);
                    min = Math.min(minAndMax[0], min);
                    max = Math.max(minAndMax[1], max);
                    this.minDataTable.put(this.dataOverlay.dataSources2D.get(j), minAndMax[0]);
                    this.maxDataTable.put(this.dataOverlay.dataSources2D.get(j), minAndMax[1]);
                    continue;
                }
                min = Math.min(this.minDataTable.get(this.dataOverlay.dataSources2D.get(j)), min);
                max = Math.max(this.maxDataTable.get(this.dataOverlay.dataSources2D.get(j)), max);
                continue;
            }
            if (this.dataOverlay.dataSources2D.get((int)j).dataFileType != 1) continue;
            if (!this.minDataTable.containsKey(this.dataOverlay.dataSources2D.get(j))) {
                minAndMax = SparseMatrix.loadSparseMatrixFromPairwiseFile(dataFile, "\t").getMinAndMax();
                min = Math.min(minAndMax[0], min);
                max = Math.max(minAndMax[1], max);
                this.minDataTable.put(this.dataOverlay.dataSources2D.get(j), minAndMax[0]);
                this.maxDataTable.put(this.dataOverlay.dataSources2D.get(j), minAndMax[1]);
                continue;
            }
            min = Math.min(this.minDataTable.get(this.dataOverlay.dataSources2D.get(j)), min);
            max = Math.max(this.maxDataTable.get(this.dataOverlay.dataSources2D.get(j)), max);
        }
        if (min == Double.MAX_VALUE && max == Double.MIN_VALUE) {
            min = 0.0;
            max = 1.0;
        }
        if (this.dataOverlay.useMin) {
            this.minField.setText(min + "");
        }
        if (this.dataOverlay.useMax) {
            this.maxField.setText(max + "");
        }
    }

    public void updateDataLegend() {
        double min = Double.parseDouble(this.minField.getText());
        double max = Double.parseDouble(this.maxField.getText());
        DataTransform.TransformType type = DataTransform.TransformType.IDENTITY;
        switch (this.transformTypeComboBox.getSelectedIndex()) {
            case 0: {
                type = DataTransform.TransformType.LINEAR;
                break;
            }
            case 1: {
                type = DataTransform.TransformType.EXPLOG;
            }
        }
        DataTransform dt = new DataTransform(min, max, type);
        if (this.dataLegend1.colorGradient != null) {
            this.dataOverlay.colorGradient = this.dataLegend1.colorGradient;
        }
        this.dataLegend1.initialise(this.nameField.getText(), dt, this.dataOverlay.colorGradient, this.dataOverlay.colorGradient);
    }

    private void initComponents() {
        this.jTextField3 = new JTextField();
        this.jLabel8 = new JLabel();
        this.jPanel1 = new JPanel();
        this.dataBrowseButton = new JButton();
        this.mappingBrowseButton = new JButton();
        this.mappingFileField = new JTextField();
        this.dataFileField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel3 = new JLabel();
        this.dataTypeComboBox = new JComboBox();
        this.codonPositionsCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.previousButton = new JButton();
        this.currentField = new JTextField();
        this.jLabel12 = new JLabel();
        this.upperField = new JTextField();
        this.nextButton = new JButton();
        this.addNewButton = new JButton();
        this.deleteButton = new JButton();
        this.errorLabel_dataFile = new JLabel();
        this.errorLabel_mappingAlignment = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.transformTypeComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.minField = new JTextField();
        this.jLabel7 = new JLabel();
        this.nameField = new JTextField();
        this.dataMinComboBox = new JComboBox();
        this.dataMaxComboBox = new JComboBox();
        this.maxField = new JTextField();
        this.jLabel9 = new JLabel();
        this.errorLabel_fieldName = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.addButton = new JButton();
        this.jTextField3.setText("jTextField3");
        this.jLabel8.setText("jLabel8");
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(700, 550));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Data sources"));
        this.dataBrowseButton.setText("Browse...");
        this.dataBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.dataBrowseButtonActionPerformed(evt);
            }
        });
        this.mappingBrowseButton.setText("Browse...");
        this.mappingBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.mappingBrowseButtonActionPerformed(evt);
            }
        });
        this.mappingFileField.setEditable(false);
        this.mappingFileField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.mappingFileFieldActionPerformed(evt);
            }
        });
        this.dataFileField.setEditable(false);
        this.dataFileField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.dataFileFieldActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Data file");
        this.jLabel10.setText("Mapping alignment");
        this.jLabel3.setText("Data file type");
        this.dataTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"DOOSS Matrix", "Pairwise Matrix"}));
        this.dataTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.dataTypeComboBoxActionPerformed(evt);
            }
        });
        this.codonPositionsCheckBox.setText("Codon positions?");
        this.codonPositionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.codonPositionsCheckBoxActionPerformed(evt);
            }
        });
        this.previousButton.setText("<");
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.previousButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.previousButton);
        this.currentField.setHorizontalAlignment(0);
        this.currentField.setText("1");
        this.currentField.setPreferredSize(new Dimension(40, 20));
        this.jPanel3.add(this.currentField);
        this.jLabel12.setText(" of ");
        this.jPanel3.add(this.jLabel12);
        this.upperField.setHorizontalAlignment(0);
        this.upperField.setText("1");
        this.upperField.setPreferredSize(new Dimension(40, 20));
        this.upperField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.upperFieldActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.upperField);
        this.nextButton.setText(">");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.nextButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.nextButton);
        this.addNewButton.setText("Add new");
        this.addNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.addNewButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.addNewButton);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.deleteButton);
        this.errorLabel_dataFile.setIcon(new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png")));
        this.errorLabel_dataFile.setText(" ");
        this.errorLabel_mappingAlignment.setIcon(new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png")));
        this.errorLabel_mappingAlignment.setText(" ");
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setText("The \"Add new\" allows you to combine multiple data sources into the same overlay. This is useful when you have related data sources corresponding to non-overlapping parts of the genome, e.g. genes. Non-empty values in the last data source take precedence (i.e. overwrite) over values in the previous data source(s).");
        this.jScrollPane3.setViewportView(this.jTextPane1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel10).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.dataTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.codonPositionsCheckBox)).addComponent(this.mappingFileField, -1, 301, Short.MAX_VALUE).addComponent(this.dataFileField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.errorLabel_dataFile).addComponent(this.errorLabel_mappingAlignment)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mappingBrowseButton).addComponent(this.dataBrowseButton))).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.dataFileField, -2, -1, -2).addComponent(this.errorLabel_dataFile).addComponent(this.dataBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.mappingFileField, -2, -1, -2).addComponent(this.errorLabel_mappingAlignment)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.dataTypeComboBox, -2, -1, -2).addComponent(this.codonPositionsCheckBox))).addComponent(this.mappingBrowseButton, -2, 23, -2)).addGap(18, 18, 18).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jScrollPane3, -2, 70, -2)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Data display"));
        this.jLabel1.setText("Field name");
        this.transformTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Linear", "Exponential logarithm (p-values)", "None"}));
        this.transformTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.transformTypeComboBoxActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Data transform");
        this.minField.setText("0.0");
        this.minField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.minFieldActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Data minimum");
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.nameFieldActionPerformed(evt);
            }
        });
        this.dataMinComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Use minimum value", "Custom"}));
        this.dataMinComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.dataMinComboBoxActionPerformed(evt);
            }
        });
        this.dataMaxComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Use maximum value", "Custom"}));
        this.dataMaxComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.dataMaxComboBoxActionPerformed(evt);
            }
        });
        this.maxField.setText("1.0");
        this.jLabel9.setText("Data maximum");
        this.errorLabel_fieldName.setIcon(new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png")));
        this.errorLabel_fieldName.setText(" ");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel9)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.dataMaxComboBox, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.dataMinComboBox, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.nameField, -1, 127, Short.MAX_VALUE).addComponent(this.transformTypeComboBox, -2, 126, -2)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minField, -1, 70, Short.MAX_VALUE).addComponent(this.maxField, -1, 70, Short.MAX_VALUE))).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.errorLabel_fieldName).addContainerGap()))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(9, 9, 9).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nameField, -2, -1, -2).addComponent(this.errorLabel_fieldName)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.transformTypeComboBox, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataMinComboBox, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.minField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxField, -2, -1, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataMaxComboBox, -2, -1, -2).addComponent(this.jLabel9)))));
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder("Data legend preview"));
        this.addButton.setText("Ok");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceDialog2D.this.addButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.addButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addContainerGap()));
        this.pack();
    }

    private void dataTypeComboBoxActionPerformed(ActionEvent evt) {
        this.currentItem.dataFileType = this.dataTypeComboBox.getSelectedIndex();
        if (this.currentItem.dataFileType == 0) {
            // empty if block
        }
    }

    private void dataBrowseButtonActionPerformed(ActionEvent evt) {
        int returnVal = Wizard.fileChooserOpen.showOpenDialog(this);
        if (returnVal == 0) {
            this.dataFileField.setText(Wizard.fileChooserOpen.getSelectedFile().getPath());
            this.currentItem.dataFile = new File(Wizard.fileChooserOpen.getSelectedFile().getPath());
            if (this.currentItem.dataFile.exists()) {
                this.displayDataSource(this.currentIndex);
            }
        }
        this.updateMinMaxField();
        this.updateToolTips();
    }

    private void mappingBrowseButtonActionPerformed(ActionEvent evt) {
        int returnVal = Wizard.fileChooserOpen.showOpenDialog(this);
        if (returnVal == 0) {
            this.mappingFileField.setText(Wizard.fileChooserOpen.getSelectedFile().getPath());
            this.currentItem.mappingFile = new File(Wizard.fileChooserOpen.getSelectedFile().getPath());
        }
        this.updateToolTips();
    }

    private void dataMinComboBoxActionPerformed(ActionEvent evt) {
        this.dataOverlay.useMin = this.dataMinComboBox.getSelectedIndex() == 0;
        this.updateMinMaxField();
        this.updateTextFields();
    }

    private void dataMaxComboBoxActionPerformed(ActionEvent evt) {
        this.dataOverlay.useMax = this.dataMaxComboBox.getSelectedIndex() == 0;
        this.updateMinMaxField();
        this.updateTextFields();
    }

    private void transformTypeComboBoxActionPerformed(ActionEvent evt) {
        switch (this.transformTypeComboBox.getSelectedIndex()) {
            case 0: {
                this.dataOverlay.transformType = DataTransform.TransformType.LINEAR;
                break;
            }
            case 1: {
                this.dataOverlay.transformType = DataTransform.TransformType.EXPLOG;
                break;
            }
            case 2: {
                this.dataOverlay.transformType = DataTransform.TransformType.IDENTITY;
            }
        }
        this.updateDataLegend();
    }

    private void addNewButtonActionPerformed(ActionEvent evt) {
        this.addNewDataSource();
        this.displayDataSource(this.currentIndex);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.displayDataSource(Math.min(this.currentIndex + 1, this.dataOverlay.dataSources2D.size() - 1));
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        this.displayDataSource(Math.max(this.currentIndex - 1, 0));
    }

    public void displayDataSource(int index) {
        this.currentItem = this.dataOverlay.dataSources2D.get(index);
        this.currentIndex = index;
        this.codonPositionsCheckBox.setSelected(this.currentItem.codonPositions);
        this.dataFileField.setText(this.currentItem.dataFile.getPath());
        this.mappingFileField.setText(this.currentItem.mappingFile.getPath());
        this.dataTypeComboBox.setSelectedIndex(this.currentItem.dataFileType);
        this.currentField.setText(this.currentIndex + 1 + "");
        this.upperField.setText(this.dataOverlay.dataSources2D.size() + "");
        this.updateTextFields();
        this.updateDataLegend();
    }

    public void updateTextFields() {
        if (this.dataMinComboBox.getSelectedIndex() == 0) {
            this.minField.setEditable(false);
        } else {
            this.minField.setEditable(true);
        }
        if (this.dataMaxComboBox.getSelectedIndex() == 0) {
            this.maxField.setEditable(false);
        } else {
            this.maxField.setEditable(true);
        }
    }

    private void upperFieldActionPerformed(ActionEvent evt) {
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (this.dataOverlay.dataSources2D.size() > 1) {
            this.dataOverlay.dataSources2D.remove(this.currentIndex);
            this.displayDataSource(Math.min(Math.max(this.currentIndex, 0), this.dataOverlay.dataSources2D.size() - 1));
        }
    }

    private void codonPositionsCheckBoxActionPerformed(ActionEvent evt) {
        this.currentItem.codonPositions = this.codonPositionsCheckBox.isSelected();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        if (this.openIndex == -1) {
            this.dataModel.overlays.add(this.dataOverlay);
        }
        this.dataOverlay.fieldName = this.nameField.getText();
        this.dataOverlay.type = "SequenceData2D";
        this.dataOverlay.colorGradient = this.dataLegend1.colorGradient;
        this.dataOverlay.minValue = Double.parseDouble(this.minField.getText());
        this.dataOverlay.maxValue = Double.parseDouble(this.maxField.getText());
        this.dispose();
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
    }

    private void dataFileFieldActionPerformed(ActionEvent evt) {
    }

    private void mappingFileFieldActionPerformed(ActionEvent evt) {
    }

    private void minFieldActionPerformed(ActionEvent evt) {
    }

    public void addNewDataSource() {
        this.currentItem = new DataSource2D();
        this.currentIndex = this.dataOverlay.dataSources2D.size();
        this.dataOverlay.dataSources2D.add(this.currentItem);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SequenceDialog2D dialog = new SequenceDialog2D((Frame)new JFrame(), true, new DataModel(), -1);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource().equals(this.nameField)) {
            this.updateDataLegend();
            if (this.nameField.getInputVerifier().verify(this.nameField)) {
                // empty if block
            }
        } else if (e.getSource().equals(this.minField)) {
            if (this.minField.getInputVerifier().verify(this.minField)) {
                this.updateDataLegend();
            }
        } else if (e.getSource().equals(this.maxField) && this.maxField.getInputVerifier().verify(this.maxField)) {
            this.updateDataLegend();
        }
        this.updateToolTips();
    }
}

