/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import structurevis.structures.io.ReadseqTools;
import structurevis.ui.datacreation.DataModel;
import structurevis.ui.datacreation.DataOverlay;
import structurevis.ui.datacreation.verifiers.TextVerifier;
import structurevis.ui.datacreation.wizard.Wizard;

public class NucleotideDialog
extends JDialog
implements KeyListener {
    ImageIcon errorIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png"));
    ImageIcon correctIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/correct.png"));
    Image appIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/sv_icon.png")).getImage();
    DataOverlay dataOverlay = new DataOverlay();
    DataModel dataModel;
    int openIndex = -1;
    TextVerifier textVerifier = new TextVerifier();
    private JButton addButton;
    private JButton browseButton;
    private JLabel errorLabelNucleotideAlignment;
    private JLabel errorLabel_fieldName;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JTextField nameField;
    private JTextField nucleotideAlignmentField;

    public NucleotideDialog(Frame parent, boolean modal, DataModel dataModel, int openOverlay) {
        super(parent, modal);
        this.openIndex = openOverlay;
        this.dataModel = dataModel;
        this.initComponents();
        if (openOverlay == -1) {
            this.nameField.setText(dataModel.getNextName("NucleotideComposition_"));
        } else {
            this.dataOverlay = dataModel.overlays.get(openOverlay);
            this.nucleotideAlignmentField.setText(dataModel.overlays.get((int)openOverlay).nucleotideAlignmentFile.getPath());
            this.nameField.setText(dataModel.overlays.get((int)openOverlay).fieldName);
        }
        this.nameField.addKeyListener(this);
        this.nameField.setInputVerifier(this.textVerifier);
        this.setTitle("Add nucleotide alignment");
        this.setIconImage(this.appIcon);
        this.updateToolTips();
    }

    public void updateToolTips() {
        this.errorLabelNucleotideAlignment.setIcon(this.errorIcon);
        this.errorLabelNucleotideAlignment.setToolTipText("");
        if (this.nucleotideAlignmentField.getText().equals("")) {
            this.errorLabelNucleotideAlignment.setToolTipText("Please select a file.");
        } else if (!new File(this.nucleotideAlignmentField.getText()).exists()) {
            this.errorLabelNucleotideAlignment.setToolTipText("The specified file does not exist.");
        } else if (!ReadseqTools.isKnownFormat(new File(this.nucleotideAlignmentField.getText()))) {
            this.errorLabelNucleotideAlignment.setToolTipText("The alignment format is not recognized.");
        } else {
            this.errorLabelNucleotideAlignment.setToolTipText("The alignment format has been detected as: " + ReadseqTools.getFormatName(new File(this.nucleotideAlignmentField.getText())) + ".");
            this.errorLabelNucleotideAlignment.setIcon(this.correctIcon);
        }
        this.errorLabel_fieldName.setToolTipText("");
        this.errorLabel_fieldName.setIcon(this.errorIcon);
        if (this.nameField.getText().equals("")) {
            this.errorLabel_fieldName.setToolTipText("Please enter a name.");
        } else if (this.dataModel.isFieldNameUsed(this.nameField.getText(), this.dataOverlay)) {
            this.errorLabel_fieldName.setToolTipText("A data overlay with this name already exists in this project. Please use a different name.");
        } else {
            this.errorLabel_fieldName.setIcon(null);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.browseButton = new JButton();
        this.nucleotideAlignmentField = new JTextField();
        this.addButton = new JButton();
        this.jLabel3 = new JLabel();
        this.nameField = new JTextField();
        this.errorLabelNucleotideAlignment = new JLabel();
        this.errorLabel_fieldName = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Nucleotide alignment");
        this.browseButton.setText("Browse...");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NucleotideDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.nucleotideAlignmentField.setEditable(false);
        this.addButton.setText("Ok");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NucleotideDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Field name");
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NucleotideDialog.this.nameFieldActionPerformed(evt);
            }
        });
        this.errorLabelNucleotideAlignment.setIcon(new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png")));
        this.errorLabelNucleotideAlignment.setText(" ");
        this.errorLabel_fieldName.setIcon(new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png")));
        this.errorLabel_fieldName.setText(" ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.addButton).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nucleotideAlignmentField, -1, 337, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabelNucleotideAlignment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(layout.createSequentialGroup().addComponent(this.nameField, -2, 227, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel_fieldName))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseButton).addComponent(this.nucleotideAlignmentField, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.errorLabelNucleotideAlignment)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.nameField, -2, -1, -2).addComponent(this.errorLabel_fieldName)).addGap(18, 18, 18).addComponent(this.addButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        int returnVal;
        if (new File(this.nucleotideAlignmentField.getText()).exists()) {
            Wizard.fileChooserOpen.setSelectedFile(new File(this.nucleotideAlignmentField.getText()));
        }
        if ((returnVal = Wizard.fileChooserOpen.showOpenDialog(this)) == 0) {
            this.nucleotideAlignmentField.setText(Wizard.fileChooserOpen.getSelectedFile().getPath());
        }
        this.updateToolTips();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        if (this.openIndex == -1) {
            this.dataModel.overlays.add(this.dataOverlay);
        }
        this.dataOverlay.nucleotideAlignmentFile = new File(this.nucleotideAlignmentField.getText());
        this.dataOverlay.fieldName = this.nameField.getText();
        this.dataOverlay.type = "NucleotideComposition";
        this.dispose();
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NucleotideDialog dialog = new NucleotideDialog((Frame)new JFrame(), true, new DataModel(), -1);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.nameField.getInputVerifier().verify(this.nameField)) {
            // empty if block
        }
        this.updateToolTips();
    }
}

