/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.symbol.Location;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;
import structurevis.data.Mapping;
import structurevis.structures.io.ReadseqTools;
import structurevis.ui.datacreation.DataModel;
import structurevis.ui.datacreation.WizardMain;

public class GenomeOrganizationTable
extends JPanel {
    DataModel dataModel;
    TableDataModel tableDataModel;
    final JTable table;
    public JScrollPane scrollPane;
    static int currentColor = 0;
    static Color[] geneColors = new Color[]{new Color(255, 190, 190), new Color(190, 255, 255), new Color(190, 190, 255), new Color(255, 190, 255), new Color(200, 255, 190), new Color(255, 255, 190)};
    public int genomeLength = 0;

    public GenomeOrganizationTable(DataModel dataModel) {
        super(new BorderLayout());
        this.dataModel = dataModel;
        this.tableDataModel = new TableDataModel();
        this.table = new JTable(this.tableDataModel);
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Boolean.class, new CheckBoxRenderer(true));
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setDefaultEditor(Color.class, new ColorEditor());
        this.table.setRowHeight(20);
        this.table.getColumnModel().getColumn(8).setCellEditor(new SpinnerEditor(0, Integer.MAX_VALUE));
        this.scrollPane = new JScrollPane(this.table);
        this.add(this.scrollPane);
    }

    public static Object[] defaultRow() {
        currentColor = (currentColor + 1) % geneColors.length;
        Object[] data = new Object[]{new Boolean(false), "", new Integer(-1), new Integer(-1), new Boolean(true), new Integer(-1), new Integer(-1), geneColors[currentColor], new Integer(0)};
        return data;
    }

    public Mapping createGenbankMapping(File genbankFile) {
        Mapping genbankMapping = null;
        genbankMapping = this.dataModel.mapCache.getMap(this.dataModel.getReferenceAlignment(), genbankFile);
        if (genbankMapping == null) {
            ReadseqTools.convertToFastaFormat(this.dataModel.getReferenceAlignment(), new File("temp1.fas"));
            ReadseqTools.convertToFastaFormat(genbankFile, new File("temp2.fas"));
            genbankMapping = Mapping.createMappingWithRestrictionsAutoDirection(new File("temp1.fas"), new File("temp2.fas"), 1, -1, -1, -1, -1);
            this.tableDataModel.updateMappings();
            this.dataModel.mapCache.registerMap(this.dataModel.getReferenceAlignment(), genbankFile, genbankMapping);
        }
        return genbankMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationsFromGenbankFile(File genbankFile, boolean map) {
        WizardMain.wizard.getDialog().setCursor(Cursor.getPredefinedCursor(3));
        Mapping genbankMapping = null;
        if (map) {
            genbankMapping = this.createGenbankMapping(genbankFile);
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(genbankFile));
            Namespace ns = RichObjectFactory.getDefaultNamespace();
            RichSequenceIterator seqs = RichSequence.IOTools.readGenbankDNA(br, ns);
            while (seqs.hasNext()) {
                try {
                    RichSequence rs = seqs.nextRichSequence();
                    Iterator<Feature> it = rs.features();
                    while (it.hasNext()) {
                        Feature ft = it.next();
                        String name = null;
                        int newGenomeLength = 0;
                        if (ft.getType().equalsIgnoreCase("source")) {
                            newGenomeLength = ft.getLocation().getMax();
                        }
                        if (genbankMapping != null) {
                            newGenomeLength = genbankMapping.getRefLength();
                        }
                        this.genomeLength = Math.max(this.genomeLength, newGenomeLength);
                        name = ft.getAnnotation().containsProperty("gene") ? ft.getAnnotation().getProperty("gene").toString() : (ft.getAnnotation().containsProperty("product") ? ft.getAnnotation().getProperty("product").toString() : ft.getType());
                        Iterator<Location> blocks = ft.getLocation().blockIterator();
                        Object[] newRow = GenomeOrganizationTable.defaultRow();
                        while (blocks.hasNext()) {
                            Location lt = blocks.next();
                            Object[] row = Arrays.copyOf(newRow, newRow.length);
                            row[1] = name;
                            row[2] = lt.getMin();
                            row[3] = lt.getMax();
                            this.tableDataModel.addRow(row, genbankMapping, genbankFile);
                        }
                    }
                }
                catch (NoSuchElementException ex) {
                    Logger.getLogger(GenomeOrganizationTable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (BioException ex) {
                    Logger.getLogger(GenomeOrganizationTable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GenomeOrganizationTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {
                Logger.getLogger(GenomeOrganizationTable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        WizardMain.wizard.getDialog().setCursor(Cursor.getPredefinedCursor(0));
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("SimpleTableDemo");
        frame.setDefaultCloseOperation(3);
        GenomeOrganizationTable newContentPane = new GenomeOrganizationTable(null);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GenomeOrganizationTable.createAndShowGUI();
            }
        });
    }

    class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ChangeListener {
        Integer currentValue;
        JSpinner button;

        public SpinnerEditor(int min, int max) {
            this.button = new JSpinner(new SpinnerNumberModel(0, min, max, 1));
            this.button.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.currentValue = (Integer)this.button.getValue();
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentValue = (Integer)value;
            this.button.setValue(this.currentValue);
            return this.button;
        }
    }

    class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color currentColor;
        JButton button = new JButton();
        JColorChooser colorChooser;
        JDialog dialog;
        protected static final String EDIT = "edit";

        public ColorEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            this.colorChooser = new JColorChooser();
            this.dialog = JColorChooser.createDialog(this.button, "Pick a Color", true, this.colorChooser, this, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                this.button.setBackground(this.currentColor);
                this.colorChooser.setColor(this.currentColor);
                this.dialog.setVisible(true);
                this.fireEditingStopped();
            } else {
                this.currentColor = this.colorChooser.getColor();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentColor = (Color)value;
            return this.button;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            this.setToolTipText("RGB value: " + newColor.getRed() + ", " + newColor.getGreen() + ", " + newColor.getBlue());
            return this;
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer(boolean isBordered) {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean isChecked = (Boolean)object;
            if (isChecked == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.setSelected(isChecked);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    class TableDataModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Use", "Locus name", "Start", "End", "Use mapping", "Mapped start", "Mapped end", "Color", "Level"};
        Class[] columnClasses = new Class[]{Boolean.class, String.class, Integer.class, Integer.class, Boolean.class, Integer.class, Integer.class, Color.class, Integer.class};
        public ArrayList<Object[]> rows = new ArrayList();
        public ArrayList<Mapping> mappings = new ArrayList();
        public ArrayList<File> mappingFiles = new ArrayList();
        boolean hasMappedData = false;

        TableDataModel() {
        }

        public void recomputeMappings() {
            WizardMain.wizard.getDialog().setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < this.mappings.size(); ++i) {
                Mapping mapping = this.mappings.get(i);
                if (mapping == null) continue;
                mapping = GenomeOrganizationTable.this.createGenbankMapping(this.mappingFiles.get(i));
                this.mappings.set(i, mapping);
            }
            this.updateMappings();
            WizardMain.wizard.getDialog().setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.rows.get(row)[col];
        }

        public void addRow(Object[] row, Mapping mapping, File mappingFile) {
            this.rows.add(row);
            this.mappings.add(mapping);
            this.mappingFiles.add(mappingFile);
            if (mapping == null) {
                row[4] = null;
            } else {
                this.hasMappedData = true;
            }
            this.fireTableRowsInserted(this.rows.size(), this.rows.size());
        }

        public void removeRow(int index) {
            this.rows.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void removeRows(int[] indices) {
            Arrays.sort(indices);
            int correction = 0;
            for (int i = 0; i < indices.length; ++i) {
                this.removeRow(indices[i] - correction);
                ++correction;
            }
        }

        public void move(int index, int value) {
            Object[] array = this.rows.remove(index);
            this.rows.add(index + value, array);
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int c) {
            return this.columnClasses[c];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 4 && this.getValueAt(row, col) == null) {
                return false;
            }
            return col != 5 && col != 6;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.rows.get((int)row)[col] = value;
            this.fireTableCellUpdated(row, col);
            if (col == 2 || col == 3 || col == 4) {
                this.updateMapping(row);
            }
        }

        public void updateMappings() {
            for (int i = 0; i < this.rows.size(); ++i) {
                this.updateMapping(i);
            }
        }

        public void updateMapping(int row) {
            Mapping mapping = this.mappings.get(row);
            if (this.getValueAt(row, 4) != null && ((Boolean)this.getValueAt(row, 4)).booleanValue() && mapping != null) {
                this.setValueAt(mapping.bToANearest((Integer)this.getValueAt(row, 2) - 1) + 1, row, 5);
                this.setValueAt(mapping.bToANearest((Integer)this.getValueAt(row, 3) - 1) + 1, row, 6);
            } else {
                this.setValueAt((Integer)this.getValueAt(row, 2), row, 5);
                this.setValueAt((Integer)this.getValueAt(row, 3), row, 6);
            }
        }
    }
}

