/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import structurevis.structures.io.ReadseqTools;
import structurevis.ui.datacreation.DataModel;
import structurevis.ui.datacreation.DataModelListener;
import structurevis.ui.datacreation.GenomeOrganizationTable;
import structurevis.ui.datacreation.WizardMain;
import structurevis.ui.datacreation.wizard.Wizard;
import structurevis.ui.datacreation.wizard.WizardListener;
import structurevis.ui.layerpanel.GenomeLayer;
import structurevis.ui.layerpanel.GenomeOrganization;
import structurevis.ui.layerpanel.LayerPanel;
import structurevis.ui.layerpanel.Region;

public class GenomeOrganizationPanel
extends JPanel
implements ListSelectionListener,
TableModelListener,
WizardListener,
DataModelListener {
    ImageIcon errorIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png"));
    ImageIcon correctIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/correct.png"));
    GenomeOrganizationTable genomeTable;
    LayerPanel layerPanel;
    DataModel dataModel;
    private JButton addButton;
    private JButton addFromGenbankAndMapButton;
    private JButton addFromGenbankWithoutMapButton;
    private JLabel errorLabel_addFromGenbank;
    private JTextPane genomeOrganizationDescription;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane3;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JScrollPane previewScrollPane;
    private JButton recomputMappingsButton;
    private JButton removeButton;

    public GenomeOrganizationPanel(DataModel dataModel) {
        this.dataModel = dataModel;
        this.initComponents();
        this.genomeTable = new GenomeOrganizationTable(dataModel);
        this.jPanel1.add(this.genomeTable);
        this.layerPanel = new LayerPanel(null, 10000);
        this.previewScrollPane.setViewportView(this.layerPanel);
        this.genomeTable.tableDataModel.addTableModelListener(this);
        this.genomeTable.table.getSelectionModel().addListSelectionListener(this);
        this.removeButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        try {
            PropertyResourceBundle resources = (PropertyResourceBundle)ResourceBundle.getBundle("structurevis.ui.datacreation.text");
            this.genomeOrganizationDescription.setText(resources.getString("GENOME_ANNOTATIONS_DESCRIPTION"));
            this.genomeOrganizationDescription.setCaretPosition(0);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        WizardMain.wizard.addWizardListener(this);
        dataModel.addDataModelListener(this);
        this.recomputMappingsButton.setVisible(false);
        this.updateErrors();
    }

    public void updateErrors() {
        this.errorLabel_addFromGenbank.setIcon(this.errorIcon);
        this.errorLabel_addFromGenbank.setIcon(this.errorIcon);
        this.errorLabel_addFromGenbank.setToolTipText("");
        this.addFromGenbankAndMapButton.setEnabled(false);
        if (this.dataModel.getReferenceAlignment() == null) {
            this.errorLabel_addFromGenbank.setToolTipText("Please select a reference file on the 'Genome structure' panel.");
            WizardMain.wizard.showErrorsBeforeContinue(true);
        } else if (!this.dataModel.getReferenceAlignment().exists()) {
            this.errorLabel_addFromGenbank.setToolTipText("The specified reference file does not exist.");
            WizardMain.wizard.showErrorsBeforeContinue(true);
        } else if (!ReadseqTools.isKnownFormat(this.dataModel.getReferenceAlignment())) {
            this.errorLabel_addFromGenbank.setToolTipText("The format of the specified reference file is not recognized.");
            WizardMain.wizard.showErrorsBeforeContinue(true);
        } else {
            this.addFromGenbankAndMapButton.setEnabled(true);
            this.errorLabel_addFromGenbank.setIcon(null);
        }
    }

    private void initComponents() {
        this.addFromGenbankAndMapButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.previewScrollPane = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.genomeOrganizationDescription = new JTextPane();
        this.jLabel3 = new JLabel();
        this.addFromGenbankWithoutMapButton = new JButton();
        this.errorLabel_addFromGenbank = new JLabel();
        this.recomputMappingsButton = new JButton();
        this.addFromGenbankAndMapButton.setText("Add from Genbank and map...");
        this.addFromGenbankAndMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeOrganizationPanel.this.addFromGenbankAndMapButtonActionPerformed(evt);
            }
        });
        this.addButton.setText("Add empty");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeOrganizationPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeOrganizationPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.previewScrollPane.setBorder(BorderFactory.createTitledBorder("Sequence annotations preview"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Sequence annotations"));
        this.jPanel1.setLayout(new BorderLayout());
        this.moveUpButton.setText("Move up");
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeOrganizationPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        this.moveDownButton.setText("Move down");
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeOrganizationPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        this.genomeOrganizationDescription.setContentType("text/html");
        this.genomeOrganizationDescription.setEditable(false);
        this.jScrollPane3.setViewportView(this.genomeOrganizationDescription);
        this.jLabel3.setText("Description");
        this.addFromGenbankWithoutMapButton.setText("Add from Genbank without mapping...");
        this.addFromGenbankWithoutMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeOrganizationPanel.this.addFromGenbankWithoutMapButtonActionPerformed(evt);
            }
        });
        this.errorLabel_addFromGenbank.setIcon(new ImageIcon(this.getClass().getResource("/structurevis/resources/error.png")));
        this.errorLabel_addFromGenbank.setText(" ");
        this.recomputMappingsButton.setText("Re-compute mappings");
        this.recomputMappingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenomeOrganizationPanel.this.recomputMappingsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewScrollPane, GroupLayout.Alignment.TRAILING, -1, 774, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, 774, Short.MAX_VALUE).addComponent(this.jScrollPane3, -1, 774, Short.MAX_VALUE).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.recomputMappingsButton).addGroup(layout.createSequentialGroup().addComponent(this.addFromGenbankAndMapButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel_addFromGenbank).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addFromGenbankWithoutMapButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 230, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.addFromGenbankAndMapButton).addComponent(this.removeButton).addComponent(this.moveDownButton).addComponent(this.moveUpButton).addComponent(this.addFromGenbankWithoutMapButton).addComponent(this.errorLabel_addFromGenbank)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recomputMappingsButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.previewScrollPane, -1, 144, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 83, -2).addContainerGap()));
    }

    private void addFromGenbankAndMapButtonActionPerformed(ActionEvent evt) {
        int returnVal = Wizard.fileChooserOpen.showOpenDialog(this);
        if (returnVal == 0) {
            this.genomeTable.addAnnotationsFromGenbankFile(Wizard.fileChooserOpen.getSelectedFile(), true);
            this.genomeTable.tableDataModel.updateMappings();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.genomeTable.tableDataModel.removeRows(this.genomeTable.table.getSelectedRows());
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        int s = this.genomeTable.table.getSelectedRow();
        if (s >= 1) {
            this.genomeTable.tableDataModel.move(this.genomeTable.table.getSelectedRow(), -1);
            this.genomeTable.table.getSelectionModel().setSelectionInterval(s - 1, s - 1);
        }
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        int s = this.genomeTable.table.getSelectedRow();
        if (s >= 0 && s < this.genomeTable.table.getRowCount() - 1) {
            this.genomeTable.tableDataModel.move(this.genomeTable.table.getSelectedRow(), 1);
            this.genomeTable.table.getSelectionModel().setSelectionInterval(s + 1, s + 1);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.genomeTable.tableDataModel.addRow(GenomeOrganizationTable.defaultRow(), null, null);
        this.genomeTable.scrollPane.getVerticalScrollBar().setValue(this.genomeTable.scrollPane.getVerticalScrollBar().getMaximum() + 100);
        this.genomeTable.table.setRowSelectionInterval(this.genomeTable.table.getRowCount() - 1, this.genomeTable.table.getRowCount() - 1);
    }

    private void addFromGenbankWithoutMapButtonActionPerformed(ActionEvent evt) {
        int returnVal = Wizard.fileChooserOpen.showOpenDialog(this);
        if (returnVal == 0) {
            this.genomeTable.addAnnotationsFromGenbankFile(Wizard.fileChooserOpen.getSelectedFile(), false);
            this.genomeTable.tableDataModel.updateMappings();
        }
    }

    private void recomputMappingsButtonActionPerformed(ActionEvent evt) {
        this.genomeTable.tableDataModel.recomputeMappings();
        this.recomputMappingsButton.setVisible(false);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.dataModel.genomeOrganization = new GenomeOrganization();
        int maxLevel = 0;
        for (int i = 0; i < this.genomeTable.tableDataModel.rows.size(); ++i) {
            Object[] row = this.genomeTable.tableDataModel.rows.get(i);
            if (!((Boolean)row[0]).booleanValue()) continue;
            Region r = new Region((Integer)row[5], (Integer)row[6], (String)row[1]);
            r.color = (Color)row[7];
            r.level = (Integer)row[8];
            this.dataModel.genomeOrganization.genome.add(r);
            maxLevel = Math.max(maxLevel, r.level);
        }
        this.layerPanel.removeAllLayers();
        GenomeLayer l = new GenomeLayer(this.layerPanel, this.dataModel.genomeOrganization, "Sequence annotations");
        this.layerPanel.genomeLength = this.genomeTable.genomeLength;
        l.setPreferredSize(new Dimension(10000, l.rulerHeight + (maxLevel + 1) * l.blockHeight));
        this.layerPanel.setPreferredSize(new Dimension(10000, l.rulerHeight + (maxLevel + 1) * l.blockHeight));
        this.layerPanel.addLayer(l);
        this.previewScrollPane.revalidate();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.genomeTable.table.getSelectedRowCount() > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
        if (this.genomeTable.table.getSelectedRowCount() == 1) {
            this.moveDownButton.setEnabled(true);
            this.moveUpButton.setEnabled(true);
        } else {
            this.moveDownButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
        }
    }

    @Override
    public void panelChangedEvent(Object fromPanelIdentifier, Object toPanelIdentifier) {
        if (toPanelIdentifier.equals("GENOME_ORGANIZATION_PANEL")) {
            this.updateErrors();
        }
    }

    public void computeMappings() {
    }

    @Override
    public void referenceAlignmentChanged(File oldReferenceAlignment, File newReferenceAlignment) {
        if ((oldReferenceAlignment == null && newReferenceAlignment != null || !oldReferenceAlignment.equals(newReferenceAlignment)) && this.genomeTable.tableDataModel.hasMappedData) {
            Object[] options = new Object[]{"Yes (recommended)", "No"};
            int n = JOptionPane.showOptionDialog(this, "The reference alignment has changed. Do you wish to recompute the genome annotation mapping(s)? It is strongly recommended that you do.", "Reference alignment changed.", 0, 3, null, options, options[0]);
            if (n == 0) {
                this.genomeTable.tableDataModel.recomputeMappings();
                this.recomputMappingsButton.setVisible(false);
            } else {
                this.recomputMappingsButton.setVisible(true);
            }
        }
    }

    @Override
    public void dataSourceProcessed(int n, int total, Object dataSource) {
    }
}

