/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation;

import java.io.File;
import javax.swing.JOptionPane;
import structurevis.ui.datacreation.DataModel;
import structurevis.ui.datacreation.DataModelListener;
import structurevis.ui.datacreation.FinishPanel;
import structurevis.ui.datacreation.WizardMain;
import structurevis.ui.datacreation.wizard.WizardPanelDescriptor;

public class FinishDescriptor
extends WizardPanelDescriptor
implements DataModelListener {
    public static final String IDENTIFIER = "FINISH_PANEL";
    public FinishPanel panel;
    DataModel dataModel;
    boolean success = true;

    public FinishDescriptor(DataModel dataModel) {
        this.dataModel = dataModel;
        this.panel = new FinishPanel(dataModel);
        this.setPanelDescriptorIdentifier(IDENTIFIER);
        this.setPanelComponent(this.panel);
        dataModel.addDataModelListener(this);
    }

    @Override
    public Object getNextPanelDescriptor() {
        return FINISH;
    }

    @Override
    public Object getBackPanelDescriptor() {
        return "DATA_PANEL";
    }

    @Override
    public void aboutToDisplayPanel() {
    }

    @Override
    public void displayingPanel() {
        this.getWizard().setBackButtonEnabled(false);
        this.getWizard().setNextFinishButtonEnabled(false);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Object[] options;
                    int n;
                    FinishDescriptor.this.panel.jTextArea1.setText("");
                    FinishDescriptor.this.panel.jTextArea1.insert("DOOSS is creating your dataset, this may take a few minutes.", FinishDescriptor.this.panel.jTextArea1.getText().length());
                    FinishDescriptor.this.panel.dataModel.saveProject();
                    FinishDescriptor.this.panel.jProgressBar1.setValue(100);
                    FinishDescriptor.this.panel.jTextArea1.insert("\nCompleted successfully.", FinishDescriptor.this.panel.jTextArea1.getText().length());
                    if (WizardMain.mainapp != null && (n = JOptionPane.showOptionDialog(FinishDescriptor.this.panel, "Do you wish to open this dataset now? Note: your current dataset will be closed.", "Open dataset?", 0, 3, null, options = new Object[]{"Yes", "No"}, options[1])) == 0) {
                        FinishDescriptor.this.getWizard().close(0);
                        WizardMain.mainapp.openStructureCollectionFromFolder(FinishDescriptor.this.panel.dataModel.projectDirectory);
                    }
                    FinishDescriptor.this.getWizard().setNextFinishButtonEnabled(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    FinishDescriptor.this.panel.jProgressBar1.setValue(0);
                    Throwable throwable = ex.getCause();
                    if (throwable == null) {
                        String traceString = "";
                        StackTraceElement[] traceElem = ex.getStackTrace();
                        for (int i = 0; i < traceElem.length; ++i) {
                            traceString = traceString + traceElem[i].toString() + "\n";
                        }
                        FinishDescriptor.this.panel.jTextArea1.insert("\n\nAn unknown error has occurred, please go back and review the settings you have used.\nError thrown: " + ex.toString() + "\nDetails:\n" + traceString, FinishDescriptor.this.panel.jTextArea1.getText().length());
                    } else {
                        FinishDescriptor.this.panel.jTextArea1.insert("\nThe following error has occurred:\n" + ex.getCause().toString(), FinishDescriptor.this.panel.jTextArea1.getText().length());
                    }
                    FinishDescriptor.this.success = false;
                    System.out.println("An error occured in FinishDescriptor.java");
                    FinishDescriptor.this.getWizard().setBackButtonEnabled(true);
                }
            }
        };
        t.start();
    }

    @Override
    public void aboutToHidePanel() {
    }

    @Override
    public void referenceAlignmentChanged(File oldReferenceAlignment, File newReferenceAlignment) {
    }

    @Override
    public void dataSourceProcessed(int n, int total, Object dataSource) {
        int perc = (int)((double)n / (double)Math.max(total, 1) * 100.0);
        this.panel.jTextArea1.insert("\nData source " + n + " of " + total + " processed.", this.panel.jTextArea1.getText().length());
        this.panel.jProgressBar1.setValue(perc);
    }
}

