/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import structurevis.ui.datacreation.DataOverlay;

public class DataTable
extends JPanel {
    DataModel dataModel = new DataModel();
    final JTable table = new JTable(this.dataModel);
    public JScrollPane scrollPane;

    public DataTable() {
        super(new BorderLayout());
        this.table.setFillsViewportHeight(true);
        this.scrollPane = new JScrollPane(this.table);
        this.add(this.scrollPane);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("SimpleTableDemo");
        frame.setDefaultCloseOperation(3);
        DataTable newContentPane = new DataTable();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTable.createAndShowGUI();
            }
        });
    }

    class DataModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Name", "Data type"};
        Class[] columnClasses = new Class[]{String.class, String.class};
        public ArrayList<Object[]> rows = new ArrayList();

        DataModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.rows.get(row)[col];
        }

        public void setRows(ArrayList<DataOverlay> list) {
            this.rows.clear();
            for (int i = 0; i < list.size(); ++i) {
                Object[] list2 = new Object[]{list.get((int)i).fieldName, list.get((int)i).type};
                this.rows.add(list2);
            }
            this.fireTableDataChanged();
        }

        public void addRow(Object[] row) {
            this.rows.add(row);
            this.fireTableRowsInserted(this.rows.size(), this.rows.size());
        }

        public void removeRow(int index) {
            this.rows.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void removeRows(int[] indices) {
            Arrays.sort(indices);
            int correction = 0;
            for (int i = 0; i < indices.length; ++i) {
                this.removeRow(indices[i] - correction);
                ++correction;
            }
        }

        public void move(int index, int value) {
            Object[] array = this.rows.remove(index);
            this.rows.add(index + value, array);
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int c) {
            return this.columnClasses[c];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.rows.get((int)row)[col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

