/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import structurevis.ui.datacreation.DataModel;
import structurevis.ui.datacreation.DataOverlay;
import structurevis.ui.datacreation.DataTable;
import structurevis.ui.datacreation.NucleotideDialog;
import structurevis.ui.datacreation.SequenceDialog1D;
import structurevis.ui.datacreation.SequenceDialog2D;
import structurevis.ui.datacreation.WizardMain;
import structurevis.ui.datacreation.wizard.WizardListener;

public class DataPanel
extends JPanel
implements ListSelectionListener,
WizardListener {
    DataModel dataModel;
    private JButton addButton1D;
    private JButton addButton2D;
    private JButton addSequenceData;
    private DataTable dataTable1;
    private JButton deleteButton;
    private JButton editButton;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextPane jTextPane1;
    boolean referencedAdded = false;
    DataOverlay dataOverlay = null;

    public DataPanel(DataModel dataModel) {
        this.dataModel = dataModel;
        this.initComponents();
        this.dataTable1.table.getSelectionModel().addListSelectionListener(this);
        try {
            PropertyResourceBundle resources = (PropertyResourceBundle)ResourceBundle.getBundle("structurevis.ui.datacreation.text");
            this.jTextPane1.setText(resources.getString("DATA_PANEL_DESCRIPTION"));
            this.jTextPane1.setCaretPosition(0);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        WizardMain.wizard.addWizardListener(this);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.dataTable1 = new DataTable();
        this.addButton1D = new JButton();
        this.addButton2D = new JButton();
        this.addSequenceData = new JButton();
        this.deleteButton = new JButton();
        this.editButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder("Data overlays"));
        this.dataTable1.setPreferredSize(new Dimension(200, 200));
        this.jScrollPane1.setViewportView(this.dataTable1);
        this.addButton1D.setText("Add 1D data");
        this.addButton1D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.addButton1DActionPerformed(evt);
            }
        });
        this.addButton2D.setText("Add 2D data");
        this.addButton2D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.addButton2DActionPerformed(evt);
            }
        });
        this.addSequenceData.setText("Add sequence data");
        this.addSequenceData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.addSequenceDataActionPerformed(evt);
            }
        });
        this.deleteButton.setText("Delete");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.editButton.setText("Edit");
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.editButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Description");
        this.jTextPane1.setContentType("text/html");
        this.jTextPane1.setEditable(false);
        this.jScrollPane2.setViewportView(this.jTextPane1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 338, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editButton, -1, -1, Short.MAX_VALUE).addComponent(this.deleteButton, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 248, Short.MAX_VALUE).addComponent(this.jLabel2))).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.addButton1D).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton2D).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addSequenceData))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton)).addComponent(this.jScrollPane2, -1, 434, Short.MAX_VALUE))).addComponent(this.jScrollPane1, -1, 454, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton1D).addComponent(this.addButton2D).addComponent(this.addSequenceData))));
    }

    private void addButton1DActionPerformed(ActionEvent evt) {
        SequenceDialog1D dialog = new SequenceDialog1D((Frame)new JFrame(), true, this.dataModel, -1);
        this.centerAndShow(dialog);
        this.dataTable1.dataModel.setRows(this.dataModel.overlays);
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        String type = this.dataModel.overlays.get((int)this.dataTable1.table.getSelectedRow()).type;
        if (type.equals("SequenceData1D")) {
            SequenceDialog1D dialog = new SequenceDialog1D((Frame)new JFrame(), true, this.dataModel, this.dataTable1.table.getSelectedRow());
            this.dataTable1.dataModel.setRows(this.dataModel.overlays);
            this.centerAndShow(dialog);
        } else if (type.equals("SequenceData2D")) {
            SequenceDialog2D dialog = new SequenceDialog2D((Frame)new JFrame(), true, this.dataModel, this.dataTable1.table.getSelectedRow());
            this.dataTable1.dataModel.setRows(this.dataModel.overlays);
            this.centerAndShow(dialog);
        } else if (type.equals("NucleotideComposition")) {
            NucleotideDialog dialog = new NucleotideDialog((Frame)new JFrame(), true, this.dataModel, this.dataTable1.table.getSelectedRow());
            this.dataTable1.dataModel.setRows(this.dataModel.overlays);
            this.centerAndShow(dialog);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.dataModel.overlays.remove(this.dataTable1.table.getSelectedRow());
        this.dataTable1.dataModel.setRows(this.dataModel.overlays);
    }

    private void addButton2DActionPerformed(ActionEvent evt) {
        SequenceDialog2D dialog = new SequenceDialog2D((Frame)new JFrame(), true, this.dataModel, -1);
        this.centerAndShow(dialog);
        this.dataTable1.dataModel.setRows(this.dataModel.overlays);
    }

    private void addSequenceDataActionPerformed(ActionEvent evt) {
        NucleotideDialog dialog = new NucleotideDialog((Frame)new JFrame(), true, this.dataModel, -1);
        this.centerAndShow(dialog);
        this.dataTable1.dataModel.setRows(this.dataModel.overlays);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.dataTable1.table.getSelectedRow() != -1) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    public void centerAndShow(JDialog dialog) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - dialog.getWidth()) / 2;
        int y = (screenSize.height - dialog.getHeight()) / 2;
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    @Override
    public void panelChangedEvent(Object fromPanelIdentifier, Object toPanelIdentifier) {
        if (toPanelIdentifier.equals("DATA_PANEL") && this.dataModel.getReferenceAlignment() != null && this.dataModel.getReferenceAlignment().exists()) {
            if (!this.referencedAdded) {
                this.dataOverlay = new DataOverlay();
            }
            this.dataOverlay.nucleotideAlignmentFile = this.dataModel.getReferenceAlignment();
            this.dataOverlay.type = "NucleotideComposition";
            if (!this.referencedAdded) {
                this.dataOverlay.fieldName = "reference_alignment";
                if (this.dataModel.isFieldNameUsed("reference_alignment", this.dataOverlay)) {
                    this.dataOverlay.fieldName = this.dataModel.getNextName("reference_alignment");
                }
                this.dataModel.overlays.add(this.dataOverlay);
                this.dataTable1.dataModel.setRows(this.dataModel.overlays);
                this.referencedAdded = true;
            }
        }
    }
}

