/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.datacreation;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.EventListenerList;
import structurevis.data.IO;
import structurevis.data.MapCache;
import structurevis.data.Mapping;
import structurevis.data.ParrisData;
import structurevis.structures.StructureCollection;
import structurevis.structures.StructureParser;
import structurevis.structures.io.ReadseqTools;
import structurevis.structures.io.StructureCollectionStAXReader;
import structurevis.structures.io.StructureCollectionStAXWriter;
import structurevis.structures.metadata.MetadataFromFile;
import structurevis.ui.DataTransform;
import structurevis.ui.datacreation.DataModelListener;
import structurevis.ui.datacreation.DataOverlay;
import structurevis.ui.datacreation.DataSource1D;
import structurevis.ui.datacreation.DataSource2D;
import structurevis.ui.layerpanel.GenomeOrganization;

public class DataModel {
    MapCache mapCache = new MapCache();
    File projectDirectory;
    File genomeStructureFile;
    GenomeStructureFileType genomeStructureFileType = GenomeStructureFileType.STANDARD_CT_FILE;
    private File referenceNucleotideAlignment;
    File referenceNucleotideAlignmentFASTA;
    boolean nucleicAcidRNA = true;
    boolean conformationCircular = false;
    File substructureFile = null;
    SubstructuresStructureFileType substructuresStructureFileType = SubstructuresStructureFileType.NASP_FILE_TYPE;
    int minSubstructureSize = 10;
    int maxSubstructureSize = 150;
    GenomeOrganization genomeOrganization = new GenomeOrganization();
    File genomeOrganizationMappingFile = null;
    ArrayList<DataOverlay> overlays = new ArrayList();
    HashMap<File, String> fileMap = new HashMap();
    int fileid = 0;
    DecimalFormat df3 = new DecimalFormat("000");
    EventListenerList listenerList = new EventListenerList();

    public boolean isFieldNameUsed(String name, DataOverlay thisOne) {
        for (int i = 0; i < this.overlays.size(); ++i) {
            if (!this.overlays.get((int)i).fieldName.equalsIgnoreCase(name) || this.overlays.get(i).equals(thisOne)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.genomeStructureFile + "\n" + (Object)((Object)this.genomeStructureFileType) + "\n" + this.nucleicAcidRNA + "\n" + this.conformationCircular + "\n" + this.substructureFile + "\n" + (Object)((Object)this.substructuresStructureFileType) + "\n" + this.minSubstructureSize + "\n" + this.maxSubstructureSize;
    }

    public void loadProject() {
    }

    public void saveProject() throws Exception {
        this.projectDirectory.mkdir();
        StructureCollection s = new StructureCollection();
        switch (this.genomeStructureFileType) {
            case STANDARD_CT_FILE: {
                s.dotBracketStructure = StructureParser.parseCtFile(this.genomeStructureFile).get(0).getDotBracketString();
            }
            case NASP_CT_FILE: {
                s.dotBracketStructure = StructureParser.parseNaspCtFile(this.genomeStructureFile).getDotBracketString();
                break;
            }
            case DOT_BRACKET_FILE: {
                s.dotBracketStructure = StructureParser.getDotBracketStringFromFile(this.genomeStructureFile);
            }
            case TAB_DELIMITTED_HELIX: {
                s.dotBracketStructure = StructureParser.parseTabDelimittedHelixFile(this.genomeStructureFile, 0).getDotBracketString();
            }
        }
        this.referenceNucleotideAlignmentFASTA = new File(this.projectDirectory.getPath() + "/reference-alignment.fas");
        ReadseqTools.convertToFastaFormat(this.referenceNucleotideAlignment, this.referenceNucleotideAlignmentFASTA);
        if (this.genomeStructureFile != null && this.genomeStructureFile.exists()) {
            String filename = this.registerFile(this.genomeStructureFile);
            String consensusFile = this.projectDirectory.getPath() + File.separatorChar + filename + "-" + this.genomeStructureFile.getName() + ".consensus_structure";
            IO.copyFile(this.genomeStructureFile, new File(consensusFile));
        }
        s.dnaSequence = !this.nucleicAcidRNA;
        s.genomeLength = s.dotBracketStructure.length();
        s.circularGenome = this.conformationCircular;
        s.metadata.add(this.genomeOrganization);
        if (this.substructureFile != null) {
            switch (this.substructuresStructureFileType) {
                case NASP_FILE_TYPE: {
                    StructureCollection temp = StructureParser.parseNaspFiles(this.substructureFile, s.dotBracketStructure);
                    s.structures = temp.structures;
                    break;
                }
                case EXISTING_COLLECTION: {
                    s.structures = StructureCollectionStAXReader.loadStructureCollectionFromFile((File)this.substructureFile).structures;
                }
            }
        } else {
            s.structures = StructureParser.enumerateSubstructures(s.dotBracketStructure, this.minSubstructureSize, this.maxSubstructureSize, this.conformationCircular);
        }
        int totalDataSources = 0;
        for (int j = 0; j < this.overlays.size(); ++j) {
            totalDataSources += Math.max(Math.max(this.overlays.get((int)j).dataSources1D.size(), this.overlays.get((int)j).dataSources2D.size()), 1);
        }
        int numDataSourcesProcessed = 0;
        for (int j = 0; j < this.overlays.size(); ++j) {
            Mapping referenceToB;
            File mappingFilePath;
            Object dataSource;
            MetadataFromFile metadata = new MetadataFromFile();
            DataOverlay overlay = this.overlays.get(j);
            metadata.type = overlay.type;
            if (overlay.type.equals("SequenceData1D")) {
                for (int i = 0; i < overlay.dataSources1D.size(); ++i) {
                    dataSource = overlay.dataSources1D.get(i);
                    File mappingFileFASTA = new File(this.projectDirectory.getPath() + "/" + ((DataSource1D)dataSource).mappingFile.getName() + ".fas");
                    ReadseqTools.convertToFastaFormat(((DataSource1D)dataSource).mappingFile, mappingFileFASTA);
                    String filename = this.registerFile(((DataSource1D)dataSource).dataFile);
                    String dataFile = filename + "-" + ((DataSource1D)dataSource).dataFile.getName() + ".csv";
                    String mappingFile = "reference-to-" + filename + ".mapping";
                    if (!new File(this.projectDirectory.getPath() + File.separatorChar + mappingFile).exists()) {
                        mappingFilePath = new File(this.projectDirectory.getPath() + "/" + mappingFile);
                        if (this.mapCache.filePairExists(this.referenceNucleotideAlignmentFASTA, mappingFileFASTA)) {
                            IO.copyFile(this.mapCache.getMappingFile(this.referenceNucleotideAlignmentFASTA, mappingFileFASTA), mappingFilePath);
                        } else {
                            this.mapCache.registerFilePair(this.referenceNucleotideAlignmentFASTA, mappingFileFASTA, mappingFilePath);
                            referenceToB = Mapping.createMapping(this.referenceNucleotideAlignmentFASTA, mappingFileFASTA, 1);
                            referenceToB.saveMapping(mappingFilePath);
                        }
                    }
                    switch (((DataSource1D)dataSource).dataSourceType) {
                        case CSV_1D: {
                            if (!new File(this.projectDirectory.getPath() + "/" + dataFile).exists()) {
                                IO.copyFile(((DataSource1D)dataSource).dataFile, new File(this.projectDirectory.getPath() + "/" + dataFile));
                            }
                            metadata.files.add(new File(dataFile));
                            metadata.mappingFiles.add(new File(mappingFile));
                            metadata.dataColumns.add(((DataSource1D)dataSource).dataColumn);
                            metadata.codonData.add(((DataSource1D)dataSource).codonPositions);
                            break;
                        }
                        case PARRIS_MARGINALS: {
                            if (!new File(this.projectDirectory.getPath() + "/" + dataFile).exists()) {
                                ParrisData parrisData = new ParrisData(((DataSource1D)dataSource).dataFile);
                                parrisData.saveToCSV(new File(this.projectDirectory.getPath() + "/" + dataFile));
                            }
                            metadata.files.add(new File(dataFile));
                            metadata.dataColumns.add(((DataSource1D)dataSource).dataColumn + 7);
                            metadata.mappingFiles.add(new File(mappingFile));
                            metadata.codonData.add(new Boolean(true));
                        }
                    }
                    this.fireDataSourceProcessed(++numDataSourcesProcessed, totalDataSources, null);
                }
                metadata.name = overlay.fieldName;
                metadata.useMin = true;
                metadata.min = overlay.minValue;
                metadata.useMax = true;
                metadata.max = overlay.maxValue;
                metadata.dataTransform = new DataTransform(overlay.minValue, overlay.maxValue, overlay.transformType);
                metadata.colorGradient = overlay.colorGradient;
            } else if (overlay.type.equals("SequenceData2D")) {
                block20: for (int i = 0; i < overlay.dataSources2D.size(); ++i) {
                    System.out.println("SequenceData2D " + i);
                    dataSource = overlay.dataSources2D.get(i);
                    String filename = this.registerFile(((DataSource2D)dataSource).dataFile);
                    String dataFile = filename + "-" + ((DataSource2D)dataSource).dataFile.getName() + ".matrix";
                    String mappingFile = "reference-to-" + filename + ".mapping";
                    File mappingFileFASTA = new File(this.projectDirectory.getPath() + "/" + ((DataSource2D)dataSource).mappingFile.getName() + ".fas");
                    if (!mappingFileFASTA.exists() || !new File(this.projectDirectory.getPath() + "/" + mappingFile).exists()) {
                        ReadseqTools.convertToFastaFormat(((DataSource2D)dataSource).mappingFile, mappingFileFASTA);
                        mappingFilePath = new File(this.projectDirectory.getPath() + "/" + mappingFile);
                        if (this.mapCache.filePairExists(this.referenceNucleotideAlignmentFASTA, mappingFileFASTA)) {
                            IO.copyFile(this.mapCache.getMappingFile(this.referenceNucleotideAlignmentFASTA, mappingFileFASTA), mappingFilePath);
                        } else {
                            this.mapCache.registerFilePair(this.referenceNucleotideAlignmentFASTA, mappingFileFASTA, mappingFilePath);
                            referenceToB = Mapping.createMapping(this.referenceNucleotideAlignmentFASTA, mappingFileFASTA, 1);
                            referenceToB.saveMapping(mappingFilePath);
                        }
                        this.fireDataSourceProcessed(++numDataSourcesProcessed, totalDataSources, null);
                    }
                    switch (((DataSource2D)dataSource).dataSourceType) {
                        case PAIRWISE_TAB_2D: {
                            if (!new File(this.projectDirectory.getPath() + "/" + dataFile).exists()) {
                                IO.copyFile(((DataSource2D)dataSource).dataFile, new File(this.projectDirectory.getPath() + "/" + dataFile));
                            }
                            metadata.files.add(new File(dataFile));
                            metadata.mappingFiles.add(new File(mappingFile));
                            metadata.codonData.add(((DataSource2D)dataSource).codonPositions);
                            continue block20;
                        }
                        default: {
                            throw new Exception("Matrix type not supported.");
                        }
                    }
                }
                metadata.name = overlay.fieldName;
                metadata.type = "SequenceData2D";
                metadata.useMin = true;
                metadata.min = overlay.minValue;
                metadata.useMax = true;
                metadata.max = overlay.maxValue;
                metadata.dataTransform = new DataTransform(overlay.minValue, overlay.maxValue, overlay.transformType);
                metadata.colorGradient = overlay.colorGradient;
            } else if (overlay.type.equals("NucleotideComposition")) {
                metadata.name = overlay.fieldName;
                metadata.type = "NucleotideComposition";
                String filename = this.registerFile(overlay.nucleotideAlignmentFile);
                String dataFile = filename + "-" + overlay.nucleotideAlignmentFile.getName() + ".fas";
                String mappingFile = "reference-to-" + filename + ".mapping";
                File nucleotideFileFASTA = new File(this.projectDirectory.getPath() + "/" + dataFile);
                if (!nucleotideFileFASTA.exists() || !new File(this.projectDirectory.getPath() + "/" + mappingFile).exists()) {
                    ReadseqTools.convertToFastaFormat(overlay.nucleotideAlignmentFile, nucleotideFileFASTA);
                    File mappingFilePath2 = new File(this.projectDirectory.getPath() + "/" + mappingFile);
                    if (this.mapCache.filePairExists(this.referenceNucleotideAlignmentFASTA, nucleotideFileFASTA)) {
                        IO.copyFile(this.mapCache.getMappingFile(this.referenceNucleotideAlignmentFASTA, nucleotideFileFASTA), mappingFilePath2);
                    } else {
                        this.mapCache.registerFilePair(this.referenceNucleotideAlignmentFASTA, nucleotideFileFASTA, mappingFilePath2);
                        Mapping referenceToB2 = Mapping.createMapping(this.referenceNucleotideAlignmentFASTA, nucleotideFileFASTA, 1);
                        referenceToB2.saveMapping(mappingFilePath2);
                    }
                }
                metadata.files.add(new File(dataFile));
                metadata.mappingFiles.add(new File(mappingFile));
                this.fireDataSourceProcessed(++numDataSourcesProcessed, totalDataSources, null);
            }
            s.metadata.add(metadata);
        }
        StructureCollectionStAXWriter.saveStructureCollectionToFile(s, new File(this.projectDirectory.getPath() + "/collection.xml"));
    }

    public String getNextFileName(String filePath, String startsWith) {
        int i = 0;
        while (new File(filePath + "/" + startsWith + i).exists()) {
            ++i;
        }
        return startsWith + i;
    }

    public String getNextName(String startWith) {
        int i = 0;
        while (true) {
            String namei = startWith + i;
            boolean match = false;
            for (int j = 0; j < this.overlays.size(); ++j) {
                if (!this.overlays.get((int)j).fieldName.equalsIgnoreCase(namei)) continue;
                match = true;
                break;
            }
            if (!match) {
                return namei;
            }
            ++i;
        }
    }

    public static double getMin(double[] data) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            min = Math.min(data[i], min);
        }
        return min;
    }

    public static double getMax(double[] data) {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < data.length; ++i) {
            max = Math.max(data[i], max);
        }
        return max;
    }

    public String registerFile(File file) {
        String filename = this.fileMap.get(file);
        if (filename == null) {
            filename = this.df3.format(this.fileid);
            this.fileMap.put(file, filename);
            ++this.fileid;
        }
        return filename;
    }

    public boolean fileExists(File file) {
        return this.fileMap.containsKey(file);
    }

    public File getReferenceAlignment() {
        return this.referenceNucleotideAlignment;
    }

    public void setReferenceAlignment(File referenceAlignment) {
        File oldReferenceAlignment = this.referenceNucleotideAlignment;
        this.referenceNucleotideAlignment = referenceAlignment;
        this.fireReferenceAlignmentChanged(oldReferenceAlignment, referenceAlignment);
    }

    public void addDataModelListener(DataModelListener l) {
        this.listenerList.add(DataModelListener.class, l);
    }

    public void removeDataModelListener(DataModelListener l) {
        this.listenerList.remove(DataModelListener.class, l);
    }

    public void fireReferenceAlignmentChanged(File oldReferenceAlignment, File newReferenceAlignment) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataModelListener.class) continue;
            ((DataModelListener)listeners[i + 1]).referenceAlignmentChanged(oldReferenceAlignment, newReferenceAlignment);
        }
    }

    public void fireDataSourceProcessed(int n, int total, Object dataSource) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataModelListener.class) continue;
            ((DataModelListener)listeners[i + 1]).dataSourceProcessed(n, total, dataSource);
        }
    }

    public static enum DataSourceType {
        CSV_1D,
        PARRIS_MARGINALS,
        PAIRWISE_TAB_2D;

    }

    public static enum SubstructuresStructureFileType {
        NASP_FILE_TYPE,
        EXISTING_COLLECTION;

    }

    public static enum GenomeStructureFileType {
        STANDARD_CT_FILE,
        NASP_CT_FILE,
        DOT_BRACKET_FILE,
        TAB_DELIMITTED_HELIX;

    }
}

