/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.analyses;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import structurevis.structures.Structure;
import structurevis.structures.metadata.NucleotideComposition;
import structurevis.ui.MainApp;
import structurevis.ui.analyses.AmbiguityCodesFrame;
import structurevis.ui.analyses.Location;
import structurevis.ui.analyses.Search;
import structurevis.ui.analyses.SearchTable;

public class SearchPanel
extends JPanel {
    MainApp mainapp = null;
    ArrayList<NucleotideComposition> nucleotideDataList = null;
    ArrayList data = new ArrayList();
    SearchTable searchTable = null;
    public SearchThread currentThread = null;
    private ButtonGroup buttonGroup1;
    private JButton clearButton;
    private JComboBox dataSourceBox;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JToggleButton jToggleButton1;
    private JTextField searchField;
    private JCheckBox showParentCheckBox1;
    private JLabel statusLabel;

    public SearchPanel(MainApp mainapp) {
        this.initComponents();
        this.mainapp = mainapp;
        this.searchTable = new SearchTable(mainapp);
        this.jPanel1.add((Component)this.searchTable, "Center");
        if (mainapp.structureCollection != null) {
            this.nucleotideDataList = mainapp.structureCollection.nucleotideComposition;
            this.data.addAll(this.nucleotideDataList);
            DefaultComboBoxModel<String> dataModel = new DefaultComboBoxModel<String>();
            this.dataSourceBox.setModel(dataModel);
            for (int i = 0; i < this.data.size(); ++i) {
                dataModel.addElement(this.nucleotideDataList.get((int)i).name);
            }
        }
    }

    public void clearHighlighting() {
        this.mainapp.drawPanel1.setHighlightPosition(-1, -1);
    }

    public void kill() {
        if (this.currentThread != null) {
            this.currentThread.kill();
            this.currentThread = null;
        }
    }

    public static ArrayList<Structure> getStructuresWithoutChildren(ArrayList<Structure> structures) {
        ArrayList<Structure> childlessStructures = new ArrayList<Structure>();
        for (int i = 0; i < structures.size(); ++i) {
            boolean hasChild = false;
            for (int j = 0; j < structures.size(); ++j) {
                if (i == j || !SearchPanel.isParentStructureOf(structures.get(i), structures.get(j))) continue;
                hasChild = true;
                break;
            }
            if (hasChild) continue;
            childlessStructures.add(structures.get(i));
        }
        return childlessStructures;
    }

    public static boolean isParentStructureOf(Structure s1, Structure s2) {
        return s1.getStartPosition() <= s2.getStartPosition() && s1.getEndPosition() >= s2.getEndPosition();
    }

    public void performSearch() {
        this.kill();
        if (this.dataSourceBox.getSelectedIndex() >= 0) {
            Object data = this.data.get(this.dataSourceBox.getSelectedIndex());
            this.currentThread = new SearchThread(data);
            this.currentThread.setPriority(1);
            this.currentThread.start();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.dataSourceBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.searchField = new JTextField();
        this.clearButton = new JButton();
        this.jButton2 = new JButton();
        this.jToggleButton1 = new JToggleButton();
        this.showParentCheckBox1 = new JCheckBox();
        this.statusLabel = new JLabel();
        this.dataSourceBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.dataSourceBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Data source");
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel2.setForeground(new Color(102, 102, 102));
        this.jLabel2.setText("Double-click on a row to open the corresponding structure in the viewer.");
        this.jLabel3.setText("Search");
        this.clearButton.setText("Clear Highlighting");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.jButton2.setText("Search");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jToggleButton1.setText("Display DNA Ambiguity Codes");
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.showParentCheckBox1.setText("Show parent structures");
        this.showParentCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.showParentCheckBox1ActionPerformed(evt);
            }
        });
        this.statusLabel.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dataSourceBox, -2, 205, -2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchField, -2, 181, -2)).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton)).addComponent(this.showParentCheckBox1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jToggleButton1, -1, -1, Short.MAX_VALUE).addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataSourceBox, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.searchField, -2, -1, -2).addComponent(this.clearButton).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jToggleButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showParentCheckBox1).addComponent(this.statusLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, 382, Short.MAX_VALUE)));
    }

    private void dataSourceBoxActionPerformed(ActionEvent evt) {
        this.performSearch();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.clearHighlighting();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.performSearch();
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        AmbiguityCodesFrame frame = new AmbiguityCodesFrame();
        frame.setSize(350, 550);
        frame.setIconImage(this.mainapp.appIcon.getImage());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - frame.getWidth()) / 2;
        int y = (screenSize.height - frame.getHeight()) / 2;
        frame.setLocation(x, y);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    private void showParentCheckBox1ActionPerformed(ActionEvent evt) {
        this.performSearch();
    }

    public void createAndShowGUI() {
        JFrame frame = new JFrame("Structure ranking");
        frame.setDefaultCloseOperation(2);
        frame.setIconImage(this.mainapp.appIcon.getImage());
        SearchPanel newContentPane = new SearchPanel(this.mainapp);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void createAndShowGUI(MainApp mainapp) {
        JFrame frame = new JFrame("Structure ranking");
        frame.setDefaultCloseOperation(2);
        frame.setIconImage(mainapp.appIcon.getImage());
        SearchPanel newContentPane = new SearchPanel(mainapp);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchPanel.createAndShowGUI(null);
            }
        });
    }

    class SearchThread
    extends Thread {
        Object data;
        boolean running = false;
        boolean hasStopped = true;

        public SearchThread(Object data) {
            this.data = data;
        }

        @Override
        public void run() {
            this.hasStopped = false;
            this.running = true;
            SearchPanel.this.statusLabel.setForeground(Color.red);
            SearchPanel.this.statusLabel.setText("Searching...");
            SearchPanel.this.searchTable.tableDataModel.clear();
            Search search = new Search();
            ArrayList<Search.SearchResult> results = search.search(SearchPanel.this.searchField.getText(), (NucleotideComposition)this.data, 0.75, true);
            ArrayList<Structure> structures = SearchPanel.this.mainapp.structureCollection.structures;
            for (int j = 0; this.running && j < results.size(); ++j) {
                Search.SearchResult result = results.get(j);
                ArrayList<Structure> s1 = new ArrayList<Structure>();
                for (int i = 0; i < structures.size(); ++i) {
                    Structure structure = structures.get(i);
                    structure.index = i;
                    if (result.matchPosition < structure.getStartPosition() - 1 || result.matchPosition + result.searchTerm.length() >= structure.getStartPosition() - 1 + structure.getLength()) continue;
                    s1.add(structure);
                }
                ArrayList<Structure> s2 = s1;
                if (!SearchPanel.this.showParentCheckBox1.isSelected()) {
                    s2 = SearchPanel.getStructuresWithoutChildren(s1);
                }
                for (int i = 0; i < s2.size(); ++i) {
                    Structure structure = s2.get(i);
                    Object[] row = new Object[]{result.searchTerm, result.match, new Location(result.matchPosition + 1, result.matchPosition + result.searchTerm.length()), structure.index, new Location(structure.startPosition, structure.startPosition + structure.length), structure.getLength(), result.score};
                    SearchPanel.this.searchTable.tableDataModel.addRow(row);
                    SearchPanel.this.searchTable.repaint();
                }
            }
            SearchPanel.this.statusLabel.setForeground(Color.green);
            SearchPanel.this.statusLabel.setText("Search complete.");
            this.hasStopped = true;
        }

        public void kill() {
            this.running = false;
            while (!this.hasStopped) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(SearchPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

