/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.analyses;

import java.util.ArrayList;
import java.util.Hashtable;
import structurevis.structures.metadata.NucleotideComposition;

public class Search {
    Alphabet alpha = new Alphabet();

    public Search() {
        this.alpha.putValue("A", "A", 1.0);
        this.alpha.putValue("C", "C", 1.0);
        this.alpha.putValue("G", "G", 1.0);
        this.alpha.putValue("T", "TU", 1.0);
        this.alpha.putValue("U", "TU", 1.0);
        this.alpha.putValue("Y", "CT", 0.5);
        this.alpha.putValue("R", "AG", 0.5);
        this.alpha.putValue("W", "AT", 0.5);
        this.alpha.putValue("S", "GC", 0.5);
        this.alpha.putValue("K", "TG", 0.5);
        this.alpha.putValue("M", "CA", 0.5);
        this.alpha.putValue("D", "AGT", 0.3333333333333333);
        this.alpha.putValue("V", "ACG", 0.3333333333333333);
        this.alpha.putValue("H", "ACT", 0.3333333333333333);
        this.alpha.putValue("B", "CGT", 0.3333333333333333);
        this.alpha.putValue("N", "ACGT", 0.25);
        this.alpha.putValue("X", "ACGT", 0.25);
        this.alpha.putValue("-", "-", 1.0);
    }

    public ArrayList<SearchResult> search(String searchString, String s, double cutoff) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (int i = 0; i < s.length() - searchString.length(); ++i) {
            double score = this.alpha.match(searchString, s, i);
            if (!(score >= cutoff)) continue;
            SearchResult result = new SearchResult();
            result.searchTerm = searchString;
            result.match = s.substring(i, i + searchString.length());
            result.matchPosition = i;
            result.score = score;
            results.add(result);
        }
        return results;
    }

    public ArrayList<SearchResult> search(String searchString, NucleotideComposition nucleotideComposition, double cutoff, boolean circular) {
        ArrayList<String> searchTerms = this.getGappedPermutations(searchString, 1);
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (int i = 0; i < nucleotideComposition.mappedFrequencyComposition.length; ++i) {
            String bestSearchTerm = null;
            double bestScore = -1.0;
            for (int j = 0; j < searchTerms.size(); ++j) {
                double score;
                int end = nucleotideComposition.mappedFrequencyComposition.length - searchTerms.get(j).length();
                if (circular) {
                    end = nucleotideComposition.mappedFrequencyComposition.length;
                }
                if (i >= end || !((score = this.alpha.match(searchTerms.get(j), nucleotideComposition.mappedFrequencyComposition, i, circular)) > bestScore)) continue;
                bestSearchTerm = searchTerms.get(j);
                bestScore = score;
            }
            if (!(bestScore >= cutoff)) continue;
            SearchResult result = new SearchResult();
            result.searchTerm = bestSearchTerm;
            if (i + bestSearchTerm.length() <= nucleotideComposition.mappedFrequencyComposition.length) {
                result.match = nucleotideComposition.consensus.substring(i, i + bestSearchTerm.length());
            } else {
                result.match = nucleotideComposition.consensus.substring(i, nucleotideComposition.mappedFrequencyComposition.length);
                result.match = result.match + nucleotideComposition.consensus.substring(0, (i + bestSearchTerm.length()) % nucleotideComposition.mappedFrequencyComposition.length);
            }
            result.matchPosition = i;
            result.score = bestScore;
            results.add(result);
        }
        return results;
    }

    public ArrayList<String> getGappedPermutations(String s, int gaps) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(s);
        this.getGappedPermutations(strings, gaps);
        return strings;
    }

    public void getGappedPermutations(ArrayList<String> strings, int gaps) {
        int length = strings.size();
        if (gaps > 0) {
            for (int j = 0; j < length; ++j) {
                String s = strings.get(j);
                for (int i = 1; i < s.length() - 1; ++i) {
                    strings.add(s.substring(0, i) + "-" + s.substring(i));
                }
            }
            this.getGappedPermutations(strings, gaps - 1);
        }
    }

    public static void main(String[] args) {
        new Search();
    }

    class SearchResult {
        String searchTerm;
        String match;
        int matchPosition;
        double score;

        SearchResult() {
        }

        public String toString() {
            return this.searchTerm + ":" + this.match + " (" + this.matchPosition + "," + this.score + ")";
        }
    }

    class Alphabet {
        Hashtable<String, String> alphabet = new Hashtable();
        Hashtable<String, Double> scores = new Hashtable();

        Alphabet() {
        }

        public String getChars(String code) {
            String chars = this.alphabet.get(code);
            if (chars == null) {
                return "";
            }
            return chars;
        }

        public double match(String searchString, String s, int startPos) {
            double score = 0.0;
            double total = 0.0;
            for (int i = 0; i < searchString.length(); ++i) {
                String searchChar = searchString.charAt(i) + "";
                String sChar = s.substring(i + startPos, i + startPos + 1);
                double matchScore = this.getScore(sChar, searchChar);
                if (this.charMatches(sChar, searchChar)) {
                    score += matchScore;
                }
                total += matchScore;
            }
            System.out.println(score + "\t" + total);
            return score / total;
        }

        public double match(String searchString, double[][] nucleotideFrequency, int startPos, boolean circular) {
            double score = 0.0;
            double total = 0.0;
            for (int i = 0; i < searchString.length(); ++i) {
                String searchChar = searchString.charAt(i) + "";
                int pos = i + startPos;
                if (circular) {
                    pos %= nucleotideFrequency.length;
                }
                double matchScore = nucleotideFrequency[pos][0] * this.getScore("A", searchChar);
                double subtotal = 0.0;
                if (this.charMatches("A", searchChar)) {
                    score += matchScore;
                }
                subtotal += matchScore;
                matchScore = nucleotideFrequency[pos][1] * this.getScore("C", searchChar);
                if (this.charMatches("C", searchChar)) {
                    score += matchScore;
                }
                subtotal += matchScore;
                matchScore = nucleotideFrequency[pos][2] * this.getScore("G", searchChar);
                if (this.charMatches("G", searchChar)) {
                    score += matchScore;
                }
                subtotal += matchScore;
                matchScore = nucleotideFrequency[pos][3] * this.getScore("T", searchChar);
                if (this.charMatches("T", searchChar)) {
                    score += matchScore;
                }
                if ((subtotal += matchScore) == 0.0) {
                    // empty if block
                }
                total += subtotal;
            }
            return score / total;
        }

        public void putValue(String code, String chars, double score) {
            this.putChars(code, chars);
            this.scores.put(code, score);
        }

        private void putChars(String code, String chars) {
            String oldChars = this.getChars(code);
            for (int i = 0; i < chars.length(); ++i) {
                if (oldChars.contains(chars.charAt(i) + "")) continue;
                oldChars = oldChars + chars.charAt(i) + "";
            }
            this.alphabet.put(code, oldChars);
        }

        public double getScore(String code1, String code2) {
            Double score1 = this.scores.get(code1);
            Double score2 = this.scores.get(code2);
            if (score1 == null) {
                score1 = new Double(0.0);
            }
            if (score2 == null) {
                score2 = new Double(0.0);
            }
            return score1 * score2;
        }

        public boolean charMatches(String code1, String code2) {
            String chars1 = this.getChars(code1);
            String chars2 = this.getChars(code2);
            for (int i = 0; i < chars1.length(); ++i) {
                if (!chars2.contains(chars1.charAt(i) + "")) continue;
                return true;
            }
            return false;
        }
    }
}

