/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.analyses;

import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import structurevis.data.Mapping;
import structurevis.ui.MainApp;
import structurevis.ui.TableSorter;
import structurevis.ui.analyses.Location;

public class RankingTable
extends JPanel {
    TableDataModel tableDataModel;
    final JTable table;
    public JScrollPane scrollPane;
    final MainApp mainapp;

    public RankingTable(MainApp mainapp) {
        super(new BorderLayout());
        this.mainapp = mainapp;
        this.tableDataModel = new TableDataModel();
        TableSorter sorter = new TableSorter(this.tableDataModel);
        this.table = new JTable(sorter);
        sorter.setTableHeader(this.table.getTableHeader());
        sorter.sortOnColumn(this.table.getTableHeader(), this.table.getColumnCount() - 1, 1);
        this.table.setFillsViewportHeight(true);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JTable target = (JTable)e.getSource();
                    int row = target.getSelectedRow();
                    int column = target.getSelectedColumn();
                    int s = (Integer)RankingTable.this.table.getModel().getValueAt(row, 0) - 1;
                    RankingTable.this.mainapp.openStructure(s);
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table);
        this.add(this.scrollPane);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("SimpleTableDemo");
        frame.setDefaultCloseOperation(3);
        RankingTable newContentPane = new RankingTable(null);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RankingTable.createAndShowGUI();
            }
        });
    }

    class TableDataModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Structure #", "Structure ID", "Location", "Structure Length", "Structure N", "Genome N", "Structure Mean", "Genome Mean", "Structure Median", "Genome Median", "Mann-Whitney U stat.", "p-value", "z-score"};
        Class[] columnClasses = new Class[]{Integer.class, String.class, Location.class, Integer.class, Integer.class, Integer.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class};
        public ArrayList<Object[]> rows = new ArrayList();
        public ArrayList<Mapping> mappings = new ArrayList();
        public ArrayList<File> mappingFiles = new ArrayList();
        boolean hasMappedData = false;

        TableDataModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.rows.get(row)[col];
        }

        public void clear() {
            this.rows.clear();
            this.fireTableRowsDeleted(0, this.rows.size());
        }

        public void addRows(ArrayList rowsArray) {
            int start = this.rows.size() + 1;
            int end = this.rows.size() + rowsArray.size();
            this.rows.addAll(rowsArray);
            this.fireTableRowsInserted(start, end);
        }

        public void addRow(Object[] row) {
            this.rows.add(row);
            this.fireTableRowsInserted(this.rows.size(), this.rows.size());
        }

        public void removeRow(int index) {
            this.rows.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void removeRows(int[] indices) {
            Arrays.sort(indices);
            int correction = 0;
            for (int i = 0; i < indices.length; ++i) {
                this.removeRow(indices[i] - correction);
                ++correction;
            }
        }

        public void move(int index, int value) {
            Object[] array = this.rows.remove(index);
            this.rows.add(index + value, array);
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int c) {
            return this.columnClasses[c];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.rows.get((int)row)[col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

