/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui.analyses;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import structurevis.ranking.Ranking;
import structurevis.ranking.RankingAnalyses;
import structurevis.structures.Structure;
import structurevis.structures.StructureParser;
import structurevis.structures.metadata.MetadataFromFile;
import structurevis.structures.metadata.SequenceData1D;
import structurevis.structures.metadata.SequenceData2D;
import structurevis.ui.MainApp;
import structurevis.ui.analyses.Location;
import structurevis.ui.analyses.RankingTable;

public class RankingPanel
extends JPanel {
    MainApp mainapp = null;
    ArrayList<SequenceData1D> sequenceData1D = null;
    ArrayList<SequenceData2D> sequenceData2D = null;
    ArrayList sequenceData = new ArrayList();
    RankingTable rankingTable = null;
    public RankingThread currentThread = null;
    Hashtable<String, ArrayList> rowCache = new Hashtable();
    private JRadioButton allSitesButton;
    private ButtonGroup buttonGroup1;
    private JComboBox dataSourceBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JRadioButton pairedOnlyButton;
    private JButton saveAsCSVButton;
    private JLabel statusLabel;
    private JRadioButton unpairedOnlyButton;

    public RankingPanel(MainApp mainapp) {
        this.initComponents();
        this.mainapp = mainapp;
        this.rankingTable = new RankingTable(mainapp);
        this.jPanel1.add(this.rankingTable);
        if (mainapp.structureCollection != null) {
            this.sequenceData1D = mainapp.structureCollection.sequenceData1D;
            this.sequenceData2D = mainapp.structureCollection.sequenceData2D;
            this.sequenceData.addAll(this.sequenceData1D);
            this.sequenceData.addAll(this.sequenceData2D);
            DefaultComboBoxModel<String> sequenceDataModel = new DefaultComboBoxModel<String>();
            this.dataSourceBox.setModel(sequenceDataModel);
            for (int i = 0; i < this.sequenceData.size(); ++i) {
                sequenceDataModel.addElement(((MetadataFromFile)this.sequenceData.get((int)i)).name);
            }
        }
    }

    public ArrayList getListFromCache(String key) {
        ArrayList ret = this.rowCache.get(key);
        if (ret == null) {
            return new ArrayList();
        }
        return ret;
    }

    public void kill() {
        if (this.currentThread != null) {
            this.currentThread.kill();
            this.currentThread = null;
        }
    }

    public void performRanking() {
        this.kill();
        if (this.dataSourceBox.getSelectedIndex() >= 0) {
            Object data = this.sequenceData.get(this.dataSourceBox.getSelectedIndex());
            this.currentThread = new RankingThread(data);
            this.currentThread.setPriority(1);
            this.currentThread.start();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.dataSourceBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.pairedOnlyButton = new JRadioButton();
        this.unpairedOnlyButton = new JRadioButton();
        this.allSitesButton = new JRadioButton();
        this.statusLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.saveAsCSVButton = new JButton();
        this.dataSourceBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankingPanel.this.dataSourceBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Data source");
        this.jPanel1.setLayout(new BorderLayout());
        this.buttonGroup1.add(this.pairedOnlyButton);
        this.pairedOnlyButton.setText("Paired only");
        this.pairedOnlyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankingPanel.this.pairedOnlyButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.unpairedOnlyButton);
        this.unpairedOnlyButton.setText("Unpaired only");
        this.unpairedOnlyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankingPanel.this.unpairedOnlyButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.allSitesButton);
        this.allSitesButton.setSelected(true);
        this.allSitesButton.setText("All nucleotides");
        this.allSitesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankingPanel.this.allSitesButtonActionPerformed(evt);
            }
        });
        this.statusLabel.setText(" ");
        this.jLabel2.setForeground(new Color(102, 102, 102));
        this.jLabel2.setText("Double-click on a row to open the corresponding structure in the viewer.");
        this.saveAsCSVButton.setText("Save as CSV");
        this.saveAsCSVButton.setEnabled(false);
        this.saveAsCSVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RankingPanel.this.saveAsCSVButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dataSourceBox, -2, 205, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allSitesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pairedOnlyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unpairedOnlyButton).addGap(18, 18, 18).addComponent(this.statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addComponent(this.saveAsCSVButton)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataSourceBox, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.pairedOnlyButton).addComponent(this.unpairedOnlyButton).addComponent(this.allSitesButton).addComponent(this.statusLabel).addComponent(this.saveAsCSVButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, 334, Short.MAX_VALUE).addGap(22, 22, 22)));
    }

    private void dataSourceBoxActionPerformed(ActionEvent evt) {
        this.performRanking();
    }

    private void allSitesButtonActionPerformed(ActionEvent evt) {
        this.performRanking();
    }

    private void pairedOnlyButtonActionPerformed(ActionEvent evt) {
        this.performRanking();
    }

    private void unpairedOnlyButtonActionPerformed(ActionEvent evt) {
        this.performRanking();
    }

    private void saveAsCSVButtonActionPerformed(ActionEvent evt) {
        String name = ((SequenceData1D)this.sequenceData.get((int)this.dataSourceBox.getSelectedIndex())).name;
        if (this.pairedOnlyButton.isSelected()) {
            name = name + "-paired_only";
        } else if (this.unpairedOnlyButton.isSelected()) {
            name = name + "-unpaired_only";
        }
        File outFile = new File(MainApp.fileChooserSave.getCurrentDirectory().getPath() + "/" + name + "-ranking.csv");
        MainApp.fileChooserSave.setDialogTitle("Save CSV");
        MainApp.fileChooserSave.setSelectedFile(outFile);
        int returnVal = MainApp.fileChooserSave.showSaveDialog(this);
        if (returnVal == 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.saveAsCSV(MainApp.fileChooserSave.getSelectedFile());
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        MainApp.fileChooserSave.setDialogTitle("Open");
        System.out.println(name + "\t" + this.rankingTable.tableDataModel.rows.size());
    }

    public void saveAsCSV(File outFile) {
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(outFile));
            TableColumnModel columnModel = this.rankingTable.table.getTableHeader().getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount() - 1; ++i) {
                buffer.write(columnModel.getColumn(i).getHeaderValue().toString() + ",");
            }
            buffer.write(columnModel.getColumn(columnModel.getColumnCount() - 1).getHeaderValue().toString());
            buffer.newLine();
            TableModel tableModel = this.rankingTable.table.getModel();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                for (int j = 0; j < tableModel.getColumnCount() - 1; ++j) {
                    buffer.write(tableModel.getValueAt(i, j).toString() + ",");
                }
                buffer.write(tableModel.getValueAt(i, tableModel.getColumnCount() - 1).toString().toString());
                buffer.newLine();
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void createAndShowGUI(MainApp mainapp) {
        JFrame frame = new JFrame("Structure ranking");
        frame.setDefaultCloseOperation(2);
        frame.setIconImage(mainapp.appIcon.getImage());
        RankingPanel newContentPane = new RankingPanel(mainapp);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RankingPanel.createAndShowGUI(null);
            }
        });
    }

    class RankingThread
    extends Thread {
        Object data;
        boolean running = false;
        boolean hasStopped = true;

        public RankingThread(Object data) {
            this.data = data;
        }

        @Override
        public void run() {
            this.hasStopped = false;
            this.running = true;
            RankingPanel.this.saveAsCSVButton.setEnabled(false);
            RankingPanel.this.statusLabel.setForeground(Color.red);
            RankingPanel.this.statusLabel.setText("Ranking...");
            RankingPanel.this.rankingTable.tableDataModel.clear();
            boolean paired = true;
            Structure fullStructure = StructureParser.parseDotBracketString(RankingPanel.this.mainapp.structureCollection.dotBracketStructure);
            int PAIR_PARAMETER = 0;
            boolean unpaired = true;
            if (RankingPanel.this.pairedOnlyButton.isSelected()) {
                paired = true;
                unpaired = false;
                PAIR_PARAMETER = 1;
            } else if (RankingPanel.this.unpairedOnlyButton.isSelected()) {
                paired = false;
                unpaired = true;
                PAIR_PARAMETER = 2;
            }
            if (this.data instanceof SequenceData1D) {
                SequenceData1D sequenceData1D = (SequenceData1D)this.data;
                String cacheKey = sequenceData1D.name + "_" + PAIR_PARAMETER;
                ArrayList rows = RankingPanel.this.getListFromCache(cacheKey);
                RankingPanel.this.rankingTable.tableDataModel.addRows(rows);
                ArrayList<Structure> structures = RankingPanel.this.mainapp.structureCollection.structures;
                for (int i = rows.size(); this.running && i < structures.size(); ++i) {
                    RankingPanel.this.statusLabel.setText("Ranking (" + (i + 1) + " of " + structures.size() + ")");
                    Structure structure = structures.get(i);
                    Ranking ranking = RankingAnalyses.rankSequenceData1D(sequenceData1D, structure, RankingPanel.this.mainapp.structureCollection.dotBracketStructure.length(), fullStructure, paired, unpaired);
                    Object[] row = new Object[]{new Integer(i + 1), structure.name, new Location(structure.startPosition, structure.startPosition + structure.length), new Integer(structure.length), new Integer(ranking.xN), new Integer(ranking.yN), new Double(ranking.xMean), new Double(ranking.yMean), new Double(ranking.xMedian), new Double(ranking.yMedian), new Double(ranking.mannWhitneyU), new Double(RankingAnalyses.NormalZ(Math.abs(ranking.zScore)) / 2.0), new Double(ranking.zScore)};
                    RankingPanel.this.rankingTable.tableDataModel.addRow(row);
                    RankingPanel.this.rankingTable.repaint();
                }
                ArrayList<Object[]> clone = new ArrayList<Object[]>();
                for (int i = 0; i < RankingPanel.this.rankingTable.tableDataModel.rows.size(); ++i) {
                    clone.add(RankingPanel.this.rankingTable.tableDataModel.rows.get(i));
                }
                RankingPanel.this.rowCache.put(cacheKey, clone);
            } else if (this.data instanceof SequenceData2D) {
                SequenceData2D sequenceData2D = (SequenceData2D)this.data;
                String cacheKey = sequenceData2D.name + "_" + PAIR_PARAMETER;
                ArrayList rows = RankingPanel.this.getListFromCache(cacheKey);
                RankingPanel.this.rankingTable.tableDataModel.addRows(rows);
                ArrayList<Structure> structures = RankingPanel.this.mainapp.structureCollection.structures;
                for (int i = rows.size(); this.running && i < structures.size(); ++i) {
                    RankingPanel.this.statusLabel.setText("Ranking (" + (i + 1) + " of " + structures.size() + ")");
                    Structure structure = structures.get(i);
                    Ranking ranking = RankingAnalyses.rankSequenceData2D(sequenceData2D, structure, RankingPanel.this.mainapp.structureCollection.dotBracketStructure.length(), fullStructure, paired, unpaired);
                    Object[] row = new Object[]{new Integer(i + 1), structure.name, new Location(structure.startPosition, structure.startPosition + structure.length), new Integer(structure.length), new Integer(ranking.xN), new Integer(ranking.yN), new Double(ranking.xMean), new Double(ranking.yMean), new Double(ranking.xMedian), new Double(ranking.yMedian), new Double(ranking.mannWhitneyU), new Double(RankingAnalyses.NormalZ(Math.abs(ranking.zScore)) / 2.0), new Double(ranking.zScore)};
                    RankingPanel.this.rankingTable.tableDataModel.addRow(row);
                    RankingPanel.this.rankingTable.repaint();
                }
                ArrayList<Object[]> clone = new ArrayList<Object[]>();
                for (int i = 0; i < RankingPanel.this.rankingTable.tableDataModel.rows.size(); ++i) {
                    clone.add(RankingPanel.this.rankingTable.tableDataModel.rows.get(i));
                }
                RankingPanel.this.rowCache.put(cacheKey, clone);
            }
            this.hasStopped = true;
            RankingPanel.this.statusLabel.setForeground(Color.green);
            RankingPanel.this.statusLabel.setText("Ranking complete");
            RankingPanel.this.saveAsCSVButton.setEnabled(true);
        }

        public void kill() {
            this.running = false;
            while (!this.hasStopped) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(RankingPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

