/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import structurevis.structures.Structure;
import structurevis.ui.ColorTools;
import structurevis.ui.MainApp;

public class StructureDrawPanel1
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int SHOW = 0;
    public static final int HIDE = 1;
    public int oneDimensionalData = 0;
    public boolean show2DData = true;
    public static final int NASP_SHOW = 0;
    public static final int NASP_HIDE = 1;
    public int naspType = 1;
    public BufferedImage bufferedImage = null;
    public Graphics2D g = null;
    public boolean repaint = true;
    public int currentStructure = -1;
    int numStructures;
    MainApp mainapp = null;
    static ArrayList<String> sequences = new ArrayList();
    static ArrayList<String> sequenceNames = new ArrayList();
    static double[] weights;
    Font f1 = new Font("Arial", 0, 100);
    Font f2 = new Font("Arial", 0, 12);
    ArrayList<Interaction> covariationInteractions = new ArrayList();
    static final float[] dash1;
    static final BasicStroke dashedStroke;
    static final BasicStroke normalStroke;
    boolean dnasequence = false;
    boolean saveStructures = false;
    Structure structure = null;
    Point2D.Double[] nucleotidePositions;
    int nucleotideDiameter = 40;
    double xoffset = 150.0;
    ArrayList<Point2D.Double> np = null;
    double minx = Double.MAX_VALUE;
    double miny = Double.MAX_VALUE;
    double maxx = Double.MIN_VALUE;
    double maxy = Double.MIN_VALUE;
    double posx = -1.0;
    double posy = -1.0;
    int selectedNucleotide = -1;

    public StructureDrawPanel1() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void initialise(MainApp mainapp) {
        this.mainapp = mainapp;
        this.numStructures = 1;
        this.nucleotidePositions = null;
        this.nextStructure();
    }

    public Point2D getPointAlongArc(double x, double y, double width, double height, double startAngle, double offsetAngle) {
        return new Arc2D.Double(x, y, width, height, startAngle, offsetAngle, 0).getEndPoint();
    }

    public Ellipse2D getCircleCenteredAt(double x, double y, double diameter) {
        return new Ellipse2D.Double(x - diameter / 2.0, y - diameter / 2.0, diameter, diameter);
    }

    public void previousStructure() {
        --this.currentStructure;
        this.structure = this.mainapp.structureCollection.structures.get(this.currentStructure);
        if (this.currentStructure < 0) {
            this.currentStructure += this.numStructures;
        }
        this.gotoStructure(this.currentStructure);
    }

    public void nextStructure() {
        this.currentStructure = (this.currentStructure + 1) % this.numStructures;
        if (this.mainapp.structureCollection != null && this.mainapp.structureCollection.structures != null) {
            this.structure = this.mainapp.structureCollection.structures.get(this.currentStructure);
            this.gotoStructure(this.currentStructure);
        }
    }

    public void openStructure(Structure s) {
        this.structure = s;
        this.computeAndDraw();
        if (this.saveStructures) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(StructureDrawPanel1.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.mainapp.callNext();
        }
    }

    public void gotoStructure(int i) {
        this.currentStructure = (i + 1) % this.numStructures;
        this.structure = this.mainapp.structureCollection.structures.get(this.currentStructure);
        this.computeAndDraw();
    }

    public void computeAndDraw() {
        this.computeStructureToBeDrawn(this.structure);
        this.repaint = true;
        this.repaint();
    }

    public void redraw() {
        this.repaint = true;
        this.repaint();
    }

    public void computeStructureToBeDrawn(Structure structure) {
        int i;
        if (structure == null) {
            return;
        }
        this.np = StructureDrawPanel1.getStructureCoordinates(structure.getDotBracketString());
        this.minx = Double.MAX_VALUE;
        this.miny = Double.MAX_VALUE;
        this.maxx = Double.MIN_VALUE;
        this.maxy = Double.MIN_VALUE;
        for (i = 0; i < this.np.size(); ++i) {
            Point2D.Double pos = this.np.get(i);
            this.minx = Math.min(this.minx, pos.x);
            this.miny = Math.min(this.miny, pos.y);
            this.maxx = Math.max(this.maxx, pos.x);
            this.maxy = Math.max(this.maxy, pos.y);
        }
        this.nucleotidePositions = new Point2D.Double[this.np.size()];
        for (i = 0; i < this.nucleotidePositions.length; ++i) {
            this.nucleotidePositions[i] = new Point2D.Double();
            this.nucleotidePositions[i].x = this.xoffset + (this.np.get((int)i).x - this.minx) * 3.7;
            this.nucleotidePositions[i].y = 50.0 + (this.np.get((int)i).y - this.miny) * 3.5;
        }
    }

    public void drawComplexStructure() {
        int i;
        if (this.structure == null || this.nucleotidePositions == null) {
            return;
        }
        int panelWidth = (int)((this.maxx - this.minx) * 4.0 + this.xoffset * 2.0);
        int panelHeight = (int)((this.maxy - this.miny) * 4.0 + 100.0);
        Dimension d = new Dimension(panelWidth, panelHeight);
        this.setPreferredSize(d);
        this.revalidate();
        try {
            if (this.bufferedImage == null || d.width != this.bufferedImage.getWidth() || d.height != this.bufferedImage.getHeight()) {
                this.bufferedImage = (BufferedImage)this.createImage(d.width, d.height);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.mainapp, ex.getMessage(), "Error", 0);
            return;
        }
        this.g = (Graphics2D)this.bufferedImage.getGraphics();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setColor(Color.white);
        this.g.fillRect(0, 0, d.width, d.height);
        this.g.setColor(Color.black);
        int length = this.structure.length;
        this.covariationInteractions.clear();
        if (this.show2DData && this.mainapp.data2D != null) {
            for (int i2 = this.structure.getStartPosition(); i2 <= this.structure.getEndPosition(); ++i2) {
                for (int j = this.structure.getStartPosition(); j <= this.structure.getEndPosition(); ++j) {
                    if (this.mainapp.maxDistance != -1 && Math.abs(j - i2) > this.mainapp.maxDistance) continue;
                    Color c = null;
                    int k = i2 - this.structure.getStartPosition();
                    int l = j - this.structure.getStartPosition();
                    double p = this.mainapp.data2D.matrix.get(i2 - 1, j - 1);
                    if (p == this.mainapp.data2D.matrix.emptyValue) {
                        c = null;
                    } else if (!(this.mainapp.useLowerThreshold2D && !(p >= this.mainapp.thresholdMin2D) || this.mainapp.useUpperThreshold2D && !(p <= this.mainapp.thresholdMax2D) || this.mainapp.data2D == null)) {
                        c = this.mainapp.data2D.colorGradientSecondary.getColor((float)this.mainapp.data2D.dataTransform.transform(p));
                    }
                    if (c == null) continue;
                    double x1 = this.nucleotidePositions[k].getX();
                    double y1 = this.nucleotidePositions[k].getY();
                    double x2 = this.nucleotidePositions[l].getX();
                    double y2 = this.nucleotidePositions[l].getY();
                    Shape shape = null;
                    int structureMidpoint = this.structure.getStartPosition() + this.structure.length / 2;
                    if (i2 <= structureMidpoint && j <= structureMidpoint) {
                        double x1p = Math.max(x1 - Math.abs((y1 - y2) / 2.0), 0.0);
                        shape = new QuadCurve2D.Double(x1, y1, x1p, (y1 + y2) / 2.0, x2, y2);
                    } else if (i2 > structureMidpoint && j > structureMidpoint) {
                        double x2p = Math.min(x2 + Math.abs((y1 - y2) / 2.0), (double)panelWidth);
                        shape = new QuadCurve2D.Double(x1, y1, x2p, (y1 + y2) / 2.0, x2, y2);
                    } else {
                        shape = new Line2D.Double(this.nucleotidePositions[k], this.nucleotidePositions[l]);
                    }
                    this.covariationInteractions.add(new Interaction(shape, i2, j));
                    this.g.setColor(c);
                    this.g.setStroke(normalStroke);
                    this.g.draw(shape);
                    this.g.setColor(Color.black);
                    this.g.setStroke(new BasicStroke());
                }
            }
        }
        int[] tetraloop = new int[this.nucleotidePositions.length];
        for (i = 0; i < this.nucleotidePositions.length; ++i) {
            int pos = (this.structure.startPosition + i - 1) % this.mainapp.structureCollection.genomeLength;
            Ellipse2D stemNucleotide = this.getCircleCenteredAt(this.nucleotidePositions[i].getX(), this.nucleotidePositions[i].getY(), this.nucleotideDiameter);
            this.g.setColor(Color.white);
            Color nucleotideBackgroundColor = this.mainapp.missingDataColor;
            if (this.oneDimensionalData == 0 && this.mainapp.data1D != null && this.mainapp.data1D.used[pos]) {
                double p = this.mainapp.data1D.data[pos];
                if (!(!this.mainapp.data1D.used[pos] || this.mainapp.useLowerThreshold1D && !(p >= this.mainapp.thresholdMin1D) || this.mainapp.useUpperThreshold1D && !(p <= this.mainapp.thresholdMax1D))) {
                    nucleotideBackgroundColor = this.mainapp.data1D.colorGradientSecondary.getColor(this.mainapp.data1D.dataTransform.transform((float)p));
                } else if (this.mainapp.useLowerThreshold1D && !(p >= this.mainapp.thresholdMin1D) || this.mainapp.useUpperThreshold1D && !(p <= this.mainapp.thresholdMax1D)) {
                    nucleotideBackgroundColor = this.mainapp.filteredDataColor;
                }
                this.g.setColor(nucleotideBackgroundColor);
                this.g.fill(stemNucleotide);
                this.g.setColor(Color.black);
            } else {
                this.g.setColor(nucleotideBackgroundColor);
                this.g.fill(stemNucleotide);
            }
            if (tetraloop[i] > 0) {
                this.g.setColor(Color.magenta);
                this.g.setStroke(new BasicStroke(3.0f));
                this.g.draw(stemNucleotide);
            } else {
                this.g.setColor(Color.black);
                this.g.draw(stemNucleotide);
            }
            this.g.setStroke(new BasicStroke());
            this.g.setColor(ColorTools.selectBestForegroundColor(nucleotideBackgroundColor, Color.white, Color.black));
            if (this.mainapp.nucleotideComposition == null) continue;
            if (this.mainapp.nucleotideCompositionType == MainApp.NucleotideCompositionType.SHANNON) {
                double[] fa = Arrays.copyOf(this.mainapp.nucleotideComposition.mappedShannonComposition[(this.structure.startPosition + i - 1) % this.mainapp.structureCollection.genomeLength], 5);
                for (int k = 0; k < 4; ++k) {
                    fa[k] = fa[k] / 2.0;
                }
                this.drawSequenceLogo(this.g, this.nucleotidePositions[i].getX(), this.nucleotidePositions[i].getY() - (double)(this.nucleotideDiameter / 2) + 3.0, this.nucleotideDiameter, this.nucleotideDiameter - 5, fa);
                this.g.setFont(this.f2);
                continue;
            }
            if (this.mainapp.nucleotideCompositionType != MainApp.NucleotideCompositionType.FREQUENCY) continue;
            double[] fa = this.mainapp.nucleotideComposition.mappedFrequencyComposition[(this.structure.startPosition + i - 1) % this.mainapp.structureCollection.genomeLength];
            this.drawSequenceLogo(this.g, this.nucleotidePositions[i].getX(), this.nucleotidePositions[i].getY() - (double)(this.nucleotideDiameter / 2) + 3.0, this.nucleotideDiameter, this.nucleotideDiameter - 5, fa);
            this.g.setFont(this.f2);
        }
        for (i = 0; i < this.nucleotidePositions.length; ++i) {
            int offsetx = 0;
            double side = 1.0;
            if (i < length / 2) {
                offsetx = -(this.nucleotideDiameter - 3);
                side = -1.0;
            } else {
                offsetx = this.nucleotideDiameter - 3;
            }
            if (this.nucleotidePositions[i] == null) continue;
            this.g.setColor(Color.black);
            int pos = (this.structure.getStartPosition() + i - 1) % this.mainapp.structureCollection.genomeLength + 1;
            StructureDrawPanel1.drawStringCentred(this.g, (double)offsetx + this.nucleotidePositions[i].getX(), this.nucleotidePositions[i].getY() - 2.0, "" + pos);
            this.g.setColor(Color.black);
            this.g.draw(new Line2D.Double(this.nucleotidePositions[i].getX() + side * (double)this.nucleotideDiameter / 2.0 - 2.0, this.nucleotidePositions[i].getY(), this.nucleotidePositions[i].getX() + side * (double)this.nucleotideDiameter / 2.0 + 2.0, this.nucleotidePositions[i].getY()));
        }
    }

    public void saveAsPNG(File file) {
        try {
            if (this.bufferedImage != null) {
                ImageIO.write((RenderedImage)this.bufferedImage, "png", file);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(StructureDrawPanel1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void drawSequenceLogo(Graphics2D g, double x, double y, double width, double height, double[] h) {
        double fontHeight = g.getFontMetrics(this.f1).getHeight();
        double scale = height / (fontHeight - (double)g.getFontMetrics(this.f1).getDescent() + 2.0);
        double base = y;
        for (int i = 0; i < h.length; ++i) {
            double fontHeightScale = h[i];
            Font tallerFont = this.f1.deriveFont(AffineTransform.getScaleInstance(scale, fontHeightScale * scale));
            String a = "";
            switch (i) {
                case 0: {
                    a = "A";
                    break;
                }
                case 1: {
                    a = "C";
                    break;
                }
                case 2: {
                    a = "G";
                    break;
                }
                case 3: {
                    a = this.dnasequence ? "T" : "U";
                }
            }
            String b = a.length() > 0 ? a : "X";
            g.setFont(tallerFont);
            g.drawString(a, (float)(x + -g.getFontMetrics().getStringBounds(a, g).getWidth() / 2.0), (float)(base += g.getFontMetrics(tallerFont).getStringBounds(b, g).getHeight() - (double)g.getFontMetrics().getDescent()));
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.repaint) {
            this.repaint = false;
            this.drawComplexStructure();
        }
        graphics.drawImage(this.bufferedImage, 0, 0, this);
        if (this.selectedNucleotide != -1) {
            graphics.setColor(Color.black);
            graphics.drawOval((int)this.posx - this.nucleotideDiameter / 2, (int)this.posy - this.nucleotideDiameter / 2, this.nucleotideDiameter, this.nucleotideDiameter);
            this.nucleotidePositions[this.selectedNucleotide] = new Point2D.Double(this.posx, this.posy);
        }
    }

    public static void drawStringCentred(Graphics2D g, double x, double y, String s) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(s, g);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        double x1 = x + (double)(-textWidth / 2);
        double y1 = y + (double)(-textHeight / 2 + fm.getAscent());
        g.drawString(s, (float)x1, (float)y1);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.posx = e.getX();
        this.posy = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mainapp.data2DLabel.setText("");
        for (int i = 0; i < this.covariationInteractions.size(); ++i) {
            if (!(this.covariationInteractions.get((int)i).shape instanceof QuadCurve2D)) continue;
            int c = 0;
            boolean[] count = new boolean[]{this.covariationInteractions.get((int)i).shape.intersects(e.getX() - 2, e.getY() - 2, 4.0, 4.0), this.covariationInteractions.get((int)i).shape.intersects(e.getX() + 2, e.getY() - 2, 4.0, 4.0), this.covariationInteractions.get((int)i).shape.intersects(e.getX() - 2, e.getY() + 2, 4.0, 4.0), this.covariationInteractions.get((int)i).shape.intersects(e.getX() + 2, e.getY() + 2, 4.0, 4.0)};
            for (int k = 0; k < count.length; ++k) {
                if (!count[k]) continue;
                ++c;
            }
            if (c > 0) {
                // empty if block
            }
            if (c >= 1 && c > 3) continue;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int minIndex = -1;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.nucleotidePositions.length; ++i) {
            double distance = this.nucleotidePositions[i].distance(e.getPoint());
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minIndex = i;
        }
        if (minDistance <= (double)(this.nucleotideDiameter / 2)) {
            this.selectedNucleotide = minIndex;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.selectedNucleotide = -1;
        this.redraw();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static Point2D.Double[] normaliseStructureCoordinates(ArrayList<Point2D.Double> coordinates) {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        for (int i = 0; i < coordinates.size(); ++i) {
            Point2D.Double pos = coordinates.get(i);
            minx = Math.min(minx, pos.x);
            miny = Math.min(miny, pos.y);
            maxx = Math.max(maxx, pos.x);
            maxy = Math.max(maxy, pos.y);
        }
        Point2D.Double[] normalisedPositions = new Point2D.Double[coordinates.size()];
        for (int i = 0; i < normalisedPositions.length; ++i) {
            normalisedPositions[i] = new Point2D.Double();
            normalisedPositions[i].x = 0.0 + (coordinates.get((int)i).x - minx);
            normalisedPositions[i].y = 0.0 + (coordinates.get((int)i).y - miny);
        }
        return normalisedPositions;
    }

    public static ArrayList<Point2D.Double> getStructureCoordinates(String dotBracketString) {
        ArrayList<Point2D.Double> coordinates = new ArrayList<Point2D.Double>();
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(new File("temp.dbn")));
            buffer.write(">temp");
            buffer.newLine();
            for (int i = 0; i < dotBracketString.length(); ++i) {
                buffer.write("A");
            }
            buffer.newLine();
            buffer.write(dotBracketString);
            buffer.newLine();
            buffer.close();
            Process p = Runtime.getRuntime().exec("cmd /c RNAPlot -t 1 -o ps < temp.dbn");
            if (p.waitFor() == 0) {
                BufferedReader bufferIn = new BufferedReader(new FileReader(new File("temp_ss.ps")));
                String textline = null;
                boolean readCoord = false;
                while ((textline = bufferIn.readLine()) != null) {
                    if (textline.startsWith("/coor")) {
                        readCoord = true;
                        continue;
                    }
                    if (!readCoord) continue;
                    String[] split = textline.substring(1).replaceAll("]", "").split("\\s");
                    if (textline.startsWith("[")) {
                        Point2D.Double point = new Point2D.Double(Double.parseDouble(split[0]), Double.parseDouble(split[1]));
                        coordinates.add(point);
                        continue;
                    }
                    readCoord = false;
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(StructureDrawPanel1.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(StructureDrawPanel1.class.getName()).log(Level.SEVERE, null, ex);
        }
        return coordinates;
    }

    static {
        dash1 = new float[]{7.0f};
        dashedStroke = new BasicStroke(2.0f, 0, 0, 7.0f, dash1, 0.0f);
        normalStroke = new BasicStroke(6.0f);
    }

    class Interaction {
        Shape shape;
        int nucleotidei;
        int nucleotidej;

        public Interaction(Shape shape, int nucleotidei, int nucleotidej) {
            this.shape = shape;
            this.nucleotidei = nucleotidei;
            this.nucleotidej = nucleotidej;
        }

        public String toString() {
            return this.nucleotidei + " <-> " + this.nucleotidej;
        }
    }
}

