/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import net.hanjava.svg.SVG2EMF;
import structurevis.structures.Structure;
import structurevis.ui.ColorTools;
import structurevis.ui.DataLegend;
import structurevis.ui.DistanceMatrix;
import structurevis.ui.MainApp;
import structurevis.ui.NAView;
import structurevis.ui.RNAFoldingTools;
import structurevis.ui.StructureEdit;

public class StructureDrawPanel
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    public static final int SHOW = 0;
    public static final int HIDE = 1;
    public int oneDimensionalData = 0;
    public boolean show2DData = true;
    public static final int NASP_SHOW = 0;
    public static final int NASP_HIDE = 1;
    public int naspType = 1;
    public Graphics2D g = null;
    public boolean repaint = true;
    public int currentStructure = -1;
    int numStructures;
    MainApp mainapp = null;
    static ArrayList<String> sequences = new ArrayList();
    static ArrayList<String> sequenceNames = new ArrayList();
    static double[] weights;
    Font f1 = new Font("Arial", 0, 100);
    Font f2 = new Font("Arial", 0, 12);
    ArrayList<Interaction> covariationInteractions = new ArrayList();
    static final float[] dash1;
    static final BasicStroke dashedStroke;
    static final BasicStroke normalStroke;
    boolean saveStructures = false;
    Structure structure = null;
    DistanceMatrix structureDistanceMatrix = null;
    Point2D.Double[] nucleotidePositions;
    int nucleotideDiameter = 40;
    double xoffset = 150.0;
    double zoomScale = 1.0;
    ArrayList<Point2D.Double> np = null;
    double minx = Double.MAX_VALUE;
    double miny = Double.MAX_VALUE;
    double maxx = Double.MIN_VALUE;
    double maxy = Double.MIN_VALUE;
    JPopupMenu popupMenu = new JPopupMenu();
    JMenu zoomWindowMenu = new JMenu("Zoom level");
    JRadioButtonMenuItem customZoomLevelItem = new JRadioButtonMenuItem("Custom");
    private static final int[] zoomLevels;
    ButtonGroup slidingWindowGroup = new ButtonGroup();
    JRadioButtonMenuItem[] zoomMenuItems = new JRadioButtonMenuItem[zoomLevels.length];
    int currentZoomIndex = 3;
    JMenu dnaRnaMenu = new JMenu("Nucleic acid");
    JRadioButtonMenuItem dnaMenuItem = new JRadioButtonMenuItem("DNA");
    JRadioButtonMenuItem rnaMenuItem = new JRadioButtonMenuItem("RNA");
    ButtonGroup dnaRnaGroup = new ButtonGroup();
    JMenuItem saveAsPNGItem = new JMenuItem("Save as PNG (at current zoom level)");
    JMenuItem saveAsSVGItem = new JMenuItem("Save as SVG");
    JMenuItem saveAsEMFItem = new JMenuItem("Save as EMF");
    JCheckBoxMenuItem showBondsItem = new JCheckBoxMenuItem("Show bonds");
    JMenu numberingMenu = new JMenu("Numbering");
    ButtonGroup numberingGroup = new ButtonGroup();
    JRadioButtonMenuItem numberNone = new JRadioButtonMenuItem("None");
    JRadioButtonMenuItem number1 = new JRadioButtonMenuItem("1");
    JRadioButtonMenuItem number5 = new JRadioButtonMenuItem("5");
    JRadioButtonMenuItem number10 = new JRadioButtonMenuItem("10");
    public static final int DRAW_SVG_GRAPHIC = 1;
    public static final int DRAW_NATIVE_GRAPHIC = 2;
    boolean useNativeDrawType = true;
    int currentDrawType = 1;
    DecimalFormat decimalFormat = new DecimalFormat("0.00");
    Color bondColor = Color.lightGray;
    int bondThickness = 4;
    JPopupMenu createBondPopupMenu = new JPopupMenu();
    JMenuItem createBondItem = new JMenuItem("Create bond");
    JMenuItem createBondRedrawItem = new JMenuItem("Create bond (Re-draw)");
    JPopupMenu disruptBondPopupMenu = new JPopupMenu();
    JMenuItem disruptBondItem = new JMenuItem("Disrupt bond");
    JMenuItem disruptBondRedrawItem = new JMenuItem("Disrupt bond (Re-draw)");
    JMenuItem redrawStructureItem = new JMenuItem("Re-draw structure");
    JMenuItem resetStructureItem = new JMenuItem("Reset structure");
    double horizontalScale = 2.6;
    double verticalScale = 2.6;
    int[] pairedSites = null;
    int selectedNuc1 = -1;
    int selectedNuc2 = -1;
    StructureEdit edit = null;
    URI uri;
    LinkedList extraElements = new LinkedList();
    SVGUniverse svgUniverse = SVGCache.getSVGUniverse();
    SVGDiagram diagram = null;
    SVGDiagram diagramWithLogo = null;
    public BufferedImage bufferedImage = null;
    int startHighlightPosition = -1;
    int endHighlightPosition = -1;
    double posx = -1.0;
    double posy = -1.0;
    int selectedNucleotideX = -1;
    int selectedNucleotideY = -1;
    int selectedNucleotide = -1;

    public StructureDrawPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.redrawStructureItem.addActionListener(this);
        this.popupMenu.add(this.redrawStructureItem);
        this.resetStructureItem.addActionListener(this);
        this.popupMenu.add(this.resetStructureItem);
        this.dnaMenuItem.addActionListener(this);
        this.dnaRnaMenu.add(this.dnaMenuItem);
        this.dnaRnaGroup.add(this.dnaMenuItem);
        this.rnaMenuItem.addActionListener(this);
        this.dnaRnaMenu.add(this.rnaMenuItem);
        this.dnaRnaGroup.add(this.rnaMenuItem);
        this.popupMenu.add(this.dnaRnaMenu);
        this.dnaMenuItem.setSelected(true);
        this.zoomWindowMenu.add(this.customZoomLevelItem);
        this.slidingWindowGroup.add(this.customZoomLevelItem);
        for (int i = 0; i < zoomLevels.length; ++i) {
            this.zoomMenuItems[i] = new JRadioButtonMenuItem(zoomLevels[i] + "%");
            this.zoomMenuItems[i].addActionListener(this);
            this.slidingWindowGroup.add(this.zoomMenuItems[i]);
            this.zoomWindowMenu.add(this.zoomMenuItems[i]);
        }
        this.zoomMenuItems[this.currentZoomIndex].setSelected(true);
        this.popupMenu.add(this.zoomWindowMenu);
        this.saveAsPNGItem.addActionListener(this);
        this.popupMenu.add(this.saveAsPNGItem);
        this.saveAsSVGItem.addActionListener(this);
        this.popupMenu.add(this.saveAsSVGItem);
        this.saveAsEMFItem.addActionListener(this);
        this.popupMenu.add(this.saveAsEMFItem);
        this.showBondsItem.setSelected(true);
        this.showBondsItem.addActionListener(this);
        this.popupMenu.add(this.showBondsItem);
        this.numberNone.addActionListener(this);
        this.number1.addActionListener(this);
        this.number5.addActionListener(this);
        this.number5.setSelected(true);
        this.number10.addActionListener(this);
        this.numberingMenu.add(this.numberNone);
        this.numberingGroup.add(this.numberNone);
        this.numberingMenu.add(this.number1);
        this.numberingGroup.add(this.number1);
        this.numberingMenu.add(this.number5);
        this.numberingGroup.add(this.number5);
        this.numberingMenu.add(this.number10);
        this.numberingGroup.add(this.number10);
        this.popupMenu.add(this.numberingMenu);
        this.createBondItem.addActionListener(this);
        this.createBondRedrawItem.addActionListener(this);
        this.createBondPopupMenu.add(this.createBondItem);
        this.createBondPopupMenu.add(this.createBondRedrawItem);
        this.disruptBondItem.addActionListener(this);
        this.disruptBondRedrawItem.addActionListener(this);
        this.disruptBondPopupMenu.add(this.disruptBondItem);
        this.disruptBondPopupMenu.add(this.disruptBondRedrawItem);
    }

    public void initialise(MainApp mainapp) {
        this.mainapp = mainapp;
        this.numStructures = 1;
        this.nucleotidePositions = null;
        this.nextStructure();
        this.setPreferredSize(new Dimension(800, 600));
        this.revalidate();
    }

    public Point2D getPointAlongArc(double x, double y, double width, double height, double startAngle, double offsetAngle) {
        return new Arc2D.Double(x, y, width, height, startAngle, offsetAngle, 0).getEndPoint();
    }

    public Ellipse2D getCircleCenteredAt(double x, double y, double diameter) {
        return new Ellipse2D.Double(x - diameter / 2.0, y - diameter / 2.0, diameter, diameter);
    }

    public void previousStructure() {
        --this.currentStructure;
        this.structure = this.mainapp.structureCollection.structures.get(this.currentStructure);
        if (this.currentStructure < 0) {
            this.currentStructure += this.numStructures;
        }
        this.openStructure(this.structure);
    }

    public void nextStructure() {
        this.currentStructure = (this.currentStructure + 1) % this.numStructures;
        if (this.mainapp.structureCollection != null && this.mainapp.structureCollection.structures != null) {
            this.structure = this.mainapp.structureCollection.structures.get(this.currentStructure);
        }
        this.openStructure(this.structure);
    }

    public void openStructure(Structure s) {
        this.structure = s;
        this.structureDistanceMatrix = this.structure.length < 500 ? new DistanceMatrix(this.structure.pairedSites) : null;
        if (this.mainapp != null) {
            if (this.mainapp.showDNA) {
                this.dnaMenuItem.setSelected(true);
            } else {
                this.rnaMenuItem.setSelected(true);
            }
        }
        this.computeAndDraw();
        if (this.saveStructures) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(StructureDrawPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.mainapp.callNext();
        }
    }

    public void computeAndDraw() {
        this.computeStructureToBeDrawn(this.structure);
        this.repaint = true;
        this.repaint();
    }

    public void redraw() {
        this.repaint = true;
        this.repaint();
    }

    public void computeStructureToBeDrawn(Structure structure) {
        if (structure == null) {
            return;
        }
        this.pairedSites = RNAFoldingTools.getPairedSitesFromDotBracketString(structure.getDotBracketString());
        this.edit = new StructureEdit(this.pairedSites);
        this.computeStructureToBeDrawn(this.edit.pairedSites);
    }

    public void computeStructureToBeDrawn(int[] pairedSites) {
        int i;
        this.np = NAView.naview_xy_coordinates(pairedSites);
        this.minx = Double.MAX_VALUE;
        this.miny = Double.MAX_VALUE;
        this.maxx = Double.MIN_VALUE;
        this.maxy = Double.MIN_VALUE;
        for (i = 0; i < this.np.size(); ++i) {
            Point2D.Double pos = this.np.get(i);
            this.minx = Math.min(this.minx, pos.x);
            this.miny = Math.min(this.miny, pos.y);
            this.maxx = Math.max(this.maxx, pos.x);
            this.maxy = Math.max(this.maxy, pos.y);
        }
        this.nucleotidePositions = new Point2D.Double[this.np.size()];
        for (i = 0; i < this.nucleotidePositions.length; ++i) {
            this.nucleotidePositions[i] = new Point2D.Double();
            this.nucleotidePositions[i].x = this.xoffset + (this.np.get((int)i).x - this.minx) * this.horizontalScale;
            this.nucleotidePositions[i].y = 50.0 + (this.np.get((int)i).y - this.miny) * this.verticalScale;
        }
    }

    public void createStructureSVG() {
        StringReader reader = new StringReader(this.drawStructure(true));
        SVGCache.getSVGUniverse().clear();
        this.uri = SVGCache.getSVGUniverse().loadSVG((Reader)reader, "myImage");
        this.diagram = SVGCache.getSVGUniverse().getDiagram(this.uri);
    }

    public static String getHexString(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF | 0x1000000).substring(1);
    }

    public String drawStructure(boolean drawSequenceLogo) {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (this.structure == null || this.nucleotidePositions == null) {
            return null;
        }
        int panelWidth = (int)((this.maxx - this.minx) * this.horizontalScale + this.xoffset * 2.0);
        int panelHeight = (int)((this.maxy - this.miny) * this.verticalScale + 100.0);
        pw.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        pw.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
        pw.println("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"" + panelWidth + "\" height=\"" + panelHeight + "\" style=\"fill:none;stroke-width:16\">");
        if (this.mainapp.showBonds) {
            pw.println("<g>");
            for (int i2 = 0; i2 < this.nucleotidePositions.length; ++i2) {
                int a = i2;
                int b = this.edit.pairedSites[i2] - 1;
                if (i2 + 1 >= this.edit.pairedSites[i2]) continue;
                pw.println("    <line id=\"bond_" + i2 + "\" x1=\"" + this.nucleotidePositions[a].x + "\" y1=\"" + this.nucleotidePositions[a].y + "\"  x2=\"" + this.nucleotidePositions[b].x + "\" y2=\"" + this.nucleotidePositions[b].y + "\" style=\"stroke-width:" + this.bondThickness + ";stroke:#" + StructureDrawPanel.getHexString(this.bondColor) + "\"/>");
            }
            pw.println("</g>");
        }
        pw.println("<g>");
        int length = this.structure.length;
        this.covariationInteractions.clear();
        if (this.show2DData && this.mainapp.data2D != null) {
            for (i = this.structure.getStartPosition(); i <= this.structure.getEndPosition(); ++i) {
                for (int j = this.structure.getStartPosition(); j <= this.structure.getEndPosition(); ++j) {
                    int k = i - this.structure.getStartPosition();
                    int l = j - this.structure.getStartPosition();
                    if (this.mainapp.maxDistance != -1 && (this.structureDistanceMatrix == null || this.structureDistanceMatrix.getDistance(k, l) > this.mainapp.maxDistance) && (this.structureDistanceMatrix != null || this.mainapp.distanceMatrix.getDistance(i - 1, j - 1) > this.mainapp.maxDistance)) continue;
                    Color c = null;
                    double value = this.mainapp.data2D.matrix.get(i - 1, j - 1);
                    if (value == this.mainapp.data2D.matrix.emptyValue) {
                        c = null;
                    } else if (!(this.mainapp.useLowerThreshold2D && !(value >= this.mainapp.thresholdMin2D) || this.mainapp.useUpperThreshold2D && !(value <= this.mainapp.thresholdMax2D) || this.mainapp.data2D == null)) {
                        c = this.mainapp.data2D.colorGradientSecondary.getColor((float)this.mainapp.data2D.dataTransform.transform(value));
                    }
                    if (c == null || this.nucleotidePositions.length != this.structure.length) continue;
                    double x1 = this.nucleotidePositions[k].getX();
                    double y1 = this.nucleotidePositions[k].getY();
                    double x2 = this.nucleotidePositions[l].getX();
                    double y2 = this.nucleotidePositions[l].getY();
                    Shape shape = null;
                    int structureMidpoint = this.structure.getStartPosition() + this.structure.length / 2;
                    if (i <= structureMidpoint && j <= structureMidpoint) {
                        double x1p = Math.max(x1 - Math.abs((y1 - y2) / 2.0), 0.0);
                        shape = new QuadCurve2D.Double(x1, y1, x1p, (y1 + y2) / 2.0, x2, y2);
                    } else if (i > structureMidpoint && j > structureMidpoint) {
                        double x2p = Math.min(x2 + Math.abs((y1 - y2) / 2.0), (double)panelWidth);
                        shape = new QuadCurve2D.Double(x1, y1, x2p, (y1 + y2) / 2.0, x2, y2);
                    } else {
                        shape = new Line2D.Double(this.nucleotidePositions[k], this.nucleotidePositions[l]);
                    }
                    this.covariationInteractions.add(new Interaction(shape, i, j));
                    pw.println("    <polyline id=\"2d_data_" + i + "_" + j + "\" points=\"" + x1 + " " + y1 + " " + x2 + " " + y2 + "\" style=\"stroke-width:5;stroke:#" + StructureDrawPanel.getHexString(c) + "\"/>");
                }
            }
        }
        pw.println("</g>");
        pw.println("<g>");
        for (i = 0; i < this.nucleotidePositions.length; ++i) {
            double[] fa;
            int pos = (this.structure.startPosition + i - 1) % this.mainapp.structureCollection.genomeLength;
            Color nucleotideBackgroundColor = this.mainapp.missingDataColor;
            if (this.oneDimensionalData == 0 && this.mainapp.data1D != null && this.mainapp.data1D.used[pos]) {
                double p = this.mainapp.data1D.data[pos];
                if (!(!this.mainapp.data1D.used[pos] || this.mainapp.useLowerThreshold1D && !(p >= this.mainapp.thresholdMin1D) || this.mainapp.useUpperThreshold1D && !(p <= this.mainapp.thresholdMax1D))) {
                    nucleotideBackgroundColor = this.mainapp.data1D.colorGradientSecondary.getColor(this.mainapp.data1D.dataTransform.transform((float)p));
                } else if (this.mainapp.useLowerThreshold1D && !(p >= this.mainapp.thresholdMin1D) || this.mainapp.useUpperThreshold1D && !(p <= this.mainapp.thresholdMax1D)) {
                    nucleotideBackgroundColor = this.mainapp.filteredDataColor;
                }
            }
            pw.println("    <circle id=\"nucleotide_" + (this.structure.startPosition + i) + "\" cx=\"" + this.nucleotidePositions[i].getX() + "\" cy=\"" + this.nucleotidePositions[i].getY() + "\" r=\"" + this.nucleotideDiameter / 2 + "\" style=\"stroke-width:2;stroke:black;fill:#" + StructureDrawPanel.getHexString(nucleotideBackgroundColor) + "\"/>");
            if (!drawSequenceLogo) continue;
            Color bestColor = ColorTools.selectBestForegroundColor(nucleotideBackgroundColor, Color.white, Color.black);
            if (this.mainapp.nucleotideComposition == null) continue;
            if (this.mainapp.nucleotideCompositionType == MainApp.NucleotideCompositionType.SHANNON) {
                fa = Arrays.copyOf(this.mainapp.nucleotideComposition.mappedShannonComposition[(this.structure.startPosition + i - 1) % this.mainapp.structureCollection.genomeLength], 5);
                for (int k = 0; k < 4; ++k) {
                    fa[k] = fa[k] / 2.0;
                }
                pw.print(this.drawSequenceLogoSVG("logo_" + (this.structure.startPosition + i), this.nucleotidePositions[i].getX(), this.nucleotidePositions[i].getY() - (double)(this.nucleotideDiameter / 2) + 4.0, this.nucleotideDiameter, this.nucleotideDiameter - 8, fa, bestColor));
                continue;
            }
            if (this.mainapp.nucleotideCompositionType != MainApp.NucleotideCompositionType.FREQUENCY) continue;
            fa = this.mainapp.nucleotideComposition.mappedFrequencyComposition[(this.structure.startPosition + i - 1) % this.mainapp.structureCollection.genomeLength];
            pw.print(this.drawSequenceLogoSVG("logo_" + (this.structure.startPosition + i), this.nucleotidePositions[i].getX(), this.nucleotidePositions[i].getY() - (double)(this.nucleotideDiameter / 2) + 4.0, this.nucleotideDiameter, this.nucleotideDiameter - 8, fa, bestColor));
        }
        pw.println("</g>");
        pw.println("<g>");
        for (i = 0; i < this.nucleotidePositions.length; ++i) {
            int offsetx = 0;
            double side = 1.0;
            String textanchor = "start";
            if (i < length / 2) {
                offsetx = -(this.nucleotideDiameter / 2) - 5;
                side = -1.0;
                textanchor = "end";
            } else {
                offsetx = this.nucleotideDiameter / 2 + 5;
            }
            if (this.nucleotidePositions[i] == null) continue;
            int pos = (this.structure.getStartPosition() + i - 1) % this.mainapp.structureCollection.genomeLength + 1;
            double fontSize = 11.0;
            if (this.mainapp.numbering == 0 || pos % this.mainapp.numbering != 0) continue;
            pw.println("    <text id=\"nucleotide_position_" + pos + "\" x=\"" + ((double)offsetx + this.nucleotidePositions[i].getX()) + "\" y=\"" + (this.nucleotidePositions[i].getY() + fontSize / 2.0) + "\" style=\"font-size:" + fontSize + "px;stroke:none;fill:black\" text-anchor=\"" + textanchor + "\" >");
            pw.println("        <tspan>" + pos + "</tspan>");
            pw.println("    </text>");
            double x1 = this.nucleotidePositions[i].getX() + side * (double)this.nucleotideDiameter / 2.0 - 2.5;
            double y1 = this.nucleotidePositions[i].getY();
            double x2 = this.nucleotidePositions[i].getX() + side * (double)this.nucleotideDiameter / 2.0 + 2.5;
            double y2 = this.nucleotidePositions[i].getY();
            pw.println("    <polyline points=\"" + x1 + " " + y1 + " " + x2 + " " + y2 + "\" style=\"stroke-width:1;stroke:black\"/>");
        }
        pw.println("</g>");
        pw.println("</svg>");
        pw.close();
        return sw.toString();
    }

    public String drawSequenceLogoSVG(String id, double x, double y, double width, double height, double[] h, Color textColor) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        double fontHeight = 100.0;
        double scale = height / fontHeight;
        double base = y;
        for (int i = 0; i < h.length; ++i) {
            double fontHeightScale = h[i];
            String a = "";
            switch (i) {
                case 0: {
                    a = "A";
                    break;
                }
                case 1: {
                    a = "C";
                    break;
                }
                case 2: {
                    a = "G";
                    break;
                }
                case 3: {
                    a = this.mainapp.showDNA ? "T" : "U";
                }
            }
            String b = a.length() > 0 ? a : "X";
            base += fontHeightScale * scale * fontHeight;
            if (b.equals("X") || !(h[i] > 0.0)) continue;
            float xf = (float)x;
            float yf = (float)base;
            xf = (float)((double)xf / scale);
            yf = (float)((double)yf / (fontHeightScale * scale));
            pw.println("    <g transform=\"scale(" + scale + "," + fontHeightScale * scale + ")\">");
            pw.print("        <text x=\"" + xf + "\" y=\"" + yf + "\" id=\"" + id + "_" + i + "\"  style=\"font-size:" + (int)fontHeight + "px;stroke:none;fill:#" + StructureDrawPanel.getHexString(textColor) + ";text-anchor:middle;\">");
            pw.println("            <tspan id=\"base\">" + b + "</tspan>");
            pw.println("</text>");
            pw.println("    </g>");
        }
        return sw.toString();
    }

    public void drawStructureNative(Graphics graphics) {
        int i;
        if (this.structure == null || this.nucleotidePositions == null) {
            return;
        }
        int panelWidth = (int)((this.maxx - this.minx) * this.horizontalScale + this.xoffset * 2.0);
        int panelHeight = (int)((this.maxy - this.miny) * this.verticalScale + 100.0);
        Dimension d = new Dimension((int)((double)panelWidth * this.zoomScale), (int)((double)panelHeight * this.zoomScale));
        this.g = (Graphics2D)graphics;
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.scale(this.zoomScale, this.zoomScale);
        this.g.setColor(Color.white);
        this.g.fillRect(0, 0, panelWidth, panelHeight);
        if (this.mainapp.showBonds) {
            for (int i2 = 0; i2 < this.nucleotidePositions.length; ++i2) {
                int a = i2;
                int b = this.edit.pairedSites[i2] - 1;
                if (i2 + 1 >= this.edit.pairedSites[i2]) continue;
                Line2D.Double bond = new Line2D.Double(this.nucleotidePositions[a], this.nucleotidePositions[b]);
                this.g.setStroke(new BasicStroke(this.bondThickness));
                this.g.setColor(this.bondColor);
                if (this.selectedNuc1 == a && this.selectedNuc2 == b || this.selectedNuc1 == b && this.selectedNuc2 == a) {
                    this.g.setColor(Color.red);
                }
                this.g.draw(bond);
            }
            if (this.selectedNuc1 != -1 && this.selectedNuc2 != -1) {
                Line2D.Double bond = new Line2D.Double(this.nucleotidePositions[this.selectedNuc1], this.nucleotidePositions[this.selectedNuc2]);
                float[] dash = new float[]{10.0f};
                this.g.setStroke(new BasicStroke(this.bondThickness, 0, 0, 10.0f, dash, 0.0f));
                this.g.setColor(Color.red);
                this.g.draw(bond);
            }
        }
        this.g.setColor(Color.black);
        int length = this.structure.length;
        this.covariationInteractions.clear();
        if (this.show2DData && this.mainapp.data2D != null) {
            for (int i3 = this.structure.getStartPosition(); i3 <= this.structure.getEndPosition(); ++i3) {
                for (int j = this.structure.getStartPosition(); j <= this.structure.getEndPosition(); ++j) {
                    int k = i3 - this.structure.getStartPosition();
                    int l = j - this.structure.getStartPosition();
                    if (this.mainapp.maxDistance != -1 && (this.structureDistanceMatrix == null || this.structureDistanceMatrix.getDistance(k, l) > this.mainapp.maxDistance) && (this.structureDistanceMatrix != null || this.mainapp.distanceMatrix.getDistance(i3 - 1, j - 1) > this.mainapp.maxDistance)) continue;
                    Color c = null;
                    double p = this.mainapp.data2D.matrix.get(i3 - 1, j - 1);
                    if (p == this.mainapp.data2D.matrix.emptyValue) {
                        c = null;
                    } else if (!(this.mainapp.useLowerThreshold2D && !(p >= this.mainapp.thresholdMin2D) || this.mainapp.useUpperThreshold2D && !(p <= this.mainapp.thresholdMax2D) || this.mainapp.data2D == null)) {
                        c = this.mainapp.data2D.colorGradientSecondary.getColor((float)this.mainapp.data2D.dataTransform.transform(p));
                    }
                    if (c == null) continue;
                    double x1 = this.nucleotidePositions[k].getX();
                    double y1 = this.nucleotidePositions[k].getY();
                    double x2 = this.nucleotidePositions[l].getX();
                    double y2 = this.nucleotidePositions[l].getY();
                    Shape shape = null;
                    int structureMidpoint = this.structure.getStartPosition() + this.structure.length / 2;
                    if (i3 <= structureMidpoint && j <= structureMidpoint) {
                        double x1p = Math.max(x1 - Math.abs((y1 - y2) / 2.0), 0.0);
                        shape = new QuadCurve2D.Double(x1, y1, x1p, (y1 + y2) / 2.0, x2, y2);
                    } else if (i3 > structureMidpoint && j > structureMidpoint) {
                        double x2p = Math.min(x2 + Math.abs((y1 - y2) / 2.0), (double)panelWidth);
                        shape = new QuadCurve2D.Double(x1, y1, x2p, (y1 + y2) / 2.0, x2, y2);
                    } else {
                        shape = new Line2D.Double(this.nucleotidePositions[k], this.nucleotidePositions[l]);
                    }
                    this.covariationInteractions.add(new Interaction(shape, i3, j));
                    this.g.setColor(c);
                    this.g.setStroke(normalStroke);
                    this.g.draw(shape);
                    this.g.setColor(Color.black);
                    this.g.setStroke(new BasicStroke());
                }
            }
        }
        int[] tetraloop = new int[this.nucleotidePositions.length];
        for (i = 0; i < this.nucleotidePositions.length; ++i) {
            int index;
            int pos = (this.structure.startPosition + i - 1) % this.mainapp.structureCollection.genomeLength;
            Ellipse2D stemNucleotide = this.getCircleCenteredAt(this.nucleotidePositions[i].getX(), this.nucleotidePositions[i].getY(), this.nucleotideDiameter);
            this.g.setColor(Color.white);
            Color nucleotideBackgroundColor = this.mainapp.missingDataColor;
            if (this.oneDimensionalData == 0 && this.mainapp.data1D != null && this.mainapp.data1D.used[pos]) {
                double p = this.mainapp.data1D.data[pos];
                if (!(!this.mainapp.data1D.used[pos] || this.mainapp.useLowerThreshold1D && !(p >= this.mainapp.thresholdMin1D) || this.mainapp.useUpperThreshold1D && !(p <= this.mainapp.thresholdMax1D))) {
                    nucleotideBackgroundColor = this.mainapp.data1D.colorGradientSecondary.getColor(this.mainapp.data1D.dataTransform.transform((float)p));
                } else if (this.mainapp.useLowerThreshold1D && !(p >= this.mainapp.thresholdMin1D) || this.mainapp.useUpperThreshold1D && !(p <= this.mainapp.thresholdMax1D)) {
                    nucleotideBackgroundColor = this.mainapp.filteredDataColor;
                }
                this.g.setColor(nucleotideBackgroundColor);
                this.g.fill(stemNucleotide);
                this.g.setColor(Color.black);
            } else {
                this.g.setColor(nucleotideBackgroundColor);
                this.g.fill(stemNucleotide);
            }
            this.g.setColor(Color.black);
            this.g.draw(stemNucleotide);
            this.g.setStroke(new BasicStroke());
            this.g.setColor(ColorTools.selectBestForegroundColor(nucleotideBackgroundColor, Color.white, Color.black));
            if (this.mainapp.nucleotideComposition == null) continue;
            if (this.mainapp.nucleotideCompositionType == MainApp.NucleotideCompositionType.SHANNON) {
                int k;
                if (pos >= this.mainapp.nucleotideComposition.mappedShannonComposition.length) continue;
                double[] fa = new double[4];
                for (k = 0; k < fa.length; ++k) {
                    fa[k] = this.mainapp.nucleotideComposition.mappedShannonComposition[pos][k];
                    if (!Double.isNaN(fa[k])) continue;
                    fa[k] = 0.0;
                }
                for (k = 0; k < 4; ++k) {
                    fa[k] = fa[k] / 2.0;
                }
                this.drawSequenceLogo(this.g, this.nucleotidePositions[i].getX(), this.nucleotidePositions[i].getY() - (double)(this.nucleotideDiameter / 2) + 0.0, this.nucleotideDiameter, this.nucleotideDiameter - 5, fa);
                this.g.setFont(this.f2);
                continue;
            }
            if (this.mainapp.nucleotideCompositionType != MainApp.NucleotideCompositionType.FREQUENCY || (index = (this.structure.startPosition + i - 1) % this.mainapp.structureCollection.genomeLength) >= this.mainapp.nucleotideComposition.mappedFrequencyComposition.length) continue;
            double[] fa = this.mainapp.nucleotideComposition.mappedFrequencyComposition[index];
            this.drawSequenceLogo(this.g, this.nucleotidePositions[i].getX(), this.nucleotidePositions[i].getY() - (double)(this.nucleotideDiameter / 2) + 0.0, this.nucleotideDiameter, this.nucleotideDiameter - 5, fa);
            this.g.setFont(this.f2);
        }
        for (i = 0; i < this.nucleotidePositions.length; ++i) {
            int offsetx = 0;
            double side = 1.0;
            if (i < length / 2) {
                offsetx = -(this.nucleotideDiameter - 3);
                side = -1.0;
            } else {
                offsetx = this.nucleotideDiameter - 3;
            }
            if (this.nucleotidePositions[i] == null) continue;
            this.g.setColor(Color.black);
            this.g.setFont(this.f2);
            int pos = (this.structure.getStartPosition() + i - 1) % this.mainapp.structureCollection.genomeLength + 1;
            if (this.mainapp.numbering == 0 || pos % this.mainapp.numbering != 0) continue;
            StructureDrawPanel.drawStringCentred(this.g, (double)offsetx + this.nucleotidePositions[i].getX(), this.nucleotidePositions[i].getY() - 2.0, "" + pos);
            this.g.setColor(Color.black);
            this.g.draw(new Line2D.Double(this.nucleotidePositions[i].getX() + side * (double)this.nucleotideDiameter / 2.0 - 2.0, this.nucleotidePositions[i].getY(), this.nucleotidePositions[i].getX() + side * (double)this.nucleotideDiameter / 2.0 + 2.0, this.nucleotidePositions[i].getY()));
        }
    }

    public int drawComplexStructure() {
        if (this.structure == null || this.nucleotidePositions == null) {
            return 0;
        }
        if (this.useNativeDrawType) {
            return 2;
        }
        if (this.structure.length <= 200) {
            this.createStructureSVG();
            return 1;
        }
        return 2;
    }

    public void saveAsSVG(File file) throws IOException {
        BufferedWriter buffer = new BufferedWriter(new FileWriter(file));
        buffer.write(this.drawStructure(true));
        buffer.close();
    }

    public void saveAsEMF(File file) throws IOException {
        File tempFile = new File("temp.svg");
        this.saveAsSVG(tempFile);
        String svgUrl = "file:///" + tempFile.getAbsolutePath();
        SVG2EMF.convert((String)svgUrl, (File)file);
    }

    public void saveAsPNG(File file) {
        int panelWidth = (int)((this.maxx - this.minx) * this.horizontalScale + this.xoffset * 2.0);
        int panelHeight = (int)((this.maxy - this.miny) * this.verticalScale + 100.0);
        Dimension d = new Dimension((int)Math.ceil((double)panelWidth * this.zoomScale), (int)Math.ceil((double)panelHeight * this.zoomScale));
        BufferedImage tempImage = null;
        try {
            tempImage = (BufferedImage)this.createImage(d.width, d.height);
            this.g = (Graphics2D)tempImage.getGraphics();
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g.setColor(Color.white);
            this.g.fillRect(0, 0, (int)((double)panelWidth * this.zoomScale), (int)((double)panelHeight * this.zoomScale));
            if (this.useNativeDrawType) {
                this.drawStructureNative(tempImage.getGraphics());
            } else if (this.diagram != null) {
                this.diagram.render(this.g);
            } else {
                throw new Exception("Diagram could not be saved. Unknown reason.");
            }
            if (tempImage != null) {
                ImageIO.write((RenderedImage)tempImage, "png", file);
            }
        }
        catch (SVGException ex) {
            JOptionPane.showMessageDialog(this.mainapp, ex.getMessage(), "Error", 0);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.mainapp, ex.getMessage(), "Error", 0);
            return;
        }
    }

    public void drawSequenceLogo(Graphics2D g, double x, double y, double width, double height, double[] h) {
        int i;
        double fontHeight = g.getFontMetrics(this.f1).getAscent();
        double base = y;
        double scale = height / fontHeight;
        double sum = 0.0;
        for (int i2 = 0; i2 < 4; ++i2) {
            sum += h[i2];
        }
        Font subtractFont = this.f1.deriveFont(AffineTransform.getScaleInstance(scale * 0.8, (1.0 - sum) * scale));
        base += (double)(g.getFontMetrics(subtractFont).getAscent() / 2);
        for (i = 0; i < h.length; ++i) {
            Font scaledFont = this.f1.deriveFont(AffineTransform.getScaleInstance(scale * 0.8, h[i] * scale));
            String a = "";
            switch (i) {
                case 0: {
                    a = "A";
                    break;
                }
                case 1: {
                    a = "C";
                    break;
                }
                case 2: {
                    a = "G";
                    break;
                }
                case 3: {
                    a = this.mainapp.showDNA ? "T" : "U";
                }
            }
            double fh = g.getFontMetrics(scaledFont).getAscent();
            g.setFont(scaledFont);
            g.drawString(a, (float)(x - g.getFontMetrics().getStringBounds(a, g).getWidth() / 2.0), (float)(base += fh));
        }
        for (i = 0; i < h.length; ++i) {
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int nucY;
        int nucX;
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int panelWidth = (int)((this.maxx - this.minx) * this.horizontalScale + this.xoffset * 2.0);
        int panelHeight = (int)((this.maxy - this.miny) * this.verticalScale + 100.0);
        if (this.repaint) {
            this.repaint = false;
            this.currentDrawType = this.drawComplexStructure();
        }
        if (this.currentDrawType == 1) {
            g.scale(this.zoomScale, this.zoomScale);
            g.setColor(Color.white);
            g.fillRect(0, 0, panelWidth, panelHeight);
            if (this.diagram != null) {
                try {
                    this.diagram.render(g);
                }
                catch (SVGException ex) {
                    Logger.getLogger(StructureDrawPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else if (this.currentDrawType == 2) {
            g.setColor(Color.white);
            g.fillRect(0, 0, (int)((double)panelWidth * this.zoomScale), (int)((double)panelHeight * this.zoomScale));
            this.drawStructureNative(g);
        }
        this.setPreferredSize(new Dimension((int)Math.ceil((double)panelWidth * this.zoomScale), (int)Math.ceil((double)panelHeight * this.zoomScale)));
        this.revalidate();
        if (this.selectedNucleotide != -1) {
            g.setColor(Color.black);
            g.drawOval((int)this.posx - this.nucleotideDiameter / 2, (int)this.posy - this.nucleotideDiameter / 2, this.nucleotideDiameter, this.nucleotideDiameter);
            this.nucleotidePositions[this.selectedNucleotide] = new Point2D.Double(this.posx, this.posy);
        }
        if (this.selectedNucleotideX != -1 || this.selectedNucleotideY != -1) {
            int nucY2;
            g.setColor(Color.blue);
            g.setStroke(new BasicStroke(4.0f));
            int nucX2 = this.selectedNucleotideX - this.structure.startPosition + 1;
            if (nucX2 >= 0 && nucX2 < this.nucleotidePositions.length) {
                g.drawOval((int)this.nucleotidePositions[nucX2].x - this.nucleotideDiameter / 2, (int)this.nucleotidePositions[nucX2].y - this.nucleotideDiameter / 2, this.nucleotideDiameter, this.nucleotideDiameter);
            }
            if ((nucY2 = this.selectedNucleotideY - this.structure.startPosition + 1) >= 0 && nucY2 < this.nucleotidePositions.length) {
                g.drawOval((int)this.nucleotidePositions[nucY2].x - this.nucleotideDiameter / 2, (int)this.nucleotidePositions[nucY2].y - this.nucleotideDiameter / 2, this.nucleotideDiameter, this.nucleotideDiameter);
            }
            g.setColor(Color.black);
            g.setStroke(new BasicStroke());
        }
        for (int i = this.startHighlightPosition; i < this.endHighlightPosition; ++i) {
            g.setColor(Color.orange);
            g.setStroke(new BasicStroke(3.0f));
            int nucX3 = i - this.structure.startPosition;
            if (nucX3 < 0 || nucX3 >= this.nucleotidePositions.length) continue;
            g.drawOval((int)this.nucleotidePositions[nucX3].x - this.nucleotideDiameter / 2, (int)this.nucleotidePositions[nucX3].y - this.nucleotideDiameter / 2, this.nucleotideDiameter, this.nucleotideDiameter);
        }
        g.setColor(Color.red);
        g.setStroke(new BasicStroke(4.0f));
        if (this.selectedNuc1 != -1 && (nucX = this.selectedNuc1) >= 0 && nucX < this.nucleotidePositions.length) {
            g.drawOval((int)this.nucleotidePositions[nucX].x - this.nucleotideDiameter / 2, (int)this.nucleotidePositions[nucX].y - this.nucleotideDiameter / 2, this.nucleotideDiameter, this.nucleotideDiameter);
        }
        if (this.selectedNuc2 != -1 && (nucY = this.selectedNuc2) >= 0 && nucY < this.nucleotidePositions.length) {
            g.drawOval((int)this.nucleotidePositions[nucY].x - this.nucleotideDiameter / 2, (int)this.nucleotidePositions[nucY].y - this.nucleotideDiameter / 2, this.nucleotideDiameter, this.nucleotideDiameter);
        }
        g.setColor(Color.black);
        g.setStroke(new BasicStroke());
    }

    public void setHighlightPosition(int startPosition, int endPosition) {
        this.startHighlightPosition = startPosition;
        this.endHighlightPosition = endPosition;
        this.repaint();
    }

    public static void drawStringCentred(Graphics2D g, double x, double y, String s) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(s, g);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        double x1 = x + (double)(-textWidth / 2);
        double y1 = y + (double)(-textHeight / 2 + fm.getAscent());
        g.drawString(s, (float)x1, (float)y1);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.posx = (double)e.getX() / this.zoomScale;
        this.posy = (double)e.getY() / this.zoomScale;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        String interactionText = "";
        double x = (double)e.getPoint().x / this.zoomScale;
        double y = (double)e.getPoint().y / this.zoomScale;
        if (this.nucleotidePositions != null) {
            int minIndex = -1;
            double minDistance = Double.MAX_VALUE;
            for (int i = 0; i < this.nucleotidePositions.length; ++i) {
                Point2D.Double scaledPoint = new Point2D.Double(x, y);
                double distance = this.nucleotidePositions[i].distance(scaledPoint);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                minIndex = i;
            }
            int nucleotide = -1;
            if (minDistance <= (double)(this.nucleotideDiameter / 2)) {
                nucleotide = minIndex;
            }
            int pos = (this.structure.getStartPosition() + nucleotide - 1) % this.mainapp.structureCollection.genomeLength;
            if (this.mainapp.nucleotideComposition != null && nucleotide != -1) {
                interactionText = interactionText + "Composition (";
                for (int i = 0; i < 4; ++i) {
                    String a = "";
                    switch (i) {
                        case 0: {
                            a = "A";
                            break;
                        }
                        case 1: {
                            a = "C";
                            break;
                        }
                        case 2: {
                            a = "G";
                            break;
                        }
                        case 3: {
                            a = this.mainapp.showDNA ? "T" : "U";
                        }
                    }
                    double perc = this.mainapp.nucleotideComposition.mappedFrequencyComposition[pos][i];
                    interactionText = interactionText + a + " " + this.decimalFormat.format(perc * 100.0) + "%,  ";
                }
                interactionText = interactionText + "[" + this.mainapp.nucleotideComposition.mappedNonGapCount[pos] + "])     ";
            } else {
                interactionText = interactionText + "Composition (none)     ";
            }
            if (this.mainapp.data1D != null && nucleotide != -1) {
                double p = this.mainapp.data1D.data[pos];
                interactionText = interactionText + "1D data (" + (pos + 1) + ", " + DataLegend.formatValue(p, this.mainapp.data1D.dataTransform, 6) + ")     ";
            } else {
                interactionText = interactionText + "1D data (none)     ";
            }
        }
        if (this.mainapp != null) {
            this.mainapp.data2DLabel.setText("");
            int interaction2D = -1;
            for (int i = 0; i < this.covariationInteractions.size(); ++i) {
                int c = 0;
                boolean[] count = new boolean[]{this.covariationInteractions.get((int)i).shape.intersects(x - 2.0, y - 2.0, 4.0, 4.0), this.covariationInteractions.get((int)i).shape.intersects(x + 2.0, y - 2.0, 4.0, 4.0), this.covariationInteractions.get((int)i).shape.intersects(x - 2.0, y + 2.0, 4.0, 4.0), this.covariationInteractions.get((int)i).shape.intersects(x + 2.0, y + 2.0, 4.0, 4.0)};
                for (int k = 0; k < count.length; ++k) {
                    if (!count[k]) continue;
                    ++c;
                }
                if (c > 0) {
                    // empty if block
                }
                if (c < 1 || c > 3) continue;
                interaction2D = i;
            }
            int oldSelectedNucleotideX = this.selectedNucleotideX;
            int oldSelectedNucleotideY = this.selectedNucleotideY;
            this.selectedNucleotideX = -1;
            this.selectedNucleotideY = -1;
            if (interaction2D != -1) {
                Interaction interaction = this.covariationInteractions.get(interaction2D);
                double p = this.mainapp.data2D.matrix.get(interaction.nucleotidei - 1, interaction.nucleotidej - 1);
                interactionText = interactionText + "2D data (" + interaction.nucleotidei + " <-> " + interaction.nucleotidej + ", " + DataLegend.formatValue(p, this.mainapp.data2D.dataTransform, 6) + ")";
                this.selectedNucleotideX = interaction.nucleotidei - 1;
                this.selectedNucleotideY = interaction.nucleotidej - 1;
            } else {
                interactionText = interactionText + "2D data (none)";
            }
            this.mainapp.data2DLabel.setText(interactionText);
            if (oldSelectedNucleotideX != this.selectedNucleotideX || oldSelectedNucleotideY != this.selectedNucleotideY) {
                this.repaint();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.selectedNuc1 != -1 && this.selectedNuc2 != -1) {
            this.selectedNuc1 = -1;
            this.selectedNuc2 = -1;
        }
        int minIndex = -1;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.nucleotidePositions.length; ++i) {
            Point2D.Double scaledPoint = new Point2D.Double((double)e.getPoint().x / this.zoomScale, (double)e.getPoint().y / this.zoomScale);
            double distance = this.nucleotidePositions[i].distance(scaledPoint);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minIndex = i;
        }
        if (minDistance <= (double)(this.nucleotideDiameter / 2)) {
            if (this.selectedNuc1 == minIndex) {
                this.selectedNuc1 = -1;
            } else if (this.selectedNuc2 == minIndex) {
                this.selectedNuc2 = -1;
            } else if (this.selectedNuc1 == -1) {
                this.selectedNuc1 = minIndex;
            } else if (this.selectedNuc2 == -1) {
                this.selectedNuc2 = minIndex;
            }
        } else {
            double minDistanceFromBond = Double.MAX_VALUE;
            int nuc1 = -1;
            int nuc2 = -1;
            for (int i = 0; i < this.nucleotidePositions.length; ++i) {
                Line2D.Double bond;
                double dist;
                int a = i;
                int b = this.edit.pairedSites[i] - 1;
                if (i + 1 >= this.edit.pairedSites[i] || !((dist = (bond = new Line2D.Double(this.nucleotidePositions[a], this.nucleotidePositions[b])).ptLineDist((double)e.getPoint().x / this.zoomScale, (double)e.getPoint().y / this.zoomScale)) < minDistanceFromBond)) continue;
                minDistanceFromBond = dist;
                nuc1 = a;
                nuc2 = b;
            }
            if (minDistanceFromBond != Double.MAX_VALUE && minDistanceFromBond < 3.0) {
                this.selectedNuc1 = nuc1;
                this.selectedNuc2 = nuc2;
            }
        }
        if (SwingUtilities.isLeftMouseButton(e) && this.selectedNuc1 != -1 && this.selectedNuc2 != -1) {
            if (this.edit.isBasePaired(this.selectedNuc1, this.selectedNuc2)) {
                this.disruptBondPopupMenu.show(this, e.getX(), e.getY());
            } else {
                this.createBondPopupMenu.show(this, e.getX(), e.getY());
            }
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            int minIndex = -1;
            double minDistance = Double.MAX_VALUE;
            for (int i = 0; i < this.nucleotidePositions.length; ++i) {
                Point2D.Double scaledPoint = new Point2D.Double((double)e.getPoint().x / this.zoomScale, (double)e.getPoint().y / this.zoomScale);
                double distance = this.nucleotidePositions[i].distance(scaledPoint);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                minIndex = i;
            }
            if (minDistance <= (double)(this.nucleotideDiameter / 2)) {
                this.selectedNucleotide = minIndex;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.popupMenu.show(this, e.getX(), e.getY());
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            this.selectedNucleotide = -1;
            this.redraw();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block17: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block21: {
                                                block20: {
                                                    block19: {
                                                        block18: {
                                                            block16: {
                                                                if (!e.getSource().equals(this.saveAsPNGItem)) break block16;
                                                                String name = "structure";
                                                                MainApp.fileChooserSave.setDialogTitle("Save as PNG");
                                                                MainApp.fileChooserSave.setSelectedFile(new File(MainApp.fileChooserSave.getCurrentDirectory().getPath() + "/" + name + ".png"));
                                                                int returnVal = MainApp.fileChooserSave.showSaveDialog(this);
                                                                if (returnVal == 0) {
                                                                    this.setCursor(Cursor.getPredefinedCursor(3));
                                                                    this.saveAsPNG(MainApp.fileChooserSave.getSelectedFile());
                                                                    this.setCursor(Cursor.getPredefinedCursor(0));
                                                                }
                                                                MainApp.fileChooserSave.setDialogTitle("Open");
                                                                break block17;
                                                            }
                                                            if (!e.getSource().equals(this.saveAsSVGItem)) break block18;
                                                            MainApp.fileChooserSave.setDialogTitle("Save as SVG");
                                                            String name = "structure";
                                                            MainApp.fileChooserSave.setSelectedFile(new File(MainApp.fileChooserSave.getCurrentDirectory().getPath() + "/" + name + ".svg"));
                                                            int returnVal = MainApp.fileChooserSave.showSaveDialog(this);
                                                            if (returnVal == 0) {
                                                                this.setCursor(Cursor.getPredefinedCursor(3));
                                                                try {
                                                                    this.saveAsSVG(MainApp.fileChooserSave.getSelectedFile());
                                                                }
                                                                catch (IOException ex) {
                                                                    Logger.getLogger(StructureDrawPanel.class.getName()).log(Level.SEVERE, null, ex);
                                                                }
                                                                this.setCursor(Cursor.getPredefinedCursor(0));
                                                            }
                                                            MainApp.fileChooserSave.setDialogTitle("Open");
                                                            break block17;
                                                        }
                                                        if (!e.getSource().equals(this.saveAsEMFItem)) break block19;
                                                        MainApp.fileChooserSave.setDialogTitle("Save as EMF");
                                                        String name = "structure";
                                                        MainApp.fileChooserSave.setSelectedFile(new File(MainApp.fileChooserSave.getCurrentDirectory().getPath() + "/" + name + ".emf"));
                                                        int returnVal = MainApp.fileChooserSave.showSaveDialog(this);
                                                        if (returnVal == 0) {
                                                            this.setCursor(Cursor.getPredefinedCursor(3));
                                                            try {
                                                                this.saveAsEMF(MainApp.fileChooserSave.getSelectedFile());
                                                            }
                                                            catch (IOException ex) {
                                                                Logger.getLogger(StructureDrawPanel.class.getName()).log(Level.SEVERE, null, ex);
                                                            }
                                                            this.setCursor(Cursor.getPredefinedCursor(0));
                                                        }
                                                        MainApp.fileChooserSave.setDialogTitle("Open");
                                                        break block17;
                                                    }
                                                    if (!e.getSource().equals(this.dnaMenuItem)) break block20;
                                                    this.mainapp.showDNA = true;
                                                    this.redraw();
                                                    break block17;
                                                }
                                                if (!e.getSource().equals(this.rnaMenuItem)) break block21;
                                                this.mainapp.showDNA = false;
                                                this.redraw();
                                                break block17;
                                            }
                                            if (!e.getSource().equals(this.showBondsItem)) break block22;
                                            this.mainapp.showBonds = this.showBondsItem.isSelected();
                                            this.redraw();
                                            break block17;
                                        }
                                        if (!e.getSource().equals(this.numberNone) && !e.getSource().equals(this.number1) && !e.getSource().equals(this.number5) && !e.getSource().equals(this.number10)) break block23;
                                        if (e.getSource().equals(this.numberNone)) {
                                            this.mainapp.numbering = 0;
                                        }
                                        if (e.getSource().equals(this.number1)) {
                                            this.mainapp.numbering = 1;
                                        }
                                        if (e.getSource().equals(this.number5)) {
                                            this.mainapp.numbering = 5;
                                        }
                                        if (e.getSource().equals(this.number10)) {
                                            this.mainapp.numbering = 10;
                                        }
                                        this.redraw();
                                        break block17;
                                    }
                                    if (!e.getSource().equals(this.disruptBondItem)) break block24;
                                    this.edit.makeSingleStranded(this.selectedNuc1);
                                    this.edit.makeSingleStranded(this.selectedNuc2);
                                    this.selectedNuc1 = -1;
                                    this.selectedNuc2 = -1;
                                    this.repaint();
                                    break block17;
                                }
                                if (!e.getSource().equals(this.disruptBondRedrawItem)) break block25;
                                this.edit.makeSingleStranded(this.selectedNuc1);
                                this.edit.makeSingleStranded(this.selectedNuc2);
                                this.computeStructureToBeDrawn(this.edit.pairedSites);
                                this.selectedNuc1 = -1;
                                this.selectedNuc2 = -1;
                                this.repaint();
                                break block17;
                            }
                            if (!e.getSource().equals(this.createBondItem)) break block26;
                            if (this.edit.canMakeBasePair(this.selectedNuc1, this.selectedNuc2)) {
                                this.edit.makeBasePair(this.selectedNuc1, this.selectedNuc2);
                            } else {
                                JOptionPane.showMessageDialog(this, "This base-pairing is not possible as it does not result in a correct secondary structure.", "Illegal base-pairing", 2);
                            }
                            this.selectedNuc1 = -1;
                            this.selectedNuc2 = -1;
                            this.repaint();
                            break block17;
                        }
                        if (!e.getSource().equals(this.createBondRedrawItem)) break block27;
                        if (this.edit.canMakeBasePair(this.selectedNuc1, this.selectedNuc2)) {
                            this.edit.makeBasePair(this.selectedNuc1, this.selectedNuc2);
                        } else {
                            JOptionPane.showMessageDialog(this, "This base-pairing is not possible as it does not result in a correct secondary structure.", "Illegal base-pairing", 2);
                        }
                        this.computeStructureToBeDrawn(this.edit.pairedSites);
                        this.selectedNuc1 = -1;
                        this.selectedNuc2 = -1;
                        this.repaint();
                        break block17;
                    }
                    if (!e.getSource().equals(this.redrawStructureItem)) break block28;
                    this.computeStructureToBeDrawn(this.edit.pairedSites);
                    this.selectedNuc1 = -1;
                    this.selectedNuc2 = -1;
                    this.repaint();
                    break block17;
                }
                if (!e.getSource().equals(this.resetStructureItem)) break block29;
                int n = JOptionPane.showConfirmDialog(this.mainapp, "This will reset your edits, are you sure you want to continue?", "Warning", 0);
                if (n != 0) break block17;
                this.edit.reset();
                break block17;
            }
            for (int i = 0; i < zoomLevels.length; ++i) {
                if (!e.getSource().equals(this.zoomMenuItems[i])) continue;
                this.currentZoomIndex = i;
                this.zoomScale = (double)zoomLevels[this.currentZoomIndex] / 100.0;
                this.drawComplexStructure();
                break;
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int clicks = e.getWheelRotation();
        double prevZoomScale = this.zoomScale;
        this.zoomScale = clicks < 0 ? Math.min(4.0, this.zoomScale + 0.1 * (double)(-Math.min(clicks, 4))) : Math.max(0.1, this.zoomScale - 0.1 * (double)Math.min(clicks, 4));
        if (prevZoomScale != this.zoomScale) {
            this.customZoomLevelItem.setSelected(true);
            Rectangle visible = this.getVisibleRect();
            double currentCenterX = visible.x + visible.width / 2;
            double currentCenterY = visible.y + visible.height / 2;
            this.drawComplexStructure();
            this.redraw();
            Rectangle newVisible = this.getVisibleRect();
            double newLeftX = currentCenterX - (double)(newVisible.width / 2);
            double newLeftY = currentCenterX - (double)(newVisible.height / 2);
            this.mainapp.substructureScrollPane.getViewport().setViewPosition(new Point((int)newLeftX, (int)newLeftY));
        }
    }

    public Point2D.Double getViewCenter() {
        Rectangle visible = this.getVisibleRect();
        double currentCenterX = visible.x + visible.width / 2;
        double currentCenterY = visible.y + visible.height / 2;
        return new Point2D.Double(currentCenterX, currentCenterY);
    }

    static {
        dash1 = new float[]{7.0f};
        dashedStroke = new BasicStroke(2.0f, 0, 0, 7.0f, dash1, 0.0f);
        normalStroke = new BasicStroke(6.0f);
        zoomLevels = new int[]{25, 50, 75, 100, 125, 150, 175, 200, 250, 300, 400};
    }

    class Interaction {
        Shape shape;
        int nucleotidei;
        int nucleotidej;

        public Interaction(Shape shape, int nucleotidei, int nucleotidej) {
            this.shape = shape;
            this.nucleotidei = nucleotidei;
            this.nucleotidej = nucleotidej;
        }

        public String toString() {
            return this.nucleotidei + " <-> " + this.nucleotidej;
        }
    }
}

