/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import structurevis.ui.MainApp;
import structurevis.ui.datacreation.WizardMain;

public class StartupDialog
extends JDialog {
    MainApp mainapp;
    File lastUsedDataset;
    private JButton createNewDaset;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JTextField jTextField1;
    private JButton openFromFile;
    private JButton openLastUsed;

    public StartupDialog(MainApp mainapp) {
        super((Frame)mainapp, true);
        this.mainapp = mainapp;
        this.initComponents();
        this.lastUsedDataset = mainapp.appPersistence.getLastDatasetUsed();
        if (this.lastUsedDataset != null && !this.lastUsedDataset.isDirectory()) {
            this.lastUsedDataset = this.lastUsedDataset.getParentFile();
        }
        if (this.lastUsedDataset == null || !this.lastUsedDataset.exists()) {
            this.lastUsedDataset = new File(new File("workspace/HIVShapeExample").getPath());
        }
        this.jTextField1.setText(this.lastUsedDataset.getAbsolutePath());
        this.jTextField1.setCaretPosition(this.jTextField1.getText().length());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
    }

    private void initComponents() {
        this.openLastUsed = new JButton();
        this.jTextField1 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.openFromFile = new JButton();
        this.createNewDaset = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Open a dataset");
        this.openLastUsed.setText("Open");
        this.openLastUsed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartupDialog.this.openLastUsedActionPerformed(evt);
            }
        });
        this.jTextField1.setEditable(false);
        this.jLabel1.setText("Open last used");
        this.openFromFile.setText("Open dataset from file");
        this.openFromFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartupDialog.this.openFromFileActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.openFromFile);
        this.createNewDaset.setText("Create a new dataset");
        this.createNewDaset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartupDialog.this.createNewDasetActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.createNewDaset);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextField1, -1, 322, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openLastUsed).addGap(6, 6, 6)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, 463, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.openLastUsed)).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public void startLoad() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.mainapp.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void endLoad() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.mainapp.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void openLastUsedActionPerformed(ActionEvent evt) {
        this.dispose();
        this.startLoad();
        if (this.lastUsedDataset.isDirectory()) {
            this.mainapp.openStructureCollectionFromFolder(this.lastUsedDataset);
        } else {
            this.mainapp.openStructureCollectionFromFile(this.lastUsedDataset);
        }
        this.mainapp.toFront();
        this.endLoad();
    }

    private void openFromFileActionPerformed(ActionEvent evt) {
        this.dispose();
        this.startLoad();
        int returnVal = this.mainapp.openDatasetAction();
        if (returnVal == 0) {
            this.mainapp.toFront();
        }
        this.endLoad();
    }

    private void createNewDasetActionPerformed(ActionEvent evt) {
        new WizardMain().show(this.mainapp);
        this.dispose();
        this.mainapp.toFront();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                StartupDialog dialog = new StartupDialog(null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

