/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RNAFoldingTools {
    public static final double emptyValue = Double.MAX_VALUE;

    public static void main(String[] args) {
        ArrayList<String> sequences = new ArrayList<String>();
        sequences.add("ACT--CC-");
        sequences.add("ACTC-CCG");
        sequences.add("ACTCTCCG");
        System.out.println(RNAFoldingTools.getReferenceSequence(sequences, 9));
        String[] structures = new String[]{"(((..(..))))(..)", "(((..(..))))(..)", "(((..(..))))(..)"};
        double[][] basePairCount = RNAFoldingTools.getBasePairCountMatrix(structures);
        double[] singleBaseCount = RNAFoldingTools.getSingleBaseCount(structures);
        RNAFoldingTools rnaTools = new RNAFoldingTools();
        int[] pairedSites = RNAFoldingTools.getPosteriorDecodingConsensusStructure(basePairCount, singleBaseCount);
        for (int i = 0; i < pairedSites.length; ++i) {
            System.out.println(i + 1 + "\t" + pairedSites[i]);
        }
        System.out.println("Dot bracket structure: " + RNAFoldingTools.getDotBracketStringFromPairedSites(pairedSites));
    }

    public static double[] getSingleBaseProb(double[][] basePairProb) {
        double[] singleBaseProb = new double[basePairProb.length];
        for (int i = 0; i < basePairProb.length; ++i) {
            singleBaseProb[i] = 1.0;
            for (int j = 0; j < basePairProb[0].length; ++j) {
                int n = i;
                singleBaseProb[n] = singleBaseProb[n] - basePairProb[i][j];
            }
        }
        return singleBaseProb;
    }

    public static int[] getPosteriorDecodingConsensusStructure(float[][] basePairProb) {
        return RNAFoldingTools.getPosteriorDecodingConsensusStructure(RNAFoldingTools.getDoubleMatrix(basePairProb));
    }

    public static int[] getPosteriorDecodingConsensusStructure(double[][] basePairProb) {
        double[] singleBaseProb = new double[basePairProb.length];
        for (int i = 0; i < basePairProb.length; ++i) {
            singleBaseProb[i] = 1.0;
            for (int j = 0; j < basePairProb[0].length; ++j) {
                int n = i;
                singleBaseProb[n] = singleBaseProb[n] - basePairProb[i][j];
            }
        }
        return RNAFoldingTools.getPosteriorDecodingConsensusStructure(basePairProb, singleBaseProb);
    }

    public static int[] getPosteriorDecodingConsensusStructure(double[][] basePairProb, double[] singleBaseProb) {
        double[][] eMatrix = new double[basePairProb.length][basePairProb[0].length];
        for (int i = 0; i < eMatrix.length; ++i) {
            for (int j = 0; j < eMatrix.length; ++j) {
                eMatrix[i][j] = Double.MAX_VALUE;
            }
        }
        int[] pairedWith = new int[eMatrix.length];
        int[][] S = new int[basePairProb.length][basePairProb[0].length];
        RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, S, 0, eMatrix.length - 1);
        RNAFoldingTools.writeMatrix(S, new File("e.matrix"));
        RNAFoldingTools.writeMatrix(S, new File("s.matrix"));
        RNAFoldingTools.traceBack(S, 0, eMatrix.length - 1, pairedWith);
        return pairedWith;
    }

    public MultiThreadedPosteriorDecoding performPosteriorDecodingMultiThreaded(double[][] basePairProb, double[] singleBaseProb) {
        MultiThreadedPosteriorDecoding m = new MultiThreadedPosteriorDecoding(basePairProb, singleBaseProb);
        return m;
    }

    public MultiThreadedPosteriorDecoding performPosteriorDecodingMultiThreaded(double[][] basePairProb) {
        double[] singleBaseProb = new double[basePairProb.length];
        for (int i = 0; i < basePairProb.length; ++i) {
            singleBaseProb[i] = 1.0;
            for (int j = 0; j < basePairProb[0].length; ++j) {
                int n = i;
                singleBaseProb[n] = singleBaseProb[n] - basePairProb[i][j];
            }
        }
        return new MultiThreadedPosteriorDecoding(basePairProb, singleBaseProb);
    }

    public int[] getPosteriorDecodingConsensusStructureMultiThreaded(double[][] basePairProb, double[] singleBaseProb) {
        return this.performPosteriorDecodingMultiThreaded((double[][])basePairProb, (double[])singleBaseProb).pairedWith;
    }

    public int[] getPosteriorDecodingConsensusStructureMultiThreaded(float[][] basePairProb) {
        return this.getPosteriorDecodingConsensusStructureMultiThreaded(RNAFoldingTools.getDoubleMatrix(basePairProb));
    }

    public int[] getPosteriorDecodingConsensusStructureMultiThreaded(double[][] basePairProb) {
        return this.performPosteriorDecodingMultiThreaded((double[][])basePairProb).pairedWith;
    }

    private static double recursePosteriorDecoding(double[][] basePairProb, double[] singleBaseProb, double[][] eMatrix, int i, int j, int[] pairedWith) {
        if (i > j) {
            return 0.0;
        }
        if (eMatrix[i][j] != Double.MAX_VALUE) {
            return eMatrix[i][j];
        }
        if (i == j) {
            eMatrix[i][j] = singleBaseProb[i];
            return eMatrix[i][j];
        }
        double u1 = RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, i + 1, j, pairedWith) + singleBaseProb[i];
        double p1 = RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, i + 1, j - 1, pairedWith) + basePairProb[i][j];
        double u2 = RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, i, j - 1, pairedWith) + singleBaseProb[j];
        double p2 = 0.0;
        for (int k = i; k < j; ++k) {
            p2 = Math.max(p2, RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, i, k, pairedWith) + RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, k + 1, j, pairedWith));
        }
        eMatrix[i][j] = Math.max(u1, Math.max(p1, Math.max(u2, p2)));
        if (p1 > u1 && p1 > u2 && p1 > p2 && pairedWith != null) {
            pairedWith[i] = j + 1;
            pairedWith[j] = i + 1;
            System.out.println("B" + i + "\t" + j);
        }
        return eMatrix[i][j];
    }

    private static double recursePosteriorDecoding(double[][] basePairProb, double[] singleBaseProb, double[][] eMatrix, int[][] S, int i, int j) {
        if (i > j) {
            return 0.0;
        }
        if (eMatrix[i][j] != Double.MAX_VALUE) {
            return eMatrix[i][j];
        }
        if (i == j) {
            eMatrix[i][j] = singleBaseProb[i];
            return eMatrix[i][j];
        }
        double u1 = RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, S, i + 1, j) + singleBaseProb[i];
        double p1 = RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, S, i + 1, j - 1) + 2.0 * basePairProb[i][j];
        double u2 = RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, S, i, j - 1) + singleBaseProb[j];
        double p2 = 0.0;
        int max_k = i;
        for (int k = i; k < j; ++k) {
            double p2k = RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, S, i, k) + RNAFoldingTools.recursePosteriorDecoding(basePairProb, singleBaseProb, eMatrix, S, k + 1, j);
            if (!(p2k > p2)) continue;
            p2 = p2k;
            max_k = k;
        }
        double max = 0.0;
        if (u1 > p1 && u1 > p2 && u1 > u2) {
            max = u1;
            S[i][j] = -1;
        } else if (u2 > p1 && u2 > p2) {
            max = u2;
            S[i][j] = -2;
        } else if (p1 > p2) {
            max = p1;
            S[i][j] = -3;
        } else {
            max = p2;
            S[i][j] = max_k;
        }
        eMatrix[i][j] = max;
        return eMatrix[i][j];
    }

    public static void traceBack(int[][] S, int i, int j, int[] pairedWith) {
        if (i < j) {
            if (S[i][j] == -3) {
                pairedWith[i] = j + 1;
                pairedWith[j] = i + 1;
                RNAFoldingTools.traceBack(S, i + 1, j - 1, pairedWith);
            } else {
                RNAFoldingTools.traceBack(S, i, S[i][j], pairedWith);
                RNAFoldingTools.traceBack(S, S[i][j] + 1, j, pairedWith);
            }
        }
    }

    public static double[] getSingleBaseCount(String[] dotBracketStructures) {
        double[] singleBaseCount = new double[dotBracketStructures[0].length()];
        for (int i = 0; i < dotBracketStructures.length; ++i) {
            String structure = dotBracketStructures[i];
            for (int j = 0; j < structure.length(); ++j) {
                if (structure.charAt(j) != '.') continue;
                int n = j;
                singleBaseCount[n] = singleBaseCount[n] + 1.0;
            }
        }
        return singleBaseCount;
    }

    public static double[][] getBasePairCountMatrix(String[] dotBracketStructures) {
        double[][] basePairMatrix = new double[dotBracketStructures[0].length()][dotBracketStructures[0].length()];
        for (int i = 0; i < dotBracketStructures.length; ++i) {
            Stack<Integer> stack = new Stack<Integer>();
            String structure = dotBracketStructures[i];
            for (int j = 0; j < structure.length(); ++j) {
                if (structure.charAt(j) == '(') {
                    stack.push(j);
                    continue;
                }
                if (structure.charAt(j) != ')') continue;
                int x = (Integer)stack.pop();
                int y = j;
                double[] dArray = basePairMatrix[x];
                int n = y;
                dArray[n] = dArray[n] + 1.0;
                double[] dArray2 = basePairMatrix[y];
                int n2 = x;
                dArray2[n2] = dArray2[n2] + 1.0;
            }
        }
        return basePairMatrix;
    }

    public static void printMatrix(double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                System.out.print(RNAFoldingTools.pad(matrix[i][j] + "", 4) + "  ");
            }
            System.out.println();
        }
    }

    public static void writeMatrix(double[][] matrix, File file) {
        DecimalFormat df = new DecimalFormat("0.0000E0");
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < matrix.length; ++i) {
                for (int j = 0; j < matrix[0].length; ++j) {
                    buffer.write(RNAFoldingTools.pad(df.format(matrix[i][j]) + "", 10) + "  ");
                }
                buffer.newLine();
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void writeMatrix(int[][] matrix, File file) {
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < matrix.length; ++i) {
                for (int j = 0; j < matrix[0].length; ++j) {
                    buffer.write(RNAFoldingTools.pad(matrix[i][j] + "", 4) + "  ");
                }
                buffer.newLine();
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String pad(String s, int length) {
        String ret = s;
        for (int i = s.length(); i < length; ++i) {
            ret = ret + " ";
        }
        return ret.substring(0, length);
    }

    public void test() {
        int repeats = 100;
        int size = 25;
        while (true) {
            System.out.println("-------------------------------------------------------------");
            size += 25;
            String s = "((";
            for (int i = 0; i < size; ++i) {
                s = s + ".";
            }
            s = s + "))";
            String[] structures = new String[]{s};
            double[][] basePairCount = RNAFoldingTools.getBasePairCountMatrix(structures);
            double[] singleBaseCount = RNAFoldingTools.getSingleBaseCount(structures);
            long startTime1 = System.currentTimeMillis();
            int divisionSize = 0;
            for (int i = 0; i < repeats; ++i) {
                MultiThreadedPosteriorDecoding m = new MultiThreadedPosteriorDecoding(basePairCount, singleBaseCount);
                m.compute();
                divisionSize = m.divisionSize;
            }
            long endTime1 = System.currentTimeMillis();
            long elapsed1 = endTime1 - startTime1;
            long startTime2 = System.currentTimeMillis();
            for (int i = 0; i < repeats; ++i) {
                RNAFoldingTools.getPosteriorDecodingConsensusStructure(basePairCount, singleBaseCount);
            }
            long endTime2 = System.currentTimeMillis();
            long elapsed2 = endTime2 - startTime2;
            double rate1 = (double)repeats / (double)elapsed1;
            double rate2 = (double)repeats / (double)elapsed2;
            double ratio = rate1 / rate2;
            System.out.println(size + 4 + "\t" + elapsed1 + "\t" + elapsed2 + "\t" + divisionSize + "\t" + rate1 + "\t" + rate2 + "\t" + ratio);
            if (elapsed2 <= 5000L) continue;
            repeats = Math.max(1, repeats / 2);
        }
    }

    public static String getDotBracketStringFromPairedSites(int[] pairedSites) {
        String dbs = "";
        for (int i = 0; i < pairedSites.length; ++i) {
            dbs = pairedSites[i] == 0 ? dbs + "." : (pairedSites[i] > i + 1 ? dbs + "(" : dbs + ")");
        }
        return dbs;
    }

    public static int[] getPairedSitesFromDotBracketString(String dotBracketStructure) {
        int[] pairedSites = new int[dotBracketStructure.length()];
        Stack<Integer> stack = new Stack<Integer>();
        for (int j = 0; j < dotBracketStructure.length(); ++j) {
            if (dotBracketStructure.charAt(j) == '(') {
                stack.push(j);
                continue;
            }
            if (dotBracketStructure.charAt(j) != ')') continue;
            int x = (Integer)stack.pop();
            int y = j;
            pairedSites[x] = y + 1;
            pairedSites[y] = x + 1;
        }
        return pairedSites;
    }

    public static int[] getPairedSitesFromDotBracketString(String dotBracketStructure, char openBracket, char closeBracket) {
        int[] pairedSites = new int[dotBracketStructure.length()];
        Stack<Integer> stack = new Stack<Integer>();
        for (int j = 0; j < dotBracketStructure.length(); ++j) {
            if (dotBracketStructure.charAt(j) == openBracket) {
                stack.push(j);
                continue;
            }
            if (dotBracketStructure.charAt(j) != closeBracket || stack.empty()) continue;
            int x = (Integer)stack.pop();
            int y = j;
            pairedSites[x] = y + 1;
            pairedSites[y] = x + 1;
        }
        return pairedSites;
    }

    public static String getReferenceSequence(ArrayList<String> sequences, int refLength) {
        int i;
        int length = 0;
        for (int i2 = 0; i2 < sequences.size(); ++i2) {
            length = Math.max(length, sequences.get(i2).length());
        }
        int[] counts = new int[length];
        int maxCount = 0;
        boolean[] countUsed = new boolean[length];
        for (int i3 = 0; i3 < sequences.size(); ++i3) {
            String seq = sequences.get(i3);
            for (int j = 0; j < seq.length(); ++j) {
                if (seq.charAt(j) == '-') continue;
                int n = j;
                counts[n] = counts[n] + 1;
                maxCount = Math.max(maxCount, counts[j]);
            }
        }
        String referenceString = "";
        int n = 0;
        for (int k = maxCount; k >= 0; --k) {
            for (i = 0; i < counts.length; ++i) {
                if (!countUsed[i] && counts[i] == k) {
                    countUsed[i] = true;
                    ++n;
                }
                if (n == refLength) break;
            }
            if (n == refLength) break;
        }
        String ref = "";
        for (i = 0; i < countUsed.length; ++i) {
            ref = countUsed[i] ? ref + "N" : ref + "-";
        }
        while (ref.length() < refLength) {
            ref = ref + "X";
        }
        return ref;
    }

    public static String getDotBracketStringFromCtFile(File ctFile) {
        return RNAFoldingTools.getDotBracketStringFromPairedSites(RNAFoldingTools.getPairedSitesFromCtFile(ctFile));
    }

    public static String getSequenceByName(String seqName, ArrayList<String> sequences, ArrayList<String> sequenceNames) {
        for (int i = 0; i < sequences.size(); ++i) {
            if (!sequenceNames.get(i).equals(seqName)) continue;
            return sequences.get(i);
        }
        System.err.println("Could not find ref seq: " + seqName);
        return sequences.get(0);
    }

    public static int[] getPairedSitesFromCtFile(File ctFile) {
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(ctFile));
            String textline = null;
            int[] pairedSites = null;
            while ((textline = buffer.readLine()) != null) {
                String[] split = textline.trim().split("(\\s)+");
                int length = Integer.parseInt(split[0]);
                pairedSites = new int[length];
                for (int i = 0; i < length && (textline = buffer.readLine()) != null; ++i) {
                    String[] split2 = textline.trim().split("(\\s)+");
                    pairedSites[Integer.parseInt((String)split2[0]) - 1] = Integer.parseInt(split2[4]);
                }
            }
            buffer.close();
            return pairedSites;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int[] getPairedSitesFromDBNStringFile(File dbnFile) {
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(dbnFile));
            String textline = buffer.readLine();
            buffer.close();
            System.out.println(textline);
            return RNAFoldingTools.getPairedSitesFromDotBracketString(textline);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static double[][] loadMatrix(File bpFile) {
        double[][] bpMatrix = null;
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(bpFile));
            String textline = buffer.readLine();
            int length = textline.split("(\\s)+").length;
            bpMatrix = new double[length][length];
            for (int i = 0; i < length; ++i) {
                String[] split = textline.split("(\\s)+");
                for (int j = 0; j < length; ++j) {
                    bpMatrix[i][j] = Double.parseDouble(split[j]);
                }
                textline = buffer.readLine();
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return bpMatrix;
    }

    public static double[][] getDoubleMatrix(float[][] matrix) {
        double[][] doubleMatrix = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                doubleMatrix[i][j] = matrix[i][j];
            }
        }
        return doubleMatrix;
    }

    public static float[][] getFloatMatrix(double[][] matrix) {
        float[][] floatMatrix = new float[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                floatMatrix[i][j] = (float)matrix[i][j];
            }
        }
        return floatMatrix;
    }

    public static void loadFastaSequences(File file, ArrayList<String> sequences, ArrayList<String> sequenceNames) {
        RNAFoldingTools.loadFastaSequences(file, sequences, sequenceNames, Integer.MAX_VALUE);
    }

    public static void loadFastaSequences(File file, ArrayList<String> sequences, ArrayList<String> sequenceNames, int max) {
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(file));
            String textline = null;
            String sequence = "";
            int n = 0;
            boolean maxReached = false;
            while (!((textline = buffer.readLine()) == null || maxReached && textline.startsWith(">"))) {
                if (textline.startsWith(">")) {
                    if (++n >= max) {
                        maxReached = true;
                    }
                    sequenceNames.add(textline.substring(1));
                    if (sequence.equals("")) continue;
                    sequences.add(sequence.toUpperCase());
                    sequence = "";
                    continue;
                }
                sequence = sequence + textline.trim();
            }
            buffer.close();
            if (!sequence.equals("")) {
                sequences.add(sequence);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static double calculatePPfoldReliabilityScore(int[] pairedSites, double[][] basePairProb) {
        double[] singleBaseProb = RNAFoldingTools.getSingleBaseProb(basePairProb);
        double ppfoldReliablityScore = 0.0;
        for (int i = 0; i < pairedSites.length; ++i) {
            if (pairedSites[i] == 0) {
                ppfoldReliablityScore += singleBaseProb[i];
                continue;
            }
            ppfoldReliablityScore += basePairProb[i][pairedSites[i] - 1];
        }
        return ppfoldReliablityScore / (double)pairedSites.length;
    }

    public static double calculatePairsOnlyReliabilityScore(int[] pairedSites, double[][] basePairProb) {
        double ppfoldReliablityScore = 0.0;
        double pairs = 0.0;
        for (int i = 0; i < pairedSites.length; ++i) {
            if (pairedSites[i] == 0) continue;
            ppfoldReliablityScore += basePairProb[i][pairedSites[i] - 1];
            pairs += 1.0;
        }
        if (pairs == 0.0) {
            return 1.0;
        }
        return ppfoldReliablityScore / pairs;
    }

    public static double calculatePairsOnlyReliabilityScore(int[] pairedSites, double[][] basePairProb, ArrayList<Double> weights) {
        double ppfoldReliablityScore = 0.0;
        double pairs = 0.0;
        double weightSum = 0.0;
        for (int i = 0; i < pairedSites.length; ++i) {
            if (pairedSites[i] == 0) continue;
            double weighting = weights.get(i) * weights.get(pairedSites[i] - 1);
            ppfoldReliablityScore += basePairProb[i][pairedSites[i] - 1] * weighting;
            weightSum += weighting;
            pairs += 1.0;
        }
        if (pairs == 0.0) {
            return 1.0;
        }
        return ppfoldReliablityScore / pairs;
    }

    public static void writeToFile(File f, String s, boolean append) {
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(f, append));
            buffer.write(s + "\n");
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void saveCtFile(File outFile, int[] pairedSites, String header, String sequence) {
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(outFile));
            buffer.write(header + "\n");
            for (int i = 0; i < pairedSites.length; ++i) {
                buffer.write(i + 1 + sequence.charAt(i) + "\t" + i + "\t" + (i + 2) + "\t" + pairedSites[i] + "\t" + (i + 1) + "\n");
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void saveDotBracketFile(File outFile, int[] pairedSites, String header, String sequence) {
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(outFile));
            buffer.write(">" + header + "\n");
            buffer.write(sequence + "\n");
            buffer.write(RNAFoldingTools.getDotBracketStringFromPairedSites(pairedSites) + "\n");
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isRNAalignment(ArrayList<String> sequences) {
        double countRNA = 0.0;
        double countNonRNA = 0.0;
        for (int i = 0; i < sequences.size(); ++i) {
            String s = sequences.get(i).toUpperCase();
            block9: for (int j = 0; j < s.length(); ++j) {
                switch (s.charAt(j)) {
                    case 'A': {
                        countRNA += 1.0;
                        continue block9;
                    }
                    case 'C': {
                        countRNA += 1.0;
                        continue block9;
                    }
                    case 'G': {
                        countRNA += 1.0;
                        continue block9;
                    }
                    case 'T': {
                        countRNA += 1.0;
                        continue block9;
                    }
                    case 'U': {
                        countRNA += 1.0;
                        continue block9;
                    }
                    case '-': {
                        continue block9;
                    }
                    default: {
                        countNonRNA += 1.0;
                    }
                }
            }
        }
        double ratio = countRNA / countNonRNA;
        return ratio > 0.5;
    }

    public class MultiThreadedPosteriorDecoding {
        double[][] basePairProb;
        double[] singleBaseProb;
        int[] pairedWith;
        final Integer lock = new Integer(0);
        final Integer waitLock = new Integer(0);
        int maxThreads = Runtime.getRuntime().availableProcessors();
        int threadsUsed = 0;
        int currentBlockY = 0;
        int currentX = 0;
        int currentY = 0;
        int length;
        int startingDivisionSize;
        int divisionSize;
        int blockIncrement;
        double[][] eMatrix;
        int[][] S;

        public MultiThreadedPosteriorDecoding(double[][] basePairCount, double[] singleBaseCount) {
            this.length = singleBaseCount.length;
            this.pairedWith = new int[this.length];
            this.basePairProb = basePairCount;
            this.singleBaseProb = singleBaseCount;
            this.blockIncrement = this.divisionSize = Math.max(this.length / this.maxThreads, 10);
            this.startingDivisionSize = this.divisionSize;
            this.eMatrix = new double[this.length][this.length];
            for (int i = 0; i < this.eMatrix.length; ++i) {
                for (int j = 0; j < this.eMatrix.length; ++j) {
                    this.eMatrix[i][j] = Double.MAX_VALUE;
                }
            }
            this.S = new int[this.length][this.length];
            this.compute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double compute() {
            try {
                Integer n = this.waitLock;
                synchronized (n) {
                    for (int i = 0; i < this.maxThreads; ++i) {
                        this.computeNextSection();
                    }
                    this.waitLock.wait();
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(RNAFoldingTools.class.getName()).log(Level.SEVERE, null, ex);
            }
            RNAFoldingTools.recursePosteriorDecoding(this.basePairProb, this.singleBaseProb, this.eMatrix, 0, this.eMatrix.length - 1, this.pairedWith);
            RNAFoldingTools.traceBack(this.S, 0, this.eMatrix.length - 1, this.pairedWith);
            return this.eMatrix[0][this.eMatrix.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeNextSection() {
            Integer n = this.lock;
            synchronized (n) {
                Pair p = this.getNextSection();
                if (p.x != -1) {
                    new PosteriorDecodingThread(p.x, p.y).start();
                }
            }
        }

        public Pair getNextSection() {
            Pair p = this.getNextSectionRecursive();
            if (p.x == -1) {
                return p;
            }
            return new Pair(Math.min(p.x, this.length - 1), Math.min(p.y, this.length - 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Pair getNextSectionRecursive() {
            int newX = this.currentX;
            int newY = this.currentY;
            Integer n = this.lock;
            synchronized (n) {
                if (newX == -1 && newY == -1) {
                    return new Pair(-1, -1);
                }
                if (newX == 0 && newY == 0) {
                    newX = 0;
                    newY = this.divisionSize;
                } else {
                    newX += this.divisionSize;
                    newY += this.divisionSize;
                    if (this.currentBlockY >= this.length) {
                        newX = -1;
                        newY = -1;
                    } else if (newX >= this.length) {
                        this.currentBlockY += this.blockIncrement;
                        this.divisionSize = (int)Math.max((double)(this.length - this.currentBlockY) / (double)this.maxThreads, 10.0);
                        newX = 0;
                        newY = this.currentBlockY + this.divisionSize;
                    }
                }
            }
            this.currentX = newX;
            this.currentY = newY;
            if (newY - this.divisionSize > this.length) {
                return this.getNextSection();
            }
            return new Pair(newX, newY);
        }

        class PosteriorDecodingThread
        extends Thread {
            int x;
            int y;

            public PosteriorDecodingThread(int x, int y) {
                this.x = x;
                this.y = y;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RNAFoldingTools.recursePosteriorDecoding(MultiThreadedPosteriorDecoding.this.basePairProb, MultiThreadedPosteriorDecoding.this.singleBaseProb, MultiThreadedPosteriorDecoding.this.eMatrix, MultiThreadedPosteriorDecoding.this.S, this.x, this.y);
                MultiThreadedPosteriorDecoding.this.computeNextSection();
                if (this.x == 0 && this.y == MultiThreadedPosteriorDecoding.this.length - 1) {
                    Integer n = MultiThreadedPosteriorDecoding.this.waitLock;
                    synchronized (n) {
                        MultiThreadedPosteriorDecoding.this.waitLock.notify();
                    }
                }
            }
        }
    }

    static class Pair {
        int x;
        int y;

        public Pair(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }
}

