/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import structurevis.structures.StructureParser;
import structurevis.ui.DistanceMatrix;
import structurevis.ui.FullGenomeDrawPanel;
import structurevis.ui.MainApp;

public class ProgressDialog
extends JDialog {
    MainApp mainapp;
    File collectionFolder;
    int binSize = 5;
    int radius = 1000;
    int maxSubstructureSize = 200;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public ProgressDialog(MainApp mainapp) {
        super((Frame)mainapp, false);
        this.mainapp = mainapp;
        this.collectionFolder = mainapp.collectionFolder;
        this.initComponents();
        this.setDefaultCloseOperation(0);
        this.setTitle("Initializing dataset for the first use...");
        this.jProgressBar1.setIndeterminate(true);
        new ProgressThread().start();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        this.setModal(true);
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.setDefaultCloseOperation(0);
        this.setTitle("Initializing...");
        this.setResizable(false);
        this.jScrollPane1.setBorder(null);
        this.jTextPane1.setBorder(null);
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setFont(new Font("Arial", 0, 12));
        this.jTextPane1.setText("DOOSS is generating graphical coordinates and interaction distances for structures in this dataset. This may take a few minutes, but only needs to be done the first time a dataset is opened.");
        this.jTextPane1.setOpaque(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 379, Short.MAX_VALUE).addComponent(this.jProgressBar1, GroupLayout.Alignment.TRAILING, -1, 379, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 60, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, 19, -2).addGap(11, 11, 11)));
        this.pack();
    }

    class ProgressThread
    extends Thread {
        ProgressThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!DistanceMatrix.getCacheFile(ProgressDialog.this.collectionFolder).exists() || !FullGenomeDrawPanel.getCacheFile(ProgressDialog.this.collectionFolder, ProgressDialog.this.maxSubstructureSize).exists()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ProgressDialog.this.setVisible(true);
                        }
                    }).start();
                }
                ProgressDialog.this.mainapp.distanceMatrix = DistanceMatrix.load(ProgressDialog.this.collectionFolder);
                if (ProgressDialog.this.mainapp.distanceMatrix == null) {
                    int bestBinSize = DistanceMatrix.getBestBinSize(ProgressDialog.this.mainapp.structureCollection.dotBracketStructure.length(), 1000);
                    ProgressDialog.this.mainapp.distanceMatrix = new DistanceMatrix(bestBinSize, ProgressDialog.this.radius, StructureParser.getPairedNucleotidePositions(ProgressDialog.this.mainapp.structureCollection.dotBracketStructure));
                    ProgressDialog.this.mainapp.distanceMatrix.computeFloydWarshall();
                    ProgressDialog.this.mainapp.distanceMatrix.cache(ProgressDialog.this.collectionFolder);
                }
                ProgressDialog.this.mainapp.genomePanel1.initialise(ProgressDialog.this.mainapp, ProgressDialog.this.maxSubstructureSize);
            }
            catch (Exception ex) {
                System.err.println("An error occured: " + ex.getMessage());
            }
            finally {
                ProgressDialog.this.setModal(false);
                ProgressDialog.this.setVisible(false);
                ProgressDialog.this.dispose();
            }
        }
    }
}

