/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import structurevis.data.IO;
import structurevis.data.Mapping;
import structurevis.structures.Structure;
import structurevis.structures.StructureCollection;
import structurevis.structures.io.StructureCollectionStAXReader;
import structurevis.structures.metadata.Metadata;
import structurevis.structures.metadata.MetadataFromFile;
import structurevis.structures.metadata.NucleotideComposition;
import structurevis.structures.metadata.SequenceData1D;
import structurevis.structures.metadata.SequenceData2D;
import structurevis.ui.AboutDialog;
import structurevis.ui.ApplicationPersistence;
import structurevis.ui.DataLegend;
import structurevis.ui.DistanceMatrix;
import structurevis.ui.FullGenomeDrawPanel;
import structurevis.ui.HelpDialog;
import structurevis.ui.ProgressDialog;
import structurevis.ui.ProjectFileFilter;
import structurevis.ui.ProjectFileView;
import structurevis.ui.RNAFoldingTools;
import structurevis.ui.StartupDialog;
import structurevis.ui.StructureDrawPanel;
import structurevis.ui.analyses.RankingPanel;
import structurevis.ui.analyses.SearchPanel;
import structurevis.ui.datacreation.WizardMain;
import structurevis.ui.layerpanel.GenomeLayer;
import structurevis.ui.layerpanel.GraphLayer;
import structurevis.ui.layerpanel.LayerPanel;

public class MainApp
extends JFrame
implements AdjustmentListener,
ChangeListener,
ListSelectionListener,
WindowListener {
    public static File persistenceFile = new File(System.getProperty("user.dir") + File.separatorChar + "app.persistence");
    public static File defaultWorkspace = new File(System.getProperty("user.dir") + File.separatorChar + "workspace" + File.separatorChar);
    public ImageIcon appIcon = new ImageIcon(this.getClass().getResource("/structurevis/resources/sv_icon.png"));
    public static JFileChooser fileChooserOpen = new JFileChooser();
    public static JFileChooser projectChooserOpen = new JFileChooser();
    public static JFileChooser fileChooserSave = new JFileChooser();
    public StructureDrawPanel drawPanel1;
    FullGenomeDrawPanel genomePanel1;
    JList directoryStructureList = new JList();
    JList parentStructureList = new JList();
    JList childStructureList = new JList();
    ArrayList<StructureListObject> directoryStructureFiles = new ArrayList();
    File[] files = new File[0];
    LayerPanel layerPanel1;
    GenomeLayer genomeLayer;
    GraphLayer graphLayer1D;
    public File collectionFolder = null;
    public StructureCollection structureCollection = null;
    ApplicationPersistence appPersistence = new ApplicationPersistence(persistenceFile);
    DataLegend dataLegend1D = null;
    DataLegend dataLegend2D = null;
    NucleotideComposition nucleotideComposition = null;
    NucleotideCompositionType nucleotideCompositionType = NucleotideCompositionType.FREQUENCY;
    boolean showDNA = true;
    boolean showBonds = true;
    int numbering = 5;
    Color filteredDataColor = Color.darkGray;
    Color missingDataColor = Color.lightGray;
    SequenceData1D data1D = null;
    SequenceData2D data2D = null;
    double thresholdMin1D = Double.MIN_VALUE;
    double thresholdMax1D = Double.MAX_VALUE;
    double thresholdMin2D = Double.MIN_VALUE;
    double thresholdMax2D = Double.MAX_VALUE;
    boolean useUpperThreshold1D = false;
    boolean useLowerThreshold1D = false;
    boolean useUpperThreshold2D = false;
    boolean useLowerThreshold2D = false;
    int maxDistance = -1;
    int selected = 0;
    DistanceMatrix distanceMatrix;
    double[] oneDimensionalSlidingData;
    int windowSize = 11;
    boolean setGenomePanelVerticalPos = true;
    boolean next = false;
    JFrame rankingFrame = null;
    RankingPanel rankingPanel = null;
    Desktop desktop = null;
    JFrame searchFrame = null;
    SearchPanel searchPanel = null;
    private JMenuItem aboutMenuItem;
    private JPanel bottomPanel;
    private JScrollPane childListScrollPane;
    private JMenuItem createDatasetItem;
    public JLabel data2DLabel;
    private JScrollPane directoryListScrollPane;
    private JLabel distanceLabel2D;
    private JSlider distanceSlider;
    private JMenuItem exitItem;
    private JMenuItem exportDatasetItem;
    private JScrollPane genomeScrollPane;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    public JScrollPane jScrollPane1;
    private JPanel leftPanel;
    private JPanel leftPanelCenterPanel;
    private JPanel legendPanel;
    private JLabel limitLabel;
    private JPanel mainPanel;
    private JTabbedPane mainTabbedPane;
    private JButton nextButton;
    private JComboBox nucleotideCompositionBox;
    private ButtonGroup nucleotideCompositionGroup;
    private JComboBox oneDimensionalDataBox;
    private JMenuItem openDatasetItem;
    private JScrollPane parentListScrollPane;
    private JButton previousButton;
    private JMenuItem rankingMenuItem;
    private JPanel rightPanel;
    private JMenuItem sequenceSearchItem;
    private JTextPane structureTextPane;
    public JScrollPane substructureScrollPane;
    private JComboBox twoDimensionalDataBox;
    private JRadioButton unbiasedFrequencyRadioButton;
    private JRadioButton unbiasedShannonRadioButton;
    private JSplitPane verticalSplitPane;

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.structureCollection != null) {
            this.appPersistence.setLastDatasetUsed(this.structureCollection.file);
        }
        this.appPersistence.save(persistenceFile);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public MainApp() {
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (splash == null) {
            return;
        }
        this.initComponents();
        this.drawPanel1 = new StructureDrawPanel();
        this.genomePanel1 = new FullGenomeDrawPanel();
        if (!defaultWorkspace.exists()) {
            defaultWorkspace.mkdir();
        }
        SwingUtilities.updateComponentTreeUI(projectChooserOpen);
        projectChooserOpen.setFileView(new ProjectFileView());
        projectChooserOpen.setFileSelectionMode(1);
        projectChooserOpen.addChoosableFileFilter(new ProjectFileFilter());
        projectChooserOpen.setAcceptAllFileFilterUsed(false);
        projectChooserOpen.setApproveButtonText("Open project");
        SwingUtilities.updateComponentTreeUI(fileChooserOpen);
        SwingUtilities.updateComponentTreeUI(fileChooserSave);
        this.substructureScrollPane.setViewportView(this.drawPanel1);
        this.genomeScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.genomeScrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        this.genomeScrollPane.setViewportView(this.genomePanel1);
        this.mainTabbedPane.addChangeListener(this);
        this.directoryListScrollPane.setViewportView(this.directoryStructureList);
        this.directoryStructureList.addListSelectionListener(this);
        this.parentListScrollPane.setViewportView(this.parentStructureList);
        this.parentStructureList.addListSelectionListener(this);
        this.childListScrollPane.setViewportView(this.childStructureList);
        this.childStructureList.addListSelectionListener(this);
        this.unbiasedFrequencyRadioButton.addChangeListener(this);
        this.unbiasedShannonRadioButton.addChangeListener(this);
        this.addWindowListener(this);
        this.setIconImage(this.appIcon.getImage());
        this.dataLegend1D = new DataLegend();
        this.dataLegend1D.showFilteredAndMissingData(this.filteredDataColor, this.missingDataColor);
        this.dataLegend1D.addChangeListener(this);
        this.legendPanel.add(this.dataLegend1D);
        this.dataLegend2D = new DataLegend();
        this.dataLegend2D.addChangeListener(this);
        this.legendPanel.add(this.dataLegend2D);
        splash.close();
    }

    public void openStructureCollectionFromFolder(File folder) {
        File collectionFile = new File(folder.getAbsolutePath() + File.separatorChar + "collection.xml");
        if (collectionFile.exists()) {
            this.openStructureCollectionFromFile(collectionFile);
        } else {
            JOptionPane.showMessageDialog(this, "Cannot open. This is not a DOOSS project.", "Error", 0);
            this.openDatasetAction();
        }
    }

    public void openStructureCollectionFromFile(File file) {
        int i;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataLegend1D.setVisible(false);
        this.dataLegend2D.setVisible(false);
        this.data1D = null;
        this.data2D = null;
        this.nucleotideComposition = null;
        this.thresholdMin1D = Double.MIN_VALUE;
        this.thresholdMax1D = Double.MAX_VALUE;
        this.thresholdMin2D = Double.MIN_VALUE;
        this.thresholdMax2D = Double.MAX_VALUE;
        this.useUpperThreshold1D = false;
        this.dataLegend1D.upSliderOpen = true;
        this.useLowerThreshold1D = false;
        this.dataLegend1D.downSliderOpen = true;
        this.useUpperThreshold2D = false;
        this.dataLegend2D.upSliderOpen = true;
        this.useLowerThreshold2D = false;
        this.dataLegend2D.downSliderOpen = true;
        this.selected = 0;
        this.structureCollection = StructureCollectionStAXReader.loadStructureCollectionFromFile(file);
        this.collectionFolder = file.getParentFile();
        if (this.collectionFolder != null) {
            this.setTitle("DOOSS - " + this.collectionFolder.getAbsolutePath());
        }
        for (int i2 = 0; i2 < this.structureCollection.metadata.size(); ++i2) {
            Metadata metadata = this.structureCollection.metadata.get(i2);
            if (!metadata.getType().equals("MetadataFromFile")) continue;
            MetadataFromFile metadataFromFile = (MetadataFromFile)this.structureCollection.metadata.get(i2);
            if (metadataFromFile.type.equals("NucleotideComposition")) {
                NucleotideComposition nucleotideComposition = new NucleotideComposition(IO.getFileInCwd(this.collectionFolder, metadataFromFile.files.get(0)), Mapping.loadMapping(IO.getFileInCwd(this.collectionFolder, metadataFromFile.mappingFiles.get(0))));
                nucleotideComposition.name = metadataFromFile.name;
                this.structureCollection.nucleotideComposition.add(nucleotideComposition);
                continue;
            }
            if (metadataFromFile.type.equals("SequenceData1D")) {
                ArrayList<SequenceData1D> data = new ArrayList<SequenceData1D>();
                int dataColumnIndex = 0;
                for (int j = 0; j < metadataFromFile.files.size(); ++j) {
                    if (j < metadataFromFile.dataColumns.size()) {
                        dataColumnIndex = j;
                    }
                    data.add(SequenceData1D.loadFromCsv(IO.getFileInCwd(this.collectionFolder, metadataFromFile.files.get(j)), Mapping.loadMapping(IO.getFileInCwd(this.collectionFolder, metadataFromFile.mappingFiles.get(j))), metadataFromFile.codonData.get(j), 0, metadataFromFile.dataColumns.get(dataColumnIndex)));
                }
                SequenceData1D data1D = SequenceData1D.combine(metadataFromFile.name, data);
                data1D.colorGradient = metadataFromFile.colorGradient;
                data1D.colorGradientSecondary = metadataFromFile.colorGradientSecondary;
                data1D.useMin = metadataFromFile.useMin;
                data1D.useMax = metadataFromFile.useMax;
                data1D.min = metadataFromFile.min;
                data1D.max = metadataFromFile.max;
                data1D.dataTransform = metadataFromFile.dataTransform;
                this.structureCollection.sequenceData1D.add(data1D);
                continue;
            }
            if (!metadataFromFile.type.equals("SequenceData2D")) continue;
            try {
                SequenceData2D data2D = SequenceData2D.loadFromSparseMatrixFile(IO.getFileInCwd(this.collectionFolder, metadataFromFile.files.get(0)), Mapping.loadMapping(IO.getFileInCwd(this.collectionFolder, metadataFromFile.mappingFiles.get(0))));
                data2D.name = metadataFromFile.name;
                data2D.colorGradient = metadataFromFile.colorGradient;
                data2D.colorGradientSecondary = metadataFromFile.colorGradientSecondary;
                data2D.useMin = metadataFromFile.useMin;
                data2D.useMax = metadataFromFile.useMax;
                data2D.min = metadataFromFile.min;
                data2D.max = metadataFromFile.max;
                data2D.dataTransform = metadataFromFile.dataTransform;
                this.structureCollection.sequenceData2D.add(data2D);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Could not load '" + metadataFromFile.name + "'.\n Error: " + ex.getCause().getMessage(), "Error", 0);
            }
        }
        Vector<String> nucleotideCompositionListModel = new Vector<String>();
        nucleotideCompositionListModel.add("None");
        for (int i3 = 0; i3 < this.structureCollection.nucleotideComposition.size(); ++i3) {
            nucleotideCompositionListModel.add(this.structureCollection.nucleotideComposition.get((int)i3).name);
        }
        this.nucleotideCompositionBox.setModel(new DefaultComboBoxModel(nucleotideCompositionListModel));
        Vector<String> oneDimensionalDataListModel = new Vector<String>();
        oneDimensionalDataListModel.add("None");
        for (int i4 = 0; i4 < this.structureCollection.sequenceData1D.size(); ++i4) {
            oneDimensionalDataListModel.add(this.structureCollection.sequenceData1D.get((int)i4).name);
        }
        this.oneDimensionalDataBox.setModel(new DefaultComboBoxModel(oneDimensionalDataListModel));
        Vector<String> twoDimensionalDataListModel = new Vector<String>();
        twoDimensionalDataListModel.add("None");
        for (i = 0; i < this.structureCollection.sequenceData2D.size(); ++i) {
            twoDimensionalDataListModel.add(this.structureCollection.sequenceData2D.get((int)i).name);
        }
        this.twoDimensionalDataBox.setModel(new DefaultComboBoxModel(twoDimensionalDataListModel));
        this.directoryStructureFiles = new ArrayList();
        for (i = 0; i < this.structureCollection.structures.size(); ++i) {
            StructureListObject s = new StructureListObject(i, this.structureCollection.structures.get(i));
            this.directoryStructureFiles.add(s);
        }
        this.directoryStructureList.setListData(this.directoryStructureFiles.toArray());
        this.showDNA = this.structureCollection.dnaSequence;
        this.nucleotideComposition = this.structureCollection.getNucleotideComposition();
        this.layerPanel1 = new LayerPanel(this, this.structureCollection.genomeLength);
        this.genomeLayer = new GenomeLayer(this.layerPanel1, this.structureCollection.getGenomeOrganization(), "Sequence annotations");
        this.graphLayer1D = new GraphLayer(this.layerPanel1, this.data1D, "1D data (none)");
        this.graphLayer1D.canPin = false;
        this.layerPanel1.setGenomeLayer(this.genomeLayer);
        this.layerPanel1.setGraphLayer1D(this.graphLayer1D);
        this.jScrollPane1.setViewportView(this.layerPanel1);
        this.jScrollPane1.setBackground(Color.white);
        this.jScrollPane1.getViewport().setBackground(Color.white);
        this.layerPanel1.autofitWidth();
        this.drawPanel1.initialise(this);
        this.setGenomePanelVerticalPos = true;
        ProgressDialog p = new ProgressDialog(this);
        this.setCursor(Cursor.getDefaultCursor());
        this.openStructure(this.selected);
        try {
            this.nucleotideCompositionBox.setSelectedIndex(Math.min(1, this.nucleotideCompositionBox.getItemCount()));
            this.oneDimensionalDataBox.setSelectedIndex(Math.min(1, this.oneDimensionalDataBox.getItemCount()));
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (this.rankingFrame != null) {
            this.rankingFrame.dispose();
            this.rankingFrame = null;
        }
        if (this.searchFrame != null) {
            this.searchFrame.dispose();
            this.searchFrame = null;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.directoryStructureList.isEnabled() && !e.getValueIsAdjusting()) {
            StructureListObject s = null;
            if (e.getSource().equals(this.parentStructureList)) {
                s = (StructureListObject)this.parentStructureList.getSelectedValue();
            } else if (e.getSource().equals(this.directoryStructureList)) {
                s = (StructureListObject)this.directoryStructureList.getSelectedValue();
            } else if (e.getSource().equals(this.childStructureList)) {
                s = (StructureListObject)this.childStructureList.getSelectedValue();
            }
            if (s != null) {
                this.openStructure(s.structureIndex);
            }
        }
    }

    public void update1DThreshold() {
        double min = this.dataLegend1D.transform.transform(this.dataLegend1D.transform.min);
        double max = this.dataLegend1D.transform.transform(this.dataLegend1D.transform.max);
        this.thresholdMax1D = this.dataLegend1D.transform.inverseTransform(min + (double)this.dataLegend1D.upSliderPercentY * (max - min));
        this.thresholdMin1D = this.dataLegend1D.transform.inverseTransform(min + (double)this.dataLegend1D.downSliderPercentY * (max - min));
        this.redrawVisibleTab();
    }

    public void update2DThreshold() {
        double min = this.dataLegend2D.transform.transform(this.dataLegend2D.transform.min);
        double max = this.dataLegend2D.transform.transform(this.dataLegend2D.transform.max);
        this.thresholdMax2D = this.dataLegend2D.transform.inverseTransform(min + (double)this.dataLegend2D.upSliderPercentY * (max - min));
        this.thresholdMin2D = this.dataLegend2D.transform.inverseTransform(min + (double)this.dataLegend2D.downSliderPercentY * (max - min));
        this.redrawVisibleTab();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.dataLegend1D)) {
            this.update1DThreshold();
            this.data1D.colorGradientSecondary = this.dataLegend1D.colorGradient;
            this.useLowerThreshold1D = !this.dataLegend1D.downSliderOpen;
            this.useUpperThreshold1D = !this.dataLegend1D.upSliderOpen;
            this.graphLayer1D.redraw();
            this.redrawVisibleTab();
        } else if (e.getSource().equals(this.dataLegend2D)) {
            this.update2DThreshold();
            this.data2D.colorGradientSecondary = this.dataLegend2D.colorGradient;
            this.useLowerThreshold2D = !this.dataLegend2D.downSliderOpen;
            this.useUpperThreshold2D = !this.dataLegend2D.upSliderOpen;
            this.redrawVisibleTab();
        } else if (e.getSource().equals(this.unbiasedFrequencyRadioButton) || e.getSource().equals(this.unbiasedShannonRadioButton)) {
            this.nucleotideCompositionType = this.unbiasedFrequencyRadioButton.isSelected() ? NucleotideCompositionType.FREQUENCY : NucleotideCompositionType.SHANNON;
            this.redrawVisibleTab();
        }
        if (e.getSource().equals(this.mainTabbedPane)) {
            this.redrawVisibleTab();
        }
    }

    public void redrawVisibleTab() {
        switch (this.mainTabbedPane.getSelectedIndex()) {
            case 0: {
                this.drawPanel1.redraw();
                break;
            }
            case 1: {
                this.genomePanel1.redraw();
                if (!this.setGenomePanelVerticalPos) break;
                int verticalPos = (int)this.genomePanel1.basePosY + 30 - this.genomeScrollPane.getViewport().getHeight();
                this.genomeScrollPane.getViewport().setViewPosition(new Point(0, verticalPos));
                this.setGenomePanelVerticalPos = false;
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.redrawVisibleTab();
        }
    }

    private void initComponents() {
        this.nucleotideCompositionGroup = new ButtonGroup();
        this.verticalSplitPane = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.leftPanel = new JPanel();
        this.leftPanelCenterPanel = new JPanel();
        this.directoryListScrollPane = new JScrollPane();
        this.childListScrollPane = new JScrollPane();
        this.parentListScrollPane = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.oneDimensionalDataBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.twoDimensionalDataBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.unbiasedFrequencyRadioButton = new JRadioButton();
        this.unbiasedShannonRadioButton = new JRadioButton();
        this.nucleotideCompositionBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.rightPanel = new JPanel();
        this.structureTextPane = new JTextPane();
        this.legendPanel = new JPanel();
        this.mainTabbedPane = new JTabbedPane();
        this.substructureScrollPane = new JScrollPane();
        this.genomeScrollPane = new JScrollPane();
        this.bottomPanel = new JPanel();
        this.distanceSlider = new JSlider();
        this.limitLabel = new JLabel();
        this.distanceLabel2D = new JLabel();
        this.data2DLabel = new JLabel();
        this.nextButton = new JButton();
        this.previousButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.openDatasetItem = new JMenuItem();
        this.createDatasetItem = new JMenuItem();
        this.exportDatasetItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.rankingMenuItem = new JMenuItem();
        this.sequenceSearchItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("DOOSS");
        this.verticalSplitPane.setDividerLocation(80);
        this.verticalSplitPane.setDividerSize(2);
        this.verticalSplitPane.setOrientation(0);
        this.jPanel2.setMinimumSize(new Dimension(100, 50));
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane1.setMinimumSize(new Dimension(100, 100));
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.verticalSplitPane.setTopComponent(this.jPanel2);
        this.mainPanel.setLayout(new BorderLayout());
        this.leftPanel.setPreferredSize(new Dimension(175, 472));
        this.leftPanel.setLayout(new BorderLayout(2, 0));
        this.leftPanelCenterPanel.setLayout(new BoxLayout(this.leftPanelCenterPanel, 3));
        this.directoryListScrollPane.setBorder(BorderFactory.createTitledBorder("Directory"));
        this.directoryListScrollPane.setVerticalScrollBarPolicy(22);
        this.directoryListScrollPane.setMinimumSize(new Dimension(33, 15));
        this.leftPanelCenterPanel.add(this.directoryListScrollPane);
        this.childListScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder("Child structures")));
        this.childListScrollPane.setVerticalScrollBarPolicy(22);
        this.childListScrollPane.setMinimumSize(new Dimension(41, 15));
        this.leftPanelCenterPanel.add(this.childListScrollPane);
        this.parentListScrollPane.setBorder(BorderFactory.createTitledBorder("Parent structures"));
        this.parentListScrollPane.setVerticalScrollBarPolicy(22);
        this.parentListScrollPane.setMinimumSize(new Dimension(33, 15));
        this.leftPanelCenterPanel.add(this.parentListScrollPane);
        this.leftPanel.add((Component)this.leftPanelCenterPanel, "Center");
        this.jPanel4.setPreferredSize(new Dimension(175, 250));
        this.jLabel3.setText("1-dimensional data");
        this.oneDimensionalDataBox.setMinimumSize(new Dimension(100, 18));
        this.oneDimensionalDataBox.setPreferredSize(new Dimension(140, 20));
        this.oneDimensionalDataBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.oneDimensionalDataBoxActionPerformed(evt);
            }
        });
        this.jLabel4.setText("2-dimensional data");
        this.twoDimensionalDataBox.setMinimumSize(new Dimension(100, 18));
        this.twoDimensionalDataBox.setPreferredSize(new Dimension(140, 20));
        this.twoDimensionalDataBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.twoDimensionalDataBoxActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Nucleotide composition data"));
        this.jLabel5.setText("Composition type");
        this.nucleotideCompositionGroup.add(this.unbiasedFrequencyRadioButton);
        this.unbiasedFrequencyRadioButton.setSelected(true);
        this.unbiasedFrequencyRadioButton.setText("Unbiased frequency");
        this.nucleotideCompositionGroup.add(this.unbiasedShannonRadioButton);
        this.unbiasedShannonRadioButton.setText("Unbiased shannon entropy");
        this.nucleotideCompositionBox.setMinimumSize(new Dimension(100, 18));
        this.nucleotideCompositionBox.setPreferredSize(new Dimension(140, 20));
        this.nucleotideCompositionBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.nucleotideCompositionBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Sequence alignment");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nucleotideCompositionBox, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.unbiasedFrequencyRadioButton).addComponent(this.jLabel2).addComponent(this.unbiasedShannonRadioButton)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nucleotideCompositionBox, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unbiasedFrequencyRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.unbiasedShannonRadioButton)));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.oneDimensionalDataBox, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.twoDimensionalDataBox, -2, -1, -2).addComponent(this.jLabel4)).addContainerGap()).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 2, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oneDimensionalDataBox, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.twoDimensionalDataBox, -2, -1, -2).addContainerGap()));
        this.leftPanel.add((Component)this.jPanel4, "Last");
        this.mainPanel.add((Component)this.leftPanel, "West");
        this.rightPanel.setPreferredSize(new Dimension(180, 520));
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 3));
        this.structureTextPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.structureTextPane.setContentType("text/html");
        this.structureTextPane.setEditable(false);
        this.structureTextPane.setMargin(new Insets(10, 10, 10, 10));
        this.structureTextPane.setOpaque(false);
        this.rightPanel.add(this.structureTextPane);
        this.legendPanel.setPreferredSize(new Dimension(150, 500));
        this.legendPanel.setLayout(new GridLayout(0, 1));
        this.rightPanel.add(this.legendPanel);
        this.mainPanel.add((Component)this.rightPanel, "East");
        this.mainTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainApp.this.mainTabbedPaneStateChanged(evt);
            }
        });
        this.mainTabbedPane.addTab("Substructure view", this.substructureScrollPane);
        this.mainTabbedPane.addTab("Full-scale view", this.genomeScrollPane);
        this.mainPanel.add((Component)this.mainTabbedPane, "Center");
        this.mainTabbedPane.getAccessibleContext().setAccessibleName("Substructure view");
        this.verticalSplitPane.setRightComponent(this.mainPanel);
        this.getContentPane().add((Component)this.verticalSplitPane, "Center");
        this.bottomPanel.setPreferredSize(new Dimension(607, 40));
        this.distanceSlider.setMajorTickSpacing(10);
        this.distanceSlider.setMinorTickSpacing(1);
        this.distanceSlider.setSnapToTicks(true);
        this.distanceSlider.setValue(100);
        this.distanceSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainApp.this.distanceSliderStateChanged(evt);
            }
        });
        this.limitLabel.setText("Limit nearby 2D interactions");
        this.distanceLabel2D.setText("Display all");
        this.data2DLabel.setText(" ");
        this.nextButton.setText("Next");
        this.nextButton.setPreferredSize(new Dimension(75, 23));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.nextButtonActionPerformed(evt);
            }
        });
        this.previousButton.setText("Previous");
        this.previousButton.setPreferredSize(new Dimension(75, 23));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.previousButtonActionPerformed(evt);
            }
        });
        GroupLayout bottomPanelLayout = new GroupLayout(this.bottomPanel);
        this.bottomPanel.setLayout(bottomPanelLayout);
        bottomPanelLayout.setHorizontalGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bottomPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.previousButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton, -2, 70, -2).addGap(22, 22, 22).addComponent(this.limitLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.distanceSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.distanceLabel2D).addGap(18, 18, 18).addComponent(this.data2DLabel, -1, 3135, Short.MAX_VALUE).addContainerGap()));
        bottomPanelLayout.setVerticalGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bottomPanelLayout.createSequentialGroup().addContainerGap().addGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bottomPanelLayout.createSequentialGroup().addGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.distanceLabel2D, -2, 24, -2).addComponent(this.data2DLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(bottomPanelLayout.createSequentialGroup().addComponent(this.distanceSlider, -2, 24, -2).addContainerGap()).addGroup(bottomPanelLayout.createSequentialGroup().addGroup(bottomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.previousButton, -2, -1, -2).addComponent(this.nextButton, -1, -1, Short.MAX_VALUE).addComponent(this.limitLabel, -2, 19, -2)).addContainerGap()))));
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.jMenu1.setText("File");
        this.openDatasetItem.setText("Open dataset");
        this.openDatasetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.openDatasetItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.openDatasetItem);
        this.createDatasetItem.setText("Create dataset");
        this.createDatasetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.createDatasetItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.createDatasetItem);
        this.exportDatasetItem.setText("Export dataset to zip");
        this.exportDatasetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.exportDatasetItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exportDatasetItem);
        this.exitItem.setText("Exit ");
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.exitItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exitItem);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu3.setText("Analysis");
        this.rankingMenuItem.setText("Ranking");
        this.rankingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.rankingMenuItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.rankingMenuItem);
        this.sequenceSearchItem.setText("Sequence Search");
        this.sequenceSearchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.sequenceSearchItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.sequenceSearchItem);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu2.setText("Help");
        this.jMenuItem4.setText("Help contents");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem4);
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainApp.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    public ArrayList<StructureListObject> getParentStructures(int start, int end) {
        ArrayList<StructureListObject> parentStructures = new ArrayList<StructureListObject>();
        for (int i = 0; i < this.structureCollection.structures.size(); ++i) {
            Structure s = this.structureCollection.structures.get(i);
            if (s.getStartPosition() > start || end > s.getEndPosition()) continue;
            parentStructures.add(new StructureListObject(i, this.structureCollection.structures.get(i)));
        }
        ArrayList<StructureListObject> ret = new ArrayList<StructureListObject>();
        while (parentStructures.size() > 0) {
            int min = 0;
            for (int j = 0; j < parentStructures.size(); ++j) {
                int a = ((StructureListObject)parentStructures.get((int)j)).structure.length;
                int b = ((StructureListObject)parentStructures.get((int)min)).structure.length;
                if (a > b) continue;
                min = j;
            }
            ret.add((StructureListObject)parentStructures.remove(min));
        }
        return ret;
    }

    public ArrayList<StructureListObject> getChildStructures(int start, int end) {
        ArrayList<StructureListObject> childStructures = new ArrayList<StructureListObject>();
        for (int i = 0; i < this.structureCollection.structures.size(); ++i) {
            Structure s = this.structureCollection.structures.get(i);
            if (s.getStartPosition() < start || end < s.getEndPosition()) continue;
            childStructures.add(new StructureListObject(i, this.structureCollection.structures.get(i)));
        }
        ArrayList<StructureListObject> ret = new ArrayList<StructureListObject>();
        while (childStructures.size() > 0) {
            int min = 0;
            for (int j = 0; j < childStructures.size(); ++j) {
                int a = ((StructureListObject)childStructures.get((int)j)).structure.length;
                int b = ((StructureListObject)childStructures.get((int)min)).structure.length;
                if (a > b) continue;
                min = j;
            }
            ret.add((StructureListObject)childStructures.remove(min));
        }
        return ret;
    }

    public int getStructureIndexAtPosition(int position) {
        int s = -1;
        if (this.structureCollection != null) {
            for (int i = 0; i < this.structureCollection.structures.size(); ++i) {
                if (this.structureCollection.structures.get(i).getStartPosition() > position || this.structureCollection.structures.get(i).getEndPosition() < position) continue;
                if (s != -1) {
                    int ilen = this.structureCollection.structures.get((int)i).length;
                    int slen = this.structureCollection.structures.get((int)s).length;
                    if (ilen >= slen) continue;
                    s = i;
                    continue;
                }
                s = i;
            }
        }
        return s;
    }

    public Structure getLargestStructureAtPosition(int position, int lessThanLength) {
        Structure s = null;
        if (this.structureCollection != null) {
            for (int i = 0; i < this.structureCollection.structures.size(); ++i) {
                if (this.structureCollection.structures.get((int)i).length >= lessThanLength || this.structureCollection.structures.get(i).getStartPosition() > position || this.structureCollection.structures.get(i).getEndPosition() < position) continue;
                if (s != null) {
                    int ilen = this.structureCollection.structures.get((int)i).length;
                    int slen = s.length;
                    if (ilen <= slen) continue;
                    s = this.structureCollection.structures.get(i);
                    continue;
                }
                s = this.structureCollection.structures.get(i);
            }
        }
        return s;
    }

    public ArrayList<Structure> getStructuresAtPosition(int position) {
        ArrayList<Structure> structures = new ArrayList<Structure>();
        if (this.structureCollection != null) {
            for (int i = 0; i < this.structureCollection.structures.size(); ++i) {
                if (this.structureCollection.structures.get(i).getStartPosition() > position || this.structureCollection.structures.get(i).getEndPosition() < position) continue;
                structures.add(this.structureCollection.structures.get(i));
            }
        }
        return structures;
    }

    public ArrayList<Structure> getStructuresInRegion(int start, int end) {
        ArrayList<Structure> structures = new ArrayList<Structure>();
        if (this.structureCollection != null) {
            for (int i = 0; i < this.structureCollection.structures.size(); ++i) {
                if (this.structureCollection.structures.get(i).getStartPosition() < start || this.structureCollection.structures.get(i).getEndPosition() > end) continue;
                structures.add(this.structureCollection.structures.get(i));
            }
        }
        return structures;
    }

    public Structure getStructureAtPosition(int position) {
        int s = this.getStructureIndexAtPosition(position);
        if (s >= 0 && s < this.directoryStructureFiles.size()) {
            return this.structureCollection.structures.get(s);
        }
        return null;
    }

    public void gotoPosition(int position) {
        int s = this.getStructureIndexAtPosition(position);
        if (s >= 0 && s < this.directoryStructureFiles.size()) {
            this.openStructure(s);
        }
    }

    public void loadParentStructures(int start, int end) {
        this.parentStructureList.setListData(this.getParentStructures(start, end).toArray());
    }

    public void loadChildStructures(int start, int end) {
        this.childStructureList.setListData(this.getChildStructures(start, end).toArray());
    }

    public void openStructure(Structure structure) {
        this.openStructure(this.structureCollection.structures.indexOf(structure));
    }

    public void openStructure(int index) {
        Object[] options;
        int n;
        Structure structure = this.structureCollection.structures.get(index);
        boolean openStructure = true;
        if (structure.length > 300 && (n = JOptionPane.showOptionDialog(this, "This structure is longer than 300 nucleotides, opening this structure may cause DOOSS to hang.\nAre you sure you want to continue?", "Warning", 0, 3, null, options = new Object[]{"Yes", "No"}, options[1])) != 0) {
            openStructure = false;
        }
        if (openStructure) {
            this.mainTabbedPane.setSelectedIndex(0);
            if (this.structureCollection != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.selected = index;
                if (this.selected < 0) {
                    this.selected = 0;
                }
                this.setEnabled(false);
                this.directoryStructureList.setSelectedIndex(this.selected);
                String text = "<font face=\"Arial\">";
                text = text + "<b><u>Structure info</u></b><br>";
                text = text + "<font size=\"0\"><br></font><font size=\"3\">";
                text = text + "<b>ID:</b> " + structure.name + "<br>";
                text = text + "<b>Position:</b> " + structure.getStartPosition() + " - " + structure.getEndPosition() + "<br>";
                text = text + "<b>Length:</b> " + structure.length + "<br>";
                if (this.structureTextPane != null && text != null) {
                    this.structureTextPane.setText(text);
                }
                this.drawPanel1.openStructure(structure);
                this.genomeLayer.selectStructure(structure);
                this.setEnabled(true);
                this.loadParentStructures(structure.getStartPosition(), structure.getEndPosition());
                this.loadChildStructures(structure.getStartPosition(), structure.getEndPosition());
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.redrawVisibleTab();
        }
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        --this.selected;
        if (this.selected < 0) {
            this.selected = this.directoryStructureFiles.size() - 1;
        }
        this.openStructure(this.selected);
    }

    public void callNext() {
        if (this.next) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MainApp.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.nextButtonActionPerformed(null);
        }
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        if (this.drawPanel1.saveStructures) {
            this.next = true;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MainApp.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.drawPanel1.saveAsPNG(new File("c:/project/hepacivirus/images/hcv-" + (this.selected + 1) + ".png"));
        }
        this.selected = (this.selected + 1) % this.directoryStructureFiles.size();
        this.openStructure(this.selected);
    }

    private void oneDimensionalDataBoxActionPerformed(ActionEvent evt) {
        if (this.oneDimensionalDataBox.getSelectedIndex() == 0) {
            this.data1D = null;
            this.graphLayer1D.isPinned = false;
            this.graphLayer1D.canPin = false;
            this.graphLayer1D.setData(this.data1D);
            this.graphLayer1D.setLayerName("1D data (none)");
            this.layerPanel1.updatePanel();
            this.dataLegend1D.setVisible(false);
            this.graphLayer1D.redraw();
        } else {
            this.data1D = this.structureCollection.sequenceData1D.get(this.oneDimensionalDataBox.getSelectedIndex() - 1);
            this.graphLayer1D.isPinned = false;
            this.graphLayer1D.canPin = true;
            this.graphLayer1D.setData(this.data1D);
            this.graphLayer1D.redraw();
            this.layerPanel1.revalidate();
            this.graphLayer1D.setLayerName("1D data (" + this.data1D.name + ")");
            this.layerPanel1.updatePanel();
            this.dataLegend1D.initialise(this.data1D);
            this.update1DThreshold();
        }
        this.redrawVisibleTab();
    }

    private void distanceSliderStateChanged(ChangeEvent evt) {
        if (this.distanceSlider.getValue() == this.distanceSlider.getMaximum()) {
            this.distanceLabel2D.setText("Display all");
            this.maxDistance = -1;
        } else {
            this.distanceLabel2D.setText(this.distanceSlider.getValue() + "");
            this.maxDistance = this.distanceSlider.getValue();
        }
        if (!this.distanceSlider.getValueIsAdjusting()) {
            this.redrawVisibleTab();
        }
    }

    private void nucleotideCompositionBoxActionPerformed(ActionEvent evt) {
        this.nucleotideComposition = this.nucleotideCompositionBox.getSelectedIndex() == 0 ? null : this.structureCollection.nucleotideComposition.get(this.nucleotideCompositionBox.getSelectedIndex() - 1);
        this.redrawVisibleTab();
    }

    public int openDatasetAction() {
        projectChooserOpen.setCurrentDirectory(defaultWorkspace);
        int returnVal = projectChooserOpen.showOpenDialog(this);
        if (returnVal == 0) {
            this.openStructureCollectionFromFolder(projectChooserOpen.getSelectedFile());
        }
        return returnVal;
    }

    private void mainTabbedPaneStateChanged(ChangeEvent evt) {
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        AboutDialog d = new AboutDialog((Frame)this, true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - d.getWidth()) / 2;
        int y = (screenSize.height - d.getHeight()) / 2;
        d.setLocation(x, y);
        d.setVisible(true);
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void exportDatasetItemActionPerformed(ActionEvent evt) {
        try {
            fileChooserSave.setDialogTitle("Export project to zip");
            fileChooserSave.setSelectedFile(new File(fileChooserSave.getCurrentDirectory().getPath() + "/" + this.collectionFolder.getName() + ".project.zip"));
            int returnVal = fileChooserSave.showSaveDialog(this);
            if (returnVal == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                IO.zipFolder(this.collectionFolder, fileChooserSave.getSelectedFile(), 2);
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            fileChooserSave.setDialogTitle("Open");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createDatasetItemActionPerformed(ActionEvent evt) {
        new WizardMain().show(this);
    }

    private void openDatasetItemActionPerformed(ActionEvent evt) {
        this.openDatasetAction();
    }

    private void twoDimensionalDataBoxActionPerformed(ActionEvent evt) {
        if (this.twoDimensionalDataBox.getSelectedIndex() == 0) {
            this.dataLegend2D.setVisible(false);
            this.data2D = null;
        } else {
            this.data2D = this.structureCollection.sequenceData2D.get(this.twoDimensionalDataBox.getSelectedIndex() - 1);
            this.thresholdMin2D = this.data2D.dataTransform.min;
            this.thresholdMax2D = this.data2D.dataTransform.max;
            this.dataLegend2D.initialise(this.data2D);
            this.update2DThreshold();
        }
        this.redrawVisibleTab();
    }

    private void rankingMenuItemActionPerformed(ActionEvent evt) {
        if (this.rankingFrame == null) {
            this.rankingFrame = new JFrame("Structure ranking");
            this.rankingFrame.setDefaultCloseOperation(1);
            this.rankingFrame.setIconImage(this.appIcon.getImage());
            this.rankingPanel = new RankingPanel(this);
            this.rankingPanel.setOpaque(true);
            this.rankingFrame.setContentPane(this.rankingPanel);
            this.rankingFrame.addWindowListener(new WindowListener(){

                @Override
                public void windowClosed(WindowEvent arg0) {
                }

                @Override
                public void windowActivated(WindowEvent arg0) {
                }

                @Override
                public void windowClosing(WindowEvent arg0) {
                    MainApp.this.rankingPanel.kill();
                }

                @Override
                public void windowDeactivated(WindowEvent arg0) {
                }

                @Override
                public void windowDeiconified(WindowEvent arg0) {
                }

                @Override
                public void windowIconified(WindowEvent arg0) {
                }

                @Override
                public void windowOpened(WindowEvent arg0) {
                }
            });
        }
        if (this.rankingPanel != null && this.rankingPanel.currentThread == null) {
            this.rankingPanel.performRanking();
        }
        this.rankingFrame.pack();
        this.rankingFrame.setVisible(true);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        if (Desktop.isDesktopSupported()) {
            this.desktop = Desktop.getDesktop();
        }
        try {
            if (this.desktop != null) {
                this.desktop.open(new File("Manual/index.html"));
            } else {
                HelpDialog.showDialog(this.appIcon, new File("Manual/toc.html"), new File("Manual/gettingstarted.html"));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void sequenceSearchItemActionPerformed(ActionEvent evt) {
        if (this.searchFrame == null) {
            this.searchFrame = new JFrame("Sequence Search");
            this.searchFrame.setDefaultCloseOperation(1);
            this.searchFrame.setIconImage(this.appIcon.getImage());
            this.searchPanel = new SearchPanel(this);
            this.searchPanel.setOpaque(true);
            this.searchFrame.setContentPane(this.searchPanel);
            this.searchFrame.addWindowListener(new WindowListener(){

                @Override
                public void windowClosed(WindowEvent arg0) {
                }

                @Override
                public void windowActivated(WindowEvent arg0) {
                }

                @Override
                public void windowClosing(WindowEvent arg0) {
                    MainApp.this.searchPanel.kill();
                }

                @Override
                public void windowDeactivated(WindowEvent arg0) {
                }

                @Override
                public void windowDeiconified(WindowEvent arg0) {
                }

                @Override
                public void windowIconified(WindowEvent arg0) {
                }

                @Override
                public void windowOpened(WindowEvent arg0) {
                }
            });
        }
        if (this.searchPanel != null && this.searchPanel.currentThread == null) {
            this.searchPanel.performSearch();
        }
        this.searchFrame.pack();
        this.searchFrame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (UnsupportedLookAndFeelException ex) {
            // empty catch block
        }
        MainApp mainapp = new MainApp();
        mainapp.setSize(800, 600);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - mainapp.getWidth()) / 2;
        int y = (screenSize.height - mainapp.getHeight()) / 2;
        mainapp.setLocation(x, y);
        mainapp.setExtendedState(6);
        mainapp.setVisible(true);
        StartupDialog s = new StartupDialog(mainapp);
        s.setVisible(true);
    }

    public static Point2D.Double[] normaliseStructureCoordinates(ArrayList<Point2D.Double> coordinates) {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        for (int i = 0; i < coordinates.size(); ++i) {
            Point2D.Double pos = coordinates.get(i);
            minx = Math.min(minx, pos.x);
            miny = Math.min(miny, pos.y);
            maxx = Math.max(maxx, pos.x);
            maxy = Math.max(maxy, pos.y);
        }
        Point2D.Double[] normalisedPositions = new Point2D.Double[coordinates.size()];
        for (int i = 0; i < normalisedPositions.length; ++i) {
            normalisedPositions[i] = new Point2D.Double();
            normalisedPositions[i].x = 0.0 + (coordinates.get((int)i).x - minx);
            normalisedPositions[i].y = 0.0 + (coordinates.get((int)i).y - miny);
        }
        return normalisedPositions;
    }

    public ArrayList<Point2D.Double> getStructureCoordinates(String dotBracketString) {
        ArrayList<Point2D.Double> coordinates = new ArrayList<Point2D.Double>();
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(new File("temp.dbn")));
            buffer.write(">temp");
            buffer.newLine();
            for (int i = 0; i < dotBracketString.length(); ++i) {
                buffer.write("A");
            }
            buffer.newLine();
            buffer.write(dotBracketString);
            buffer.newLine();
            buffer.close();
            Process p = this.appPersistence.execRNAPlot("temp.dbn");
            int code = p.waitFor();
            if (code == 0) {
                BufferedReader bufferIn = new BufferedReader(new FileReader(new File("temp_ss.ps")));
                String textline = null;
                boolean readCoord = false;
                while ((textline = bufferIn.readLine()) != null) {
                    if (textline.startsWith("/coor")) {
                        readCoord = true;
                        continue;
                    }
                    if (!readCoord) continue;
                    String[] split = textline.substring(1).replaceAll("]", "").split("\\s");
                    if (textline.startsWith("[")) {
                        Point2D.Double point = new Point2D.Double(Double.parseDouble(split[0]), Double.parseDouble(split[1]));
                        coordinates.add(point);
                        continue;
                    }
                    readCoord = false;
                }
                bufferIn.close();
            } else {
                JOptionPane.showMessageDialog(this, "RNAplot could not be executed to calculate the structure coordinates.", "Fatal error", 0);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "RNAplot could not be executed to calculate the structure coordinates.", "Fatal error", 0);
            Logger.getLogger(StructureDrawPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            JOptionPane.showMessageDialog(this, "RNAplot could not be executed to calculate the structure coordinates.", "Fatal error", 0);
            Logger.getLogger(StructureDrawPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        int[] pairedSites = RNAFoldingTools.getPairedSitesFromDotBracketString(dotBracketString);
        for (int i = 1; i < pairedSites.length - 1; ++i) {
            Point2D.Double a = coordinates.get(i - 1);
            Point2D.Double b = coordinates.get(i);
            Point2D.Double c = coordinates.get(i + 1);
            System.out.println(dotBracketString.charAt(i));
            double d1 = Point2D.distance(a.x, a.y, b.x, b.y);
            System.out.println(i - 1 + "\t" + i + "\t" + d1);
            double d2 = Point2D.distance(b.x, b.y, c.x, c.y);
            System.out.println(i + "\t" + (i + 1) + "\t" + d2);
        }
        return coordinates;
    }

    public ArrayList<Point2D.Double> adjustCoordinates(ArrayList<Point2D.Double> origCoordinates, ArrayList<Point2D.Double> coordinates, String dotBracketString) {
        ArrayList<Point2D.Double> adjusted = new ArrayList<Point2D.Double>(coordinates.size());
        adjusted.add(coordinates.get(0));
        int lastBracket = 40;
        for (int i = 1; i < dotBracketString.length() - 1; ++i) {
            double d1;
            if (dotBracketString.charAt(i) != '.') {
                lastBracket = dotBracketString.charAt(i);
            }
            Point2D.Double a1 = coordinates.get(i - 1);
            Point2D.Double a2 = coordinates.get(i);
            Point2D.Double a3 = coordinates.get(i + 1);
            Point2D.Double o1 = origCoordinates.get(i - 1);
            Point2D.Double o2 = origCoordinates.get(i);
            Point2D.Double o3 = origCoordinates.get(i + 1);
            Point2D.Double newPoint = (Point2D.Double)a2.clone();
            if (dotBracketString.charAt(i) == '.' && (d1 = Point2D.distance(a1.x, a1.y, a2.x, a2.y)) < 14.0) {
                newPoint.x = lastBracket == 40 ? (newPoint.x -= 15.0 - d1) : (newPoint.x += 15.0 - d1);
            }
            adjusted.add(newPoint);
        }
        adjusted.add(coordinates.get(coordinates.size() - 1));
        return adjusted;
    }

    class StructureListObject {
        int structureIndex;
        Structure structure;
        String descriptiveName;

        public StructureListObject(int structureIndex, Structure s) {
            this.structureIndex = structureIndex;
            this.structure = s;
            this.descriptiveName = "" + s.name + " [" + s.getStartPosition() + "-" + s.getEndPosition() + "] L=" + s.length;
        }

        public String toString() {
            return this.descriptiveName;
        }
    }

    public static enum NucleotideCompositionType {
        FREQUENCY,
        SHANNON,
        HIDE;

    }
}

