/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hanjava.svg.SVG2EMF;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class Main {
    public static void main(String[] args) throws FileNotFoundException {
        try {
            String svgUrl = "file:///C:/structure10.svg";
            File emfFile = new File("C:/structure10.emf");
            SVG2EMF.convert((String)svgUrl, (File)emfFile);
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        BufferedReader br = new BufferedReader(new FileReader("sequence.gb"));
        Namespace ns = RichObjectFactory.getDefaultNamespace();
        RichSequenceIterator seqs = RichSequence.IOTools.readGenbankDNA(br, ns);
        while (seqs.hasNext()) {
            try {
                RichSequence rs = seqs.nextRichSequence();
                Iterator<Feature> it = rs.features();
                while (it.hasNext()) {
                    Feature ft = it.next();
                    System.out.println(ft.getType() + "\n" + ft.getLocation() + "\n" + ft.getAnnotation());
                    if (ft.getAnnotation().containsProperty("product")) {
                        System.out.println(">" + ft.getAnnotation().getProperty("product"));
                    }
                    System.out.println("---------------------------------------------");
                }
            }
            catch (NoSuchElementException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (BioException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

