/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import structurevis.data.SparseVector;
import structurevis.structures.Structure;
import structurevis.structures.StructureParser;
import structurevis.ui.ColorTools;
import structurevis.ui.MainApp;
import structurevis.ui.NAView;
import structurevis.ui.RNAFoldingTools;
import structurevis.ui.StructureDrawPanel;

public class FullGenomeDrawPanel
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener {
    Point2D.Double[] fullCoordinates;
    ArrayList<CoordinatesAndNucleotidePosition> coordinatesAndPosMinList;
    ArrayList<Double> sortedXPositionMinList;
    ArrayList<CoordinatesAndNucleotidePosition> coordinatesAndPosMaxList;
    ArrayList<Double> sortedXPositionMaxList;
    int[] structures;
    double width = 0.0;
    double basePosY = 0.0;
    double lowestPosY = Double.MIN_VALUE;
    boolean forceRepaint = true;
    static final BasicStroke normalStroke = new BasicStroke(2.5f);
    double nucleotideRadius = 6.0;
    double nucleotideDiameter = this.nucleotideRadius * 2.0;
    JPopupMenu popupMenu = new JPopupMenu();
    JMenuItem gotoStructureItem = new JMenuItem();
    int gotoStructure = -1;
    MainApp mainapp = null;
    boolean initialised = false;

    public static File getCacheFile(File collectionFolder, int maxSubstructureSize) {
        return new File(collectionFolder.getPath() + "/" + maxSubstructureSize + "_fullgenome.cache");
    }

    public void cache(int maxSubstructureSize) {
        File cacheFile = FullGenomeDrawPanel.getCacheFile(this.mainapp.collectionFolder, maxSubstructureSize);
        try {
            int i;
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cacheFile)));
            out.writeInt(this.fullCoordinates.length);
            for (i = 0; i < this.fullCoordinates.length; ++i) {
                if (this.fullCoordinates[i] != null) {
                    out.writeDouble(this.fullCoordinates[i].x);
                    out.writeDouble(this.fullCoordinates[i].y);
                    continue;
                }
                out.writeDouble(Double.MIN_VALUE);
                out.writeDouble(Double.MIN_VALUE);
            }
            out.writeInt(this.coordinatesAndPosMinList.size());
            for (i = 0; i < this.coordinatesAndPosMinList.size(); ++i) {
                out.writeDouble(this.coordinatesAndPosMinList.get((int)i).p.x);
                out.writeDouble(this.coordinatesAndPosMinList.get((int)i).p.y);
                out.writeInt(this.coordinatesAndPosMinList.get((int)i).nucleotidePosition);
            }
            out.writeInt(this.sortedXPositionMinList.size());
            for (i = 0; i < this.sortedXPositionMinList.size(); ++i) {
                out.writeDouble(this.sortedXPositionMinList.get(i));
            }
            out.writeInt(this.coordinatesAndPosMaxList.size());
            for (i = 0; i < this.coordinatesAndPosMaxList.size(); ++i) {
                out.writeDouble(this.coordinatesAndPosMaxList.get((int)i).p.x);
                out.writeDouble(this.coordinatesAndPosMaxList.get((int)i).p.y);
                out.writeInt(this.coordinatesAndPosMaxList.get((int)i).nucleotidePosition);
            }
            out.writeInt(this.sortedXPositionMaxList.size());
            for (i = 0; i < this.sortedXPositionMaxList.size(); ++i) {
                out.writeDouble(this.sortedXPositionMaxList.get(i));
            }
            out.writeInt(this.structures.length);
            for (i = 0; i < this.structures.length; ++i) {
                out.writeInt(this.structures[i]);
            }
            out.writeDouble(this.width);
            out.writeDouble(this.basePosY);
            out.writeDouble(this.lowestPosY);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean load(int maxSubstructureSize) {
        File cacheFile = FullGenomeDrawPanel.getCacheFile(this.mainapp.collectionFolder, maxSubstructureSize);
        if (cacheFile.exists()) {
            try {
                Point2D.Double p;
                int i;
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(cacheFile)));
                this.fullCoordinates = new Point2D.Double[in.readInt()];
                for (int i2 = 0; i2 < this.fullCoordinates.length; ++i2) {
                    double x = in.readDouble();
                    double y = in.readDouble();
                    if (x == Double.MIN_VALUE && y == Double.MIN_VALUE) continue;
                    this.fullCoordinates[i2] = new Point2D.Double(x, y);
                }
                int len = in.readInt();
                for (i = 0; i < len; ++i) {
                    p = new Point2D.Double(in.readDouble(), in.readDouble());
                    this.coordinatesAndPosMinList.add(new CoordinatesAndNucleotidePosition(p, in.readInt()));
                }
                len = in.readInt();
                for (i = 0; i < len; ++i) {
                    this.sortedXPositionMinList.add(in.readDouble());
                }
                len = in.readInt();
                for (i = 0; i < len; ++i) {
                    p = new Point2D.Double(in.readDouble(), in.readDouble());
                    this.coordinatesAndPosMaxList.add(new CoordinatesAndNucleotidePosition(p, in.readInt()));
                }
                len = in.readInt();
                for (i = 0; i < len; ++i) {
                    this.sortedXPositionMaxList.add(in.readDouble());
                }
                this.structures = new int[in.readInt()];
                for (i = 0; i < this.structures.length; ++i) {
                    this.structures[i] = in.readInt();
                }
                this.width = in.readDouble();
                this.basePosY = in.readDouble();
                this.lowestPosY = in.readDouble();
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public FullGenomeDrawPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.gotoStructureItem.addActionListener(this);
        this.popupMenu.add(this.gotoStructureItem);
    }

    public int getMaxEndPosition(ArrayList<Structure> substructures) {
        int max = 0;
        for (int i = 0; i < substructures.size(); ++i) {
            max = Math.max(substructures.get(i).getEndPosition(), max);
        }
        return max;
    }

    public void initialise(MainApp mainapp, int maxSubstructureSize) {
        this.mainapp = mainapp;
        if (mainapp != null && mainapp.structureCollection != null) {
            String consensusStructure = mainapp.structureCollection.dotBracketStructure;
            ArrayList<Structure> substructures = StructureParser.enumerateAdjacentSubstructures(consensusStructure, 0, maxSubstructureSize, mainapp.structureCollection.circularGenome);
            this.fullCoordinates = new Point2D.Double[Math.max(consensusStructure.length(), this.getMaxEndPosition(substructures))];
            this.structures = new int[this.fullCoordinates.length];
            this.coordinatesAndPosMinList = new ArrayList();
            this.coordinatesAndPosMaxList = new ArrayList();
            this.sortedXPositionMinList = new ArrayList();
            this.sortedXPositionMaxList = new ArrayList();
            Arrays.fill(this.structures, -1);
            double offsetX = 0.0;
            int lastEndIndex = 0;
            double pairedDistance = 15.0;
            double unpairedLength = 15.0;
            double maxXcoordinate = 0.0;
            if (!this.load(maxSubstructureSize)) {
                int i;
                for (i = 0; i < substructures.size(); ++i) {
                    ArrayList<Point2D.Double> coordinates = NAView.naview_xy_coordinates(RNAFoldingTools.getPairedSitesFromDotBracketString(substructures.get(i).getDotBracketString()));
                    Point2D.Double[] normalisedCoordinates = MainApp.normaliseStructureCoordinates(coordinates);
                    int startIndex = substructures.get((int)i).startPosition - 1;
                    Arrays.fill(this.structures, startIndex, startIndex + substructures.get((int)i).length, i);
                    offsetX = maxXcoordinate + unpairedLength;
                    double maxY = normalisedCoordinates[0].y;
                    for (int j = 0; j < normalisedCoordinates.length; ++j) {
                        this.fullCoordinates[startIndex + j] = new Point2D.Double();
                        this.fullCoordinates[startIndex + j].x = offsetX + normalisedCoordinates[j].x;
                        this.fullCoordinates[startIndex + j].y = normalisedCoordinates[j].y - maxY;
                        maxXcoordinate = Math.max(maxXcoordinate, this.fullCoordinates[startIndex + j].x);
                        this.width = Math.max(this.width, this.fullCoordinates[startIndex + j].x);
                        this.basePosY = Math.max(this.basePosY, normalisedCoordinates[j].y);
                        this.lowestPosY = Math.max(this.fullCoordinates[startIndex + j].y, this.lowestPosY);
                        this.coordinatesAndPosMinList.add(new CoordinatesAndNucleotidePosition(this.fullCoordinates[startIndex + j], startIndex + j));
                        this.coordinatesAndPosMaxList.add(new CoordinatesAndNucleotidePosition(this.fullCoordinates[startIndex + j], startIndex + j));
                        lastEndIndex = startIndex + j;
                    }
                    int c = 1;
                    for (int j = ++lastEndIndex; i + 1 < substructures.size() && j < substructures.get((int)(i + 1)).startPosition - 1; ++j) {
                        this.fullCoordinates[j] = new Point2D.Double();
                        this.fullCoordinates[j].x = this.fullCoordinates[startIndex].x + (double)c * pairedDistance;
                        maxXcoordinate = Math.max(maxXcoordinate, this.fullCoordinates[j].x);
                        this.fullCoordinates[j].y = 0.0;
                        ++c;
                        this.coordinatesAndPosMinList.add(new CoordinatesAndNucleotidePosition(this.fullCoordinates[j], j));
                        this.coordinatesAndPosMaxList.add(new CoordinatesAndNucleotidePosition(this.fullCoordinates[j], j));
                    }
                }
                this.basePosY += pairedDistance;
                this.lowestPosY += pairedDistance;
                for (i = 0; i < this.coordinatesAndPosMinList.size(); ++i) {
                    for (int j = i + 1; j < this.coordinatesAndPosMinList.size(); ++j) {
                        if (!(this.coordinatesAndPosMinList.get((int)i).p.x >= this.coordinatesAndPosMinList.get((int)j).p.x)) continue;
                        this.coordinatesAndPosMinList.remove(j);
                        --j;
                    }
                }
                for (i = 0; i < this.coordinatesAndPosMaxList.size(); ++i) {
                    for (int j = i + 1; j < this.coordinatesAndPosMaxList.size(); ++j) {
                        if (!(this.coordinatesAndPosMaxList.get((int)(this.coordinatesAndPosMaxList.size() - i - 1)).p.x <= this.coordinatesAndPosMaxList.get((int)(this.coordinatesAndPosMaxList.size() - j - 1)).p.x)) continue;
                        this.coordinatesAndPosMaxList.remove(this.coordinatesAndPosMaxList.size() - j - 1);
                        --j;
                    }
                }
                for (i = 0; i < this.coordinatesAndPosMinList.size(); ++i) {
                    this.sortedXPositionMinList.add(this.coordinatesAndPosMinList.get((int)i).p.x);
                }
                for (i = 0; i < this.coordinatesAndPosMaxList.size(); ++i) {
                    this.sortedXPositionMaxList.add(this.coordinatesAndPosMaxList.get((int)i).p.x);
                }
                this.cache(maxSubstructureSize);
            }
            this.setPreferredSize(new Dimension((int)(this.width + 1.0), (int)(this.basePosY + this.lowestPosY + 1.0)));
            this.initialised = true;
        }
    }

    public void redraw() {
        this.forceRepaint = true;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.initialised) {
            Color c;
            Line2D.Double line;
            double val;
            int posj;
            Enumeration<Integer> en;
            SparseVector row;
            int posi;
            Rectangle viewableArea = g.getClipBounds();
            this.setPreferredSize(new Dimension((int)(this.width + 1.0), (int)(this.basePosY + this.lowestPosY + 1.0)));
            g.setColor(Color.white);
            g.fillRect(viewableArea.x, viewableArea.y, viewableArea.width, viewableArea.height);
            int lessThanVisibleX = Collections.binarySearch(this.sortedXPositionMinList, Double.valueOf(viewableArea.x));
            if (lessThanVisibleX < 0) {
                lessThanVisibleX = -lessThanVisibleX - 1;
            }
            lessThanVisibleX = Math.min(lessThanVisibleX, this.coordinatesAndPosMinList.size() - 1);
            int startDrawingFromNucleotide = Math.max(this.coordinatesAndPosMinList.get((int)Math.max((int)lessThanVisibleX, (int)0)).nucleotidePosition - 1, 0);
            int moreThanVisibleX = Collections.binarySearch(this.sortedXPositionMaxList, Double.valueOf(viewableArea.x + viewableArea.width));
            if (moreThanVisibleX < 0) {
                moreThanVisibleX = -moreThanVisibleX - 1;
            }
            int endDrawingAtNucleotide = Math.min(this.coordinatesAndPosMaxList.get((int)Math.min((int)moreThanVisibleX, (int)(this.coordinatesAndPosMaxList.size() - 1))).nucleotidePosition + 1, this.fullCoordinates.length);
            if (this.mainapp.data2D != null) {
                g.setStroke(normalStroke);
                for (posi = startDrawingFromNucleotide; posi < endDrawingAtNucleotide - 1; ++posi) {
                    if (posi >= this.mainapp.data2D.matrix.rows.length || (row = this.mainapp.data2D.matrix.rows[posi]) == null) continue;
                    en = row.table.keys();
                    while (en.hasMoreElements()) {
                        posj = en.nextElement();
                        val = row.get(posj);
                        if (val == this.mainapp.data2D.matrix.emptyValue || this.mainapp.maxDistance != -1 && Math.abs(posj - posi) > this.mainapp.maxDistance || this.mainapp.useLowerThreshold2D && !(val >= this.mainapp.thresholdMin2D) || this.mainapp.useUpperThreshold2D && !(val <= this.mainapp.thresholdMax2D) || this.fullCoordinates[posj] == null) continue;
                        line = new Line2D.Double(this.fullCoordinates[posi].x, this.fullCoordinates[posi].y + this.basePosY, this.fullCoordinates[posj].x, this.fullCoordinates[posj].y + this.basePosY);
                        c = this.mainapp.data2D.colorGradientSecondary.getColor((float)this.mainapp.data2D.dataTransform.transform(val));
                        g.setColor(c);
                        g.draw(line);
                    }
                }
            }
            g.setStroke(new BasicStroke());
            if (this.mainapp.data2D != null) {
                g.setStroke(normalStroke);
                for (posi = startDrawingFromNucleotide; posi < endDrawingAtNucleotide - 1; ++posi) {
                    if (posi >= this.mainapp.data2D.matrix.rows.length || (row = this.mainapp.data2D.matrixTranspose.rows[posi]) == null) continue;
                    en = row.table.keys();
                    while (en.hasMoreElements()) {
                        posj = en.nextElement();
                        if (posj >= startDrawingFromNucleotide && posj < endDrawingAtNucleotide - 1 || (val = row.get(posj)) == this.mainapp.data2D.matrixTranspose.emptyValue || this.mainapp.maxDistance != -1 && Math.abs(posj - posi) > this.mainapp.maxDistance || this.mainapp.useLowerThreshold2D && !(val >= this.mainapp.thresholdMin2D) || this.mainapp.useUpperThreshold2D && !(val <= this.mainapp.thresholdMax2D) || this.fullCoordinates[posj] == null) continue;
                        line = new Line2D.Double(this.fullCoordinates[posi].x, this.fullCoordinates[posi].y + this.basePosY, this.fullCoordinates[posj].x, this.fullCoordinates[posj].y + this.basePosY);
                        c = this.mainapp.data2D.colorGradientSecondary.getColor((float)this.mainapp.data2D.dataTransform.transform(val));
                        g.setColor(c);
                        g.draw(line);
                    }
                }
            }
            g.setStroke(new BasicStroke());
            for (int pos = startDrawingFromNucleotide; pos < endDrawingAtNucleotide; ++pos) {
                int posWrap = pos % this.mainapp.structureCollection.genomeLength;
                if (this.fullCoordinates[pos] == null || pos + 1 >= this.fullCoordinates.length || this.fullCoordinates[pos + 1] == null) continue;
                if (pos + 1 < this.structures.length && this.structures[pos] != this.structures[pos + 1]) {
                    Line2D.Double line2 = new Line2D.Double(this.fullCoordinates[pos].x, this.fullCoordinates[pos].y + this.basePosY, this.fullCoordinates[pos + 1].x, this.fullCoordinates[pos + 1].y + this.basePosY);
                    g.setColor(Color.black);
                    g.draw(line2);
                }
                Color nucleotideBackgroundColor = this.mainapp.missingDataColor;
                if (this.mainapp.data1D != null) {
                    double p = this.mainapp.data1D.data[posWrap];
                    if (!(!this.mainapp.data1D.used[posWrap] || this.mainapp.useLowerThreshold1D && !(p >= this.mainapp.thresholdMin1D) || this.mainapp.useUpperThreshold1D && !(p <= this.mainapp.thresholdMax1D))) {
                        nucleotideBackgroundColor = this.mainapp.data1D.colorGradientSecondary.getColor(this.mainapp.data1D.dataTransform.transform((float)p));
                    } else if (this.mainapp.useLowerThreshold1D && !(p >= this.mainapp.thresholdMin1D) || this.mainapp.useUpperThreshold1D && !(p <= this.mainapp.thresholdMax1D)) {
                        nucleotideBackgroundColor = this.mainapp.filteredDataColor;
                    }
                }
                g.setColor(nucleotideBackgroundColor);
                Ellipse2D.Double nucleotide = new Ellipse2D.Double(this.fullCoordinates[pos].x - this.nucleotideRadius, this.fullCoordinates[pos].y + this.basePosY - this.nucleotideRadius, this.nucleotideDiameter, this.nucleotideDiameter);
                g.fill(nucleotide);
                g.setColor(Color.black);
                g.draw(nucleotide);
                if (this.fullCoordinates[pos].y == 0.0 && (pos + 1) % 10 == 0) {
                    Line2D.Double line3 = new Line2D.Double(this.fullCoordinates[pos].x, this.fullCoordinates[pos].y + this.basePosY + this.nucleotideRadius - 1.0, this.fullCoordinates[pos].x, this.fullCoordinates[pos].y + this.basePosY + this.nucleotideRadius + 1.0);
                    g.setColor(Color.black);
                    g.draw(line3);
                    StructureDrawPanel.drawStringCentred(g, this.fullCoordinates[pos].x, this.fullCoordinates[pos].y + this.basePosY + this.nucleotideDiameter, posWrap + 1 + "");
                }
                if (this.mainapp.nucleotideComposition == null || pos >= this.fullCoordinates.length || posWrap >= this.mainapp.nucleotideComposition.consensus.length()) continue;
                g.setColor(ColorTools.selectBestForegroundColor(nucleotideBackgroundColor, Color.white, Color.black));
                StructureDrawPanel.drawStringCentred(g, this.fullCoordinates[pos].x, this.fullCoordinates[pos].y + this.basePosY - 1.0, this.mainapp.nucleotideComposition.consensus.charAt(posWrap) + "");
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int lessThanVisibleX = Collections.binarySearch(this.sortedXPositionMinList, (double)e.getX() - this.nucleotideDiameter);
        if (lessThanVisibleX < 0) {
            lessThanVisibleX = -lessThanVisibleX - 1;
        }
        int startDrawingFromNucleotide = Math.max(this.coordinatesAndPosMinList.get((int)Math.max((int)lessThanVisibleX, (int)0)).nucleotidePosition - 1, 0);
        int moreThanVisibleX = Collections.binarySearch(this.sortedXPositionMaxList, (double)e.getX() + this.nucleotideDiameter);
        if (moreThanVisibleX < 0) {
            moreThanVisibleX = -moreThanVisibleX - 1;
        }
        int endDrawingAtNucleotide = Math.min(this.coordinatesAndPosMaxList.get((int)Math.min((int)moreThanVisibleX, (int)(this.coordinatesAndPosMaxList.size() - 1))).nucleotidePosition + 1, this.fullCoordinates.length);
        Point2D.Double mousePosition = new Point2D.Double(e.getX(), e.getY());
        for (int posi = startDrawingFromNucleotide; posi < endDrawingAtNucleotide; ++posi) {
            Point2D.Double nucleotide = new Point2D.Double(this.fullCoordinates[posi].x, this.fullCoordinates[posi].y + this.basePosY);
            if (!(mousePosition.distance(nucleotide) <= this.nucleotideRadius)) continue;
            System.out.println("User clicked at " + (posi % this.mainapp.structureCollection.genomeLength + 1));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            int nucleotide = this.getNucleotideAtPosition(e.getX(), e.getY());
            this.gotoStructure = this.mainapp.getStructureIndexAtPosition(nucleotide);
            if (this.gotoStructure != -1) {
                this.gotoStructureItem.setText("Open structure " + this.gotoStructure);
                this.popupMenu.show(this, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public int getNucleotideAtPosition(double x, double y) {
        int lessThanVisibleX = Collections.binarySearch(this.sortedXPositionMinList, x - this.nucleotideDiameter);
        if (lessThanVisibleX < 0) {
            lessThanVisibleX = -lessThanVisibleX - 1;
        }
        int startDrawingFromNucleotide = Math.max(this.coordinatesAndPosMinList.get((int)Math.max((int)lessThanVisibleX, (int)0)).nucleotidePosition - 1, 0);
        int moreThanVisibleX = Collections.binarySearch(this.sortedXPositionMaxList, x + this.nucleotideDiameter);
        if (moreThanVisibleX < 0) {
            moreThanVisibleX = -moreThanVisibleX - 1;
        }
        int endDrawingAtNucleotide = Math.min(this.coordinatesAndPosMaxList.get((int)Math.min((int)moreThanVisibleX, (int)(this.coordinatesAndPosMaxList.size() - 1))).nucleotidePosition + 1, this.fullCoordinates.length);
        Point2D.Double mousePosition = new Point2D.Double(x, y);
        for (int posi = startDrawingFromNucleotide; posi < endDrawingAtNucleotide; ++posi) {
            Point2D.Double nucleotide = new Point2D.Double(this.fullCoordinates[posi].x, this.fullCoordinates[posi].y + this.basePosY);
            if (!(mousePosition.distance(nucleotide) <= this.nucleotideRadius)) continue;
            return posi + 1;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.gotoStructureItem) && this.gotoStructure != -1) {
            this.mainapp.openStructure(this.gotoStructure);
        }
    }

    class CoordinatesAndNucleotidePosition
    implements Comparable {
        Point2D.Double p;
        int nucleotidePosition;

        public CoordinatesAndNucleotidePosition(Point2D.Double p, int nucleotidePos) {
            this.p = p;
            this.nucleotidePosition = nucleotidePos;
        }

        public int compareTo(Object o) {
            CoordinatesAndNucleotidePosition other = (CoordinatesAndNucleotidePosition)o;
            if (this.p.x < other.p.x) {
                return -1;
            }
            if (this.p.x > other.p.x) {
                return 1;
            }
            return 0;
        }
    }
}

