/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class FileSpecifier {
    public File naspStructuresFile = null;
    public File naspAlignmentFile = null;
    public File naspMatrixFile = null;
    public File naspCtFile = null;
    public File naspCtWithPvaluesFile = null;
    public File coevolutionAlignmentFile = null;
    public File coevolutionDir = null;
    public ArrayList<File> geneAlignmentFiles = new ArrayList();
    public ArrayList<File> parrisMarginalsFiles = new ArrayList();
    public File genbankReferenceFile = null;
    public File collateDir = null;
    public String name;

    public FileSpecifier(File specifierFile, String name) {
        this.name = name;
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(specifierFile));
            String textline = null;
            while ((textline = buffer.readLine()) != null) {
                int i;
                String[] files;
                String[] split = textline.split("=");
                if (split.length != 2) continue;
                if (split[0].equals("NASP_STRUCTURES_FILE")) {
                    this.naspStructuresFile = new File(split[1]);
                    continue;
                }
                if (split[0].equals("NASP_ALIGNMENT_FILE")) {
                    this.naspAlignmentFile = new File(split[1]);
                    continue;
                }
                if (split[0].equals("NASP_MATRIX_FILE")) {
                    this.naspMatrixFile = new File(split[1]);
                    continue;
                }
                if (split[0].equals("NASP_CT_FILE")) {
                    this.naspCtFile = new File(split[1]);
                    continue;
                }
                if (split[0].equals("NASP_CT_WITH_PVALUES_FILE")) {
                    this.naspCtWithPvaluesFile = new File(split[1]);
                    continue;
                }
                if (split[0].equals("COEVOLUTION_ALIGNMENT_FILE")) {
                    this.coevolutionAlignmentFile = new File(split[1]);
                    continue;
                }
                if (split[0].equals("COEVOLUTION_DIRECTORY")) {
                    this.coevolutionDir = new File(split[1]);
                    continue;
                }
                if (split[0].equals("NASP_STRUCTURES_FILE")) {
                    this.naspStructuresFile = new File(split[1]);
                    continue;
                }
                if (split[0].equals("GENE_ALIGMNENT_FILE")) {
                    files = split[1].split(";");
                    for (i = 0; i < files.length; ++i) {
                        this.geneAlignmentFiles.add(new File(files[i]));
                    }
                    continue;
                }
                if (split[0].equals("PARRIS_MARGINALS_FILE")) {
                    files = split[1].split(";");
                    for (i = 0; i < files.length; ++i) {
                        this.parrisMarginalsFiles.add(new File(files[i]));
                    }
                    continue;
                }
                if (split[0].equals("GENBANK_REFERENCE_FILE")) {
                    this.genbankReferenceFile = new File(split[1]);
                    continue;
                }
                if (!split[0].equals("COLLATE_DIRECTORY")) continue;
                this.collateDir = new File(split[1]);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

