/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class DistanceMatrix {
    int n;
    int nd;
    int[][] matrix;
    int binSize;
    int radius;

    public DistanceMatrix(int binSize, int radius, int length) {
        this.n = length;
        this.binSize = binSize;
        this.radius = radius;
        this.nd = this.n / binSize + 1;
        this.matrix = new int[this.nd][this.nd];
    }

    public DistanceMatrix(int binSize, int radius, int[][] pairedSites) {
        int i;
        this.n = pairedSites[0].length;
        this.binSize = binSize;
        this.radius = radius;
        this.nd = this.n / binSize + 1;
        this.matrix = new int[this.nd][this.nd];
        for (i = 0; i < this.matrix.length; ++i) {
            Arrays.fill(this.matrix[i], Integer.MAX_VALUE);
        }
        for (i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix.length; ++j) {
                this.matrix[i][j] = Math.abs(i - j);
            }
        }
        for (i = 0; i < pairedSites[0].length; ++i) {
            int x = (pairedSites[0][i] - 1) / binSize;
            int y = (pairedSites[1][i] - 1) / binSize;
            if (pairedSites[1][i] == 0) continue;
            this.matrix[x][y] = 1;
            this.matrix[y][x] = 1;
        }
        for (i = 0; i < this.matrix.length; ++i) {
            this.matrix[i][i] = 0;
        }
    }

    public DistanceMatrix(int[][] pairedSites) {
        int i;
        this.n = pairedSites[0].length;
        this.binSize = 1;
        this.nd = this.n;
        this.matrix = new int[this.nd][this.nd];
        for (i = 0; i < this.matrix.length; ++i) {
            Arrays.fill(this.matrix[i], Integer.MAX_VALUE);
        }
        for (i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix.length; ++j) {
                this.matrix[i][j] = Math.abs(i - j);
            }
        }
        for (i = 0; i < pairedSites[0].length; ++i) {
            int x = pairedSites[0][i] - pairedSites[0][0];
            int y = pairedSites[1][i] - pairedSites[0][0];
            if (pairedSites[1][i] == 0) continue;
            this.matrix[x][y] = 1;
            this.matrix[y][x] = 1;
        }
        for (i = 0; i < this.matrix.length; ++i) {
            this.matrix[i][i] = 0;
        }
        this.computeFloydWarshall2();
    }

    public static int getBestBinSize(int genomeLength, int radius) {
        double minIterations = 1.0E8;
        double maxIterations = 200000.0 * (double)genomeLength;
        int binSize = 1;
        double numIterations;
        while (!((numIterations = DistanceMatrix.getNumberOfIterations(binSize, genomeLength, radius)) < minIterations)) {
            if (numIterations < maxIterations) {
                return binSize;
            }
            ++binSize;
        }
        return binSize;
    }

    public static double getNumberOfIterations(int binSize, int genomeLength, double radius) {
        return Math.pow(genomeLength / binSize, 3.0) * (Math.min(radius * 2.0, (double)genomeLength) / (double)genomeLength);
    }

    public void computeFloydWarshall() {
        int diagRadius = this.radius / this.binSize;
        for (int k = 0; k < this.nd; ++k) {
            if (k % 10 == 0) {
                // empty if block
            }
            for (int i = 0; i < this.nd; ++i) {
                int js;
                int j;
                int minj = i - diagRadius;
                int maxj = i + diagRadius;
                for (j = minj; j < 0; ++j) {
                    js = this.nd + j;
                    this.matrix[i][js] = Math.min(this.matrix[i][js], this.matrix[i][k] + this.matrix[k][js]);
                }
                for (j = Math.max(minj, 0); j < Math.min(maxj, this.nd); ++j) {
                    this.matrix[i][j] = Math.min(this.matrix[i][j], this.matrix[i][k] + this.matrix[k][j]);
                }
                for (j = this.nd; j < maxj; ++j) {
                    js = j - this.nd;
                    this.matrix[i][js] = Math.min(this.matrix[i][js], this.matrix[i][k] + this.matrix[k][js]);
                }
            }
        }
    }

    public void computeFloydWarshall2() {
        for (int k = 0; k < this.nd; ++k) {
            for (int i = 0; i < this.nd; ++i) {
                for (int j = 0; j < this.nd; ++j) {
                    this.matrix[i][j] = Math.min(this.matrix[i][j], this.matrix[i][k] + this.matrix[k][j]);
                }
            }
        }
    }

    public void printMatrix() {
        for (int i = 0; i < this.nd; ++i) {
            for (int j = 0; j < this.nd; ++j) {
                System.out.print(this.matrix[i][j] * this.binSize + "\t");
            }
            System.out.println();
        }
    }

    public int getDistance(int i, int j) {
        return this.matrix[i / this.binSize][j / this.binSize] * this.binSize;
    }

    public static File getCacheFile(File collectionFolder) {
        return new File(collectionFolder.getPath() + File.separatorChar + "distancematrix.cache");
    }

    public void cache(File collectionFolder) {
        File file = DistanceMatrix.getCacheFile(collectionFolder);
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            out.writeInt(this.binSize);
            out.writeInt(this.radius);
            out.writeInt(this.n);
            for (int i = 0; i < this.nd; ++i) {
                for (int j = 0; j < this.nd; ++j) {
                    out.writeInt(this.matrix[i][j]);
                }
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static DistanceMatrix load(File collectionFolder) {
        DistanceMatrix matrix = null;
        File file = DistanceMatrix.getCacheFile(collectionFolder);
        if (file.exists()) {
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                matrix = new DistanceMatrix(in.readInt(), in.readInt(), in.readInt());
                for (int i = 0; i < matrix.nd; ++i) {
                    for (int j = 0; j < matrix.nd; ++j) {
                        matrix.matrix[i][j] = in.readInt();
                    }
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return matrix;
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(DistanceMatrix.getBestBinSize(800, 1000));
        System.out.println(DistanceMatrix.getBestBinSize(3000, 1000));
        System.out.println(DistanceMatrix.getBestBinSize(5000, 1000));
        System.out.println(DistanceMatrix.getBestBinSize(10000, 1000));
        System.out.println(DistanceMatrix.getBestBinSize(20000, 1000));
        System.out.println(DistanceMatrix.getBestBinSize(40000, 1000));
    }
}

