/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

public class DataTransform {
    public double min;
    public double max;
    public TransformType type;

    public DataTransform(double min, double max, TransformType type) {
        this.min = min;
        this.max = max;
        this.type = type;
    }

    public float transform(float x) {
        return (float)this.transform((double)x);
    }

    public double transform(double x) {
        switch (this.type) {
            case IDENTITY: {
                return x;
            }
            case LINEAR: {
                return (x - this.min) / (this.max - this.min);
            }
            case EXPLOG: {
                double q = Math.log10(0.00392156862745098);
                double minp = Math.log10(this.max) - Math.log10(this.min);
                double scale = q / minp / 1.75;
                double f = Math.exp((Math.log10(x) - Math.log10(this.min)) * scale);
                return 1.0 - f;
            }
        }
        return 0.0;
    }

    public double inverseTransform(double y) {
        switch (this.type) {
            case IDENTITY: {
                return y;
            }
            case LINEAR: {
                return y * (this.max - this.min) + this.min;
            }
            case EXPLOG: {
                double q = Math.log10(0.00392156862745098);
                double minp = Math.log10(this.max) - Math.log10(this.min);
                double scale = q / minp / 1.75;
                return Math.min(Math.pow(10.0, Math.log(1.0 - y) / scale + Math.log10(this.min)), this.max);
            }
        }
        return 0.0;
    }

    public static enum TransformType {
        LINEAR,
        EXPLOG,
        IDENTITY;

    }
}

