/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.hanjava.svg.SVG2EMF;
import structurevis.structures.metadata.MetadataFromFile;
import structurevis.ui.ColorGradient;
import structurevis.ui.DataTransform;
import structurevis.ui.MainApp;
import structurevis.ui.StructureDrawPanel;

public class DataLegend
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener {
    protected EventListenerList listenerList = new EventListenerList();
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public int orientation = 0;
    public String label;
    public DataTransform transform;
    public ColorGradient colorGradient;
    public ColorGradient colorGradientDefault;
    static DecimalFormat decimalFormat = new DecimalFormat("0.00");
    static DecimalFormat exponentialFormat = new DecimalFormat("0.0E0");
    double barOffsetX = 10.0;
    double barOffsetY = 10.0;
    double barWidth = 20.0;
    double barHeight = 0.0;
    int pixelsBetweenTickMarks = 25;
    Color backgroundColor = Color.LIGHT_GRAY;
    double arrowWidth = 10.0;
    double arrowHeight = 6.0;
    float downSliderPercentY = 0.0f;
    double downSliderPosY = this.barOffsetY;
    float upSliderPercentY = 1.0f;
    double upSliderPosY = this.barOffsetY + 100.0;
    boolean upSliderOpen = false;
    boolean downSliderOpen = false;
    int sliderSelected = -1;
    int sliderIndicatorPosX = 0;
    int sliderIndicatorPosY = 0;
    String sliderIndicatorText = null;
    JTextPane pane = new JTextPane();
    boolean activeLegend;
    boolean edit = false;
    double colorArrowWidth = 10.0;
    double colorArrowHeight = 10.0;
    int colorSliderSelected = -1;
    int hideColorSlider = -1;
    int mousePosX = 0;
    int mousePosY = 0;
    JPopupMenu editPopupMenu = new JPopupMenu();
    JMenuItem modeItem = new JMenuItem("Edit gradient");
    JMenu colorPresetsMenu = new JMenu("Use preset gradient");
    JMenuItem blueWhiteGreenItem = new JMenuItem("Blue-white-green");
    JMenuItem orangeRedItem = new JMenuItem("Orange-red");
    JMenuItem whiteBlackItem = new JMenuItem("White-black");
    JMenuItem distributeColorsItem = new JMenuItem("Distribute colours");
    JMenuItem reverseColorsItem = new JMenuItem("Reverse gradient");
    JMenuItem useDefaultItem = new JMenuItem("Restore default gradient");
    JMenu saveImageMenu = new JMenu("Save legend image");
    JMenuItem saveAsPNGItem = new JMenuItem("Save as PNG");
    JMenuItem saveAsSVGItem = new JMenuItem("Save as SVG");
    JMenuItem saveAsEMFItem = new JMenuItem("Save as EMF");
    boolean showMissingAndFilteredData = false;
    Color filterColor = Color.lightGray;
    Color missingDataColor = Color.gray;
    int missingAndFilteredDataHeight = 50;
    int missingAndFilteredDataBlockSize = 14;
    int missingAndFilteredDataPadding = 10;
    int labelHash = 0;
    int[] labelPositions = new int[4];
    public static final int UP = -1;
    public static final int DOWN = 1;

    public DataLegend() {
        this.modeItem.addActionListener(this);
        this.editPopupMenu.add(this.modeItem);
        this.blueWhiteGreenItem.addActionListener(this);
        this.orangeRedItem.addActionListener(this);
        this.whiteBlackItem.addActionListener(this);
        this.colorPresetsMenu.add(this.blueWhiteGreenItem);
        this.colorPresetsMenu.add(this.orangeRedItem);
        this.colorPresetsMenu.add(this.whiteBlackItem);
        this.editPopupMenu.add(this.colorPresetsMenu);
        this.distributeColorsItem.addActionListener(this);
        this.editPopupMenu.add(this.distributeColorsItem);
        this.reverseColorsItem.addActionListener(this);
        this.editPopupMenu.add(this.reverseColorsItem);
        this.useDefaultItem.addActionListener(this);
        this.editPopupMenu.add(this.useDefaultItem);
        this.saveAsPNGItem.addActionListener(this);
        this.saveImageMenu.add(this.saveAsPNGItem);
        this.saveAsSVGItem.addActionListener(this);
        this.saveImageMenu.add(this.saveAsSVGItem);
        this.saveAsEMFItem.addActionListener(this);
        this.saveImageMenu.add(this.saveAsEMFItem);
        this.editPopupMenu.add(this.saveImageMenu);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void showEditMode() {
        this.edit = true;
        this.modeItem.setText("Set range");
        this.repaint();
    }

    public void showRangeMode() {
        this.edit = false;
        this.modeItem.setText("Change colour gradient");
        this.repaint();
    }

    public void showFilteredAndMissingData(Color filteredData, Color missingData) {
        this.showMissingAndFilteredData = true;
        this.filterColor = filteredData;
        this.missingDataColor = missingData;
    }

    public DataLegend(String label, DataTransform transform, ColorGradient colorGradient) {
    }

    public void initialise(MetadataFromFile data) {
        this.initialise(data.name, data.dataTransform, data.colorGradientSecondary, data.colorGradient);
    }

    public void initialise(String label, DataTransform transform, ColorGradient colorGradient, ColorGradient colorGradientDefault) {
        this.activeLegend = true;
        this.label = label;
        this.transform = transform;
        this.colorGradient = colorGradient;
        this.colorGradientDefault = colorGradientDefault.clone();
        if (label != null) {
            this.setLayout(null);
            this.pane.setOpaque(false);
            this.pane.setEditable(false);
            this.pane.setText(label);
            this.add(this.pane);
            StyledDocument doc = this.pane.getStyledDocument();
            SimpleAttributeSet center = new SimpleAttributeSet();
            StyleConstants.setAlignment(center, 1);
            doc.setParagraphAttributes(0, doc.getLength(), center, false);
        }
        this.setVisible(true);
        this.repaint();
    }

    public void saveAsSVG(File file) throws IOException {
        BufferedWriter buffer = new BufferedWriter(new FileWriter(file));
        buffer.write(this.getLegendAsSVG());
        buffer.close();
    }

    public void saveAsEMF(File file) throws IOException {
        File tempFile = new File("temp.svg");
        this.saveAsSVG(tempFile);
        String svgUrl = "file:///" + tempFile.getAbsolutePath();
        SVG2EMF.convert((String)svgUrl, (File)file);
    }

    public void saveAsPNG(File file) {
        int panelWidth = 200;
        int panelHeight = (int)(this.barOffsetY * 2.0 + this.barHeight);
        Dimension d = new Dimension((int)Math.ceil(panelWidth), (int)Math.ceil(panelHeight));
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = (BufferedImage)this.createImage(d.width, d.height);
            Graphics2D g = (Graphics2D)bufferedImage.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.white);
            g.fillRect(0, 0, panelWidth, panelHeight);
            StringReader reader = new StringReader(this.getLegendAsSVG());
            SVGCache.getSVGUniverse().clear();
            SVGDiagram diagram = SVGCache.getSVGUniverse().getDiagram(SVGCache.getSVGUniverse().loadSVG((Reader)reader, "myImage"));
            if (diagram == null) {
                throw new Exception("Diagram could not be saved. Unknown reason.");
            }
            diagram.render(g);
            if (bufferedImage != null) {
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
            }
        }
        catch (SVGException ex) {
            return;
        }
        catch (Exception ex) {
            return;
        }
    }

    public String getLegendAsSVG() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int barHeight = 176;
        int barWidth = 20;
        int panelWidth = 200;
        int panelHeight = (int)(this.barOffsetY * 2.0 + (double)barHeight);
        pw.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        pw.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
        pw.println("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"" + panelWidth + "\" height=\"" + panelHeight + "\" style=\"fill:none;stroke-width:2\">");
        pw.println("<defs>");
        pw.println("<linearGradient id=\"grad1\" x1=\"0%\" y1=\"0%\" x2=\"0%\" y2=\"100%\">");
        for (int i = 0; i < this.colorGradient.colours.length; ++i) {
            double perc = this.colorGradient.positions[i] * 100.0f;
            Color c = this.colorGradient.colours[i];
            pw.println("<stop offset=\"" + perc + "%\" style=\"stop-color:rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ");stop-opacity:" + (double)c.getAlpha() / 255.0 + "\" />");
        }
        pw.println("</linearGradient>");
        pw.println("</defs>");
        pw.println("<rect x=\"" + this.barOffsetX + "\" y=\"" + this.barOffsetY + "\" width=\"" + barWidth + "\" height=\"" + barHeight + "\" fill=\"url(#grad1)\"/>");
        double min = this.transform.transform(this.transform.min);
        double max = this.transform.transform(this.transform.max);
        for (int i = 0; i < barHeight; ++i) {
            double h = (double)i / (double)(barHeight - 1);
            double x = this.transform.inverseTransform(min + h * (max - min));
            if (i % 25 != 0) continue;
            int xpos = (int)(this.barOffsetX + (double)barWidth);
            if (this.edit) {
                xpos = (int)((double)xpos + this.arrowWidth);
            }
            int ypos = (int)(this.barOffsetY + h * (double)barHeight);
            if (!this.edit) {
                pw.println("<polyline points=\"" + (xpos - 1) + " " + ypos + " " + (xpos + 1) + " " + ypos + "\" style=\"stroke-width:1;stroke:#000000\"/>");
            }
            String text = DataLegend.formatValue(x, this.transform, 2);
            pw.println("<text x=\"" + (xpos + 5) + "\" y=\"" + (ypos + 3) + "\" style=\"font-size:10px;stroke:none;fill:black;\" text-anchor=\"start\">");
            pw.println("<tspan>" + text + "</tspan>");
            pw.println("</text>");
        }
        int xpos = (int)(this.barOffsetX + (double)barWidth);
        int ypos = (int)(this.barOffsetY + (double)barHeight) / 2;
        pw.println("<text x=\"" + (xpos + 35) + "\" y=\"" + ypos + "\" style=\"font-size:12px;stroke:none;fill:black;\" text-anchor=\"start\">");
        pw.println("<tspan>" + this.label + "</tspan>");
        pw.println("</text>");
        pw.println("</svg>");
        return sw.toString();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.transform != null) {
            double x;
            double h;
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fm = g.getFontMetrics();
            int width = this.getWidth();
            int height = this.getHeight();
            this.barHeight = (double)height - 2.0 * this.barOffsetX;
            if (this.showMissingAndFilteredData) {
                this.barHeight -= (double)this.missingAndFilteredDataHeight;
            }
            if (this.label != null) {
                int labelOffsetX = fm.stringWidth("######") + 5;
                this.labelPositions[0] = (int)(this.barOffsetX + this.barWidth + (double)labelOffsetX);
                this.labelPositions[1] = (int)(this.barOffsetY + (this.barHeight - (double)this.pane.getPreferredSize().height) / 2.0);
                this.labelPositions[2] = width - (int)(this.barOffsetX + this.barWidth + (double)labelOffsetX);
                this.labelPositions[3] = this.pane.getPreferredSize().height;
                if (Arrays.hashCode(this.labelPositions) != this.labelHash) {
                    this.pane.setLocation(this.labelPositions[0], this.labelPositions[1]);
                    this.pane.setSize(this.labelPositions[2], this.labelPositions[3]);
                    this.labelHash = Arrays.hashCode(this.labelPositions);
                }
            }
            double min = this.transform.transform(this.transform.min);
            double max = this.transform.transform(this.transform.max);
            int i = 0;
            while ((double)i < this.barHeight) {
                h = (double)i / (this.barHeight - 1.0);
                x = min + h * (max - min);
                Rectangle2D.Double rect = new Rectangle2D.Double(this.barOffsetX, this.barOffsetY + h * this.barHeight, this.barWidth, 2.0);
                g.setColor(this.colorGradient.getColor((float)x));
                g.fill(rect);
                ++i;
            }
            g.setColor(Color.black);
            i = 0;
            while ((double)i < this.barHeight) {
                h = (double)i / this.barHeight;
                x = this.transform.inverseTransform(min + h * (max - min));
                if (i % this.pixelsBetweenTickMarks == 0) {
                    int xpos = (int)(this.barOffsetX + this.barWidth);
                    if (this.edit) {
                        xpos = (int)((double)xpos + this.arrowWidth);
                    }
                    int ypos = (int)(this.barOffsetY + h * this.barHeight);
                    if (!this.edit) {
                        g.drawLine(xpos - 2, ypos, xpos + 1, ypos);
                    }
                    g.drawString(DataLegend.formatValue(x, this.transform, 2), xpos + 5, ypos + fm.getAscent() / 2);
                }
                ++i;
            }
            if (!this.edit) {
                this.downSliderPosY = this.barOffsetY + (double)this.downSliderPercentY * this.barHeight - this.arrowHeight;
                this.upSliderPosY = this.barOffsetY + (double)this.upSliderPercentY * this.barHeight + this.arrowHeight;
                if (this.downSliderOpen) {
                    this.fillVerticalArrow(g, this.barOffsetX + this.barWidth / 2.0, this.downSliderPosY + this.arrowHeight, this.arrowWidth, this.arrowHeight, -1, Color.white);
                } else {
                    this.fillVerticalArrow(g, this.barOffsetX + this.barWidth / 2.0, this.downSliderPosY, this.arrowWidth, this.arrowHeight, 1, Color.black);
                }
                if (this.upSliderOpen) {
                    this.fillVerticalArrow(g, this.barOffsetX + this.barWidth / 2.0, this.upSliderPosY - this.arrowHeight, this.arrowWidth, this.arrowHeight, 1, Color.white);
                } else {
                    this.fillVerticalArrow(g, this.barOffsetX + this.barWidth / 2.0, this.upSliderPosY, this.arrowWidth, this.arrowHeight, -1, Color.black);
                }
                if (this.sliderIndicatorText != null) {
                    g.setColor(Color.white);
                    int stringWidth = fm.stringWidth(this.sliderIndicatorText);
                    int blockHeight = fm.getHeight() + 2;
                    int blockWidth = stringWidth + 4;
                    g.fillRect(this.sliderIndicatorPosX - blockWidth / 2, -blockHeight + this.sliderIndicatorPosY, blockWidth, blockHeight);
                    g.setColor(Color.black);
                    g.drawString(this.sliderIndicatorText, this.sliderIndicatorPosX + 2 - blockWidth / 2, -blockHeight + this.sliderIndicatorPosY + blockHeight / 2 + fm.getAscent() / 2);
                }
            }
            if (this.edit) {
                for (i = 0; i < this.colorGradient.positions.length; ++i) {
                    double ypos;
                    if (i != this.hideColorSlider) {
                        g.setColor(Color.black);
                        ypos = (double)this.colorGradient.positions[i] * this.barHeight;
                        this.fillHorizontalArrow(g, this.barOffsetX + this.barWidth, this.barOffsetY + ypos, 10.0, 10.0, 1, this.colorGradient.colours[i]);
                        continue;
                    }
                    g.setColor(Color.black);
                    ypos = (double)this.colorGradient.positions[i] * this.barHeight;
                    this.fillHorizontalArrow(g, (double)this.mousePosX - this.arrowWidth / 2.0, this.mousePosY, 10.0, 10.0, 1, this.colorGradient.colours[i]);
                }
            }
            if (this.showMissingAndFilteredData) {
                g.setColor(this.filterColor);
                g.fillRect((int)(this.barOffsetX + this.barWidth / 2.0) - this.missingAndFilteredDataBlockSize / 2, (int)this.barOffsetY + (int)this.barHeight + 13, this.missingAndFilteredDataBlockSize, this.missingAndFilteredDataBlockSize);
                g.setColor(Color.black);
                g.drawString("Filtered data", (int)(this.barOffsetX + this.barWidth / 2.0) - this.missingAndFilteredDataBlockSize / 2 + this.missingAndFilteredDataBlockSize + 5, (int)this.barOffsetY + (int)this.barHeight + 13 + this.missingAndFilteredDataBlockSize - 3);
                g.setColor(this.missingDataColor);
                g.fillRect((int)(this.barOffsetX + this.barWidth / 2.0) - this.missingAndFilteredDataBlockSize / 2, (int)this.barOffsetY + (int)this.barHeight + 32, this.missingAndFilteredDataBlockSize, this.missingAndFilteredDataBlockSize);
                g.setColor(Color.black);
                g.drawString("Missing data", (int)(this.barOffsetX + this.barWidth / 2.0) - this.missingAndFilteredDataBlockSize / 2 + this.missingAndFilteredDataBlockSize + 5, (int)this.barOffsetY + (int)this.barHeight + 32 + this.missingAndFilteredDataBlockSize - 3);
            }
        }
    }

    public static String formatValue(double value, DataTransform transform, int fractionDigits) {
        if (transform.type == DataTransform.TransformType.LINEAR) {
            decimalFormat.setMaximumFractionDigits(fractionDigits);
            return decimalFormat.format(value);
        }
        if (transform.type == DataTransform.TransformType.EXPLOG) {
            exponentialFormat.setMaximumFractionDigits(fractionDigits);
            return exponentialFormat.format(value);
        }
        decimalFormat.setMaximumFractionDigits(fractionDigits);
        return decimalFormat.format(value);
    }

    public void fillVerticalArrow(Graphics2D g, double x, double y, double width, double height, int direction, Color fillColor) {
        Path2D.Double arrow = new Path2D.Double();
        arrow.moveTo(x - width / 2.0, y);
        arrow.lineTo(x + width / 2.0, y);
        arrow.lineTo(x, y + (double)direction * height);
        arrow.lineTo(x - width / 2.0, y);
        g.setColor(fillColor);
        g.fill(arrow);
        g.setColor(Color.DARK_GRAY);
        g.draw(arrow);
    }

    public void fillHorizontalArrow(Graphics2D g, double x, double y, double width, double height, int direction, Color fillColor) {
        Path2D.Double arrow = new Path2D.Double();
        arrow.moveTo(x, y);
        arrow.lineTo(x + (double)direction * width, y - height / 2.0);
        arrow.lineTo(x + (double)direction * width, y + height / 2.0);
        arrow.lineTo(x, y);
        g.setColor(fillColor);
        g.fill(arrow);
        g.setColor(Color.DARK_GRAY);
        g.draw(arrow);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getClickCount() >= 2) {
                if (this.edit) {
                    if (this.colorSliderSelected != -1) {
                        Color c = JColorChooser.showDialog(this, "Pick a color", this.colorGradient.colours[this.colorSliderSelected]);
                        if (c != null) {
                            this.colorGradient.colours[this.colorSliderSelected] = c;
                        }
                        this.colorSliderSelected = -1;
                    }
                } else if ((double)e.getY() >= this.downSliderPosY && (double)e.getY() < this.downSliderPosY + 1.5 * this.arrowHeight) {
                    this.downSliderOpen = !this.downSliderOpen;
                } else if ((double)e.getY() > this.upSliderPosY - 1.5 * this.arrowHeight && (double)e.getY() <= this.upSliderPosY) {
                    this.upSliderOpen = !this.upSliderOpen;
                }
            } else if (this.edit && this.colorSliderSelected == -1 && (double)e.getX() >= this.barOffsetX + this.barWidth && (double)e.getX() < this.barOffsetX + this.barWidth + this.arrowWidth * 1.5) {
                Color[] colors = new Color[this.colorGradient.colours.length + 1];
                float[] positions = new float[this.colorGradient.colours.length + 1];
                int r = 0;
                float ypos = Math.max(Math.min((float)(((double)e.getY() - this.barOffsetY) / this.barHeight), 1.0f), 0.0f);
                for (int i = 0; i < this.colorGradient.colours.length; ++i) {
                    if (ypos < this.colorGradient.positions[i]) {
                        colors[r] = this.colorGradient.getColor(ypos);
                        positions[r] = ypos;
                        ++r;
                        ypos = Float.MAX_VALUE;
                    }
                    colors[r] = this.colorGradient.colours[i];
                    positions[r] = this.colorGradient.positions[i];
                    ++r;
                }
                if (ypos != Float.MAX_VALUE) {
                    colors[r] = this.colorGradient.getColor(ypos);
                    positions[r] = ypos;
                }
                this.colorGradient.colours = colors;
                this.colorGradient.positions = positions;
            }
            this.repaint();
            this.fireChangeEvent(new ChangeEvent(this));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        block1: {
            block2: {
                block3: {
                    if (!SwingUtilities.isLeftMouseButton(e)) break block1;
                    if (this.edit) break block2;
                    if (!((double)e.getY() >= this.downSliderPosY) || !((double)e.getY() < this.downSliderPosY + 1.5 * this.arrowHeight)) break block3;
                    this.sliderSelected = 1;
                    break block1;
                }
                if (!((double)e.getY() > this.upSliderPosY - 1.5 * this.arrowHeight) || !((double)e.getY() <= this.upSliderPosY)) break block1;
                this.sliderSelected = -1;
                break block1;
            }
            this.colorSliderSelected = -1;
            for (int i = 0; i < this.colorGradient.positions.length; ++i) {
                double x = this.barOffsetX + this.barWidth;
                double y = this.barOffsetY + (double)this.colorGradient.positions[i] * this.barHeight;
                if (!((double)e.getY() >= y - 0.5 * this.colorArrowHeight) || !((double)e.getY() < y + 0.5 * this.colorArrowHeight)) continue;
                this.colorSliderSelected = i;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.fireChangeEvent(new ChangeEvent(this));
            this.sliderIndicatorText = null;
            this.repaint();
            if (this.hideColorSlider != -1) {
                Color[] colors = new Color[this.colorGradient.colours.length - 1];
                float[] positions = new float[this.colorGradient.colours.length - 1];
                int r = 0;
                for (int i = 0; i < this.colorGradient.colours.length; ++i) {
                    if (this.hideColorSlider == i) continue;
                    colors[r] = this.colorGradient.colours[i];
                    positions[r] = this.colorGradient.positions[i];
                    ++r;
                }
                this.colorGradient.colours = colors;
                this.colorGradient.positions = positions;
                this.hideColorSlider = -1;
                this.colorSliderSelected = -1;
            }
            this.fireChangeEvent(new ChangeEvent(this));
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.editPopupMenu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.edit) {
            if (this.sliderSelected == 1) {
                this.downSliderPercentY = Math.max(Math.min((float)(((double)e.getY() - this.barOffsetY) / this.barHeight), 1.0f), 0.0f);
                this.upSliderPercentY = Math.max(this.upSliderPercentY, this.downSliderPercentY);
                this.sliderIndicatorPosX = e.getX();
                this.sliderIndicatorPosY = e.getY();
                double min = this.transform.transform(this.transform.min);
                double max = this.transform.transform(this.transform.max);
                double x = this.transform.inverseTransform(min + (double)this.downSliderPercentY * (max - min));
                this.sliderIndicatorText = this.transform.type == DataTransform.TransformType.LINEAR ? decimalFormat.format(x) : (this.transform.type == DataTransform.TransformType.EXPLOG ? exponentialFormat.format(x) : decimalFormat.format(x));
            } else if (this.sliderSelected == -1) {
                this.upSliderPercentY = Math.max(Math.min((float)(((double)e.getY() - this.barOffsetY) / this.barHeight), 1.0f), 0.0f);
                this.downSliderPercentY = Math.min(this.upSliderPercentY, this.downSliderPercentY);
                this.sliderIndicatorPosX = e.getX();
                this.sliderIndicatorPosY = e.getY();
                double min = this.transform.transform(this.transform.min);
                double max = this.transform.transform(this.transform.max);
                double x = this.transform.inverseTransform(min + (double)this.upSliderPercentY * (max - min));
                this.sliderIndicatorText = this.transform.type == DataTransform.TransformType.LINEAR ? decimalFormat.format(x) : (this.transform.type == DataTransform.TransformType.EXPLOG ? exponentialFormat.format(x) : decimalFormat.format(x));
            }
            this.downSliderPosY = this.barOffsetY + (double)this.downSliderPercentY * this.barHeight - this.arrowHeight;
            this.upSliderPosY = this.barOffsetY + (double)this.upSliderPercentY * this.barHeight + this.arrowHeight;
        } else if (this.colorSliderSelected != -1) {
            if (this.colorGradient.colours.length > 2 && (double)e.getX() > this.barOffsetX + this.barWidth + this.arrowWidth * 1.5) {
                this.hideColorSlider = this.colorSliderSelected;
            } else if (this.hideColorSlider == -1) {
                double lower = this.colorSliderSelected > 0 ? (double)this.colorGradient.positions[this.colorSliderSelected - 1] : 0.0;
                double upper = this.colorSliderSelected < this.colorGradient.positions.length - 1 ? (double)this.colorGradient.positions[this.colorSliderSelected + 1] : 1.0;
                double f = ((double)e.getY() - this.barOffsetY) / this.barHeight;
                f = Math.max(Math.min(upper, f), lower);
                this.colorGradient.positions[this.colorSliderSelected] = (float)f;
            } else {
                this.hideColorSlider = -1;
            }
            this.mousePosX = e.getX();
            this.mousePosY = e.getY();
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    void fireChangeEvent(ChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(evt);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.modeItem)) {
            if (this.edit) {
                this.showRangeMode();
            } else {
                this.showEditMode();
            }
            this.repaint();
        } else if (e.getSource().equals(this.blueWhiteGreenItem)) {
            this.colorGradient = new ColorGradient(Color.blue, Color.white, Color.green);
            this.repaint();
        } else if (e.getSource().equals(this.orangeRedItem)) {
            this.colorGradient = new ColorGradient(Color.orange, Color.red);
            this.repaint();
        } else if (e.getSource().equals(this.whiteBlackItem)) {
            this.colorGradient = new ColorGradient(Color.white, Color.black);
            this.repaint();
        } else if (e.getSource().equals(this.distributeColorsItem)) {
            this.colorGradient.distributeColors();
            this.repaint();
        } else if (e.getSource().equals(this.reverseColorsItem)) {
            this.colorGradient.reverseOrder();
            this.repaint();
        } else if (e.getSource().equals(this.useDefaultItem)) {
            this.colorGradient = this.colorGradientDefault.clone();
            System.out.println("Using default");
            this.repaint();
        } else if (e.getSource().equals(this.saveAsPNGItem)) {
            String name = "legend";
            MainApp.fileChooserSave.setDialogTitle("Save as PNG");
            MainApp.fileChooserSave.setSelectedFile(new File(MainApp.fileChooserSave.getCurrentDirectory().getPath() + "/" + name + ".png"));
            int returnVal = MainApp.fileChooserSave.showSaveDialog(this);
            if (returnVal == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.saveAsPNG(MainApp.fileChooserSave.getSelectedFile());
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            MainApp.fileChooserSave.setDialogTitle("Open");
        } else if (e.getSource().equals(this.saveAsSVGItem)) {
            MainApp.fileChooserSave.setDialogTitle("Save as SVG");
            String name = "legend";
            MainApp.fileChooserSave.setSelectedFile(new File(MainApp.fileChooserSave.getCurrentDirectory().getPath() + "/" + name + ".svg"));
            int returnVal = MainApp.fileChooserSave.showSaveDialog(this);
            if (returnVal == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    this.saveAsSVG(MainApp.fileChooserSave.getSelectedFile());
                }
                catch (IOException ex) {
                    Logger.getLogger(StructureDrawPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            MainApp.fileChooserSave.setDialogTitle("Open");
        } else if (e.getSource().equals(this.saveAsEMFItem)) {
            MainApp.fileChooserSave.setDialogTitle("Save as EMF");
            String name = "legend";
            MainApp.fileChooserSave.setSelectedFile(new File(MainApp.fileChooserSave.getCurrentDirectory().getPath() + "/" + name + ".emf"));
            int returnVal = MainApp.fileChooserSave.showSaveDialog(this);
            if (returnVal == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    this.saveAsEMF(MainApp.fileChooserSave.getSelectedFile());
                }
                catch (IOException ex) {
                    Logger.getLogger(StructureDrawPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            MainApp.fileChooserSave.setDialogTitle("Open");
        }
        this.fireChangeEvent(new ChangeEvent(this));
    }
}

