/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import structurevis.ranking.RankingAnalyses;
import structurevis.structures.Structure;
import structurevis.structures.StructureParser;
import structurevis.structures.metadata.MetadataFromFile;
import structurevis.structures.metadata.SequenceData1D;
import structurevis.structures.metadata.SequenceData2D;
import structurevis.ui.MainApp;

public class ContigencyPanel
extends JPanel {
    MainApp mainapp = null;
    ArrayList<SequenceData1D> sequenceData1D = null;
    ArrayList<SequenceData2D> sequenceData2D = null;
    ArrayList sequenceData = new ArrayList();
    private JLabel ct1;
    private JLabel ct2;
    private JComboBox dataSourceBox;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JLabel pc1;
    private JLabel pc1exp;
    private JPanel pc1panel;
    private JLabel pc2;
    private JLabel pc2exp;
    private JPanel pc2panel;
    private JLabel pt1;
    private JLabel tt;
    private JLabel uc1;
    private JLabel uc1exp;
    private JPanel uc1panel;
    private JLabel uc2;
    private JLabel uc2_exp;
    private JPanel uc2panel;
    private JLabel ut1;

    public ContigencyPanel(MainApp mainapp) {
        this.initComponents();
        this.mainapp = mainapp;
        if (mainapp.structureCollection != null) {
            this.sequenceData1D = mainapp.structureCollection.sequenceData1D;
            this.sequenceData2D = mainapp.structureCollection.sequenceData2D;
            this.sequenceData.addAll(this.sequenceData1D);
            this.sequenceData.addAll(this.sequenceData2D);
            DefaultComboBoxModel<String> sequenceDataModel = new DefaultComboBoxModel<String>();
            this.dataSourceBox.setModel(sequenceDataModel);
            for (int i = 0; i < this.sequenceData.size(); ++i) {
                sequenceDataModel.addElement(((MetadataFromFile)this.sequenceData.get((int)i)).name);
            }
        }
    }

    public static void createAndShowGUI(MainApp mainapp) {
        JFrame frame = new JFrame("Structure ranking");
        frame.setDefaultCloseOperation(2);
        frame.setIconImage(mainapp.appIcon.getImage());
        ContigencyPanel newContentPane = new ContigencyPanel(mainapp);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContigencyPanel.createAndShowGUI(null);
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dataSourceBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel6 = new JLabel();
        this.pc1panel = new JPanel();
        this.pc1 = new JLabel();
        this.pc1exp = new JLabel();
        this.uc1panel = new JPanel();
        this.uc1 = new JLabel();
        this.uc1exp = new JLabel();
        this.ct1 = new JLabel();
        this.jLabel12 = new JLabel();
        this.pc2panel = new JPanel();
        this.pc2 = new JLabel();
        this.pc2exp = new JLabel();
        this.uc2panel = new JPanel();
        this.uc2 = new JLabel();
        this.uc2_exp = new JLabel();
        this.ct2 = new JLabel();
        this.jLabel11 = new JLabel();
        this.pt1 = new JLabel();
        this.ut1 = new JLabel();
        this.tt = new JLabel();
        this.jLabel1.setText("Data source");
        this.dataSourceBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContigencyPanel.this.dataSourceBoxActionPerformed(evt);
            }
        });
        this.jPanel1.setLayout(new GridLayout(4, 4));
        this.jPanel1.add(this.jLabel3);
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setText("Paired");
        this.jLabel10.setOpaque(true);
        this.jPanel1.add(this.jLabel10);
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Unpaired");
        this.jLabel5.setOpaque(true);
        this.jPanel1.add(this.jLabel5);
        this.jLabel14.setHorizontalAlignment(0);
        this.jLabel14.setText("Total");
        this.jPanel1.add(this.jLabel14);
        this.jLabel6.setText("Category 1");
        this.jLabel6.setOpaque(true);
        this.jPanel1.add(this.jLabel6);
        this.pc1panel.add(this.pc1);
        this.pc1panel.add(this.pc1exp);
        this.jPanel1.add(this.pc1panel);
        this.uc1panel.add(this.uc1);
        this.uc1panel.add(this.uc1exp);
        this.jPanel1.add(this.uc1panel);
        this.ct1.setHorizontalAlignment(0);
        this.jPanel1.add(this.ct1);
        this.jLabel12.setText("Category 2");
        this.jLabel12.setOpaque(true);
        this.jPanel1.add(this.jLabel12);
        this.pc2panel.add(this.pc2);
        this.pc2panel.add(this.pc2exp);
        this.jPanel1.add(this.pc2panel);
        this.uc2panel.add(this.uc2);
        this.uc2panel.add(this.uc2_exp);
        this.jPanel1.add(this.uc2panel);
        this.ct2.setHorizontalAlignment(0);
        this.jPanel1.add(this.ct2);
        this.jLabel11.setText("Total");
        this.jPanel1.add(this.jLabel11);
        this.pt1.setHorizontalAlignment(0);
        this.jPanel1.add(this.pt1);
        this.ut1.setHorizontalAlignment(0);
        this.jPanel1.add(this.ut1);
        this.tt.setHorizontalAlignment(0);
        this.jPanel1.add(this.tt);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jLabel1).addGap(8, 8, 8).addComponent(this.dataSourceBox, -2, 129, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 350, -2))).addContainerGap(35, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataSourceBox, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 186, -2).addContainerGap(47, Short.MAX_VALUE)));
    }

    private void dataSourceBoxActionPerformed(ActionEvent evt) {
        int index = this.dataSourceBox.getSelectedIndex();
        if (index != -1) {
            Object data = this.sequenceData.get(index);
            double cutoff = 1.0;
            if (data instanceof SequenceData1D) {
                int i;
                SequenceData1D sequenceData1D = (SequenceData1D)data;
                Structure s = StructureParser.parseDotBracketString(this.mainapp.structureCollection.dotBracketStructure);
                ArrayList<Double> paired = RankingAnalyses.getValues(sequenceData1D, 0, s.length, false, s, true, false, s.length);
                ArrayList<Double> unpaired = RankingAnalyses.getValues(sequenceData1D, 0, s.length, false, s, false, true, s.length);
                int[][] contigency = new int[2][2];
                ArrayList pairedC1 = new ArrayList();
                ArrayList pairedC2 = new ArrayList();
                ArrayList unpairedC1 = new ArrayList();
                ArrayList unpairedC2 = new ArrayList();
                for (i = 0; i < paired.size(); ++i) {
                    if (paired.get(i) < cutoff) {
                        int[] nArray = contigency[0];
                        nArray[0] = nArray[0] + 1;
                        continue;
                    }
                    int[] nArray = contigency[0];
                    nArray[1] = nArray[1] + 1;
                }
                for (i = 0; i < unpaired.size(); ++i) {
                    if (unpaired.get(i) < cutoff) {
                        int[] nArray = contigency[1];
                        nArray[0] = nArray[0] + 1;
                        continue;
                    }
                    int[] nArray = contigency[1];
                    nArray[1] = nArray[1] + 1;
                }
                double pairedTotal = contigency[0][0] + contigency[0][1];
                double c1Total = contigency[0][0] + contigency[1][0];
                double unpairedTotal = contigency[1][0] + contigency[1][1];
                double c2Total = contigency[0][1] + contigency[1][1];
                double total = pairedTotal + unpairedTotal;
                double pc1expval = pairedTotal * c1Total / total;
                double pc2expval = pairedTotal * c2Total / total;
                double uc1expval = unpairedTotal * c1Total / total;
                double uc2expval = unpairedTotal * c2Total / total;
                this.pc1.setText(contigency[0][0] + "");
                this.pc1exp.setText(pc1expval + "");
                this.pc2.setText(contigency[0][1] + "");
                this.pc2exp.setText(pc1expval + "");
                this.pt1.setText((int)pairedTotal + "");
                this.ct1.setText((int)c1Total + "");
                this.uc1.setText(contigency[1][0] + "");
                this.uc2.setText(contigency[1][1] + "");
                this.ut1.setText((int)unpairedTotal + "");
                this.ct2.setText((int)c2Total + "");
                this.tt.setText((int)total + "");
            }
        }
    }
}

