/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.awt.Color;
import java.util.Arrays;

public class ColorGradient {
    public Color[] colours;
    public float[] positions;
    private float[] differences;

    public ColorGradient(Color c1, Color c2) {
        this.colours = new Color[2];
        this.colours[0] = c1;
        this.colours[1] = c2;
        this.positions = new float[2];
        this.positions[0] = 0.0f;
        this.positions[1] = 1.0f;
    }

    public ColorGradient(Color c1, Color c2, Color c3) {
        this.colours = new Color[3];
        this.colours[0] = c1;
        this.colours[1] = c2;
        this.colours[2] = c3;
        this.positions = new float[3];
        this.positions[0] = 0.0f;
        this.positions[1] = 0.5f;
        this.positions[2] = 1.0f;
    }

    public ColorGradient(Color[] colours) {
        this.colours = colours;
        this.positions = new float[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            this.positions[i] = (float)i / (float)(colours.length - 1);
        }
    }

    public void distributeColors() {
        for (int i = 0; i < this.colours.length; ++i) {
            this.positions[i] = (float)i / (float)(this.colours.length - 1);
        }
    }

    public void reverseOrder() {
        Color[] tempColors = new Color[this.colours.length];
        for (int i = 0; i < tempColors.length; ++i) {
            tempColors[this.colours.length - 1 - i] = this.colours[i];
        }
        float[] tempPositions = new float[this.positions.length];
        for (int i = 0; i < tempPositions.length; ++i) {
            tempPositions[this.positions.length - 1 - i] = 1.0f - this.positions[i];
        }
        this.colours = tempColors;
        this.positions = tempPositions;
    }

    public ColorGradient(Color[] colours, float[] positions) {
        this.colours = colours;
        this.positions = positions;
    }

    public Color getColor(float val) {
        if (val > 1.0f) {
            return this.colours[this.colours.length - 1];
        }
        if (val < 0.0f) {
            return this.colours[0];
        }
        int c1 = 0;
        int c2 = this.colours.length - 1;
        float lower = 0.0f;
        float upper = 1.0f;
        int pos = 0;
        for (int i = 1; i < this.positions.length; ++i) {
            lower = this.positions[i - 1];
            upper = this.positions[i];
            if (!(lower <= val) || !(val <= upper)) continue;
            pos = i;
            break;
        }
        c1 = Math.max(pos - 1, 0);
        c2 = pos;
        if (val > this.positions[this.positions.length - 1]) {
            c1 = this.positions.length - 1;
            c2 = this.positions.length - 1;
        }
        float perc = (val - lower) / (upper - lower);
        int r = this.colours[c1].getRed() + (int)(perc * (float)(this.colours[c2].getRed() - this.colours[c1].getRed()));
        int g = this.colours[c1].getGreen() + (int)(perc * (float)(this.colours[c2].getGreen() - this.colours[c1].getGreen()));
        int b = this.colours[c1].getBlue() + (int)(perc * (float)(this.colours[c2].getBlue() - this.colours[c1].getBlue()));
        int a = this.colours[c1].getAlpha() + (int)(perc * (float)(this.colours[c2].getAlpha() - this.colours[c1].getAlpha()));
        return new Color(r, g, b, a);
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < this.colours.length; ++i) {
            ret = ret + "rgba(" + this.colours[i].getRed() + "," + this.colours[i].getGreen() + "," + this.colours[i].getBlue() + "," + this.colours[i].getAlpha() + "):" + this.positions[i];
            ret = ret + ";";
        }
        return ret;
    }

    public static ColorGradient getValue(String fromString) {
        String[] colorSplit = fromString.split(";");
        Color[] colors = new Color[colorSplit.length];
        float[] positions = new float[colorSplit.length];
        for (int i = 0; i < colors.length; ++i) {
            String[] colorSplit2 = colorSplit[i].split(":");
            if (colorSplit2.length >= 1) {
                String[] rgba = colorSplit2[0].replaceAll("([^0-9,])+", "").split(",");
                colors[i] = new Color(Integer.parseInt(rgba[0]), Integer.parseInt(rgba[1]), Integer.parseInt(rgba[2]), Integer.parseInt(rgba[3]));
            }
            positions[i] = colorSplit2.length >= 2 ? Float.parseFloat(colorSplit2[1]) : (float)i / (float)(colors.length - 1);
        }
        return new ColorGradient(colors, positions);
    }

    public ColorGradient clone() {
        return new ColorGradient(Arrays.copyOf(this.colours, this.colours.length), Arrays.copyOf(this.positions, this.positions.length));
    }

    public static void main(String[] args) {
        Color[] colours = new Color[]{Color.green, Color.white, Color.blue};
        System.out.println(new ColorGradient(colours).getColor(0.99f));
    }
}

