/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import structurevis.data.Mapping;

public class ApplicationPersistence {
    public File persistenceFile;
    Hashtable<String, String> map = new Hashtable();
    OS defaultOS = OS.WINDOWS;
    OS currentOS = OS.WINDOWS;
    String lastDatasetUsedKey = "lastUsedDataset";

    public ApplicationPersistence(File persistenceFile) {
        this.persistenceFile = persistenceFile;
        this.currentOS = this.getOS();
        this.load();
    }

    public void load() {
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(this.persistenceFile));
            String textline = null;
            while ((textline = buffer.readLine()) != null) {
                String[] split = textline.split("=");
                if (split.length < 2) continue;
                String key = split[0];
                String value = split[1];
                this.map.put(key, value);
            }
            buffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (this.currentOS) {
            case WINDOWS: {
                Mapping.setMuscleExecutable("muscle3.8.31_i86win32.exe");
                break;
            }
            case LINUX: {
                Mapping.setMuscleExecutable("./muscle3.8.31_i86linux32");
                break;
            }
            case MAC: {
                Mapping.setMuscleExecutable("./muscle3.8.31_i86darwin32");
            }
        }
    }

    public void save(File persistenceFile) {
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(persistenceFile));
            Enumeration<String> keys = this.map.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                buffer.write(key + "=" + this.map.get(key));
                buffer.newLine();
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setLastDatasetUsed(File lastUsedDataset) {
        this.map.put(this.lastDatasetUsedKey, lastUsedDataset.getAbsolutePath());
    }

    public File getLastDatasetUsed() {
        if (this.map.get(this.lastDatasetUsedKey) == null) {
            return null;
        }
        return new File(this.map.get(this.lastDatasetUsedKey));
    }

    public Process execRNAPlot(String dbnFile) throws IOException {
        Process p = null;
        if (this.currentOS.equals((Object)OS.WINDOWS)) {
            p = Runtime.getRuntime().exec("cmd /c RNAplot -t 1 -o ps < " + dbnFile);
        } else if (this.currentOS.equals((Object)OS.LINUX) || this.currentOS.equals((Object)OS.MAC)) {
            String[] cmd = new String[]{"/bin/bash", "-c", "./RNAplot -t 1 -o ps < temp.dbn"};
            p = Runtime.getRuntime().exec(cmd);
        }
        return p;
    }

    public OS getOS() {
        if (ApplicationPersistence.isWindows()) {
            return OS.WINDOWS;
        }
        if (ApplicationPersistence.isMac()) {
            return OS.MAC;
        }
        if (ApplicationPersistence.isUnix()) {
            return OS.LINUX;
        }
        return this.defaultOS;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static boolean isSolaris() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("sunos") >= 0;
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        MAC;

    }
}

