/*
 * Decompiled with CFR 0.152.
 */
package structurevis.structures.metadata;

import java.io.File;
import structurevis.data.Mapping;
import structurevis.data.SparseMatrix;
import structurevis.structures.metadata.MetadataFromFile;

public class SequenceData2D
extends MetadataFromFile {
    public SparseMatrix matrix;
    public SparseMatrix matrixTranspose;
    public double min = 3.4028234663852886E38;
    public double max = 1.4E-45f;

    private SequenceData2D() {
        this.type = "SequenceData2D";
    }

    public SequenceData2D(String name) {
        this.type = "SequenceData2D";
        this.name = name;
    }

    public static SequenceData2D getMappedNucleotideData2D(SparseMatrix unmappedDataB, Mapping mapping) {
        SequenceData2D nd = new SequenceData2D();
        nd.matrix = new SparseMatrix(mapping.getALength(), unmappedDataB.emptyValue);
        SparseMatrix.MatrixIterator it = unmappedDataB.getMatrixIterator();
        while (it.hasNext()) {
            double val;
            SparseMatrix.Index2D index = it.next();
            int i = index.i;
            int j = index.j;
            int x = mapping.bToA(i);
            int y = mapping.bToA(j);
            if (x == -1 || y == -1 || (val = unmappedDataB.get(i, j)) == unmappedDataB.emptyValue) continue;
            nd.matrix.set(x, y, unmappedDataB.get(i, j));
            nd.min = Math.min(nd.min, val);
            nd.max = Math.min(nd.max, val);
        }
        nd.matrixTranspose = nd.matrix.transpose();
        return nd;
    }

    public static SequenceData2D loadFromSparseMatrixFile(File matrixFile, Mapping mapping) throws Exception {
        SequenceData2D data = SequenceData2D.getMappedNucleotideData2D(SparseMatrix.loadSparseMatrixFromFile(matrixFile, "\t", true), mapping);
        return data;
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public boolean canFree() {
        return false;
    }

    @Override
    public void load(File file, Mapping mapping) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void free() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

