/*
 * Decompiled with CFR 0.152.
 */
package structurevis.structures.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import structurevis.data.Mapping;
import structurevis.structures.metadata.MetadataFromFile;

public class SequenceData1D
extends MetadataFromFile {
    public float[] data;
    public boolean[] used;
    public double min = 3.4028234663852886E38;
    public double max = 1.4E-45f;
    public boolean codonData = false;

    private SequenceData1D() {
    }

    public SequenceData1D(String name) {
        this.name = name;
    }

    public static SequenceData1D getMappedNucleotideData1D(float[] unmappedDataB, Mapping mapping, boolean codonData) {
        if (codonData) {
            SequenceData1D nd = new SequenceData1D();
            nd.data = new float[mapping.getALength()];
            for (int i = 0; i < unmappedDataB.length; ++i) {
                for (int k = 0; k < 3; ++k) {
                    int x = mapping.aToB(i * 3 + k);
                    if (x == -1) continue;
                    nd.data[i * 3 + k] = unmappedDataB[x];
                    nd.min = Math.min(nd.min, (double)unmappedDataB[x]);
                    nd.max = Math.max(nd.max, (double)unmappedDataB[x]);
                }
            }
            return nd;
        }
        SequenceData1D nd = new SequenceData1D();
        nd.data = new float[mapping.getALength()];
        for (int i = 0; i < unmappedDataB.length; ++i) {
            int x = mapping.aToB(i);
            if (x == -1) continue;
            nd.data[i] = unmappedDataB[x];
            nd.min = Math.min(nd.min, (double)unmappedDataB[x]);
            nd.max = Math.max(nd.max, (double)unmappedDataB[x]);
        }
        return nd;
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static SequenceData1D loadFromCsv(File csvFile, Mapping mapping, boolean codonData, int posColumn, int dataColumn) {
        SequenceData1D nd = null;
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(csvFile));
            String textline = buffer.readLine();
            nd = new SequenceData1D(textline.split(",")[dataColumn]);
            nd.data = new float[mapping.getALength()];
            nd.used = new boolean[mapping.getALength()];
            int x = 0;
            while ((textline = buffer.readLine()) != null) {
                String[] split = textline.split(",");
                try {
                    if (posColumn >= split.length || dataColumn >= split.length) continue;
                    int i = SequenceData1D.isInteger(split[posColumn]) ? Integer.parseInt(split[posColumn]) - 1 : x;
                    ++x;
                    float val = Float.parseFloat(split[dataColumn]);
                    if (codonData) {
                        for (int k = 0; k < 3; ++k) {
                            int a = mapping.bToA(i * 3 + k);
                            if (a == -1) continue;
                            nd.data[a] = val;
                            nd.used[a] = true;
                            nd.min = Math.min(nd.min, (double)val);
                            nd.max = Math.max(nd.max, (double)val);
                        }
                        continue;
                    }
                    int a = mapping.bToA(i);
                    System.out.println(i + "\t" + a);
                    if (a == -1) continue;
                    nd.data[a] = val;
                    nd.used[a] = true;
                    nd.min = Math.min(nd.min, (double)val);
                    nd.max = Math.max(nd.max, (double)val);
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            buffer.close();
            System.out.println(csvFile);
            for (int i = 0; i < nd.data.length; ++i) {
                System.out.println(i + "\t" + nd.data[i] + "\t" + nd.used[i]);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SequenceData1D.class.getName()).log(Level.SEVERE, null, ex);
        }
        return nd;
    }

    public static SequenceData1D combine(String name, ArrayList<SequenceData1D> data) {
        int i;
        SequenceData1D combined = null;
        int length = data.get((int)0).data.length;
        for (i = 1; i < data.size(); ++i) {
            if (length == data.get((int)i).data.length) continue;
            throw new Error("SequenceData not of equal length - 'A' mapping not correct?");
        }
        combined = new SequenceData1D(name);
        combined.data = new float[length];
        combined.used = new boolean[length];
        for (i = 0; i < data.size(); ++i) {
            SequenceData1D temp = data.get(i);
            for (int j = 0; j < length; ++j) {
                if (!temp.used[j]) continue;
                combined.data[j] = temp.data[j];
                combined.used[j] = true;
            }
            combined.min = Math.min(combined.min, temp.min);
            combined.max = Math.max(combined.max, temp.max);
        }
        return combined;
    }

    @Override
    public boolean canFree() {
        return false;
    }

    @Override
    public void load(File file, Mapping mapping) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void free() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

