/*
 * Decompiled with CFR 0.152.
 */
package structurevis.structures.metadata;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import structurevis.data.IO;
import structurevis.data.Mapping;
import structurevis.structures.metadata.MetadataFromFile;

public class NucleotideComposition
extends MetadataFromFile {
    public String name;
    File fastaAlignment;
    Mapping mapping;
    ArrayList<String> sequences = new ArrayList();
    ArrayList<String> sequenceNames = new ArrayList();
    double[] weights;
    public int[] mappedNonGapCount;
    public double[][] mappedFrequencyComposition;
    public double[][] mappedShannonComposition;
    public String consensus;

    @Override
    public boolean canFree() {
        return false;
    }

    @Override
    public void load(File file, Mapping mapping) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void free() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public NucleotideComposition() {
    }

    public NucleotideComposition(File alignmentB, Mapping mapping) {
        int i;
        this.fastaAlignment = alignmentB;
        this.mapping = mapping;
        IO.loadFastaSequences(alignmentB, this.sequences, this.sequenceNames);
        if (this.sequences.size() > 200) {
            System.out.println("::" + alignmentB);
            this.weights = new double[this.sequences.size()];
            Arrays.fill(this.weights, 1.0);
            System.out.println(this.weights.length);
        } else {
            this.weights = NucleotideComposition.getWeights(this.sequences);
        }
        double[][] unbiasedFrequencyB = NucleotideComposition.getFrequencyComposition(this.sequences, this.weights, false);
        this.mappedFrequencyComposition = new double[mapping.getALength()][4];
        for (int i2 = 0; i2 < this.mappedFrequencyComposition.length; ++i2) {
            int x = mapping.aToB(i2);
            for (int n = 0; n < this.mappedFrequencyComposition[0].length; ++n) {
                if (x == -1) continue;
                this.mappedFrequencyComposition[i2][n] = unbiasedFrequencyB[x][n];
            }
        }
        double[][] shannnonEntropyB = NucleotideComposition.getShannonEntropyComposition(this.sequences, this.weights);
        this.mappedShannonComposition = new double[mapping.getALength()][4];
        for (int i3 = 0; i3 < this.mappedShannonComposition.length; ++i3) {
            int x = mapping.aToB(i3);
            for (int n = 0; n < this.mappedShannonComposition[0].length; ++n) {
                if (x == -1) continue;
                this.mappedShannonComposition[i3][n] = shannnonEntropyB[x][n];
            }
        }
        int[] unmappedNongapCharCount = NucleotideComposition.getNumNonGappedCharacters(this.sequences);
        this.mappedNonGapCount = new int[mapping.getALength()];
        for (i = 0; i < this.mappedNonGapCount.length; ++i) {
            int x = mapping.aToB(i);
            if (x == -1) continue;
            this.mappedNonGapCount[i] = unmappedNongapCharCount[x];
        }
        this.consensus = "";
        block11: for (i = 0; i < this.mappedFrequencyComposition.length; ++i) {
            int maxFrequencyIndex = 0;
            for (int n = 1; n < 4; ++n) {
                if (!(this.mappedFrequencyComposition[i][n] > this.mappedFrequencyComposition[i][maxFrequencyIndex])) continue;
                maxFrequencyIndex = n;
            }
            if (this.mappedFrequencyComposition[i][maxFrequencyIndex] == 0.0) {
                this.consensus = this.consensus + "-";
                continue;
            }
            switch (maxFrequencyIndex) {
                case 0: {
                    this.consensus = this.consensus + "A";
                    continue block11;
                }
                case 1: {
                    this.consensus = this.consensus + "C";
                    continue block11;
                }
                case 2: {
                    this.consensus = this.consensus + "G";
                    continue block11;
                }
                case 3: {
                    this.consensus = this.consensus + "T";
                }
            }
        }
    }

    public static double[][] getFrequencyComposition(ArrayList<String> sequences, double[] weights, boolean includeGaps) {
        int seqLength = sequences.get(0).length();
        double[][] nucleotideComposition = new double[seqLength][5];
        for (int i = 0; i < seqLength; ++i) {
            int j;
            double sum = 0.0;
            double sumUngapped = 0.0;
            for (j = 0; j < sequences.size(); ++j) {
                char c = sequences.get(j).charAt(i);
                switch (c) {
                    case 'A': {
                        double[] dArray = nucleotideComposition[i];
                        dArray[0] = dArray[0] + weights[j];
                        break;
                    }
                    case 'C': {
                        double[] dArray = nucleotideComposition[i];
                        dArray[1] = dArray[1] + weights[j];
                        break;
                    }
                    case 'G': {
                        double[] dArray = nucleotideComposition[i];
                        dArray[2] = dArray[2] + weights[j];
                        break;
                    }
                    case 'T': {
                        double[] dArray = nucleotideComposition[i];
                        dArray[3] = dArray[3] + weights[j];
                        break;
                    }
                    default: {
                        double[] dArray = nucleotideComposition[i];
                        dArray[4] = dArray[4] + weights[j];
                        sumUngapped -= weights[j];
                    }
                }
                sum += weights[j];
                sumUngapped += weights[j];
            }
            if (includeGaps) {
                if (sum == 0.0) {
                    sum = 1.0;
                }
                j = 0;
                while (j < 5) {
                    double[] dArray = nucleotideComposition[i];
                    int n = j++;
                    dArray[n] = dArray[n] / sum;
                }
                continue;
            }
            if (sumUngapped == 0.0) {
                sumUngapped = 1.0;
            }
            j = 0;
            while (j < 5) {
                double[] dArray = nucleotideComposition[i];
                int n = j++;
                dArray[n] = dArray[n] / sumUngapped;
            }
        }
        return nucleotideComposition;
    }

    public static double[][] getShannonEntropyComposition(ArrayList<String> sequences, double[] weights) {
        int seqLength = sequences.get(0).length();
        double[][] nucleotideComposition = new double[seqLength][4];
        for (int i = 0; i < seqLength; ++i) {
            nucleotideComposition[i] = NucleotideComposition.getShannonEntropyAtI(sequences, i, weights);
        }
        return nucleotideComposition;
    }

    public static double[] getFrequenciesAtI(ArrayList<String> sequences, int i, double[] weights) {
        double[] fa = new double[4];
        block6: for (int j = 0; j < sequences.size(); ++j) {
            char c = sequences.get(j).charAt(i);
            switch (c) {
                case 'A': {
                    fa[0] = fa[0] + weights[j];
                    continue block6;
                }
                case 'C': {
                    fa[1] = fa[1] + weights[j];
                    continue block6;
                }
                case 'G': {
                    fa[2] = fa[2] + weights[j];
                    continue block6;
                }
                case 'T': {
                    fa[3] = fa[3] + weights[j];
                }
            }
        }
        double t = fa[0] + fa[1] + fa[2] + fa[3];
        for (int k = 0; k < 4; ++k) {
            fa[k] = fa[k] / t;
        }
        return fa;
    }

    public static int[] getNumNonGappedCharacters(ArrayList<String> sequences) {
        int[] nonGappedCharCount = new int[sequences.get(0).length()];
        for (int i = 0; i < nonGappedCharCount.length; ++i) {
            for (int j = 0; j < sequences.size(); ++j) {
                if (sequences.get(j).charAt(i) == '-') continue;
                int n = i;
                nonGappedCharCount[n] = nonGappedCharCount[n] + 1;
            }
        }
        return nonGappedCharCount;
    }

    public static double[] getShannonEntropyAtI(ArrayList<String> sequences, int i, double[] weights) {
        int n = 0;
        for (int j = 0; j < sequences.size(); ++j) {
            if (sequences.get(j).charAt(i) == '-') continue;
            ++n;
        }
        double[] fa = NucleotideComposition.getFrequenciesAtI(sequences, i, weights);
        return NucleotideComposition.getShannonEntropy(fa, n);
    }

    public static double[] getShannonEntropy(double[] fa, int n) {
        double[] ha = new double[4];
        double Hi = 0.0;
        double en = 3.0 / (2.0 * Math.log(2.0) * (double)n);
        en = 0.0;
        for (int a = 0; a < 4; ++a) {
            double log2fa = Math.log(fa[a]) / Math.log(2.0);
            if (fa[a] == 0.0) {
                Hi += 0.0;
                continue;
            }
            Hi += -(log2fa * fa[a]);
        }
        double Ri = 2.0 - (Hi + en);
        for (int a = 0; a < 4; ++a) {
            ha[a] = fa[a] * Ri;
        }
        return ha;
    }

    public static int distanceIgnoringGaps(String seq1, String seq2) {
        int dist = 0;
        int length = Math.min(seq1.length(), seq2.length());
        for (int i = 0; i < length; ++i) {
            if (seq1.charAt(i) == '-' || seq2.charAt(i) == '-' || seq1.charAt(i) == seq2.charAt(i)) continue;
            ++dist;
        }
        return dist;
    }

    public static double[][] getDistanceMatrix(ArrayList<String> sequences) {
        int len = sequences.size();
        double[][] distanceMatrix = new double[len][len];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                distanceMatrix[i][j] = NucleotideComposition.distanceIgnoringGaps(sequences.get(i), sequences.get(j));
            }
        }
        return distanceMatrix;
    }

    public static double[] getWeights(ArrayList<String> sequences) {
        if (sequences.size() == 1) {
            double[] weights = new double[sequences.size()];
            Arrays.fill(weights, 1.0);
            return weights;
        }
        double[][] distanceMatrix = NucleotideComposition.getDistanceMatrix(sequences);
        double[] weights = new double[sequences.size()];
        int i = 0;
        while (i < weights.length) {
            for (int j = 0; j < weights.length; ++j) {
                int n = i;
                weights[n] = weights[n] + distanceMatrix[i][j];
            }
            int n = i++;
            weights[n] = weights[n] / (double)weights.length;
        }
        return weights;
    }

    public static void main(String[] args) {
    }

    @Override
    public String getType() {
        return "NucleotideComposition";
    }

    @Override
    public void writeToXMLStream(XMLStreamWriter writer) throws XMLStreamException {
        try {
            writer.writeStartElement("file");
            writer.writeAttribute("fasta-file", this.fastaAlignment.getPath());
            if (this.mapping.mappingFile != null) {
                writer.writeAttribute("mapping-file", this.mapping.mappingFile.getPath());
            }
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(NucleotideComposition.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static enum CompositionType {
        FREQUENCY,
        SHANNON_ENTROPY,
        CONSENSUS;

    }
}

