/*
 * Decompiled with CFR 0.152.
 */
package structurevis.structures.metadata;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import structurevis.data.Mapping;
import structurevis.structures.metadata.Metadata;
import structurevis.ui.ColorGradient;
import structurevis.ui.DataTransform;

public class MetadataFromFile
extends Metadata {
    public String name = "";
    public String type = "";
    public ArrayList<File> files;
    public ArrayList<File> mappingFiles;
    public boolean useMin = false;
    public double min;
    public boolean useMax = false;
    public double max;
    public ArrayList<Integer> dataColumns;
    public ArrayList<Boolean> codonData;
    public DataTransform dataTransform;
    public ColorGradient colorGradient = new ColorGradient(Color.yellow, Color.red);
    public ColorGradient colorGradientSecondary = new ColorGradient(Color.yellow, Color.red);

    public MetadataFromFile() {
        this.files = new ArrayList();
        this.mappingFiles = new ArrayList();
        this.dataColumns = new ArrayList();
        this.codonData = new ArrayList();
    }

    @Override
    public String getType() {
        return "MetadataFromFile";
    }

    @Override
    public void writeToXMLStream(XMLStreamWriter writer) throws XMLStreamException {
        try {
            int i;
            String fileString;
            writer.writeStartElement("metadata-from-file");
            if (this.name != null) {
                writer.writeAttribute("name", this.name);
            }
            if (this.type != null) {
                writer.writeAttribute("type", this.type);
            }
            if (this.files != null) {
                fileString = "";
                for (i = 0; i < this.files.size(); ++i) {
                    fileString = fileString + this.files.get(i).getPath() + ";";
                }
                writer.writeAttribute("file", fileString);
            }
            if (this.mappingFiles != null) {
                fileString = "";
                for (i = 0; i < this.mappingFiles.size(); ++i) {
                    fileString = fileString + this.mappingFiles.get(i).getPath() + ";";
                }
                writer.writeAttribute("mapping-file", fileString);
            }
            if (this.codonData != null) {
                String codonString = "";
                for (i = 0; i < this.codonData.size(); ++i) {
                    codonString = codonString + this.codonData.get(i).toString() + ";";
                }
                writer.writeAttribute("codonData", codonString);
            }
            if (this.dataColumns != null) {
                String dataColumnString = "";
                for (i = 0; i < this.dataColumns.size(); ++i) {
                    dataColumnString = dataColumnString + this.dataColumns.get(i) + ";";
                }
                writer.writeAttribute("dataColumn", dataColumnString);
            }
            writer.writeAttribute("useMin", Boolean.toString(this.useMin));
            writer.writeAttribute("useMax", Boolean.toString(this.useMax));
            writer.writeAttribute("min", Double.toString(this.min));
            writer.writeAttribute("max", Double.toString(this.max));
            if (this.dataTransform != null) {
                writer.writeAttribute("transform", this.dataTransform.type.toString());
            }
            if (this.colorGradient != null) {
                writer.writeAttribute("color-gradient", this.colorGradient.toString());
            }
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(MetadataFromFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Object getData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean canFree() {
        return false;
    }

    @Override
    public void load(File file, Mapping mapping) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void free() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

