/*
 * Decompiled with CFR 0.152.
 */
package structurevis.structures.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import structurevis.structures.Structure;
import structurevis.structures.StructureCollection;
import structurevis.structures.StructureParser;
import structurevis.ui.layerpanel.GenomeOrganization;
import structurevis.ui.layerpanel.Region;

public class StructureCollectionStAXWriter {
    public static void saveStructureCollectionToFile(StructureCollection collection, File file) {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter writer = factory.createXMLStreamWriter(new FileWriter(file));
            writer.writeStartDocument();
            writer.writeCharacters("\n");
            writer.writeStartElement("structure-collection");
            if (collection != null && collection.name != null) {
                int i;
                if (collection.name != null) {
                    writer.writeAttribute("name", collection.name);
                    writer.writeAttribute("dnaSequence", Boolean.toString(collection.dnaSequence));
                    writer.writeAttribute("consensusStructure", collection.dotBracketStructure);
                }
                if (collection.genomeLength > 0) {
                    writer.writeAttribute("genomeLength", collection.genomeLength + "");
                }
                for (i = 0; i < collection.metadata.size(); ++i) {
                    writer.writeCharacters("\n");
                    writer.writeStartElement("metadata");
                    writer.writeAttribute("type", collection.metadata.get(i).getType());
                    writer.writeCharacters("\n");
                    collection.metadata.get(i).writeToXMLStream(writer);
                    writer.writeEndElement();
                }
                writer.writeCharacters("\n");
                writer.writeStartElement("structures");
                writer.writeCharacters("\n");
                for (i = 0; i < collection.structures.size(); ++i) {
                    Structure s = collection.structures.get(i);
                    writer.writeStartElement("structure");
                    writer.writeAttribute("name", s.name);
                    writer.writeAttribute("length", s.length + "");
                    writer.writeAttribute("startPosition", s.startPosition + "");
                    writer.writeCharacters("\n");
                    writer.writeStartElement("dot-bracket");
                    writer.writeCharacters(s.getDotBracketString());
                    writer.writeEndElement();
                    writer.writeCharacters("\n");
                    writer.writeEndElement();
                    writer.writeCharacters("\n");
                }
                writer.writeEndElement();
            }
            writer.writeCharacters("\n");
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(StructureCollectionStAXWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(StructureCollectionStAXWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            StructureCollection s = StructureParser.parseNaspFiles(new File("d:/Nasp/BFDV/BFDV_10Seq.out"), new File("d:/Nasp/BFDV/BFDV_10Seq.ct"));
            float[] data = new float[]{0.3f, 4.0f, 3.0f, 4.3f, 3.4f, 3.0f};
            float[][] data2D = new float[][]{{0.3f, 4.0f, 3.0f}, {4.3f, 3.4f, 3.0f}};
            GenomeOrganization genomeStructure = new GenomeOrganization();
            genomeStructure.genome.add(new Region(100, 1000, "NS1"));
            genomeStructure.genome.add(new Region(1005, 1203, "Core"));
            s.metadata.add(genomeStructure);
            StructureCollectionStAXWriter.saveStructureCollectionToFile(s, new File("output/test.xml"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

