/*
 * Decompiled with CFR 0.152.
 */
package structurevis.structures.io;

import java.awt.Color;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import structurevis.structures.Structure;
import structurevis.structures.StructureCollection;
import structurevis.structures.StructureParser;
import structurevis.structures.io.StructureCollectionStAXWriter;
import structurevis.structures.metadata.Metadata;
import structurevis.structures.metadata.MetadataFromFile;
import structurevis.structures.metadata.NucleotideComposition;
import structurevis.ui.ColorGradient;
import structurevis.ui.ColorTools;
import structurevis.ui.DataTransform;
import structurevis.ui.layerpanel.GenomeOrganization;
import structurevis.ui.layerpanel.Region;

public class StructureCollectionStAXReader
extends DefaultHandler {
    private StructureCollection collection;
    private Structure s = null;
    private CharArrayWriter contents = new CharArrayWriter();
    private String parseMetadata = null;
    private Metadata metadata = null;
    private GenomeOrganization genomeStructure = null;
    private NucleotideComposition nucleotideComposition = null;
    private MetadataFromFile metadataFromFile = null;

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        this.contents.reset();
        if (this.parseMetadata != null && this.parseMetadata.equals("GenomeStructure")) {
            if (localName.equals("region")) {
                int start = Integer.parseInt(attr.getValue("start"));
                int end = Integer.parseInt(attr.getValue("end"));
                String name = attr.getValue("name");
                int level = 0;
                if (attr.getValue("level") != null) {
                    level = Integer.parseInt(attr.getValue("level"));
                }
                Color c = Color.white;
                if (attr.getValue("color") != null) {
                    c = ColorTools.getColorFromString(attr.getValue("color"));
                }
                Region region = new Region(start, end, name);
                region.level = level;
                region.color = c;
                this.genomeStructure.genome.add(region);
            }
        } else if (this.parseMetadata != null && this.parseMetadata.equals("MetadataFromFile")) {
            if (localName.equals("metadata-from-file")) {
                int i;
                String[] split;
                if (attr.getValue("name") != null) {
                    this.metadataFromFile.name = attr.getValue("name");
                }
                if (attr.getValue("type") != null) {
                    this.metadataFromFile.type = attr.getValue("type");
                }
                if (attr.getValue("file") != null) {
                    split = attr.getValue("file").split(";");
                    this.metadataFromFile.files = new ArrayList();
                    for (i = 0; i < split.length; ++i) {
                        this.metadataFromFile.files.add(new File(split[i]));
                    }
                }
                if (attr.getValue("mapping-file") != null) {
                    split = attr.getValue("mapping-file").split(";");
                    this.metadataFromFile.mappingFiles = new ArrayList();
                    for (i = 0; i < split.length; ++i) {
                        this.metadataFromFile.mappingFiles.add(new File(split[i]));
                    }
                }
                if (attr.getValue("codonData") != null) {
                    split = attr.getValue("codonData").split(";");
                    this.metadataFromFile.codonData = new ArrayList();
                    for (i = 0; i < split.length; ++i) {
                        this.metadataFromFile.codonData.add(Boolean.parseBoolean(split[i]));
                    }
                }
                if (attr.getValue("dataColumn") != null) {
                    split = attr.getValue("dataColumn").split(";");
                    this.metadataFromFile.dataColumns = new ArrayList();
                    for (i = 0; i < split.length; ++i) {
                        if (split[i].length() <= 0) continue;
                        this.metadataFromFile.dataColumns.add(Integer.parseInt(split[i]));
                    }
                }
                if (attr.getValue("useMin") != null) {
                    this.metadataFromFile.useMin = Boolean.parseBoolean(attr.getValue("useMin"));
                }
                if (attr.getValue("useMax") != null) {
                    this.metadataFromFile.useMax = Boolean.parseBoolean(attr.getValue("useMax"));
                }
                if (attr.getValue("min") != null) {
                    this.metadataFromFile.useMin = true;
                    this.metadataFromFile.min = Double.parseDouble(attr.getValue("min"));
                }
                if (attr.getValue("max") != null) {
                    this.metadataFromFile.useMax = true;
                    this.metadataFromFile.max = Double.parseDouble(attr.getValue("max"));
                }
                if (attr.getValue("transform") != null) {
                    this.metadataFromFile.dataTransform = new DataTransform(this.metadataFromFile.min, this.metadataFromFile.max, DataTransform.TransformType.valueOf(attr.getValue("transform")));
                }
                if (attr.getValue("color-gradient") != null) {
                    this.metadataFromFile.colorGradient = ColorGradient.getValue(attr.getValue("color-gradient"));
                }
                this.metadataFromFile.colorGradientSecondary = attr.getValue("color-gradient-secondary") != null ? ColorGradient.getValue(attr.getValue("color-gradient-secondary")) : this.metadataFromFile.colorGradient;
            }
        } else if (localName.equals("structure-collection")) {
            this.collection = new StructureCollection();
            if (attr.getValue("name") != null) {
                this.collection.name = attr.getValue("name");
            }
            if (attr.getValue("genomeLength") != null) {
                this.collection.genomeLength = Integer.parseInt(attr.getValue("genomeLength"));
            }
            if (attr.getValue("circularGenome") != null) {
                this.collection.circularGenome = Boolean.parseBoolean(attr.getValue("circularGenome"));
            }
            if (attr.getValue("dnaSequence") != null) {
                this.collection.dnaSequence = Boolean.parseBoolean(attr.getValue("dnaSequence"));
            }
            if (attr.getValue("consensusStructure") != null) {
                this.collection.dotBracketStructure = attr.getValue("consensusStructure");
            }
        } else if (localName.equals("metadata")) {
            if (attr.getValue("type") != null) {
                this.parseMetadata = attr.getValue("type");
                if (this.parseMetadata.equals("GenomeStructure")) {
                    this.genomeStructure = new GenomeOrganization();
                } else if (this.parseMetadata.equals("NucleotideComposition")) {
                    this.nucleotideComposition = new NucleotideComposition();
                } else if (this.parseMetadata.equals("MetadataFromFile")) {
                    this.metadataFromFile = new MetadataFromFile();
                }
            }
        } else if (localName.equals("structure")) {
            int length = 0;
            if (attr.getValue("length") != null) {
                length = Integer.parseInt(attr.getValue("length"));
            }
            this.s = new Structure(length);
            if (attr.getValue("startPosition") != null) {
                this.s.startPosition = Integer.parseInt(attr.getValue("startPosition"));
            }
            if (attr.getValue("name") != null) {
                this.s.name = attr.getValue("name");
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals("metadata")) {
            this.parseMetadata = null;
            if (this.genomeStructure != null) {
                this.collection.metadata.add(this.genomeStructure);
                this.genomeStructure = null;
            } else if (this.nucleotideComposition != null) {
                this.collection.metadata.add(this.nucleotideComposition);
                this.nucleotideComposition = null;
            } else if (this.metadataFromFile != null) {
                this.collection.metadata.add(this.metadataFromFile);
                this.metadataFromFile = null;
            }
        } else if (localName.equals("dot-bracket") && this.s != null) {
            int[][] pairedSites = StructureParser.getPairedNucleotidePositions(this.contents.toString(), this.s.startPosition);
            this.s.pairedSites = pairedSites;
        } else if (localName.equals("structure")) {
            this.collection.structures.add(this.s);
            this.s = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    public static StructureCollection loadStructureCollectionFromFile(File file) {
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            StructureCollectionStAXReader contentHandler = new StructureCollectionStAXReader();
            xr.setContentHandler(contentHandler);
            xr.parse(new InputSource(new FileReader(file)));
            StructureCollection collection = contentHandler.collection;
            collection.file = file;
            return collection;
        }
        catch (Exception ex) {
            Logger.getLogger(StructureCollectionStAXWriter.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void main(String[] args) {
        StructureCollection collection = StructureCollectionStAXReader.loadStructureCollectionFromFile(new File("output/test.xml"));
        StructureCollectionStAXWriter.saveStructureCollectionToFile(collection, new File("output/test2.xml"));
    }
}

