/*
 * Decompiled with CFR 0.152.
 */
package structurevis.structures;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import structurevis.structures.NaspStructure;
import structurevis.structures.Structure;
import structurevis.structures.StructureCollection;

public class StructureParser {
    public static ArrayList<Structure> parseCtFile(File ctFile) throws Exception {
        ArrayList<Structure> structures = new ArrayList<Structure>();
        BufferedReader buffer = new BufferedReader(new FileReader(ctFile));
        String textline = null;
        while ((textline = buffer.readLine()) != null) {
            String[] split = textline.trim().split("(\\s)+");
            if (textline.trim().equals("")) break;
            Structure s = new Structure(Integer.parseInt(split[0]));
            s.name = split[1];
            s.sequence = "";
            for (int i = 0; i < s.length && (textline = buffer.readLine()) != null; ++i) {
                String[] split2 = textline.trim().split("(\\s)+");
                s.sequence = s.sequence + split2[1].charAt(0);
                s.pairedSites[0][i] = Integer.parseInt(split2[0]);
                s.pairedSites[1][i] = Integer.parseInt(split2[4]);
            }
            structures.add(s);
        }
        buffer.close();
        return structures;
    }

    public static Structure parseTabDelimittedHelixFile(File helixFile, int length) throws Exception {
        ArrayList<Integer> c1 = new ArrayList<Integer>();
        ArrayList<Integer> c2 = new ArrayList<Integer>();
        ArrayList<Integer> c3 = new ArrayList<Integer>();
        int len = length;
        Structure s = null;
        BufferedReader buffer = new BufferedReader(new FileReader(helixFile));
        String textline = null;
        while ((textline = buffer.readLine()) != null) {
            String[] split = textline.split("(\\s)+");
            if (split.length == 3) {
                c1.add(Integer.parseInt(split[0]));
                c2.add(Integer.parseInt(split[1]));
                c3.add(Integer.parseInt(split[2]));
                len = Math.max(len, Integer.parseInt(split[1]));
                continue;
            }
            if (textline.length() <= 0) continue;
            throw new Exception("Error parsing tab-delimitted helix file. 3 columns were expected, " + split.length + " were found.");
        }
        buffer.close();
        s = new Structure(len);
        for (int i = 0; i < c1.size(); ++i) {
            int a = (Integer)c1.get(i);
            int b = (Integer)c2.get(i);
            int helixLen = (Integer)c3.get(i);
            for (int j = 0; j < helixLen; ++j) {
                s.pairedSites[0][a - 1 + j] = a + j;
                s.pairedSites[1][a - 1 + j] = b - j;
                s.pairedSites[0][b - 1 - j] = b - j;
                s.pairedSites[1][b - 1 - j] = a + j;
            }
        }
        return s;
    }

    public static Structure parseNaspCtFile(File naspCtFile) throws Exception {
        return StructureParser.parseCtFile(naspCtFile).get(0);
    }

    public static StructureCollection parseNaspFiles(File naspFile, String dotBracketString) {
        int[][] pairedSites = StructureParser.getPairedNucleotidePositions(dotBracketString);
        StructureCollection collection = new StructureCollection();
        collection.dotBracketStructure = dotBracketString;
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(naspFile));
            String textline = null;
            boolean readStructures = false;
            while ((textline = buffer.readLine()) != null) {
                if (textline.startsWith("1:")) {
                    readStructures = true;
                } else if (textline.startsWith("Sequence shape:") && textline.toLowerCase().contains("circular")) {
                    collection.circularGenome = true;
                } else if (textline.contains("length:")) {
                    collection.genomeLength = Integer.parseInt(textline.split(":")[1].trim());
                }
                if (!readStructures) continue;
                if (textline.startsWith("---")) break;
                NaspStructure ns = NaspStructure.getNaspStructureFromString(textline);
                Structure s = null;
                int structureLength = Math.abs(ns.gappedEndB - ns.gappedStartA) + 1;
                int starta = ns.gappedStartA;
                boolean circularize = false;
                if (collection.circularGenome && structureLength > collection.genomeLength / 2) {
                    structureLength = collection.genomeLength - ns.gappedStartB + 1 + ns.gappedEndA;
                    starta = ns.gappedStartB;
                    circularize = true;
                }
                s = new Structure(structureLength);
                s.name = ns.id + "";
                s.startPosition = starta;
                int i = starta - 1;
                for (int a = 0; a < structureLength; ++a) {
                    s.pairedSites[0][a] = pairedSites[0][i];
                    s.pairedSites[1][a] = pairedSites[1][i];
                    if (circularize && s.pairedSites[0][a] > collection.genomeLength / 2) {
                        s.pairedSites[0][a] = -(-s.pairedSites[0][a] + collection.genomeLength) - 1;
                    }
                    if (circularize && s.pairedSites[1][a] > collection.genomeLength / 2) {
                        s.pairedSites[1][a] = -(-s.pairedSites[1][a] + collection.genomeLength) - 1;
                    }
                    i = (i + 1) % collection.genomeLength;
                }
                collection.structures.add(s);
            }
            buffer.close();
        }
        catch (IOException ex) {
            Logger.getLogger(StructureParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return collection;
    }

    public static StructureCollection parseNaspFiles(File naspFile, File naspCtFile) throws Exception {
        Structure consensusStructure = StructureParser.parseNaspCtFile(naspCtFile);
        StructureCollection collection = new StructureCollection();
        collection.dotBracketStructure = consensusStructure.getDotBracketString();
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(naspFile));
            String textline = null;
            boolean readStructures = false;
            while ((textline = buffer.readLine()) != null) {
                if (textline.startsWith("1:")) {
                    readStructures = true;
                } else if (textline.startsWith("Sequence shape:") && textline.toLowerCase().contains("circular")) {
                    collection.circularGenome = true;
                } else if (textline.contains("length:")) {
                    collection.genomeLength = Integer.parseInt(textline.split(":")[1].trim());
                }
                if (!readStructures) continue;
                if (textline.startsWith("---")) break;
                NaspStructure ns = NaspStructure.getNaspStructureFromString(textline);
                Structure s = null;
                int structureLength = Math.abs(ns.gappedEndB - ns.gappedStartA) + 1;
                int starta = ns.gappedStartA;
                boolean circularize = false;
                if (collection.circularGenome && structureLength > collection.genomeLength / 2) {
                    structureLength = collection.genomeLength - ns.gappedStartB + 1 + ns.gappedEndA;
                    starta = ns.gappedStartB;
                    circularize = true;
                }
                s = new Structure(structureLength);
                s.startPosition = starta;
                int i = starta - 1;
                for (int a = 0; a < structureLength; ++a) {
                    s.pairedSites[0][a] = consensusStructure.pairedSites[0][i];
                    s.pairedSites[1][a] = consensusStructure.pairedSites[1][i];
                    if (circularize && s.pairedSites[0][a] > collection.genomeLength / 2) {
                        s.pairedSites[0][a] = -(-s.pairedSites[0][a] + collection.genomeLength) - 1;
                    }
                    if (circularize && s.pairedSites[1][a] > collection.genomeLength / 2) {
                        s.pairedSites[1][a] = -(-s.pairedSites[1][a] + collection.genomeLength) - 1;
                    }
                    i = (i + 1) % collection.genomeLength;
                }
                collection.structures.add(s);
            }
            buffer.close();
        }
        catch (IOException ex) {
            Logger.getLogger(StructureParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return collection;
    }

    public static Structure parseDotBracketString(String dotBracketString) {
        Structure s = new Structure(dotBracketString.length());
        s.pairedSites = StructureParser.getPairedNucleotidePositions(dotBracketString);
        return s;
    }

    public static int[][] getPairedNucleotidePositions(String dotBracketString) {
        return StructureParser.getPairedNucleotidePositions(dotBracketString, 1);
    }

    public static int[][] getPairedNucleotidePositions(String dotBracketString, int startPosition) {
        int[][] pairedSites = new int[2][dotBracketString.length()];
        for (int i = 0; i < dotBracketString.length(); ++i) {
            pairedSites[0][i] = startPosition + i;
            int pairedPosition = 0;
            if (dotBracketString.charAt(i) != '(') continue;
            int c = 1;
            for (int j = i + 1; c != 0 && j < dotBracketString.length(); ++j) {
                if (dotBracketString.charAt(j) == '(') {
                    ++c;
                } else if (dotBracketString.charAt(j) == ')') {
                    --c;
                }
                ++pairedPosition;
            }
            if (c != 0) continue;
            pairedSites[1][i] = startPosition + i + pairedPosition;
            pairedSites[1][i + pairedPosition] = pairedSites[0][i];
        }
        return pairedSites;
    }

    public static String getDotBracketStringInverse(String dotBracketString) {
        String ret = dotBracketString.replaceAll("\\(", "A");
        ret = ret.replaceAll("\\)", "B");
        ret = ret.replaceAll("A", ")");
        ret = ret.replaceAll("B", "(");
        return ret;
    }

    public static ArrayList<Structure> enumerateAdjacentSubstructures(String dotBracketString, int minLength, int maxLength, boolean circularize) {
        int i;
        ArrayList<Structure> structures = new ArrayList<Structure>();
        int[][] pairedSites = StructureParser.getPairedNucleotidePositions(dotBracketString, 1);
        int genomeLength = dotBracketString.length();
        if (circularize) {
            int[][] pairedSitesCircularized = new int[2][genomeLength * 2];
            for (i = 0; i < genomeLength; ++i) {
                pairedSitesCircularized[0][i] = pairedSites[0][i];
                pairedSitesCircularized[1][i] = pairedSites[1][i];
            }
            for (i = 0; i < genomeLength; ++i) {
                if (pairedSites[1][i] - pairedSites[0][i] <= genomeLength / 2) continue;
                int end = pairedSites[1][i] - 1;
                pairedSitesCircularized[0][end] = pairedSites[0][end];
                pairedSitesCircularized[1][end] = pairedSites[0][i] + genomeLength;
                pairedSitesCircularized[1][i] = 0;
            }
            for (i = 0; i < genomeLength * 2; ++i) {
                pairedSitesCircularized[0][i] = i + 1;
                if (pairedSitesCircularized[1][i] == 0) continue;
                pairedSitesCircularized[0][pairedSitesCircularized[1][i] - 1] = pairedSitesCircularized[1][i];
                pairedSitesCircularized[1][pairedSitesCircularized[1][i] - 1] = pairedSitesCircularized[0][i];
            }
            pairedSites = pairedSitesCircularized;
        }
        boolean lastStructureAdded = false;
        for (i = 0; i < pairedSites[0].length; ++i) {
            int x;
            int y = pairedSites[1][i];
            if (!(y > 0 & y - (x = pairedSites[0][i]) + 1 > 0)) continue;
            Structure s = new Structure(y - x + 1);
            int[][] pairedSitesSub = new int[2][y - x + 1];
            for (int j = 0; j < pairedSitesSub[0].length; ++j) {
                pairedSitesSub[0][j] = pairedSites[0][i + j];
                pairedSitesSub[1][j] = pairedSites[1][i + j];
            }
            s.pairedSites = pairedSitesSub;
            s.startPosition = x;
            s.name = structures.size() + "";
            if (maxLength != 0 && s.length > maxLength) continue;
            i += s.length;
            if (s.length >= minLength && x + s.length < genomeLength) {
                structures.add(s);
            }
            if (lastStructureAdded || x >= genomeLength || x + s.length < genomeLength || !circularize) continue;
            structures.add(s);
            lastStructureAdded = true;
        }
        return structures;
    }

    public static ArrayList<Structure> enumerateSubstructures(String dotBracketString, int minLength, int maxLength, boolean circularize) {
        ArrayList<Structure> structures = StructureParser.enumerateAdjacentSubstructures(dotBracketString, minLength, maxLength, circularize);
        StructureParser.recursivelyEnumerateSubstructures(minLength, maxLength, structures, 0, 0);
        return structures;
    }

    private static void recursivelyEnumerateSubstructures(int minLength, int maxLength, ArrayList<Structure> structures, int startIndex, int level) {
        int added = 0;
        int end = structures.size();
        for (int k = startIndex; k < end; ++k) {
            int kAdded = 0;
            int[][] pairedSites = StructureParser.getPairedNucleotidePositions(structures.get(k).getDotBracketString(), structures.get(k).getStartPosition());
            int fullStructureLength = structures.get(k).getDotBracketString().length();
            for (int i = 0; i < pairedSites[0].length; ++i) {
                int x;
                int length;
                int y = pairedSites[1][i];
                if (!(y > 0 & (length = y - (x = pairedSites[0][i]) + 1) > 0)) continue;
                Structure s = new Structure(length);
                int[][] pairedSitesSub = new int[2][length];
                for (int j = 0; j < pairedSitesSub[0].length; ++j) {
                    pairedSitesSub[0][j] = pairedSites[0][i + j];
                    pairedSitesSub[1][j] = pairedSites[1][i + j];
                }
                s.pairedSites = pairedSitesSub;
                s.startPosition = x;
                if (maxLength != 0 && !((double)s.length < (double)fullStructureLength * 0.75)) continue;
                i += s.length;
                if (s.length < minLength || s.length >= fullStructureLength) continue;
                if (!structures.contains(s)) {
                    s.name = structures.size() + "";
                    structures.add(s);
                    ++added;
                    ++kAdded;
                    continue;
                }
                int index = structures.indexOf(s);
            }
        }
        if (added > 0) {
            StructureParser.recursivelyEnumerateSubstructures(minLength, maxLength, structures, end, level + 1);
        }
    }

    public static String getDotBracketStringFromFile(File dotBracketFile) throws Exception {
        BufferedReader buffer = new BufferedReader(new FileReader(dotBracketFile));
        String textline = buffer.readLine().trim();
        buffer.close();
        return textline;
    }

    public static boolean isDotBracketString(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '(' || text.charAt(i) == ')' || text.charAt(i) == '.') continue;
            return false;
        }
        return true;
    }
}

