/*
 * Decompiled with CFR 0.152.
 */
package structurevis.structures;

public class Structure {
    public int[][] pairedSites;
    public String name = "";
    public String sequence = "";
    public int startPosition = 0;
    public int length;
    public int index;

    public Structure(int length) {
        this.length = length;
        this.pairedSites = new int[2][length];
    }

    public String getDotBracketString() {
        String pairString = "";
        for (int i = 0; i < this.length; ++i) {
            pairString = this.pairedSites[1][i] == 0 ? pairString + "." : (this.pairedSites[0][i] < this.pairedSites[1][i] ? pairString + "(" : pairString + ")");
        }
        return pairString;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.startPosition + this.length - 1;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        return this.name + " [" + this.getStartPosition() + "-" + this.getEndPosition() + "]:" + this.getDotBracketString();
    }

    public int[][] allShortestPaths() {
        int[][] distance = new int[this.length][this.length];
        return distance;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Structure other = (Structure)obj;
        if (this.startPosition != other.startPosition) {
            return false;
        }
        return this.length == other.length;
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }
}

