/*
 * Decompiled with CFR 0.152.
 */
package structurevis.structures;

public class NaspStructure {
    public int id;
    public int gappedStartA;
    public int gappedEndA;
    public int gappedStartB;
    public int gappedEndB;
    public int ungappedStartA;
    public int ungappedEndA;
    public int ungappedStartB;
    public int ungappedEndB;
    public int length;
    public double score;
    public boolean circularGenome;
    public int genomeLength;

    public static NaspStructure getNaspStructureFromString(String line) {
        NaspStructure s = new NaspStructure();
        s.id = Integer.parseInt(line.split(":")[0]);
        String afterColon = line.split(":")[1];
        String gappedRangeA = afterColon.split("(\\|)+")[0];
        String gappedRangeB = afterColon.split("(\\|)+")[1];
        String ungappedRangeA = afterColon.split("(\\|)+")[2];
        String ungappedRangeB = afterColon.split("(\\|)+")[3];
        s.gappedStartA = Integer.parseInt(gappedRangeA.split("-")[0].trim());
        s.gappedEndA = Integer.parseInt(gappedRangeA.split("-")[1].trim());
        s.gappedStartB = Integer.parseInt(gappedRangeB.split("-")[0].trim());
        s.gappedEndB = Integer.parseInt(gappedRangeB.split("-")[1].trim());
        s.ungappedStartA = Integer.parseInt(ungappedRangeA.split("-")[0].trim());
        s.ungappedEndA = Integer.parseInt(ungappedRangeA.split("-")[1].trim());
        s.ungappedStartB = Integer.parseInt(ungappedRangeB.split("-")[0].trim());
        s.ungappedEndB = Integer.parseInt(ungappedRangeB.split("-")[1].trim());
        s.length = Integer.parseInt(afterColon.split("(\\|)+")[4].trim());
        s.score = Double.parseDouble(afterColon.split("(\\|)+")[5].trim());
        return s;
    }

    public void print() {
        System.out.println("gapped A: " + this.gappedStartA + " - " + this.gappedEndA);
        System.out.println("gapped B: " + this.gappedStartB + " - " + this.gappedEndB);
        System.out.println("ungapp A: " + this.ungappedStartA + " - " + this.ungappedEndA);
        System.out.println("ungapp B: " + this.ungappedStartB + " - " + this.ungappedEndB);
        System.out.println("length: " + this.length);
        System.out.println("score: " + this.score);
    }

    public String toString() {
        return this.id + "\t" + this.gappedStartA + "\t" + this.gappedEndA + "\t" + this.gappedStartB + "\t" + this.gappedEndB + "\t" + this.length + "\t" + this.score;
    }
}

