/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ranking;

import java.util.ArrayList;
import java.util.Collections;
import structurevis.data.SparseMatrix;
import structurevis.ranking.MyMannWhitney;
import structurevis.ranking.Ranking;
import structurevis.structures.Structure;
import structurevis.structures.metadata.SequenceData1D;
import structurevis.structures.metadata.SequenceData2D;

public class RankingAnalyses {
    double[] fullGenomeValuesAll = null;
    double[] fullGenomeValuesPaired = null;
    double[] fullGenomeValuesUnparedaired = null;

    public static double[] toDoubleArray(ArrayList<Double> array) {
        double[] values = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            values[i] = array.get(i);
        }
        return values;
    }

    public static ArrayList<Double> getValues(SequenceData1D sequenceData1D, int start, int end, boolean codon, Structure structure, boolean paired, boolean unpaired, int genomeLength) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (codon) {
            for (int i = start; i < end; i += 3) {
                boolean ispaired;
                boolean bl = ispaired = structure.pairedSites[1][i % genomeLength] != 0;
                if ((!ispaired || !paired) && (ispaired || !unpaired) || !sequenceData1D.used[i % genomeLength]) continue;
                array.add(Double.valueOf(sequenceData1D.data[i % sequenceData1D.data.length]));
            }
        } else {
            for (int i = start; i < end; ++i) {
                boolean ispaired;
                boolean bl = ispaired = structure.pairedSites[1][i % genomeLength] != 0;
                if ((!ispaired || !paired) && (ispaired || !unpaired) || !sequenceData1D.used[i % genomeLength]) continue;
                array.add(Double.valueOf(sequenceData1D.data[i % sequenceData1D.data.length]));
            }
        }
        return array;
    }

    public static Ranking rankSequenceData1D(SequenceData1D sequenceData1D, Structure substructure, int genomeLength, Structure fullStructure, boolean paired, boolean unpaired) {
        double[] ret = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        boolean codonData = false;
        ArrayList<Double> fullGenomeList = RankingAnalyses.getValues(sequenceData1D, 0, genomeLength, codonData, fullStructure, paired, unpaired, genomeLength);
        ArrayList<Double> substructureList = RankingAnalyses.getValues(sequenceData1D, substructure.startPosition - 1, substructure.startPosition + substructure.length - 1, codonData, fullStructure, paired, unpaired, genomeLength);
        double[] fullGenomeValues = RankingAnalyses.toDoubleArray(fullGenomeList);
        double[] substructureValues = RankingAnalyses.toDoubleArray(substructureList);
        double substructureMedian = Double.NaN;
        double fullGenomeMedian = Double.NaN;
        if (substructureList.size() > 0) {
            substructureMedian = RankingAnalyses.getMedian(substructureList);
        }
        if (fullGenomeList.size() > 0) {
            fullGenomeMedian = RankingAnalyses.getMedian(fullGenomeList);
        }
        MyMannWhitney mw = new MyMannWhitney(substructureValues, fullGenomeValues);
        Ranking r = new Ranking();
        r.mannWhitneyU = mw.getTestStatistic();
        r.zScore = mw.getZ();
        r.xN = substructureList.size();
        r.yN = fullGenomeList.size();
        r.xMean = RankingAnalyses.getAverage(substructureList);
        r.yMean = RankingAnalyses.getAverage(fullGenomeList);
        r.xMedian = substructureMedian;
        r.yMedian = fullGenomeMedian;
        return r;
    }

    public static ArrayList<Double> getValues(SequenceData2D sequenceData2D, int start, int end, boolean codon, Structure structure, boolean paired, boolean unpaired) {
        ArrayList<Double> array = new ArrayList<Double>();
        int length = structure.pairedSites[0].length;
        if (codon) {
            for (int i = start; i < end; i += 3) {
                double val;
                int x = structure.pairedSites[0][i % length] - 1;
                int y = structure.pairedSites[1][i % length] - 1;
                if (x == -1 || y == -1 || (val = sequenceData2D.matrix.get(x, y)) == sequenceData2D.matrix.emptyValue) continue;
                array.add(val);
            }
        } else if (paired && !unpaired) {
            for (int i = start; i < end; ++i) {
                double val;
                int x = structure.pairedSites[0][i % length] - 1;
                int y = structure.pairedSites[1][i % length] - 1;
                if (x == -1 || y == -1 || (val = sequenceData2D.matrix.get(x, y)) == sequenceData2D.matrix.emptyValue) continue;
                array.add(val);
            }
        } else {
            SparseMatrix.MatrixIterator iterator = sequenceData2D.matrix.getMatrixIterator();
            SparseMatrix.Index2D index = null;
            while (iterator.hasNext()) {
                index = iterator.next();
                if (index.i < start || index.i >= end || index.j < start || index.j >= end) continue;
                if (paired && structure.pairedSites[1][index.i] == index.j + 1) {
                    array.add(sequenceData2D.matrix.get(index.i, index.j));
                }
                if (!unpaired || structure.pairedSites[1][index.i] == index.j + 1) continue;
                array.add(sequenceData2D.matrix.get(index.i, index.j));
            }
        }
        return array;
    }

    public static Ranking rankSequenceData2D(SequenceData2D sequenceData2D, Structure substructure, int genomeLength, Structure fullStructure, boolean paired, boolean unpaired) {
        double[] ret = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        boolean codonData = false;
        ArrayList<Double> fullGenomeList = RankingAnalyses.getValues(sequenceData2D, 0, genomeLength, codonData, fullStructure, paired, unpaired);
        ArrayList<Double> substructureList = RankingAnalyses.getValues(sequenceData2D, substructure.startPosition - 1, substructure.startPosition + substructure.length - 1, codonData, fullStructure, paired, unpaired);
        if (substructure.startPosition + substructure.length - 1 >= genomeLength) {
            substructureList = RankingAnalyses.getValues(sequenceData2D, substructure.startPosition - 1, genomeLength, codonData, fullStructure, paired, unpaired);
            substructureList.addAll(RankingAnalyses.getValues(sequenceData2D, 0, (substructure.startPosition + substructure.length - 1) % genomeLength, codonData, fullStructure, paired, unpaired));
        }
        double[] fullGenomeValues = RankingAnalyses.toDoubleArray(fullGenomeList);
        double[] substructureValues = RankingAnalyses.toDoubleArray(substructureList);
        double substructureMedian = Double.NaN;
        double fullGenomeMedian = Double.NaN;
        if (substructureList.size() > 0) {
            substructureMedian = RankingAnalyses.getMedian(substructureList);
        }
        if (fullGenomeList.size() > 0) {
            fullGenomeMedian = RankingAnalyses.getMedian(fullGenomeList);
        }
        MyMannWhitney mw = new MyMannWhitney(substructureValues, fullGenomeValues);
        Ranking r = new Ranking();
        r.mannWhitneyU = mw.getTestStatistic();
        r.zScore = mw.getZ();
        r.xN = substructureList.size();
        r.yN = fullGenomeList.size();
        r.xMean = RankingAnalyses.getAverage(substructureList);
        r.yMean = RankingAnalyses.getAverage(fullGenomeList);
        r.xMedian = substructureMedian;
        r.yMedian = fullGenomeMedian;
        return r;
    }

    public static double getAverage(ArrayList<Double> list) {
        double sum = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            sum += list.get(i).doubleValue();
        }
        return sum / (double)list.size();
    }

    public static double getMedian(ArrayList<Double> list) {
        if (list.size() % 2 == 1) {
            return RankingAnalyses.select(list, list.size() / 2 + 1);
        }
        Double x = RankingAnalyses.select(list, list.size() / 2 + 1);
        Double y = RankingAnalyses.select(list, list.size() / 2 + 1 + 1);
        return (x + y) / 2.0;
    }

    public static double getMedian2(ArrayList<Double> list) {
        if (list.size() == 0) {
            return Double.NaN;
        }
        Collections.sort(list);
        if (list.size() % 2 == 1) {
            return list.get(list.size() / 2);
        }
        Double x = list.get(list.size() / 2);
        Double y = list.get(list.size() / 2 + 1);
        return (x + y) / 2.0;
    }

    public static Double select(ArrayList<Double> list, int k) {
        if (list.size() <= 10) {
            Collections.sort(list);
            return list.get(Math.min(k - 1, list.size() - 1));
        }
        int numSubsets = list.size() / 5;
        ArrayList[] subsets = new ArrayList[numSubsets];
        for (int i = 0; i < numSubsets; ++i) {
            subsets[i] = new ArrayList();
            for (int j = 0; j < 5; ++j) {
                subsets[i].add(list.get(i * 5 + j));
            }
        }
        ArrayList<Double> x = new ArrayList<Double>(numSubsets);
        for (int i = 0; i < numSubsets; ++i) {
            x.add(RankingAnalyses.select(subsets[i], 3));
        }
        Double M = RankingAnalyses.select(x, list.size() / 10);
        ArrayList<Double> L1 = new ArrayList<Double>();
        ArrayList<Double> L2 = new ArrayList<Double>();
        ArrayList<Double> L3 = new ArrayList<Double>();
        for (int i = 0; i < list.size(); ++i) {
            Double item = list.get(i);
            if (item.compareTo(M) < 0) {
                L1.add(item);
                continue;
            }
            if (item.compareTo(M) > 0) {
                L3.add(item);
                continue;
            }
            L2.add(item);
        }
        if (k <= L1.size()) {
            return RankingAnalyses.select(L1, k);
        }
        if (k > L1.size() + L2.size()) {
            return RankingAnalyses.select(L3, k - L1.size() - L2.size());
        }
        return M;
    }

    public static double NormalZ(double Z) {
        double NormalZx = 0.0;
        double Z_MAX = 6.0;
        if (Math.abs(Z) < 5.9999999) {
            if (Z == 0.0) {
                double X = 0.0;
            } else {
                double X;
                double Y = 0.5 * Math.abs(Z);
                if (Y >= Z_MAX * 0.5) {
                    X = 1.0;
                } else if (Y < 1.0) {
                    double w = Y * Y;
                    X = ((((((((1.24818987E-4 * w - 0.001075204047) * w + 0.005198775019) * w - 0.019198292004) * w + 0.059054035642) * w - 0.151968751364) * w + 0.319152932694) * w - 0.5319230073) * w + 0.797884560593) * Y * 2.0;
                } else {
                    X = (((((((((((((-4.5255659E-5 * (Y -= 2.0) + 1.5252929E-4) * Y - 1.9538132E-5) * Y - 6.76904986E-4) * Y + 0.001390604284) * Y - 7.9462082E-4) * Y - 0.002034254874) * Y + 0.006549791214) * Y - 0.010557625006) * Y + 0.011630447319) * Y - 0.009279453341) * Y + 0.005353579108) * Y - 0.002141268741) * Y + 5.35310849E-4) * Y + 0.999936657524;
                }
                NormalZx = X + 1.0 < 1.0 - X ? X + 1.0 : 1.0 - X;
            }
        } else {
            double temp = (Math.abs(Z) - 5.999999) * 10.0;
            double Temp2 = Math.pow(1.6, temp);
            double WinP = Math.pow(10.0, -9.0);
            NormalZx = WinP /= Temp2;
        }
        return NormalZx;
    }
}

