/*
 * Decompiled with CFR 0.152.
 */
package structurevis.ranking;

import java.util.Enumeration;
import java.util.Hashtable;

public class MyMannWhitney {
    double ux = 0.0;
    double uy = 0.0;
    double nx;
    double ny;
    double N;
    double tieCorrectionFactor = 0.0;
    Hashtable<Double, Double> groups = new Hashtable();

    public double getGroup(double value) {
        Double val = this.groups.get(value);
        if (val != null) {
            return val;
        }
        return 0.0;
    }

    public MyMannWhitney(double[] x, double[] y) {
        int i;
        int i2;
        this.nx = x.length;
        this.ny = y.length;
        this.N = this.nx + this.ny;
        for (i2 = 0; i2 < x.length; ++i2) {
            this.groups.put(x[i2], this.getGroup(x[i2]) + 1.0);
        }
        for (i2 = 0; i2 < y.length; ++i2) {
            this.groups.put(y[i2], this.getGroup(y[i2]) + 1.0);
        }
        double[] counts_x = new double[x.length];
        double[] counts_y = new double[y.length];
        for (i = 0; i < x.length; ++i) {
            for (int j = 0; j < y.length; ++j) {
                if (x[i] == y[j]) {
                    int n = i;
                    counts_x[n] = counts_x[n] + 0.5;
                    int n2 = j;
                    counts_y[n2] = counts_y[n2] + 0.5;
                    continue;
                }
                if (x[i] > y[j]) {
                    int n = i;
                    counts_x[n] = counts_x[n] + 1.0;
                    continue;
                }
                int n = j;
                counts_y[n] = counts_y[n] + 1.0;
            }
        }
        for (i = 0; i < counts_x.length; ++i) {
            this.ux += counts_x[i];
        }
        for (i = 0; i < counts_y.length; ++i) {
            this.uy += counts_y[i];
        }
        this.tieCorrectionFactor = 0.0;
        Enumeration<Double> keys = this.groups.keys();
        while (keys.hasMoreElements()) {
            double c = this.groups.get(keys.nextElement());
            double q = (Math.pow(c, 3.0) - c) / 12.0;
            this.tieCorrectionFactor += q;
        }
    }

    public double getTestStatistic() {
        return Math.max(this.ux, this.uy);
    }

    public double getZ() {
        double n = this.nx * this.ny / (this.N * (this.N - 1.0));
        double d = (Math.pow(this.N, 3.0) - this.N) / 12.0 - this.tieCorrectionFactor;
        double variance = Math.sqrt(n * d);
        return (this.ux - this.nx * this.ny / 2.0) / variance;
    }
}

