/*
 * Decompiled with CFR 0.152.
 */
package structurevis.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import structurevis.data.IO;
import structurevis.data.SparseMatrix;
import structurevis.structures.metadata.NucleotideComposition;

public class DataConverter {
    Hashtable<Integer, File> fileTable = new Hashtable();
    Hashtable<Integer, Double> percentNonGapsTable = new Hashtable();
    Hashtable<Integer, Double> conservationTable = new Hashtable();

    public DataConverter(File dir) {
        this.fileTable = DataConverter.getFileListing(dir, ".fas");
    }

    public static void convertSpidermonkeyMatrixToPairwise2DDelimitted(File input, File output, double pvalLessThanOrEqual, double rgainedGreaterThanOrEqual, double rgainedLessThanOrEqual, boolean printPvals) {
        String delimitter = "\t";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(input));
            BufferedWriter writer = new BufferedWriter(new FileWriter(output));
            String textline = null;
            while ((textline = reader.readLine()) != null) {
                String[] split = textline.split("\\s+");
                int i = Integer.parseInt(split[0]);
                int j = Integer.parseInt(split[1]);
                double pval = Double.parseDouble(split[4]);
                double rgained = Double.parseDouble(split[5]);
                if (!(pval <= pvalLessThanOrEqual) || !(rgained <= rgainedLessThanOrEqual) || !(rgained >= rgainedGreaterThanOrEqual)) continue;
                if (printPvals) {
                    writer.write(i + delimitter + j + delimitter + pval + "\n");
                    continue;
                }
                writer.write(i + delimitter + j + delimitter + rgained + "\n");
            }
            writer.close();
            reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void filterValuesOnGaps(File tabDelimittedMatrixIn, File tabDelimittedMatrixOut, double percentNonGapsCutOff) {
        SparseMatrix in = SparseMatrix.loadSparseMatrixFromPairwiseFile(tabDelimittedMatrixIn, "\t");
        SparseMatrix out = new SparseMatrix(in.m, in.n, in.emptyValue);
        SparseMatrix.MatrixIterator it = in.getMatrixIterator();
        while (it.hasNext()) {
            SparseMatrix.Index2D index = it.next();
            double percNonGapsAtI = this.getPercentNonGaps(index.i);
            double percNonGapsAtJ = this.getPercentNonGaps(index.j);
            if (!(percNonGapsAtI >= percentNonGapsCutOff) || !(percNonGapsAtJ >= percentNonGapsCutOff)) continue;
            out.set(index.i, index.j, in.get(index.i, index.j));
        }
        out.saveSparseMatrixToFile(tabDelimittedMatrixOut);
    }

    public void filterValuesOnConservation(File tabDelimittedMatrixIn, File tabDelimittedMatrixOut, double percentNonGapsCutOff) {
        SparseMatrix in = SparseMatrix.loadSparseMatrixFromPairwiseFile(tabDelimittedMatrixIn, "\t");
        SparseMatrix out = new SparseMatrix(in.m, in.n, in.emptyValue);
        SparseMatrix.MatrixIterator it = in.getMatrixIterator();
        while (it.hasNext()) {
            SparseMatrix.Index2D index = it.next();
            double percNonGapsAtI = this.getConservation(index.i) / 2.0;
            double percNonGapsAtJ = this.getConservation(index.j) / 2.0;
            if (!(percNonGapsAtI <= percentNonGapsCutOff) || !(percNonGapsAtJ <= percentNonGapsCutOff)) continue;
            out.set(index.i, index.j, in.get(index.i, index.j));
        }
        out.saveSparseMatrixToFile(tabDelimittedMatrixOut);
    }

    public double getPercentNonGaps(int pos) {
        int start;
        int posInFile;
        Double percentNonGaps = this.percentNonGapsTable.get(pos);
        if (percentNonGaps != null) {
            return percentNonGaps;
        }
        File sequenceFile = this.fileTable.get(pos);
        if (sequenceFile != null && (posInFile = pos - (start = Integer.parseInt(sequenceFile.getName().split("_")[1]))) >= 0) {
            ArrayList<String> sequences = new ArrayList<String>();
            ArrayList<String> sequenceNames = new ArrayList<String>();
            IO.loadFastaSequences(sequenceFile, sequences, sequenceNames);
            int[] ungapped = NucleotideComposition.getNumNonGappedCharacters(sequences);
            if (posInFile < ungapped.length) {
                double nonGapPercent = (double)ungapped[posInFile] / (double)sequences.size();
                this.percentNonGapsTable.put(pos, nonGapPercent);
                return nonGapPercent;
            }
        }
        return -1.0;
    }

    public double getConservation(int pos) {
        int start;
        int posInFile;
        Double conservationVal = this.conservationTable.get(pos);
        if (conservationVal != null) {
            return conservationVal;
        }
        File sequenceFile = this.fileTable.get(pos);
        if (sequenceFile != null && (posInFile = pos - (start = Integer.parseInt(sequenceFile.getName().split("_")[1]))) >= 0) {
            ArrayList<String> sequences = new ArrayList<String>();
            ArrayList<String> sequenceNames = new ArrayList<String>();
            IO.loadFastaSequences(sequenceFile, sequences, sequenceNames);
            if (posInFile < sequences.get(0).length()) {
                double[] weights = new double[sequences.size()];
                Arrays.fill(weights, 1.0);
                double[] fa = NucleotideComposition.getShannonEntropyAtI(sequences, posInFile, weights);
                double conservationValue = fa[0];
                for (int i = 1; i < 4; ++i) {
                    conservationValue = Math.max(conservationValue, fa[i]);
                }
                this.conservationTable.put(pos, conservationValue);
                return conservationValue;
            }
        }
        return -1.0;
    }

    public static Hashtable<Integer, File> getFileListing(File dir, String extension) {
        Hashtable<Integer, File> fileTable = new Hashtable<Integer, File>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String[] split;
            String name = files[i].getName();
            if (!name.endsWith(".fas") || !(split = (name = name.replaceAll("\\.fas$", "")).split("_"))[0].equals("id")) continue;
            int start = Integer.parseInt(split[1]);
            int end = Integer.parseInt(split[2]);
            for (int j = start; j < end; ++j) {
                fileTable.put(j, files[i]);
            }
        }
        return fileTable;
    }

    public static void main(String[] args) {
        File inputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enterob.txt");
        File outputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enterob_svis.txt");
        DataConverter.convertSpidermonkeyMatrixToPairwise2DDelimitted(inputFile, outputFile, 1.0, 1.0, Double.MAX_VALUE, true);
        inputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enterob.txt");
        outputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enterob_svis_avoidance.txt");
        DataConverter.convertSpidermonkeyMatrixToPairwise2DDelimitted(inputFile, outputFile, 1.0, 0.0, 1.0, true);
        inputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enteroa.txt");
        outputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enteroa_svis.txt");
        DataConverter.convertSpidermonkeyMatrixToPairwise2DDelimitted(inputFile, outputFile, 1.0, 1.0, Double.MAX_VALUE, true);
        inputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enteroa.txt");
        outputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enteroa_svis_avoidance.txt");
        DataConverter.convertSpidermonkeyMatrixToPairwise2DDelimitted(inputFile, outputFile, 1.0, 0.0, 1.0, true);
        inputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enteroc.txt");
        outputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enteroc_svis.txt");
        DataConverter.convertSpidermonkeyMatrixToPairwise2DDelimitted(inputFile, outputFile, 1.0, 1.0, Double.MAX_VALUE, true);
        inputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enteroc.txt");
        outputFile = new File("C:/Users/Michael/Dropbox/BrejAndMichael/Emil/enteroc_svis_avoidance.txt");
        DataConverter.convertSpidermonkeyMatrixToPairwise2DDelimitted(inputFile, outputFile, 1.0, 0.0, 1.0, true);
    }
}

