/*
 * Decompiled with CFR 0.152.
 */
package structurevis.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ParrisData {
    public int numSites = 0;
    public int numRateClasses;
    public int numSynonymousRateClasses;
    public double[] rateClasses;
    public double[][] posteriorProbabilities;
    public double[] weightedOmega;
    public double[] weightedSynonymous;
    public double[] weightedOmegaNormalised;
    public double[] weightedSynonymousNormalised;

    public ParrisData(File file) {
        int j;
        int i;
        String[] split;
        boolean readTable;
        String textline;
        BufferedReader buffer;
        try {
            buffer = new BufferedReader(new FileReader(file));
            textline = null;
            readTable = false;
            int synonmousColStart = -1;
            while ((textline = buffer.readLine()) != null) {
                if (readTable && textline.matches("^[0-9]+.*$")) {
                    ++this.numSites;
                }
                if (!textline.matches("^Rates/Site(\\s)*Omega=.*$")) continue;
                split = textline.split("(\\s)+");
                this.numRateClasses = split.length - 1;
                int j2 = 0;
                for (i = 0; i < split.length; ++i) {
                    if (!split[i].startsWith("S=")) continue;
                    if (synonmousColStart == -1) {
                        synonmousColStart = i;
                    }
                    ++j2;
                }
                this.numSynonymousRateClasses = j2;
                this.rateClasses = new double[this.numRateClasses];
                for (i = 0; i < this.numRateClasses; ++i) {
                    this.rateClasses[i] = Double.parseDouble(split[i + 1].replaceAll("[a-zA-Z]+=", ""));
                }
                readTable = true;
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.posteriorProbabilities = new double[this.numRateClasses][this.numSites];
        try {
            buffer = new BufferedReader(new FileReader(file));
            textline = null;
            readTable = false;
            int j3 = 0;
            while ((textline = buffer.readLine()) != null) {
                if (readTable && textline.matches("^[0-9]+.*$")) {
                    split = textline.split("(\\s)+");
                    for (int i2 = 0; i2 < this.numRateClasses; ++i2) {
                        this.posteriorProbabilities[i2][j3] = Double.parseDouble(split[i2 + 1]);
                    }
                    ++j3;
                }
                if (!textline.matches("^Rates/Site(\\s)*Omega=.*$")) continue;
                readTable = true;
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.weightedOmega = new double[this.numSites];
        for (j = 0; j < this.numSites; ++j) {
            for (int i3 = 0; i3 < this.numRateClasses - this.numSynonymousRateClasses; ++i3) {
                int n = j;
                this.weightedOmega[n] = this.weightedOmega[n] + this.rateClasses[i3] * this.posteriorProbabilities[i3][j];
            }
        }
        this.weightedSynonymous = new double[this.numSites];
        for (j = 0; j < this.numSites; ++j) {
            for (int i4 = this.numRateClasses - this.numSynonymousRateClasses; i4 < this.numRateClasses; ++i4) {
                int n = j;
                this.weightedSynonymous[n] = this.weightedSynonymous[n] + this.rateClasses[i4] * this.posteriorProbabilities[i4][j];
            }
        }
        this.weightedOmegaNormalised = new double[this.numSites];
        double maxomega = 0.0;
        for (int i5 = 0; i5 < this.numRateClasses - this.numSynonymousRateClasses; ++i5) {
            maxomega = Math.max(maxomega, this.rateClasses[i5]);
        }
        double power = Math.log(2.0) / Math.log(maxomega);
        for (int i6 = 0; i6 < this.weightedOmega.length; ++i6) {
            this.weightedOmegaNormalised[i6] = Math.pow(this.weightedOmega[i6], power);
        }
        this.weightedSynonymousNormalised = new double[this.numSites];
        double maxds = 0.0;
        for (i = this.numRateClasses - this.numSynonymousRateClasses; i < this.numRateClasses; ++i) {
            maxds = Math.max(maxds, this.rateClasses[i]);
        }
        power = Math.log(2.0) / Math.log(maxds);
        for (i = 0; i < this.weightedSynonymous.length; ++i) {
            this.weightedSynonymousNormalised[i] = Math.pow(this.weightedSynonymous[i], power);
        }
    }

    public void saveToCSV(File csvFile) {
        try {
            int i;
            BufferedWriter buffer = new BufferedWriter(new FileWriter(csvFile));
            buffer.write("Codon,");
            for (i = 0; i < this.numRateClasses - this.numSynonymousRateClasses; ++i) {
                buffer.write("Omega=" + this.rateClasses[i] + ",");
            }
            for (i = this.numSynonymousRateClasses; i < this.numRateClasses; ++i) {
                buffer.write("S=" + this.rateClasses[i] + ",");
            }
            buffer.write("Weighted Omega,Weighted dS,Weighted Omega normalised,Weighted dS normalised\n");
            for (i = 0; i < this.weightedSynonymous.length; ++i) {
                buffer.write(i + 1 + ",");
                for (int j = 0; j < this.numRateClasses; ++j) {
                    buffer.write(this.posteriorProbabilities[j][i] + ",");
                }
                buffer.write(this.weightedOmega[i] + ",");
                buffer.write(this.weightedSynonymous[i] + ",");
                buffer.write(this.weightedOmegaNormalised[i] + ",");
                buffer.write(this.weightedSynonymousNormalised[i] + "\n");
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

