/*
 * Decompiled with CFR 0.152.
 */
package structurevis.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import structurevis.data.CollateData;
import structurevis.data.IO;

public class Mapping {
    public static String MUSCLE_EXECUTABLE = "muscle3.8.31_i86win32.exe";
    private static final char GAP_CHARACTER = 'N';
    public static boolean impute = false;
    public static boolean imputeRandomN = true;
    public static double gapOpen = -500.0;
    public static double gapExtend = -1.0;
    public static int s = 1;
    public String alignedA0;
    public String alignedB0;
    public File mappingFile;
    public boolean bReversedComplemented = false;
    Hashtable<Integer, Integer> aToReference = new Hashtable();
    Hashtable<Integer, Integer> bToReference = new Hashtable();
    Hashtable<Integer, Integer> referenceToA = new Hashtable();
    Hashtable<Integer, Integer> referenceToB = new Hashtable();
    int refLen;

    public static void setMuscleExecutable(String muscleExecutable) {
        MUSCLE_EXECUTABLE = muscleExecutable;
    }

    public static void setAlignmentParameters(double gapOpen, double gapExtend, int s) {
        Mapping.gapOpen = gapOpen;
        Mapping.gapExtend = gapExtend;
        Mapping.s = s;
    }

    private Mapping() {
    }

    public int aToRef(int i) {
        Integer coordinate = this.aToReference.get(i);
        if (coordinate == null) {
            return -1;
        }
        return coordinate;
    }

    public int bToRef(int i) {
        Integer coordinate = this.bToReference.get(i);
        if (coordinate == null) {
            return -1;
        }
        return coordinate;
    }

    public int refToA(int i) {
        Integer coordinate = this.referenceToA.get(i);
        if (coordinate == null) {
            return -1;
        }
        return coordinate;
    }

    public int refToB(int i) {
        Integer coordinate = this.referenceToB.get(i);
        if (coordinate == null) {
            return -1;
        }
        return coordinate;
    }

    public int aToB(int i) {
        return this.refToB(this.aToRef(i));
    }

    public int aToBNearest(int i) {
        int l = 0;
        while (i - l >= 0 && this.aToB(i - l) == -1) {
            ++l;
        }
        int u = 0;
        while (i + u < this.getALength() && this.aToB(i + u) == -1) {
            ++u;
        }
        if (l < u) {
            return this.aToB(i - l);
        }
        return this.aToB(i + u);
    }

    public int bToA(int i) {
        return this.refToA(this.bToRef(i));
    }

    public int bToANearest(int i) {
        int l = 0;
        while (i - l >= 0 && this.bToA(i - l) == -1) {
            ++l;
        }
        int u = 0;
        while (i + u < this.getBLength() && this.bToA(i + u) == -1) {
            ++u;
        }
        int pos = Math.max(this.bToA(i - l), this.bToA(i + u));
        if (l < u && this.bToA(i - l) != -1) {
            return this.bToA(i - l);
        }
        if (l > u && this.bToA(i + u) != -1) {
            return this.bToA(i + u);
        }
        return pos;
    }

    public int getALength() {
        return Mapping.getUngappedPosition(this.alignedA0, this.alignedA0.length());
    }

    public int getBLength() {
        return Mapping.getUngappedPosition(this.alignedB0, this.alignedB0.length());
    }

    public int getRefLength() {
        return this.refLen;
    }

    public static int getUngappedPosition(String sequence, int gappedPos) {
        int ungappedPos = -1;
        int i = 0;
        int end = Math.min(sequence.length() - 1, gappedPos);
        for (i = 0; i <= end; ++i) {
            if (sequence.charAt(i) == '-') continue;
            ++ungappedPos;
        }
        if (i == gappedPos) {
            return ungappedPos + 1;
        }
        return ungappedPos;
    }

    public static String reverseComplement(String s) {
        StringBuffer sb = new StringBuffer(s);
        String rev = sb.reverse().toString();
        rev = rev.replaceAll("A", "1").replaceAll("C", "2").replaceAll("G", "3").replaceAll("T", "4");
        rev = rev.replaceAll("1", "T").replaceAll("2", "G").replaceAll("3", "C").replaceAll("4", "A");
        return rev;
    }

    public static Mapping createMappingWithRestrictionsAutoDirection(File alignmentA, File alignmentB, int select, int aStart, int aEnd, int bStart, int bEnd) {
        int e;
        int s;
        String seqi;
        int i;
        ArrayList<String> sequencesA = new ArrayList<String>();
        ArrayList<String> sequencesNamesA = new ArrayList<String>();
        ArrayList<String> sequencesB = new ArrayList<String>();
        ArrayList<String> sequencesNamesB = new ArrayList<String>();
        IO.loadFastaSequences(alignmentA, sequencesA, sequencesNamesA);
        IO.loadFastaSequences(alignmentB, sequencesB, sequencesNamesB);
        ArrayList<String> sequencesAmod = new ArrayList<String>();
        ArrayList<String> sequencesBmod = new ArrayList<String>();
        for (i = 0; i < sequencesA.size(); ++i) {
            seqi = sequencesA.get(i);
            s = Math.min(seqi.length() - 1, Math.max(aStart, 0));
            e = Math.min(Math.max(s, aEnd == -1 ? seqi.length() : aEnd), seqi.length());
            sequencesAmod.add(seqi.substring(s, e));
        }
        for (i = 0; i < sequencesB.size(); ++i) {
            seqi = sequencesB.get(i);
            s = Math.min(seqi.length() - 1, Math.max(bStart, 0));
            e = Math.min(Math.max(s, bEnd == -1 ? seqi.length() : bEnd), seqi.length());
            sequencesBmod.add(seqi.substring(s, e));
        }
        File restrictedA = new File("a.fas");
        File restrictedB = new File("b.fas");
        IO.saveToFASTAfile(sequencesAmod, sequencesNamesA, restrictedA);
        IO.saveToFASTAfile(sequencesBmod, sequencesNamesB, restrictedB);
        Mapping mapping = Mapping.createMapping(restrictedA, restrictedB, select);
        String seqA0 = sequencesA.get(0);
        int s2 = Math.min(mapping.alignedA0.length() - 1, Math.max(aStart, 0));
        int e2 = Math.max(s2, aEnd == -1 ? mapping.alignedA0.length() : aEnd);
        mapping.alignedA0 = Mapping.nChar('-', s2) + mapping.alignedA0 + Mapping.nChar('-', e2 - s2);
        String seqB0 = sequencesB.get(0);
        s2 = Math.min(mapping.alignedB0.length() - 1, Math.max(bStart, 0));
        e2 = Math.max(s2, bEnd == -1 ? mapping.alignedB0.length() : bEnd);
        mapping.alignedB0 = Mapping.nChar('-', s2) + mapping.alignedB0 + Mapping.nChar('-', e2 - s2);
        return mapping;
    }

    public static String nChar(char c, int n) {
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + c;
        }
        return s;
    }

    public static Mapping createMappingWithRestrictions(File alignmentA, File alignmentB, int select, boolean reverseComplementB, String outputfileName, int aStart, int aEnd, int bStart, int bEnd) {
        int e;
        int s;
        String seqi;
        int i;
        ArrayList<String> sequencesA = new ArrayList<String>();
        ArrayList<String> sequencesNamesA = new ArrayList<String>();
        ArrayList<String> sequencesB = new ArrayList<String>();
        ArrayList<String> sequencesNamesB = new ArrayList<String>();
        IO.loadFastaSequences(alignmentA, sequencesA, sequencesNamesA);
        IO.loadFastaSequences(alignmentB, sequencesB, sequencesNamesB);
        for (i = 0; i < sequencesA.size(); ++i) {
            seqi = sequencesA.get(i);
            s = Math.min(seqi.length() - 1, aStart);
            e = Math.max(s, aEnd);
            sequencesA.set(i, seqi.substring(s, e));
        }
        for (i = 0; i < sequencesB.size(); ++i) {
            seqi = sequencesB.get(i);
            s = Math.min(seqi.length() - 1, bStart);
            e = Math.max(s, bEnd);
            sequencesB.set(i, seqi.substring(s, e));
        }
        File restrictedA = new File("a.fas");
        File restrictedB = new File("b.fas");
        IO.saveToFASTAfile(sequencesA, sequencesNamesA, restrictedA);
        IO.saveToFASTAfile(sequencesB, sequencesNamesB, restrictedB);
        return Mapping.createMapping(restrictedA, restrictedB, select, reverseComplementB, outputfileName);
    }

    public static Mapping createMapping(File alignmentA, File alignmentB, int select, boolean reverseComplementB, String outputfileName) {
        Mapping mapping = null;
        ArrayList<String> sequencesA = new ArrayList<String>();
        ArrayList<String> sequencesNamesA = new ArrayList<String>();
        ArrayList<String> sequencesB = new ArrayList<String>();
        ArrayList<String> sequencesNamesB = new ArrayList<String>();
        int maxSequencesToLoad = Math.max(s, 100);
        IO.loadFastaSequences(alignmentA, sequencesA, sequencesNamesA, maxSequencesToLoad);
        IO.loadFastaSequences(alignmentB, sequencesB, sequencesNamesB, maxSequencesToLoad);
        try {
            int i;
            BufferedWriter buffer = new BufferedWriter(new FileWriter("inputfile.fasta"));
            if (impute) {
                CollateData.impute(sequencesA, s);
                CollateData.impute(sequencesB, s);
            } else if (imputeRandomN) {
                int removeIndex;
                Random random = new Random(-8813712038722450337L);
                int N = 50;
                while (sequencesA.size() > N && sequencesA.size() > s) {
                    removeIndex = s + random.nextInt(sequencesA.size() - s);
                    sequencesA.remove(removeIndex);
                    sequencesNamesA.remove(removeIndex);
                }
                while (sequencesB.size() > N && sequencesB.size() > s) {
                    removeIndex = s + random.nextInt(sequencesB.size() - s);
                    sequencesB.remove(removeIndex);
                    sequencesNamesB.remove(removeIndex);
                }
                CollateData.impute(sequencesA, s);
                CollateData.impute(sequencesB, s);
            }
            for (i = 0; i < select && i < sequencesA.size(); ++i) {
                buffer.write(">a" + i);
                buffer.newLine();
                buffer.write(sequencesA.get(i).replaceAll("-", "N"));
                buffer.newLine();
            }
            for (i = 0; i < select && i < sequencesB.size(); ++i) {
                buffer.write(">b" + i);
                buffer.newLine();
                if (reverseComplementB) {
                    buffer.write(Mapping.reverseComplement(sequencesB.get(i)).replaceAll("-", "N"));
                } else {
                    buffer.write(sequencesB.get(i).replaceAll("-", "N"));
                }
                buffer.newLine();
            }
            buffer.close();
            if (s >= 1) {
                String cmd = MUSCLE_EXECUTABLE + " -in inputfile.fasta -out " + outputfileName + " -gapopen " + gapOpen + " -gapextend " + gapExtend;
                Process p = Runtime.getRuntime().exec(cmd);
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                String textline = null;
                while ((textline = reader.readLine()) != null) {
                    System.err.println(textline);
                }
                reader.close();
                if (p.waitFor() == 0) {
                    ArrayList<String> alignedSequences = new ArrayList<String>();
                    ArrayList<String> alignedSequenceNames = new ArrayList<String>();
                    IO.loadFastaSequences(new File(outputfileName), alignedSequences, alignedSequenceNames);
                    String alignedA0 = null;
                    String alignedB0 = null;
                    for (int i2 = 0; i2 < alignedSequences.size(); ++i2) {
                        if (alignedSequenceNames.get(i2).startsWith("a")) {
                            alignedA0 = alignedSequences.get(i2);
                        }
                        if (!alignedSequenceNames.get(i2).startsWith("b")) continue;
                        alignedB0 = alignedSequences.get(i2);
                    }
                    mapping = Mapping.getMappingFromAlignedStrings(alignedA0, alignedB0, reverseComplementB);
                }
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return mapping;
    }

    public static Mapping createMapping(File alignmentA, File alignmentB, int select) {
        if (alignmentA.length() == alignmentB.length() && IO.contentEquals(alignmentA, alignmentB)) {
            ArrayList<String> sequencesA = new ArrayList<String>();
            ArrayList<String> sequencesNamesA = new ArrayList<String>();
            IO.loadFastaSequences(alignmentA, sequencesA, sequencesNamesA);
            return Mapping.getMappingFromAlignedStrings(sequencesA.get(0), sequencesA.get(0), false);
        }
        Mapping mapping = Mapping.createMapping(alignmentA, alignmentB, select, false, "mappingforward.fas");
        Mapping reverseMapping = Mapping.createMapping(alignmentA, alignmentB, select, true, "mappingreverse.fas");
        double m1 = 0.0;
        double t1 = 0.0;
        for (int i = 0; i < mapping.alignedA0.length(); ++i) {
            if (mapping.alignedA0.charAt(i) == mapping.alignedB0.charAt(i) || mapping.alignedA0.charAt(i) == '-' || mapping.alignedB0.charAt(i) == '-') {
                m1 += 1.0;
            }
            t1 += 1.0;
        }
        double m2 = 0.0;
        double t2 = 0.0;
        for (int i = 0; i < reverseMapping.alignedA0.length(); ++i) {
            if (reverseMapping.alignedA0.charAt(i) == reverseMapping.alignedB0.charAt(i) || reverseMapping.alignedA0.charAt(i) == '-' || reverseMapping.alignedB0.charAt(i) == '-') {
                m2 += 1.0;
            }
            t2 += 1.0;
        }
        if (m1 / t1 >= m2 / t2) {
            return mapping;
        }
        return reverseMapping;
    }

    public static Mapping getMappingFromAlignedStrings(String alignedA0, String alignedB0, boolean bReversedComplemented) {
        int ref;
        int i;
        if (alignedA0.length() != alignedB0.length()) {
            throw new Error("Aligned sequences are not of equal length.");
        }
        Mapping mapping = new Mapping();
        mapping.refLen = Mapping.getUngappedPosition(alignedA0, alignedA0.length());
        mapping.alignedA0 = alignedA0;
        mapping.alignedB0 = alignedB0;
        mapping.bReversedComplemented = bReversedComplemented;
        for (int i2 = 0; i2 < alignedA0.length(); ++i2) {
            int ref2 = i2;
            int refToA = Mapping.getUngappedPosition(alignedA0, ref2);
            if (alignedA0.charAt(ref2) == '-') continue;
            mapping.referenceToA.put(ref2, refToA);
            if (mapping.aToReference.containsKey(refToA)) continue;
            mapping.aToReference.put(refToA, ref2);
        }
        int bLength = Mapping.getUngappedPosition(alignedB0, alignedB0.length());
        if (bReversedComplemented) {
            for (i = 0; i < alignedB0.length(); ++i) {
                ref = i;
                int refToB = bLength - Mapping.getUngappedPosition(alignedB0, ref) - 1;
                if (alignedB0.charAt(ref) == '-') continue;
                mapping.referenceToB.put(ref, refToB);
                if (mapping.bToReference.containsKey(refToB)) continue;
                mapping.bToReference.put(refToB, ref);
            }
        } else {
            for (i = 0; i < alignedB0.length(); ++i) {
                ref = i;
                int refToB = Mapping.getUngappedPosition(alignedB0, ref);
                if (alignedB0.charAt(ref) == '-') continue;
                mapping.referenceToB.put(ref, refToB);
                if (mapping.bToReference.containsKey(refToB)) continue;
                mapping.bToReference.put(refToB, ref);
            }
        }
        return mapping;
    }

    public void printMapping(Hashtable<Integer, Integer> mapping) {
        Enumeration<Integer> en = mapping.keys();
        while (en.hasMoreElements()) {
            Integer key = en.nextElement();
            Integer val = mapping.get(key);
            System.out.println(key + "\t" + val + "\t" + this.aToRef(key) + "\t" + this.aToB(key));
        }
    }

    public void saveMapping(File outFile) {
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(outFile));
            buffer.write("#ReverseComplement=" + Boolean.toString(this.bReversedComplemented) + "\n");
            buffer.write(this.alignedA0 + "\n");
            buffer.write(this.alignedB0 + "\n");
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String charArrayToString(char[] array) {
        String ret = "";
        for (char c : array) {
            ret = ret + c;
        }
        return ret;
    }

    public static Mapping loadMapping(File inFile) {
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(inFile));
            boolean bReversedComplemented = Boolean.parseBoolean(buffer.readLine().substring(19));
            String alignedA0 = buffer.readLine();
            String alignedB0 = buffer.readLine();
            buffer.close();
            return Mapping.getMappingFromAlignedStrings(alignedA0, alignedB0, bReversedComplemented);
        }
        catch (IOException ex) {
            Logger.getLogger(Mapping.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

