/*
 * Decompiled with CFR 0.152.
 */
package structurevis.data;

import java.io.File;
import java.util.HashMap;
import structurevis.data.Mapping;

public class MapCache {
    HashMap<FilePair, Mapping> mappingMap = new HashMap();
    HashMap<FilePair, File> filePairMap = new HashMap();
    int mapid = 0;

    public void registerMap(File fileA, File fileB, Mapping mapping) {
        this.mappingMap.put(new FilePair(fileA, fileB), mapping);
    }

    public Mapping getMap(File fileA, File fileB) {
        return this.mappingMap.get(new FilePair(fileA, fileB));
    }

    public File getMappingFile(File fileA, File fileB) {
        return this.filePairMap.get(new FilePair(fileA, fileB));
    }

    public void clearMappingMap() {
        this.mappingMap.clear();
    }

    public void registerFilePair(File fileA, File fileB, File mapFile) {
        this.filePairMap.put(new FilePair(fileA, fileB), mapFile);
    }

    public boolean filePairExists(File fileA, File fileB) {
        return this.filePairMap.containsKey(new FilePair(fileA, fileB));
    }

    public void clearFilePairMap() {
        this.filePairMap.clear();
    }

    class FilePair {
        File fileA;
        File fileB;

        public FilePair(File fileA, File fileB) {
            this.fileA = fileA;
            this.fileB = fileB;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FilePair other = (FilePair)obj;
            if (!(this.fileA == other.fileA || this.fileA != null && this.fileA.equals(other.fileA))) {
                return false;
            }
            return this.fileB == other.fileB || this.fileB != null && this.fileB.equals(other.fileB);
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.fileA != null ? this.fileA.hashCode() : 0);
            hash = 29 * hash + (this.fileB != null ? this.fileB.hashCode() : 0);
            return hash;
        }
    }
}

