/*
 * Decompiled with CFR 0.152.
 */
package structurevis.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class IO {
    public static void loadFastaSequences(File file, ArrayList<String> sequences, ArrayList<String> sequenceNames) {
        IO.loadFastaSequences(file, sequences, sequenceNames, Integer.MAX_VALUE);
    }

    public static void loadFastaSequences(File file, ArrayList<String> sequences, ArrayList<String> sequenceNames, int max) {
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(file));
            String textline = null;
            String sequence = "";
            int n = 0;
            boolean maxReached = false;
            while (!((textline = buffer.readLine()) == null || maxReached && textline.startsWith(">"))) {
                if (textline.startsWith(">")) {
                    if (++n >= max) {
                        maxReached = true;
                    }
                    sequenceNames.add(textline.substring(1));
                    if (sequence.equals("")) continue;
                    sequences.add(sequence.toUpperCase());
                    sequence = "";
                    continue;
                }
                sequence = sequence + textline.trim();
            }
            buffer.close();
            if (!sequence.equals("")) {
                sequences.add(sequence);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean saveToFASTAfile(ArrayList<String> sequences, ArrayList<String> sequenceNames, File file) {
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < sequences.size() && i < sequenceNames.size(); ++i) {
                buffer.write(">" + sequenceNames.get(i) + "\n");
                buffer.write(sequences.get(i) + "\n");
            }
            buffer.close();
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void copyFile(File sourceFile, File destFile) {
        try {
            int len;
            FileInputStream in = new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(destFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException ex) {
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File getFileInCwd(File cwd, File filename) {
        return new File(cwd.getPath() + "/" + filename.getName());
    }

    public static String[] getHeadersFromCSV(File csvFile) {
        String[] headers = new String[]{};
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(csvFile));
            String textline = buffer.readLine();
            if (textline != null) {
                headers = textline.split(",");
            }
            buffer.close();
        }
        catch (IOException ex) {
            return headers;
        }
        return headers;
    }

    public static ArrayList<String> getColumnFromCSV(File csvFile, int column, boolean hasHeader) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(csvFile));
            String textline = null;
            String[] split = new String[]{};
            if (hasHeader) {
                buffer.readLine();
            }
            while ((textline = buffer.readLine()) != null) {
                split = textline.split(",");
                if (column < split.length) {
                    values.add(split[column]);
                    continue;
                }
                values.add(null);
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return values;
    }

    public static double[] getMinAndMaxValueFromCSV(File csvFile, int column, boolean hasHeader) {
        double[] minAndMax = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        ArrayList<String> data = IO.getColumnFromCSV(csvFile, column, hasHeader);
        for (int i = 0; i < data.size(); ++i) {
            try {
                if (data.get(i) == null) continue;
                double val = Double.parseDouble(data.get(i));
                minAndMax[0] = Math.min(minAndMax[0], val);
                minAndMax[1] = Math.max(minAndMax[1], val);
                continue;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return minAndMax;
    }

    public static void zipFolder(File inFolder, File outFile, int compressionLevel) throws Exception {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        out.setLevel(Math.min(Math.max(0, compressionLevel), 9));
        int len = inFolder.getAbsolutePath().lastIndexOf(File.separator);
        IO.addFolderToZipStream(inFolder, out, inFolder.getAbsolutePath().substring(0, len + 1));
        out.close();
    }

    private static void addFolderToZipStream(File folder, ZipOutputStream zipStream, String zipFilePath) throws IOException {
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                IO.addFolderToZipStream(files[i], zipStream, zipFilePath);
                continue;
            }
            String name = files[i].getAbsolutePath().substring(zipFilePath.length());
            ZipEntry zipEntry = new ZipEntry(name);
            zipStream.putNextEntry(zipEntry);
            BufferedInputStream fileInStream = new BufferedInputStream(new FileInputStream(files[i]));
            BufferedOutputStream zipOutStream = new BufferedOutputStream(zipStream);
            byte[] buffer = new byte[1024];
            while (fileInStream.available() > 0) {
                fileInStream.read(buffer);
                zipOutStream.write(buffer);
            }
            fileInStream.close();
            zipStream.closeEntry();
        }
    }

    public static void extractZip(File zipFile, File extractToPath) throws Exception {
        int BUFFER = 1024;
        ZipFile zip = new ZipFile(zipFile);
        extractToPath.mkdirs();
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        while (zipFileEntries.hasMoreElements()) {
            ZipEntry entry = zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(extractToPath.getAbsolutePath(), currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (!entry.isDirectory()) {
                int currentByte;
                BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
                while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                is.close();
            }
            if (!currentEntry.endsWith(".zip")) continue;
            IO.extractZip(destFile, extractToPath);
        }
    }

    public static boolean contentEquals(File file1, File file2) {
        try {
            int ch2;
            BufferedInputStream input1 = new BufferedInputStream(new FileInputStream(file1));
            BufferedInputStream input2 = new BufferedInputStream(new FileInputStream(file2));
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    input1.close();
                    input2.close();
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            input1.close();
            input2.close();
            return ch2 == -1;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void main(String[] args) {
        try {
            IO.zipFolder(new File("testcollection2"), new File("testcollection3.zip"), 9);
            IO.extractZip(new File("testcollection3.zip"), new File("C:/myfolder/"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

